/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructSymbol
extends OCNamespaceSymbol
implements OCTemplateSymbol<PsiElement> {
    private OCSymbolKind mySymbolKind;
    @NotNull
    private Collection<Pair<OCType, OCVisibility>> myBaseCppClasses;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @Nullable
    private List<OCTypeArgument> myTemplateSpecialization;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private TextRange myScope;
    private int myPropertiesAndAttributes;

    public OCStructSymbol() {
    }

    public OCStructSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @NotNull OCSymbolKind kind, @NotNull List<Pair<OCType, OCVisibility>> baseClasses, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> members, TextRange scope, @Nullable OCVisibility visibility, int classProperties, int classAttributes) {
        super(project2, file2, offset, parent, name, attributes, membersList, members, null, false, visibility);
        assert (kind == OCSymbolKind.STRUCT || kind == OCSymbolKind.UNION || kind == OCSymbolKind.ENUM);
        this.mySymbolKind = kind;
        this.myBaseCppClasses = baseClasses;
        this.myTemplateParameters = templateParameters;
        this.myTemplateSpecialization = templateSpecialization;
        this.myScope = scope;
        this.myPropertiesAndAttributes = classProperties | classAttributes;
    }

    public OCStructSymbol(OCStructSymbol origin, OCTypeSubstitution substitution, boolean overwriteSubstitution, @NotNull OCResolveContext context) {
        this(origin, substitution, origin.getParent(), overwriteSubstitution, context);
    }

    public OCStructSymbol(OCStructSymbol origin, OCTypeSubstitution substitution, OCSymbolWithQualifiedName parent, boolean overwriteSubstitution, @NotNull OCResolveContext context) {
        super(origin.myProject, origin.myFile, origin.myComplexOffset, parent, origin.getQualifiedName(), origin.getAttributes(), origin.getMembersList(), origin.getMembers(), null, false, origin.myVisibility);
        this.mySymbolKind = origin.getKind();
        this.myBaseCppClasses = origin.myBaseCppClasses;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.myTemplateSpecialization = origin.myTemplateSpecialization;
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, overwriteSubstitution, context);
        this.myScope = origin.getScope();
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCStructSymbol f = (OCStructSymbol)first;
        OCStructSymbol s = (OCStructSymbol)second;
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.mySymbolKind), (Object)((Object)s.mySymbolKind))) {
            return false;
        }
        if (!c.equalIterable(f.myBaseCppClasses, s.myBaseCppClasses)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalIterable(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalIterable(f.myTemplateSpecialization, s.myTemplateSpecialization);
    }

    @Override
    public void updateOffset(int start, int end, int lengthShift) {
        super.updateOffset(start, end, lengthShift);
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)parameter)).updateOffset(start, end, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)parameter)).compact();
        }
    }

    public boolean isFriendClass() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    public boolean isFinal() {
        return this.hasAttribute(OCSymbolAttribute.FINAL);
    }

    public boolean isEnumClass() {
        return this.hasProperty(Property.IS_ENUM_CLASS);
    }

    public boolean isEnum() {
        return this.getKind() == OCSymbolKind.ENUM;
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.myTemplateParameters.size() != 0 || this.myTemplateSpecialization != null;
    }

    public boolean isInnerClass() {
        for (OCSymbolWithQualifiedName parent = this.myParent; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof OCStructSymbol)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(@NotNull OCSymbolAttribute attr) {
        return (this.myPropertiesAndAttributes & attr.getMask()) != 0;
    }

    public boolean hasProperty(@NotNull Property prop) {
        return (this.myPropertiesAndAttributes & prop.getMask()) != 0;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        return this.myTemplateParameters;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean isVariadicTemplate() {
        return OCTemplateSymbolImpl.isVariadicTemplate(this);
    }

    @Override
    public boolean isSpecialization() {
        return this.getTemplateSpecialization() != null;
    }

    @Override
    public boolean isExplicitInstantiation() {
        return this.isTemplateSymbol() && this.getTemplateParameters().isEmpty();
    }

    @Override
    public int getRequiredTemplateArgumentsCnt() {
        return OCTemplateSymbolImpl.getRequiredTemplateArgumentsCnt(this);
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    public boolean isPredeclaration() {
        return this.getMembers() == null;
    }

    @Override
    public String getKindUppercase() {
        OCFile file2 = this.getContainingOCFile();
        OCSymbolKind kind = this.getKind();
        if (kind == OCSymbolKind.STRUCT && file2 != null && file2.isCpp()) {
            return "Class";
        }
        return super.getKindUppercase();
    }

    @Override
    public boolean processMembers(@Nullable String memberName, final @NotNull Processor<OCSymbol> processor2) {
        Processor<OCSymbol> inner = this.mySubstitution != OCTypeSubstitution.ID ? new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                return processor2.process((Object)OCStructSymbol.this.mySubstitution.substitute(symbol, OCStructSymbol.this, false, new OCResolveContext()));
            }
        } : processor2;
        return super.processMembers(memberName, inner);
    }

    public boolean processFields(@NotNull Processor<OCDeclaratorSymbol> processor2) {
        return this.processMembers((String)null, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCDeclaratorSymbol.class));
    }

    public boolean processFunctions(@Nullable String name, @NotNull Processor<OCFunctionSymbol> processor2) {
        return this.processMembers(name, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCFunctionSymbol.class));
    }

    @Nullable
    public OCDeclaratorSymbol findField(String name) {
        MostlySingularMultiMap<String, OCSymbol> members = this.getMembers();
        if (members == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCDeclaratorSymbol;
            }
        };
        members.processForKey((Object)name, (Processor)finder);
        return (OCDeclaratorSymbol)finder.getFoundValue();
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return this.mySymbolKind;
    }

    @Override
    @NotNull
    public OCStructType getType() {
        return new OCStructType(this);
    }

    @Override
    @Nullable
    public TextRange getScope() {
        return this.myScope;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.getType().getName();
    }

    @Override
    public Icon computeFullIcon(@Nullable PsiElement symbolElement) {
        Icon result = super.computeFullIcon(symbolElement);
        if (result != null && OCTestFrameworks.isTestClass(this)) {
            result = OCIcons.getTestIcon(result);
        }
        return result;
    }

    public boolean processAllMembersWithName(String name, final Processor<OCSymbol> processor2) {
        if (!this.isGlobal()) {
            return this.processMembers(name, new Processor<OCSymbol>(){

                public boolean process(OCSymbol constructor) {
                    return processor2.process((Object)constructor);
                }
            });
        }
        final OCSymbol definition = this.getDefinitionSymbol();
        Processor<OCSymbol> _processor = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (!symbol.getClass().equals(OCFunctionSymbol.class)) {
                    return true;
                }
                OCSymbolWithQualifiedName resolvedQualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner();
                if (resolvedQualifiedName == null || !resolvedQualifiedName.equals(definition)) {
                    return true;
                }
                return processor2.process((Object)symbol);
            }
        };
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, _processor, name);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2) {
        return this.processConstructors(processor2, false, false, null);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeUsingBaseConstructors, @NotNull OCResolveContext context) {
        return this.processConstructors(processor2, false, includeUsingBaseConstructors, context);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions) {
        return this.processConstructors(processor2, includeOutOfClassDefinitions, false, null);
    }

    private boolean processConstructors(final Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, boolean includeUsingBaseConstructors, @Nullable OCResolveContext context) {
        Processor<OCSymbol> memberProcessor = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor()) {
                    return processor2.process((Object)((OCFunctionSymbol)symbol));
                }
                return true;
            }
        };
        if (includeUsingBaseConstructors && context != null && !this.processMembers((String)null, new Processor<OCSymbol>((Processor)memberProcessor, context){
            final /* synthetic */ Processor val$memberProcessor;
            final /* synthetic */ OCResolveContext val$context;
            {
                this.val$memberProcessor = processor2;
                this.val$context = oCResolveContext;
            }

            public boolean process(OCSymbol symbol) {
                return !(symbol instanceof OCUsingSymbol) || ((OCUsingSymbol)symbol).getSymbolReference().processPossibleSymbols((Processor<OCSymbol>)this.val$memberProcessor, this.val$context);
            }
        })) {
            return false;
        }
        if (includeOutOfClassDefinitions) {
            return this.processAllMembersWithName(this.myName, memberProcessor);
        }
        return this.processMembers(this.myName, memberProcessor);
    }

    public boolean processDestructors(final Processor<OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions) {
        Processor<OCSymbol> memberProcessor = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppDestructor()) {
                    return processor2.process((Object)((OCFunctionSymbol)symbol));
                }
                return true;
            }
        };
        if (includeOutOfClassDefinitions) {
            return this.processAllMembersWithName("~" + this.myName, memberProcessor);
        }
        return this.processMembers("~" + this.myName, memberProcessor);
    }

    public boolean hasDefaultConstructor() {
        class MyProcessor
        implements Processor<OCFunctionSymbol> {
            boolean wasConstructor;
            boolean wasDefaultConstructor;

            MyProcessor() {
            }

            public boolean process(OCFunctionSymbol symbol) {
                this.wasConstructor = true;
                this.wasDefaultConstructor |= symbol.canBeCalledWithoutArguments();
                return true;
            }

            public boolean hasDefaultConstructor() {
                return !this.wasConstructor || this.wasDefaultConstructor;
            }
        }
        MyProcessor processor2 = new MyProcessor();
        this.processConstructors(processor2);
        return processor2.hasDefaultConstructor();
    }

    public boolean hasDeclaredConstructor() {
        return !this.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor());
    }

    @Nullable
    public OCFunctionSymbol getDefaultConstructor() {
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> finder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol symbol) {
                return symbol.canBeCalledWithoutArguments();
            }
        };
        this.processConstructors((Processor<? super OCFunctionSymbol>)finder);
        return (OCFunctionSymbol)finder.getFoundValue();
    }

    public boolean isPOD(boolean checkInnerStructs) {
        if (this.mySymbolKind != OCSymbolKind.STRUCT && this.mySymbolKind != OCSymbolKind.ENUM) {
            return false;
        }
        if (!this.myBaseCppClasses.isEmpty()) {
            return false;
        }
        return OCStructSymbol.isPOD(this, new HashSet<OCSymbol>(), checkInnerStructs, this.getContainingOCFile());
    }

    public boolean isPOD() {
        return this.isPOD(true);
    }

    private static boolean isPOD(OCStructSymbol symbol, final Set<OCSymbol> processed2, final boolean checkInnerStructs, final OCFile file2) {
        final boolean[] pod = new boolean[]{true};
        symbol.processMembers((String)null, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (!processed2.add(symbol)) {
                    return true;
                }
                if (symbol instanceof OCStructSymbol) {
                    if (checkInnerStructs && !OCStructSymbol.isPOD((OCStructSymbol)symbol, processed2, true, file2)) {
                        pod[0] = false;
                        return false;
                    }
                } else if (symbol instanceof OCDeclaratorSymbol) {
                    OCVisibility vis = ((OCDeclaratorSymbol)symbol).getVisibility();
                    if (vis != null && vis != OCVisibility.NULL && vis != OCVisibility.PUBLIC) {
                        pod[0] = false;
                        return false;
                    }
                    OCType type = symbol.getType().resolve(file2);
                    if (checkInnerStructs && type instanceof OCStructType && symbol.getKind() != OCSymbolKind.TYPEDEF && ContainerUtil.exists(((OCStructType)type).getStructs(), (Condition)new Condition<OCStructSymbol>(){

                        public boolean value(OCStructSymbol symbol) {
                            return !OCStructSymbol.isPOD(symbol, processed2, true, file2);
                        }
                    })) {
                        pod[0] = false;
                        return false;
                    }
                }
                return true;
            }
        });
        return pod[0];
    }

    public boolean hasMemberFunctions() {
        return !this.processFunctions(null, (Processor<OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor());
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(@NotNull PsiElement context) {
        return this.getBaseCppClasses(new OCResolveContext(context));
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(final @NotNull OCResolveContext context) {
        return ContainerUtil.map(this.myBaseCppClasses, (Function)new Function<Pair<OCType, OCVisibility>, OCType>(){

            public OCType fun(Pair<OCType, OCVisibility> pair) {
                return OCStructSymbol.this.mySubstitution.substitute((OCType)pair.first, context);
            }
        });
    }

    @NotNull
    public Collection<Pair<OCType, OCVisibility>> getBaseCppClassesWithVisibility(final @NotNull OCResolveContext context) {
        return ContainerUtil.map(this.myBaseCppClasses, (Function)new Function<Pair<OCType, OCVisibility>, Pair<OCType, OCVisibility>>(){

            public Pair<OCType, OCVisibility> fun(Pair<OCType, OCVisibility> pair) {
                OCType type = OCStructSymbol.this.mySubstitution.substitute((OCType)pair.first, context);
                return new Pair((Object)type, pair.second);
            }
        });
    }

    public boolean processBaseClasses(@NotNull OCResolveContext context, BaseClassProcessor processor2) {
        for (Pair<OCType, OCVisibility> pair : this.myBaseCppClasses) {
            OCType type = this.mySubstitution.substitute((OCType)pair.first, context);
            OCType resolved = type.accept(new OCTypeResolveVisitor(context));
            if (OCStructSymbol.processBaseClass(resolved.isUnknown() ? type : resolved, (OCVisibility)((Object)pair.second), processor2, context)) continue;
            return false;
        }
        return true;
    }

    private static boolean processBaseClass(OCType type, OCVisibility visibility, BaseClassProcessor processor2, @NotNull OCResolveContext context) {
        block4: {
            block5: {
                block3: {
                    if (!(type instanceof OCStructType)) break block3;
                    for (OCStructSymbol symbol : ((OCStructType)type).getStructs()) {
                        if (processor2.process(symbol, visibility)) continue;
                        return false;
                    }
                    break block4;
                }
                if (!(type instanceof OCReferenceType)) break block5;
                for (OCSymbol baseSymbol : context.resolveToSymbols(((OCReferenceType)type).getReference(context), true, true)) {
                    if (processor2.process(baseSymbol, visibility)) continue;
                    return false;
                }
                break block4;
            }
            if (!(type instanceof OCExpansionPackType)) break block4;
            for (OCTypeArgument typeArgument : ((OCExpansionPackType)type).getExpansions()) {
                if (!(typeArgument instanceof OCType) || OCStructSymbol.processBaseClass((OCType)typeArgument, visibility, processor2, context)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processAllBaseClasses(BaseClassProcessor processor2) {
        OCFile file2 = this.getContainingOCFile();
        return file2 == null || this.processAllBaseClasses(new OCResolveContext(file2), processor2, true);
    }

    public boolean processAllBaseClasses(@NotNull OCResolveContext context, final BaseClassProcessor processor2, final boolean skipFirstVisibility) {
        Set<OCNamespaceLikeSymbol> processed2 = OCTypeUtils.newSymbolWithSubstitutionSet();
        final Stack<OCStructSymbol> structsWorkset = new Stack<OCStructSymbol>();
        final Stack visibilityWorkset = new Stack();
        structsWorkset.add(this);
        visibilityWorkset.add(null);
        while (!structsWorkset.isEmpty()) {
            OCStructSymbol symbol = (OCStructSymbol)structsWorkset.pop();
            final OCVisibility visibility = (OCVisibility)((Object)visibilityWorkset.pop());
            if (processed2.contains(symbol)) continue;
            processed2.add(symbol);
            if (symbol.processBaseClasses(context, new BaseClassProcessor(){

                @Override
                public boolean process(OCSymbol baseSymbol, OCVisibility baseVisibility) {
                    baseVisibility = visibility == null ? (skipFirstVisibility ? OCVisibility.PUBLIC : baseVisibility) : OCVisibility.max(visibility, baseVisibility);
                    if (!processor2.process(baseSymbol, baseVisibility)) {
                        return false;
                    }
                    if (baseSymbol instanceof OCStructSymbol) {
                        structsWorkset.push((OCStructSymbol)baseSymbol);
                        visibilityWorkset.push(baseVisibility);
                    }
                    return true;
                }
            })) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestor(OCStructSymbol struct) {
        return this.resolvedNamesEqual(struct) || !struct.processAllBaseClasses(new BaseClassProcessor(){

            @Override
            public boolean process(OCSymbol symbol, OCVisibility visibility) {
                return !(symbol instanceof OCStructSymbol) || !OCStructSymbol.this.resolvedNamesEqual((OCSymbolWithQualifiedName)symbol);
            }
        });
    }

    @NotNull
    public List<OCTypeArgument> getTemplateArguments(@NotNull OCResolveContext context) {
        ArrayList<OCTypeArgument> result = new ArrayList<OCTypeArgument>();
        List<OCTypeArgument> specialization = this.getTemplateSpecialization();
        if (specialization != null) {
            for (OCTypeArgument spec : specialization) {
                if (spec instanceof OCType) {
                    OCType substitution = ((OCType)spec).transformType(new OCTypeResolveVisitor(context.substituteFirst(this.getSubstitution()), false));
                    if (substitution instanceof OCStructType && ((OCStructType)substitution).getSymbol().equals(this)) continue;
                    result.add(substitution);
                    continue;
                }
                result.add(spec);
            }
        } else {
            for (OCTypeParameterSymbol param : this.getTemplateParameters()) {
                OCTypeArgument argument = this.getSubstitution().getSubstitutionFor(param);
                if (argument instanceof OCExpansionPackType) {
                    result.addAll(((OCExpansionPackType)argument).getExpansions());
                    continue;
                }
                if (argument == null && param.isVariadic()) continue;
                result.add(argument);
            }
        }
        return result;
    }

    public static interface BaseClassProcessor {
        public boolean process(OCSymbol var1, OCVisibility var2);
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_ENUM_CLASS = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name) {
            return Enum.valueOf(Property.class, name);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        static {
            $VALUES = new Property[]{IS_ENUM_CLASS};
        }
    }
}

