/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclaratorSymbol
extends OCTemplateSymbolImpl<PsiNameIdentifierOwner> {
    private OCType myType;
    private OCSymbolKind mySymbolKind;
    private int[] myArrayLengths;
    private int myPropertiesAndAttributes;
    @Nullable
    private TextRange myScope;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @Nullable
    private OCMethodSymbol myParentMethod;
    protected OCExpressionSymbol myInitializer;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;

    public OCDeclaratorSymbol() {
    }

    public OCDeclaratorSymbol(Project project2, VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @NotNull OCType type, OCSymbolKind declaratorType, int[] arrayLengths, @Nullable OCExpressionSymbol initializer, @NotNull List<OCTypeParameterSymbol> templateParameters, int declaratorProperties, int declaratorAttributes, @Nullable TextRange scope, @Nullable OCVisibility visibility) {
        super(project2, file2, offset, parent, name, attributes, visibility);
        this.myType = type;
        this.myArrayLengths = arrayLengths.length > 0 ? arrayLengths : ArrayUtil.EMPTY_INT_ARRAY;
        this.myInitializer = initializer;
        this.mySymbolKind = declaratorType;
        this.myPropertiesAndAttributes = declaratorProperties | declaratorAttributes;
        this.myTemplateParameters = templateParameters;
        this.myScope = scope;
        assert (this.myScope == null || !this.mySymbolKind.isTemplateParameter());
    }

    public OCDeclaratorSymbol(Project project2, VirtualFile file2, int offset, OCSymbolWithQualifiedName parent, String name, @NotNull List<String> attributes, @NotNull OCType type, OCSymbolKind declaratorType) {
        this(project2, file2, offset, parent, OCQualifiedName.interned(name), attributes, type, declaratorType, ArrayUtil.EMPTY_INT_ARRAY, null, Collections.emptyList(), 0, 0, null, null);
    }

    public OCDeclaratorSymbol(OCDeclaratorSymbol origin, OCTypeSubstitution substitution, OCQualifiedName name, OCSymbolWithQualifiedName parent, @NotNull OCResolveContext context) {
        super(origin.getProject(), origin.getContainingFile(), origin.getOffset(), parent, name, origin.getAttributes(), origin.getVisibility());
        this.myType = origin.getType();
        this.myArrayLengths = origin.getArrayLengths();
        this.myInitializer = origin.getInitializer();
        this.mySymbolKind = origin.getKind();
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
        this.myScope = origin.getScope();
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
        this.myTemplateParameters = origin.getTemplateParameters();
        assert (this.myScope == null || !this.mySymbolKind.isTemplateParameter());
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCDeclaratorSymbol f = (OCDeclaratorSymbol)first;
        OCDeclaratorSymbol s = (OCDeclaratorSymbol)second;
        if (f.mySymbolKind != s.mySymbolKind) {
            return false;
        }
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!Arrays.equals(f.myArrayLengths, s.myArrayLengths)) {
            return false;
        }
        if (!c.equalObjects(f.myInitializer, s.myInitializer)) {
            return false;
        }
        if (!c.equalObjects(f.myParentMethod, s.myParentMethod)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalIterable(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    public boolean isTopLevel() {
        return this.myScope == null && this.getParent() == null;
    }

    @Override
    @NotNull
    public OCType getType() {
        return this.mySubstitution.substitute(this.myType, new OCResolveContext());
    }

    public void setType(OCFunctionType type) {
        this.myType = type;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean isTemplateSymbol() {
        return !this.myTemplateParameters.isEmpty();
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        return this.myTemplateParameters;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return null;
    }

    @Override
    @NotNull
    public String getSignature() {
        OCType type = this.getType().accept(new OCTypeParameterResolveVisitor(this.getContainingOCFile()));
        return OCDocUtil.parameterSignature(type.getName(), this.getName());
    }

    @Override
    protected Class<? extends PsiNameIdentifierOwner> getPsiElementClass() {
        return this.myParentMethod != null ? OCMethodSelectorPart.class : super.getPsiElementClass();
    }

    public void setType(@NotNull OCType type) {
        this.myType = type;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return this.mySymbolKind;
    }

    @Override
    public boolean isConst() {
        return this.hasAttribute(OCSymbolAttribute.CONST) || this.isConstexpr() || this.mySymbolKind == OCSymbolKind.ENUM_CONST;
    }

    public boolean isConstexpr() {
        return this.hasAttribute(OCSymbolAttribute.CONSTEEXPR);
    }

    public boolean isMutable() {
        return this.hasAttribute(OCSymbolAttribute.MUTABLE);
    }

    @Override
    public boolean isStatic() {
        return this.hasAttribute(OCSymbolAttribute.STATIC) || this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    public boolean isExtern() {
        return this.hasAttribute(OCSymbolAttribute.EXTERN);
    }

    public boolean isBlockModifiable() {
        return this.hasAttribute(OCSymbolAttribute.BLOCK_MODIFIABLE);
    }

    public boolean isPassByReference() {
        return this.hasProperty(Property.IS_PASS_BY_REF);
    }

    public boolean hasInitializer() {
        return this.hasProperty(Property.IS_HAS_INITIALIZER);
    }

    public boolean hasAttribute(@NotNull OCSymbolAttribute attribute) {
        return (this.myPropertiesAndAttributes & attribute.getMask()) != 0;
    }

    public boolean hasProperty(@NotNull Property property) {
        return (this.myPropertiesAndAttributes & property.getMask()) != 0;
    }

    @Override
    @Nullable
    public TextRange getScope() {
        return this.myScope;
    }

    @Override
    public boolean isDefinition() {
        return super.isDefinition() && this.myScope == null;
    }

    @NotNull
    public int[] getArrayLengths() {
        return this.myArrayLengths;
    }

    public OCExpressionSymbol getInitializer() {
        return this.myInitializer;
    }

    @Nullable
    public OCDeclaratorSymbol getDeclarationInParent() {
        if (this.getQualifier() == null) {
            return this;
        }
        OCSymbolWithQualifiedName owner = this.getResolvedOwner();
        final Ref result = new Ref(null);
        if (owner instanceof OCStructSymbol) {
            ((OCStructSymbol)owner).processMembers(this.getName(), new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCDeclaratorSymbol) {
                        result.set((Object)((OCDeclaratorSymbol)symbol));
                        return false;
                    }
                    return true;
                }
            });
        }
        return (OCDeclaratorSymbol)result.get();
    }

    public boolean resolveIsStatic() {
        if (this.isStatic() || this.getQualifier() == null) {
            return this.isStatic();
        }
        OCDeclaratorSymbol predef = this.getDeclarationInParent();
        return predef != null && predef.isStatic();
    }

    @Override
    public Icon getBaseIcon() {
        Icon icon = this.getKind().getIcon();
        if (this.isConst() && this.getKind() != OCSymbolKind.ENUM_CONST) {
            icon = OCIcons.getConstIcon(icon);
        }
        if (this.isStatic()) {
            icon = OCIcons.getStaticIcon(icon);
        }
        return OCIcons.getVisibilityIcon(this.getVisibility(), icon);
    }

    public void setParentMethod(@Nullable OCMethodSymbol parentMethod) {
        this.myParentMethod = parentMethod;
    }

    @Override
    public boolean processAssociatedSymbols(final Processor<OCSymbol> processor2) {
        if (this.mySymbolKind != OCSymbolKind.PARAMETER) {
            return super.processAssociatedSymbols(processor2);
        }
        if (this.myParentMethod != null) {
            OCMethodSymbol parentAssociate = this.myParentMethod.getAssociatedSymbol();
            if (parentAssociate == null) {
                return true;
            }
            int indexInParent = 0;
            for (OCMethodSymbol.SelectorPartSymbol selector : this.myParentMethod.getSelectors()) {
                if (this.equals(selector.getParameter())) break;
                ++indexInParent;
            }
            if (indexInParent >= this.myParentMethod.getSelectors().size()) {
                return true;
            }
            return processor2.process((Object)parentAssociate.getSelectors().get(indexInParent).getParameter());
        }
        if (this.myParent instanceof OCFunctionSymbol) {
            final int parameterIndex = ((OCFunctionSymbol)this.myParent).getParameterSymbols().indexOf(this);
            return this.myParent.processAssociatedSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCFunctionSymbol && parameterIndex != -1 && parameterIndex < ((OCFunctionSymbol)symbol).getParameterSymbols().size()) {
                        return processor2.process((Object)((OCFunctionSymbol)symbol).getParameterSymbols().get(parameterIndex));
                    }
                    return true;
                }
            });
        }
        return true;
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2, PsiFile file2) {
        if (this.mySymbolKind == OCSymbolKind.PARAMETER) {
            if (this.myParentMethod != null) {
                OCSymbol associatedSymbol = this.getAssociatedSymbol();
                return processor2.process((Object)this) && (associatedSymbol == null || processor2.process((Object)associatedSymbol));
            }
            if (this.myParent instanceof OCFunctionSymbol) {
                return processor2.process((Object)this) && this.processAssociatedSymbols(processor2);
            }
        }
        return super.processSameSymbols(processor2, file2);
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_PASS_BY_REF = new Property();
        public static final /* enum */ Property IS_HAS_INITIALIZER = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name) {
            return Enum.valueOf(Property.class, name);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        static {
            $VALUES = new Property[]{IS_PASS_BY_REF, IS_HAS_INITIALIZER};
        }
    }
}

