/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAliasUsingSymbol
extends OCTemplateSymbolImpl
implements Serializable {
    private OCType myType;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private TextRange myScope;

    public OCAliasUsingSymbol() {
    }

    public OCAliasUsingSymbol(Project project2, VirtualFile file2, long offset, @NotNull String name, OCSymbolWithQualifiedName parent, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable TextRange scope) {
        super(project2, file2, offset, parent, OCQualifiedName.with(name), Collections.emptyList(), null);
        this.myScope = scope;
        this.myTemplateParameters = templateParameters;
    }

    public OCAliasUsingSymbol(OCAliasUsingSymbol origin, OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
        super(origin.getProject(), origin.getContainingFile(), origin.getOffset(), origin.getParent(), origin.getQualifiedName(), Collections.emptyList(), null);
        this.myType = origin.myType;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
        this.myScope = origin.myScope;
    }

    @Override
    @NotNull
    public OCType getType() {
        return this.mySubstitution.substitute(this.myType, new OCResolveContext());
    }

    public void setType(OCType type) {
        this.myType = type;
    }

    @Override
    @Nullable
    public TextRange getScope() {
        return this.myScope;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        return this.myTemplateParameters;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return null;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean isTemplateSymbol() {
        return !this.myTemplateParameters.isEmpty();
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCAliasUsingSymbol f = (OCAliasUsingSymbol)first;
        OCAliasUsingSymbol s = (OCAliasUsingSymbol)second;
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalIterable(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Override
    public String toString() {
        return "using " + this.myName + ' ' + this.myType.getName();
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.USING_SYMBOL_ALIAS;
    }
}

