/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveContext
extends UserDataHolderBase {
    @Nullable
    private PsiElement myElement;
    @NotNull
    private final OCTypeSubstitution mySubstitution;
    @NotNull
    private final Set<Pair<OCSymbolReference, OCTypeSubstitution>> myResolving;
    private final HashMap<OCFunctionSymbol, OCStructSymbol> myOperatorParentsCache;
    private final Set<OCTypeResolveVisitor.TypeKey> myResolvingTypes;
    private final OCExpressionEvaluator.ValueEvaluator myEvaluator;
    @Nullable
    private OCResolveContext myOriginalContext;
    public int myInsideUsingNamespaceCounter = 0;
    private int myDepth;
    private Ref<Integer> myTypeResolveCounter = Ref.create((Object)0);
    private Stack<Integer> myUsingNamespaceIndex = new Stack();
    private boolean myWasCollision;
    private Set<OCTypeParameterSymbol> myTypeDependencies;
    private boolean myProcessNonImported;
    private boolean myOriginallyProcessNonImported;
    private boolean myDontExpandVariadics;
    private boolean isVariadicExpansionMode;
    private boolean myInSFINAE;

    public OCResolveContext() {
        this(null);
    }

    private OCResolveContext(@NotNull OCResolveContext origin, @NotNull OCTypeSubstitution substitution) {
        this.myOriginalContext = origin;
        this.myDepth = origin.myDepth + 1;
        this.myElement = origin.myElement;
        this.mySubstitution = substitution;
        this.myResolving = origin.myResolving;
        this.myResolvingTypes = origin.myResolvingTypes;
        this.myOperatorParentsCache = origin.myOperatorParentsCache;
        this.myUsingNamespaceIndex = origin.myUsingNamespaceIndex;
        this.myTypeResolveCounter = origin.myTypeResolveCounter;
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myEvaluator = origin.myEvaluator;
    }

    public OCResolveContext(@Nullable PsiElement element) {
        this.myUsingNamespaceIndex.push(Integer.MAX_VALUE);
        this.myElement = element;
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myResolving = OCTypeUtils.newReferenceWithSubstitutionSet();
        this.myResolvingTypes = new THashSet();
        this.myOperatorParentsCache = new HashMap();
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myWasCollision = false;
        this.myEvaluator = new OCExpressionEvaluator.ValueEvaluator(this);
    }

    public String toString() {
        String element;
        if (this.myElement instanceof OCFile) {
            OCFile file2 = (OCFile)this.myElement;
            element = "file " + file2.getName();
        } else {
            element = this.myElement != null ? "element " + this.myElement.getClass().getSimpleName() + ": " + this.myElement.getText() : "<null>";
        }
        return "OCResolveContext(" + element + ")";
    }

    public List<OCSymbol> doResolveToSymbols(OCSymbolReference reference, boolean onlySimpleNamespaces, boolean onlyTypes) {
        Pair pair = Pair.create((Object)reference, (Object)this.mySubstitution.getMinimalDependentSubstitution(reference, this));
        if (this.myResolving.contains(pair)) {
            this.setWasCollision(true);
            return Collections.emptyList();
        }
        this.myResolving.add((Pair<OCSymbolReference, OCTypeSubstitution>)pair);
        List<OCSymbol> result = reference.resolveToSymbols(this, onlySimpleNamespaces, onlyTypes, true);
        this.myResolving.remove(pair);
        return result;
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference) {
        return this.resolveToSymbols(reference, false, false);
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference, boolean processTypedefs, boolean onlyTypes) {
        return this.resolveToSymbols(reference, processTypedefs, true, false, onlyTypes);
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference, boolean processTypedefs, boolean processTypeParameters, boolean onlySimpleNamespaces, boolean onlyTypes) {
        List<OCSymbol> symbols = this.doResolveToSymbols(reference, onlySimpleNamespaces, onlyTypes);
        return OCSymbolReference.lookupUsingsAndTypedefs(processTypedefs, onlyTypes, this, symbols, reference, processTypeParameters);
    }

    public Set<OCTypeResolveVisitor.TypeKey> getResolvingTypes() {
        return this.myResolvingTypes;
    }

    @Nullable
    public OCStructSymbol getNonMemberOperatorParent(OCSymbol operator) {
        if (operator instanceof OCFunctionSymbol) {
            OCFunctionSymbol function = (OCFunctionSymbol)operator;
            List<OCDeclaratorSymbol> params = function.getParameterSymbols();
            if (function.isCppNonMemberOperator(this)) {
                if (this.myOperatorParentsCache.containsKey(function)) {
                    return this.myOperatorParentsCache.get(function);
                }
                OCStructSymbol result = null;
                boolean wasUnknown = false;
                this.myOperatorParentsCache.put(function, null);
                for (int i = 0; i < params.size(); ++i) {
                    OCDeclaratorSymbol parameter = operator.getName().equals("operator<<") ? params.get(params.size() - i - 1) : params.get(i);
                    OCType paramType = parameter.getType().resolve(this).getTerminalType();
                    if (paramType instanceof OCStructType) {
                        result = ((OCStructType)paramType).getSymbol();
                        break;
                    }
                    if (!(paramType instanceof OCUnknownType)) continue;
                    wasUnknown = true;
                }
                if (result == null && wasUnknown) {
                    this.myOperatorParentsCache.remove(function);
                } else {
                    this.myOperatorParentsCache.put(function, result);
                }
                return result;
            }
        }
        return null;
    }

    @Nullable
    public PsiFile getFile() {
        if (this.myElement == null || !this.myElement.isValid()) {
            return null;
        }
        PsiFile file2 = this.myElement.getContainingFile();
        while (file2 instanceof OCCodeFragment) {
            PsiElement context = file2.getContext();
            if (context == null) {
                return file2;
            }
            file2 = context.getContainingFile();
        }
        return file2;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement != null && this.myElement.isValid() ? this.myElement : null;
    }

    @Nullable
    public Project getProject() {
        return this.myElement != null ? this.myElement.getProject() : null;
    }

    public void setElement(@Nullable PsiElement element) {
        this.myElement = element;
    }

    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Nullable
    public OCResolveContext getOriginalContext() {
        return this.myOriginalContext;
    }

    @NotNull
    public OCResolveContext substitute(@NotNull OCTypeSubstitution substitution) {
        return this.substitute(substitution, false);
    }

    @NotNull
    public OCResolveContext substitute(@NotNull OCTypeSubstitution substitution, boolean overwriteSubstitution) {
        if (substitution != OCTypeSubstitution.ID) {
            OCResolveContext result = new OCResolveContext(this, OCTypeSubstitution.compose(this.mySubstitution, substitution, overwriteSubstitution, this));
            result.setProcessNonImported(this.myProcessNonImported);
            return result;
        }
        return this;
    }

    @NotNull
    public OCResolveContext substituteFirst(@NotNull OCTypeSubstitution substitution) {
        if (substitution != OCTypeSubstitution.ID) {
            OCResolveContext result = new OCResolveContext(this, OCTypeSubstitution.compose(substitution, this.mySubstitution, false, this));
            result.setProcessNonImported(this.myProcessNonImported);
            return result;
        }
        return this;
    }

    @NotNull
    public OCResolveContext useFor(@NotNull OCSymbol symbol) {
        OCTypeSubstitution substitution = this.mySubstitution.getMinimalDependentSubstitution(symbol, this);
        substitution = symbol instanceof OCSymbolWithSubstitution ? OCTypeSubstitution.compose(substitution, ((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution(), false, this) : substitution;
        OCResolveContext result = new OCResolveContext(this, substitution);
        result.setProcessNonImported(this.myProcessNonImported);
        return result;
    }

    @NotNull
    public OCResolveContext useFor(@NotNull OCTypeArgument argument, @NotNull OCTypeSubstitution substitution) {
        substitution = OCTypeSubstitution.compose(this.mySubstitution, substitution, false, this).getMinimalDependentSubstitution(argument, this);
        OCResolveContext result = new OCResolveContext(this, substitution);
        result.setProcessNonImported(this.myProcessNonImported);
        return result;
    }

    @NotNull
    public OCResolveContext clearSubstitution() {
        OCResolveContext result = new OCResolveContext(this, OCTypeSubstitution.ID);
        result.setProcessNonImported(this.myProcessNonImported);
        return result;
    }

    public void startResolvingNamespaceUsing(int usingIndex) {
        ++this.myInsideUsingNamespaceCounter;
        if (usingIndex >= 0) {
            this.myUsingNamespaceIndex.push(Math.min(usingIndex, this.myUsingNamespaceIndex.peek()));
        } else {
            this.myUsingNamespaceIndex.push(this.myUsingNamespaceIndex.peek());
        }
    }

    public void stopResolvingNamespaceUsing() {
        --this.myInsideUsingNamespaceCounter;
        this.myUsingNamespaceIndex.pop();
    }

    public int getNestingDepth() {
        return this.myDepth;
    }

    public int getCurrentUsingIndex() {
        return this.myUsingNamespaceIndex.peek();
    }

    public OCExpressionEvaluator.ValueEvaluator getEvaluator() {
        return new OCExpressionEvaluator.ValueEvaluator(this.myEvaluator, this);
    }

    public boolean isProcessNonImported() {
        return this.myProcessNonImported || this.myOriginalContext != null && this.myOriginalContext.isProcessNonImported();
    }

    public boolean isInSFINAE() {
        return this.myInSFINAE || this.myOriginalContext != null && this.myOriginalContext.isInSFINAE();
    }

    public boolean isOriginallyProcessNonImported() {
        return this.myOriginallyProcessNonImported || this.myOriginalContext != null && this.myOriginalContext.isOriginallyProcessNonImported();
    }

    public boolean isDontExpandVariadics() {
        return this.myDontExpandVariadics || this.myOriginalContext != null && this.myOriginalContext.isDontExpandVariadics();
    }

    public void setDontExpandVariadics(boolean dontExpandVariadics) {
        this.myDontExpandVariadics = dontExpandVariadics;
    }

    public boolean isVariadicExpansionMode() {
        return this.isVariadicExpansionMode;
    }

    public void setVariadicExpansionMode(boolean variadicExpansionMode) {
        this.isVariadicExpansionMode = variadicExpansionMode;
    }

    public boolean wasCollision() {
        return this.myWasCollision || this.myOriginalContext != null && this.myOriginalContext.wasCollision();
    }

    public void addTypeDependency(@NotNull OCTypeParameterSymbol dependency) {
        this.myTypeDependencies.add(dependency);
    }

    public void addTypeDependencies(@NotNull Set<OCTypeParameterSymbol> typeDependencies) {
        this.myTypeDependencies.addAll(typeDependencies);
    }

    @NotNull
    public Set<OCTypeParameterSymbol> getTypeDependencies() {
        return new HashSet<OCTypeParameterSymbol>(this.myTypeDependencies);
    }

    @NotNull
    public Set<OCTypeParameterSymbol> getTypeDependencies(@Nullable OCType extraDependenciesSource) {
        final HashSet<OCTypeParameterSymbol> dependencies = new HashSet<OCTypeParameterSymbol>(this.myTypeDependencies);
        if (extraDependenciesSource != null) {
            extraDependenciesSource.accept(new OCBooleanTypeVisitor(){

                @Override
                public Boolean visitTypeParameterType(OCTypeParameterType type) {
                    dependencies.add(type.getSymbol());
                    return true;
                }
            });
        }
        return dependencies;
    }

    public void setTypeDependencies(@NotNull Set<OCTypeParameterSymbol> typeDependencies) {
        this.myTypeDependencies = typeDependencies;
    }

    public void clearTypeDependencies() {
        this.myTypeDependencies.clear();
    }

    public boolean wasDependentType() {
        return !this.myTypeDependencies.isEmpty() || this.myOriginalContext != null && this.myOriginalContext.wasDependentType();
    }

    public int getTypeResolveCounter() {
        return (Integer)this.myTypeResolveCounter.get();
    }

    public void incTypeResolveCounter() {
        this.myTypeResolveCounter.set((Object)((Integer)this.myTypeResolveCounter.get() + 1));
    }

    public void setProcessNonImported(boolean processNonImported) {
        this.myProcessNonImported = processNonImported;
        if (this.myProcessNonImported) {
            this.myOriginallyProcessNonImported = true;
        }
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setProcessNonImported(processNonImported);
        }
    }

    public void setInSFINAE(boolean inSFINAE) {
        this.myInSFINAE = inSFINAE;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setInSFINAE(inSFINAE);
        }
    }

    public void setWasCollision(boolean wasCollision) {
        this.myWasCollision = wasCollision;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setWasCollision(wasCollision);
        }
    }

    public static boolean setNonImportedFlag(@NotNull OCResolveContext context, boolean value) {
        boolean result = context.isProcessNonImported();
        context.setProcessNonImported(value);
        return result;
    }

    public static boolean setInSFINAEFlag(@NotNull OCResolveContext context, boolean value) {
        boolean result = context.isInSFINAE();
        context.setInSFINAE(value);
        return result;
    }
}

