/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.Comparing;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.types.OCType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedName
implements Serializable,
DeepEqual.Equality<OCQualifiedName> {
    @NotNull
    private static final String GLOBAL_NAME = "";
    @NotNull
    public static final OCQualifiedName GLOBAL = new OCQualifiedName(null, "");
    @Nullable
    protected OCQualifiedName myQualifier;
    @Nullable
    protected String myName;

    protected OCQualifiedName() {
    }

    private OCQualifiedName(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        this.myQualifier = qualifier;
        this.myName = name;
    }

    public static OCQualifiedName interned(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        OCQualifiedName result = OCQualifiedName.with(qualifier, name);
        return result == GLOBAL ? result : OCNamesInternary.intern(result);
    }

    public static OCQualifiedName with(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        if (qualifier == null && GLOBAL_NAME.equals(name)) {
            return GLOBAL;
        }
        return new OCQualifiedName(qualifier, name);
    }

    public static OCQualifiedName interned(@Nullable String name) {
        return OCQualifiedName.interned(null, name);
    }

    public static OCQualifiedName with(@Nullable String name) {
        return OCQualifiedName.with(null, name);
    }

    @Nullable
    public OCQualifiedName getQualifier() {
        return this.myQualifier;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public OCQualifiedName dropArguments() {
        return this;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCQualifiedName first, @NotNull OCQualifiedName second) {
        if (!Comparing.equal((String)first.myName, (String)second.myName)) {
            return false;
        }
        return c.equalObjects(first.myQualifier, second.myQualifier);
    }

    public final boolean equals(@Nullable Object o) {
        return DeepEqual.equalObjects(this, o);
    }

    public int hashCode() {
        int result = this.myQualifier != null ? this.myQualifier.hashCode() : 0;
        result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
        return result;
    }

    public String getSuperQualifier() {
        return this.myQualifier == null ? this.myName : this.myQualifier.getSuperQualifier();
    }

    @NotNull
    public OCQualifiedName dropSuperQualifier() {
        if (this.myQualifier == null) {
            return this;
        }
        if (this.myQualifier.myQualifier == null) {
            return OCQualifiedName.with(null, this.myName);
        }
        return OCQualifiedName.with(this.myQualifier.dropSuperQualifier(), this.myName);
    }

    @NotNull
    public OCQualifiedName changeName(@Nullable String name) {
        if (Comparing.equal((String)this.myName, (String)name)) {
            return this;
        }
        return OCQualifiedName.with(this.myQualifier, name);
    }

    @NotNull
    public OCQualifiedName changeQualifier(@Nullable OCQualifiedName qualifier) {
        return OCQualifiedName.with(qualifier, this.myName);
    }

    public OCQualifiedName append(OCQualifiedName name) {
        OCQualifiedName appended = OCQualifiedName.with(this, name.getSuperQualifier());
        return name.getQualifier() == null ? appended : appended.append(name.dropSuperQualifier());
    }

    public String getCanonicalName(boolean fullName) {
        return this.getCanonicalName(fullName, true);
    }

    public String getCanonicalName(boolean fullName, boolean includeGlobalQualifier) {
        return this.getCanonicalName(fullName ? OCType.Presentation.FULL : OCType.Presentation.SHORT, includeGlobalQualifier, new OCResolveContext(null), 0);
    }

    public String getCanonicalName(@NotNull OCType.Presentation presentation, boolean includeGlobalQualifier, @NotNull OCResolveContext context, int templateDepth) {
        String name;
        String string = name = this.myName != null ? this.myName : "<anonymous>";
        if (presentation != OCType.Presentation.SHORT) {
            return this.myQualifier != null && (includeGlobalQualifier || this.myQualifier != GLOBAL) ? this.myQualifier.getCanonicalName(presentation, includeGlobalQualifier, context, templateDepth) + "::" + name : name;
        }
        return name;
    }

    public String getNameWithParent() {
        String name = this.getCanonicalName(false);
        return this.myQualifier != null && this.myQualifier != GLOBAL ? this.myQualifier.getCanonicalName(false) + "::" + name : name;
    }

    public static OCQualifiedName parse(String qualifiedName) {
        OCQualifiedName result = null;
        for (String name : qualifiedName.split("::")) {
            result = OCQualifiedName.with(result, name);
        }
        return result;
    }

    public String toString() {
        return this.getCanonicalName(true);
    }

    public List<String> flatten() {
        ArrayList<String> result = new ArrayList<String>();
        for (OCQualifiedName current = this; current != null; current = current.getQualifier()) {
            result.add(current.getName());
        }
        Collections.reverse(result);
        return result;
    }
}

