/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.NodeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPragmaOnceContentElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafType;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLocalFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCBinaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCastExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCommaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCConditionalExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerListExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNewExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCPostfixExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCPrefixExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeBuilder;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParentSymbolSetter;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBuilderDriver<T>
extends BuilderDriverBase<T, OCFile> {
    protected OCCompilerKind myCompilerKind;
    protected boolean myImplicitBridgingOn;
    private boolean myHasNullabilityFeature;

    public OCBuilderDriver(@NotNull OCFile file2, @NotNull OCInclusionContext context, @Nullable String text, @NotNull FlyweightCapableTreeStructure<T> structure, @NotNull NodeStructure<T> nodeStructure, @NotNull Processor<OCSymbol> builder) {
        super(file2, context, text, structure, nodeStructure, builder, OCInclusionContextUtil.getVirtualFile(file2));
        OCResolveConfiguration configuration = context.getConfiguration();
        if (configuration != null) {
            this.myCompilerKind = configuration.getCompilerSettings().getCompiler(context.getLanguageKind());
        }
        this.myHasNullabilityFeature = OCCompilerHelper.supportsNullability(context);
    }

    public OCBuilderDriver(@NotNull OCFile file2, @NotNull OCInclusionContext context, @NotNull FlyweightCapableTreeStructure<T> structure, @NotNull BuilderDriverBase.NamedNodeStructure<T> nodeStructure, @NotNull Processor<OCSymbol> builder) {
        super(file2, context, null, structure, nodeStructure, builder, OCInclusionContextUtil.getVirtualFile(file2));
    }

    public void processDeclarationsList(@NotNull T root) {
        IElementType predefClassType = null;
        for (T child : this.getChildren(root)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.DECLARATION || tt == OCElementTypes.FUNCTION_DECLARATION || tt == OCElementTypes.FUNCTION_DEFINITION || tt == OCElementTypes.FUNCTION_KR_DEFINITION) {
                this.processDeclaration(child, (Processor<OCSymbol>)this.builder, new BuilderDriverBase.DeclarationContext(tt == OCElementTypes.FUNCTION_DEFINITION ? OCSymbolKind.FUNCTION_DECLARATION : null));
            }
            if (tt == OCElementTypes.OBJC_KEYWORD) {
                for (T grChild : this.getChildren(child)) {
                    IElementType grTt = this.type(grChild);
                    if (grTt != OCTokenTypes.CLASS_KEYWORD && grTt != OCTokenTypes.PROTOCOL_KEYWORD) continue;
                    predefClassType = grTt;
                }
            } else if (OCElementTypes.CLASSES.contains(tt) || tt == OCElementTypes.CLASS_PREDEF) {
                this.processClassDeclaration(child, (Processor<OCSymbol>)this.builder, predefClassType);
            } else if (tt == OCElementTypes.COMPATIBILITY_ALIAS) {
                this.processCompatibilityAlias(child, (Processor<OCSymbol>)this.builder, new BuilderDriverBase.DeclarationContext());
            } else if (tt == OCElementTypes.IMPORT_MODULE_STATEMENT) {
                this.processImportModuleStatement(child);
            } else if (tt == OCElementTypes.CLASS_PREDEF_LIST) {
                this.processDeclarationsList(child);
            } else if (tt == OCElementTypes.CPP_NAMESPACE) {
                this.processNamespace(child, (Processor<OCSymbol>)this.builder, new BuilderDriverBase.DeclarationContext(), null, null, null);
            } else if (tt == OCElementTypes.CPP_NAMESPACE_ALIAS) {
                this.processNamespaceAlias(child, (Processor<OCSymbol>)this.builder, new BuilderDriverBase.DeclarationContext());
            } else if (tt == OCElementTypes.CPP_USING_STATEMENT) {
                this.processUsingStatement(child, (Processor<OCSymbol>)this.builder, new BuilderDriverBase.DeclarationContext());
            } else if (tt == OCElementTypes.CPP_EXTERN_BLOCK) {
                this.processDeclarationsList(child);
            }
            this.processDefines(child);
        }
    }

    private void processDefines(@NotNull T root) {
        IElementType tt = this.type(root);
        if (tt == OCElementTypes.MACRO_DEFINITION) {
            this.processDefineDirective(root, true);
        } else if (tt == OCElementTypes.MACRO_UNDEFINITION) {
            this.processDefineDirective(root, false);
        } else if (tt == OCElementTypes.IMPORT_DIRECTIVE) {
            this.processImportDirective(root);
        } else if (tt == OCElementTypes.CPP_PRAGMA) {
            for (T child : this.getChildren(root)) {
                if (this.type(child) != OCTokenTypes.STRING_LITERAL) continue;
                String pragmaKey = this.nodeText(child);
                if ("\"clang arc_cf_code_audited begin\"".equals(pragmaKey)) {
                    this.myImplicitBridgingOn = true;
                }
                if (!"\"clang arc_cf_code_audited end\"".equals(pragmaKey)) continue;
                this.myImplicitBridgingOn = false;
            }
        } else if (tt == OCElementTypes.PRAGMA) {
            this.processPragma(root);
        } else {
            for (T child : this.getChildren(root)) {
                this.processDefines(child);
            }
        }
    }

    private void processCompatibilityAlias(@NotNull T node, @NotNull Processor<OCSymbol> builder, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        String name = null;
        long nameOffset = -1L;
        OCType type = null;
        for (T child : this.getChildren(node)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.IDENTIFIER) {
                name = this.nodeText(child);
                nameOffset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                continue;
            }
            if (tt != OCElementTypes.REFERENCE_ELEMENT) continue;
            OCTypeBuilder typeBuilder = new OCTypeBuilder(this.myLanguageKind, this.project, context);
            type = this.processTypeElement(child, typeBuilder, builder, context);
        }
        if (!StringUtil.isEmptyOrSpaces(name) && type != null) {
            OCCompatibilityAliasSymbol symbol = new OCCompatibilityAliasSymbol(this.project, this.myVirtualFile, nameOffset, name, type);
            builder.process((Object)symbol);
        }
    }

    public void processClassDeclaration(@NotNull T classNode, @NotNull Processor<OCSymbol> builder, @Nullable IElementType predefClassType) {
        IElementType classType = this.type(classNode);
        String name = null;
        String category = null;
        T superClassRef = null;
        long nameOffset = -1L;
        ArrayList<T> optionalMethodNodes = new ArrayList<T>();
        ArrayList<T> requiredMethodNodes = new ArrayList<T>();
        ArrayList<T> optionalPropertyNodes = new ArrayList<T>();
        ArrayList<T> requiredPropertyNodes = new ArrayList<T>();
        ArrayList<T> synthesizeNodes = new ArrayList<T>();
        List<Object> genericParameterNodes = new ArrayList();
        List<String> attList = Collections.emptyList();
        T ivarsNode = null;
        List<String> protocolNames = Collections.emptyList();
        boolean isOptional = false;
        for (T child : this.getChildren(classNode)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.IDENTIFIER) {
                Iterator<T> id = this.nodeText(child);
                if (name != null) break;
                name = id;
                nameOffset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                continue;
            }
            if (tt == OCElementTypes.CATEGORY_NAME) {
                category = "";
                for (T grChild : this.getChildren(child)) {
                    if (this.type(grChild) != OCTokenTypes.IDENTIFIER) continue;
                    category = this.nodeText(grChild);
                }
                continue;
            }
            if (tt == OCElementTypes.OBJC_KEYWORD) {
                for (T grChild : this.getChildren(child)) {
                    if (this.type(grChild) == OCTokenTypes.OPTIONAL_KEYWORD) {
                        isOptional = true;
                        continue;
                    }
                    if (this.type(grChild) != OCTokenTypes.REQUIRED_KEYWORD) continue;
                    isOptional = false;
                }
                continue;
            }
            if (tt == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
                synthesizeNodes.add(child);
                continue;
            }
            if (tt == OCElementTypes.METHOD) {
                if (isOptional) {
                    optionalMethodNodes.add(child);
                    continue;
                }
                requiredMethodNodes.add(child);
                continue;
            }
            if (tt == OCElementTypes.PROPERTY) {
                if (isOptional) {
                    optionalPropertyNodes.add(child);
                    continue;
                }
                requiredPropertyNodes.add(child);
                continue;
            }
            if (tt == OCElementTypes.INSTANCE_VARIABLES_LIST) {
                ivarsNode = child;
                continue;
            }
            if (tt == OCElementTypes.SUPER_CLASS_REF) {
                List<T> superRefs = this.collectReferences(child);
                if (superRefs.size() <= 0) continue;
                superClassRef = superRefs.get(0);
                continue;
            }
            if (tt == OCElementTypes.ATTRIBUTES) {
                attList = this.processAttributeList(child);
                continue;
            }
            if (tt == OCElementTypes.PROTOCOL_LIST) {
                protocolNames = this.collectReferenceNames(child);
                continue;
            }
            if (tt == OCElementTypes.DECLARATION || tt == OCElementTypes.FUNCTION_DECLARATION || tt == OCElementTypes.FUNCTION_DEFINITION) {
                this.processDeclaration(child, builder, new BuilderDriverBase.DeclarationContext(tt == OCElementTypes.FUNCTION_DEFINITION ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.GLOBAL_VARIABLE));
                continue;
            }
            if (tt != OCElementTypes.GENERIC_PARAMETERS_LIST) continue;
            genericParameterNodes = this.collectGenericParameters(child);
        }
        if (name != null) {
            OCClassSymbolImpl klass;
            List<OCGenericParameterSymbol> genericParameters;
            MostlySingularMultiMap members = new MostlySingularMultiMap();
            List list = genericParameters = !genericParameterNodes.isEmpty() ? ContainerUtil.newArrayList() : ContainerUtil.emptyList();
            if (classType == OCElementTypes.INTERFACE) {
                klass = new OCInterfaceSymbolImpl(this.project, this.myVirtualFile, nameOffset, name, attList, category, (MostlySingularMultiMap<String, OCMemberSymbol>)members, protocolNames, null, genericParameters);
            } else if (classType == OCElementTypes.IMPLEMENTATION) {
                klass = new OCImplementationSymbol(this.project, this.myVirtualFile, nameOffset, name, attList, category, (MostlySingularMultiMap<String, OCMemberSymbol>)members, null);
            } else if (classType == OCElementTypes.PROTOCOL) {
                klass = new OCProtocolSymbolImpl(this.project, this.myVirtualFile, nameOffset, name, attList, category, (MostlySingularMultiMap<String, OCMemberSymbol>)members, protocolNames, null);
            } else if (classType == OCElementTypes.CLASS_PREDEF) {
                klass = predefClassType == OCTokenTypes.PROTOCOL_KEYWORD ? new OCProtocolSymbolImpl(this.project, this.myVirtualFile, nameOffset, name, attList, null, null, Collections.emptyList(), null) : new OCInterfaceSymbolImpl(this.project, this.myVirtualFile, nameOffset, name, attList, null, null, Collections.emptyList(), null, genericParameters);
            } else {
                throw new AssertionError((Object)"Unknown class kind");
            }
            this.processSuperClassRef(superClassRef, klass);
            for (Object genericParameterNode : genericParameterNodes) {
                this.processGenericParameter(genericParameterNode, genericParameters, klass);
            }
            if (genericParameters instanceof ArrayList) {
                ((ArrayList)genericParameters).trimToSize();
            }
            for (Object methodNode : requiredMethodNodes) {
                this.processMethod(methodNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass, false);
            }
            for (Object methodNode : optionalMethodNodes) {
                this.processMethod(methodNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass, true);
            }
            for (Object propertyNode : requiredPropertyNodes) {
                this.processProperty(propertyNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass, classType, false);
            }
            for (Object propertyNode : optionalPropertyNodes) {
                this.processProperty(propertyNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass, classType, true);
            }
            for (Object synthesizeNode : synthesizeNodes) {
                this.processSynthesizedProperties(synthesizeNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass);
            }
            if (ivarsNode != null) {
                this.handleInstanceVariables(ivarsNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass, builder);
            }
            builder.process((Object)klass);
        }
    }

    private void processSuperClassRef(@Nullable T superClassRef, @NotNull OCClassSymbol klass) {
        if (superClassRef != null) {
            BuilderDriverBase.DeclarationContext declarationContext = new BuilderDriverBase.DeclarationContext(null, null, OCBuilderDriver.withQualifiedNameOrNull(klass), null, null);
            OCTypeBuilder typeBuilder = new OCTypeBuilder(this.myLanguageKind, this.project, declarationContext);
            this.processReference(superClassRef, typeBuilder, declarationContext);
            OCType result = typeBuilder.getResult(false);
            if (result instanceof OCReferenceType) {
                klass.setSuperType((OCReferenceType)result);
            } else {
                String className = this.nodeTextNoIntern(superClassRef, false).trim();
                klass.setSuperType(OCReferenceType.fromText(OCNamesInternary.intern(className), Collections.emptyList()));
            }
        } else {
            klass.setSuperType(OCReferenceType.fromText("", Collections.emptyList()));
        }
    }

    public void processGenericParameter(@NotNull T genericParameterNode, @NotNull List<OCGenericParameterSymbol> members, @NotNull OCClassSymbol parent) {
        OCGenericParameterSymbol symbol = this.processGenericParameter(genericParameterNode, new BuilderDriverBase.DeclarationContext(null, parent, null, null, null));
        if (symbol != null) {
            members.add(symbol);
        }
    }

    @Nullable
    public OCGenericParameterSymbol processGenericParameter(@NotNull T genericParameterNode, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        OCGenericParameterSymbol.Covariance covariance = OCGenericParameterSymbol.Covariance.INVARIANT;
        OCType constraintType = null;
        String name = null;
        long offset = -1L;
        for (T child : this.getChildren(genericParameterNode)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.COVARIANT_KEYWORD) {
                covariance = OCGenericParameterSymbol.Covariance.COVARIANT;
                continue;
            }
            if (tt == OCTokenTypes.CONTRAVARIANT_KEYWORD) {
                covariance = OCGenericParameterSymbol.Covariance.CONTRAVARIANT;
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                OCTypeBuilder innerBuilder = new OCTypeBuilder(this.myLanguageKind, this.project, context);
                constraintType = this.processTypeElement(child, innerBuilder, (Processor<OCSymbol>)this.builder, context);
                continue;
            }
            if (tt != OCTokenTypes.IDENTIFIER) continue;
            name = this.nodeText(child);
            offset = this.getComplexOffsetFromNode(genericParameterNode);
        }
        if (name == null || offset == -1L) {
            return null;
        }
        if (constraintType == null) {
            constraintType = OCIdType.pointerToID(this.project);
        }
        return new OCGenericParameterSymbolImpl(this.project, this.myVirtualFile, offset, name, Collections.emptyList(), covariance, constraintType);
    }

    private void processSynthesizedProperties(@NotNull T propertyNode, @NotNull MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull OCClassSymbol parent) {
        boolean isSynthesize = false;
        for (T child : this.getChildren(propertyNode)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.OBJC_KEYWORD) {
                for (T grChild : this.getChildren(child)) {
                    if (this.type(grChild) != OCTokenTypes.SYNTHESIZE_KEYWORD) continue;
                    isSynthesize = true;
                }
                continue;
            }
            if (tt != OCElementTypes.SYNTHESIZED_PROPERTY) continue;
            T prop = null;
            T ivar = null;
            for (T grChild : this.getChildren(child)) {
                if (this.type(grChild) != OCElementTypes.REFERENCE_ELEMENT) continue;
                if (prop == null) {
                    prop = grChild;
                    continue;
                }
                ivar = grChild;
            }
            if (prop == null) {
                throw new AssertionError((Object)"Property node is null");
            }
            if (ivar == null) {
                ivar = prop;
            }
            String propName = this.nodeText(prop);
            String ivarName = this.nodeText(ivar);
            members.add((Object)propName, (Object)new OCSynthesizeSymbol(this.project, parent.getContainingFile(), this.getComplexOffsetFromNode(child), propName, Collections.emptyList(), parent, isSynthesize, ivar != prop ? ivarName : null));
            if (!isSynthesize) continue;
            members.add((Object)ivarName, (Object)new OCInstanceVariableSymbolImpl(this.project, parent.getContainingFile(), this.getComplexOffsetFromNode(ivar), ivarName, Collections.emptyList(), parent, OCUnknownType.INSTANCE, OCVisibility.PRIVATE, propName));
        }
    }

    @NotNull
    private List<T> collectReferences(@NotNull T listNode) {
        List answer = null;
        for (T child : this.getChildren(listNode)) {
            if (this.type(child) != OCElementTypes.REFERENCE_ELEMENT) continue;
            if (answer == null) {
                answer = new ArrayList();
            }
            answer.add(child);
        }
        return answer != null ? answer : Collections.emptyList();
    }

    @NotNull
    private List<String> collectReferenceNames(@NotNull T protocolListNode) {
        return ContainerUtil.map(this.collectReferences(protocolListNode), (Function)new Function<T, String>(){

            public String fun(T t) {
                return OCNamesInternary.intern(OCBuilderDriver.this.nodeTextNoIntern(t, false).trim());
            }
        });
    }

    @NotNull
    private List<T> collectGenericParameters(@NotNull T genericParametersListNode) {
        List answer = null;
        for (T child : this.getChildren(genericParametersListNode)) {
            if (this.type(child) != OCElementTypes.GENERIC_PARAMETER) continue;
            if (answer == null) {
                answer = new ArrayList();
            }
            answer.add(child);
        }
        return answer != null ? answer : Collections.emptyList();
    }

    public void processProperty(@NotNull T propertyNode, final @NotNull MostlySingularMultiMap<String, OCMemberSymbol> members, final @NotNull OCClassSymbol parent, final @NotNull IElementType classType, final boolean isOptional) {
        final EnumSet<OCPropertySymbol.PropertyAttribute> attributes = EnumSet.noneOf(OCPropertySymbol.PropertyAttribute.class);
        final EnumMap<OCPropertySymbol.PropertyAttribute, String> stringAttributes = new EnumMap<OCPropertySymbol.PropertyAttribute, String>(OCPropertySymbol.PropertyAttribute.class);
        for (T child : this.getChildren(propertyNode)) {
            IElementType elementType = this.type(child);
            if (elementType == OCElementTypes.PROPERTY_ATTRIBUTES_LIST) {
                for (T attr : this.getChildren(child)) {
                    if (this.type(attr) != OCElementTypes.PROPERTY_ATTRIBUTE) continue;
                    OCPropertySymbol.PropertyAttribute attribute = null;
                    for (T attrKid : this.getChildren(attr)) {
                        if (this.type(attrKid) != OCTokenTypes.IDENTIFIER) continue;
                        if (attribute == null) {
                            attribute = OCPropertySymbolImpl.parseAttribute(this.nodeText(attrKid));
                            if (!this.myHasNullabilityFeature && attribute != null && attribute.getGroup() == 5) {
                                attribute = null;
                            }
                            if (attribute == null || attribute == OCPropertySymbol.PropertyAttribute.GETTER || attribute == OCPropertySymbol.PropertyAttribute.SETTER) continue;
                            attributes.add(attribute);
                            continue;
                        }
                        if (attribute != OCPropertySymbol.PropertyAttribute.GETTER && attribute != OCPropertySymbol.PropertyAttribute.SETTER) continue;
                        String methodName = this.nodeText(attrKid);
                        stringAttributes.put(attribute, methodName);
                    }
                }
                continue;
            }
            if (elementType != OCElementTypes.DECLARATION && elementType != OCElementTypes.FUNCTION_DECLARATION) continue;
            this.processDeclaration(child, new Processor<OCSymbol>(){

                public boolean process(OCSymbol ocSymbol) {
                    if (!(ocSymbol instanceof OCDeclaratorSymbol)) {
                        return true;
                    }
                    OCDeclaratorSymbol symbol = (OCDeclaratorSymbol)ocSymbol;
                    OCPropertySymbolImpl property = new OCPropertySymbolImpl(OCBuilderDriver.this.project, symbol.getContainingFile(), symbol.getOffset(), symbol.getName(), symbol.getAttributes(), parent, symbol.getType(), isOptional, attributes, stringAttributes);
                    members.add((Object)symbol.getName(), (Object)property);
                    String methodName = property.getGetterName();
                    List<OCMethodSymbol.SelectorPartSymbol> selectors = Collections.singletonList(new OCMethodSymbolImpl.SelectorPartSymbolImpl(null, methodName));
                    OCMethodSymbolImpl methodSymbol = new OCMethodSymbolImpl(OCBuilderDriver.this.project, symbol.getContainingFile(), symbol.getOffset(), methodName, symbol.getAttributes(), parent, false, isOptional, false, symbol.getType(), selectors, property);
                    members.add((Object)methodName, (Object)methodSymbol);
                    if (!property.isReadonly()) {
                        methodName = property.getSetterName();
                        OCDeclaratorSymbol paramSymbol = new OCDeclaratorSymbol(OCBuilderDriver.this.project, symbol.getContainingFile(), symbol.getOffset(), null, symbol.getName(), symbol.getAttributes(), symbol.getType(), OCSymbolKind.PARAMETER);
                        members.add((Object)methodName, (Object)new OCMethodSymbolImpl(OCBuilderDriver.this.project, symbol.getContainingFile(), symbol.getOffset(), methodName, symbol.getAttributes(), parent, false, isOptional, false, OCVoidType.instance(), Collections.singletonList(new OCMethodSymbolImpl.SelectorPartSymbolImpl(paramSymbol, methodName)), property));
                    }
                    if (classType == OCElementTypes.INTERFACE) {
                        String ivarName = OCNameSuggester.getClang4ImplicitIvarName(symbol.getName());
                        members.add((Object)ivarName, (Object)new OCInstanceVariableSymbolImpl(OCBuilderDriver.this.project, symbol.getContainingFile(), 0x100000000L, ivarName, Collections.emptyList(), parent, symbol.getType(), OCVisibility.PRIVATE, property.getName()));
                    }
                    return true;
                }
            }, new BuilderDriverBase.DeclarationContext(null, null, OCBuilderDriver.withQualifiedNameOrNull(parent), null, null));
        }
    }

    private void processMethod(@NotNull T methodNode, @NotNull MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull OCClassSymbol parent, boolean isOptional) {
        StringBuilder selector = new StringBuilder();
        boolean isStatic = false;
        boolean isVararg = false;
        OCType returnType = null;
        long offset = -1L;
        ArrayList<OCMethodSymbol.SelectorPartSymbol> selectors = new ArrayList<OCMethodSymbol.SelectorPartSymbol>();
        List<String> attributeList = null;
        for (T child : this.getChildren(methodNode)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.METHOD_SELECTOR_PART) {
                Ref startOffsetRef = new Ref();
                OCMethodSymbol.SelectorPartSymbol selectorPartSymbol = this.processSelectorPart(child, selector, null, (Ref<Long>)startOffsetRef, parent);
                if (selectorPartSymbol != null) {
                    selectors.add(selectorPartSymbol);
                }
                if (offset != -1L || startOffsetRef.isNull()) continue;
                offset = (Long)startOffsetRef.get();
                continue;
            }
            if (tt == OCElementTypes.PARAMETER_DECLARATION) {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                this.processParameterDeclaration(child, (Processor<OCDeclaratorSymbol>)finder);
                OCMethodSymbolImpl.SelectorPartSymbolImpl syntheticSelector = new OCMethodSymbolImpl.SelectorPartSymbolImpl((OCDeclaratorSymbol)finder.getFoundValue(), null);
                selectors.add(syntheticSelector);
                continue;
            }
            if (tt == OCElementTypes.ATTRIBUTES) {
                if (attributeList != null) {
                    attributeList.addAll(this.processAttributeList(child));
                    continue;
                }
                attributeList = this.processAttributeList(child);
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                BuilderDriverBase.DeclarationContext returnContext = new BuilderDriverBase.DeclarationContext(null, null, OCBuilderDriver.withQualifiedNameOrNull(parent), null, null);
                returnType = this.processTypeElement(child, new OCTypeBuilder(this.myLanguageKind, this.project, returnContext), (Processor<OCSymbol>)this.builder, returnContext);
                List<String> attributes = returnContext.getAttributes();
                if (attributeList != null) {
                    if (attributes == null) continue;
                    attributeList.addAll(attributes);
                    continue;
                }
                attributeList = attributes;
                continue;
            }
            if (tt == OCTokenTypes.PLUS) {
                isStatic = true;
                continue;
            }
            if (tt != OCTokenTypes.ELLIPSIS) continue;
            isVararg = true;
        }
        if (attributeList == null) {
            attributeList = Collections.emptyList();
        }
        if (offset == -1L) {
            offset = this.getComplexOffsetFromNode(methodNode);
        }
        if (selector.length() > 0) {
            members.add((Object)selector.toString(), (Object)new OCMethodSymbolImpl(this.project, this.myVirtualFile, offset, selector.toString(), attributeList, parent, isStatic, isOptional, isVararg, returnType != null ? returnType : OCIdType.pointerToID(this.project), selectors, null));
        }
    }

    @Nullable
    private static OCSymbolWithQualifiedName withQualifiedNameOrNull(@Nullable OCClassSymbol parent) {
        return parent instanceof OCSymbolWithQualifiedName ? (OCSymbolWithQualifiedName)((Object)parent) : null;
    }

    private void handleInstanceVariables(@NotNull T ivarsNode, final @NotNull MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull OCClassSymbol parent, final @NotNull Processor<OCSymbol> ownerBuilder) {
        this.processInstanceVariables(ivarsNode, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCInstanceVariableSymbol) {
                    members.add((Object)symbol.getName(), (Object)((OCMemberSymbol)symbol));
                } else if (symbol.getKind().isType() || symbol.getKind() == OCSymbolKind.ENUM_CONST) {
                    ownerBuilder.process((Object)symbol);
                }
                return true;
            }
        }, parent);
    }

    @Nullable
    public OCMethodSymbol.SelectorPartSymbol processSelectorPart(@NotNull T selectorNode, @NotNull StringBuilder builder, @Nullable TextRange scope, @NotNull Ref<Long> startOffset, @Nullable OCClassSymbol parent) {
        String selectorName = null;
        String parameterName = null;
        OCType paramType = OCIdType.pointerToID(this.project);
        boolean passByReference = false;
        long offset = this.getComplexOffsetFromNode(selectorNode);
        List<String> stringAttributes = null;
        for (T child : this.getChildren(selectorNode)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.IDENTIFIER) {
                offset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                if (selectorName == null) {
                    startOffset.set((Object)offset);
                    selectorName = this.nodeText(child);
                    builder.append(selectorName);
                    continue;
                }
                parameterName = this.nodeText(child);
                continue;
            }
            if (tt == OCTokenTypes.COLON) {
                selectorName = selectorName != null ? selectorName + ":" : ":";
                builder.append(':');
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                BuilderDriverBase.DeclarationContext declarationContext = new BuilderDriverBase.DeclarationContext(null, null, OCBuilderDriver.withQualifiedNameOrNull(parent), null, null);
                OCTypeBuilder typeBuilder = new OCTypeBuilder(this.myLanguageKind, this.project, declarationContext);
                paramType = this.processTypeElement(child, typeBuilder, (Processor<OCSymbol>)this.builder, declarationContext);
                passByReference = typeBuilder.isPassByReference();
                List<String> attributes = declarationContext.getAttributes();
                if (attributes == null) continue;
                if (stringAttributes != null) {
                    stringAttributes.addAll(attributes);
                    continue;
                }
                stringAttributes = attributes;
                continue;
            }
            if (tt != OCElementTypes.ATTRIBUTES) continue;
            if (stringAttributes != null) {
                stringAttributes.addAll(this.processAttributeList(child));
                continue;
            }
            stringAttributes = this.processAttributeList(child);
        }
        if (selectorName != null) {
            OCDeclaratorSymbol parameter = null;
            if (parameterName != null) {
                if (stringAttributes == null) {
                    stringAttributes = Collections.emptyList();
                }
                OCQualifiedName qualifiedName = OCQualifiedName.interned(parameterName);
                int properties = passByReference ? OCDeclaratorSymbol.Property.IS_PASS_BY_REF.getMask() : 0;
                parameter = new OCDeclaratorSymbol(this.project, this.myVirtualFile, offset, OCBuilderDriver.withQualifiedNameOrNull(parent), qualifiedName, stringAttributes, paramType, OCSymbolKind.PARAMETER, ArrayUtil.EMPTY_INT_ARRAY, null, Collections.emptyList(), properties, 0, scope, null);
            }
            return new OCMethodSymbolImpl.SelectorPartSymbolImpl(parameter, selectorName);
        }
        return null;
    }

    private void processInstanceVariables(@NotNull T parentNode, @NotNull Processor<OCSymbol> builder, @NotNull OCClassSymbol parent) {
        OCVisibility curScope = OCVisibility.getDefaultObjCVisibility(OCSymbolKind.INSTANCE_VARIABLE);
        for (T child : this.getChildren(parentNode)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.OBJC_KEYWORD) {
                for (T grChild : this.getChildren(child)) {
                    IElementType grTt = this.type(grChild);
                    if (!OCTokenTypes.IVAR_VISIBILITY_KEYWORDS.contains(grTt)) continue;
                    curScope = OCVisibility.getVisibilityFromElementType(grTt);
                }
                continue;
            }
            if (tt != OCElementTypes.DECLARATION) continue;
            this.processDeclaration(child, builder, new BuilderDriverBase.DeclarationContext(null, parent, null, curScope, null));
        }
    }

    public void processNamespaceAlias(@NotNull T alias, @NotNull Processor<OCSymbol> builder, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        String name = null;
        OCQualifiedName qualifiedName = null;
        Object parent = context.getParent();
        TextRange scope = parent instanceof OCElement ? ((OCElement)parent).getTextRange() : null;
        for (T child : this.getChildren(alias)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.IDENTIFIER) {
                name = this.nodeText(child);
                continue;
            }
            if (tt != OCElementTypes.REFERENCE_ELEMENT) continue;
            qualifiedName = this.processQualifiedName(child, qualifiedName, context);
        }
        if (qualifiedName != null) {
            long startOffset = this.getComplexOffsetFromNode(alias);
            OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(qualifiedName, context.getParentSymbol(), OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE);
            context.addSymbolReference(reference);
            OCNamespaceAliasSymbol result = new OCNamespaceAliasSymbol(this.project, this.myVirtualFile, startOffset, context.getParentSymbol(), OCQualifiedName.interned(name), reference, scope);
            builder.process((Object)result);
        }
    }

    public void processUsingStatement(@NotNull T statement2, @NotNull Processor<OCSymbol> builder, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        OCSymbolKind kind = OCSymbolKind.SYMBOL_USING_SYMBOL;
        OCQualifiedName qualifiedName = null;
        String name = null;
        OCType type = null;
        long nameOffset = 0L;
        Object parent = context.getParent();
        TextRange scope = parent instanceof OCElement ? ((OCElement)parent).getTextRange() : null;
        OCSymbolImpl result = null;
        for (T child : this.getChildren(statement2)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
                context.getTemplateParameters().add(child);
            } else if (tt != OCTokenTypes.USING_CPP_KEYWORD) {
                if (tt == OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
                    kind = OCSymbolKind.NAMESPACE_USING_SYMBOL;
                } else if (tt == OCTokenTypes.IDENTIFIER) {
                    name = this.nodeText(child);
                    nameOffset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                }
            }
            if (tt == OCTokenTypes.COLON2X && qualifiedName == null) {
                qualifiedName = OCQualifiedName.GLOBAL;
                continue;
            }
            if (tt == OCElementTypes.REFERENCE_ELEMENT) {
                if (name != null) continue;
                qualifiedName = this.processQualifiedName(child, qualifiedName, context);
                nameOffset = this.getComplexOffsetFromNode(child);
                continue;
            }
            if (tt != OCElementTypes.TYPE_ELEMENT) continue;
            ArrayList<OCTypeParameterSymbol> templateParameters = context.getTemplateParameters().isEmpty() ? Collections.emptyList() : new ArrayList<OCTypeParameterSymbol>();
            OCAliasUsingSymbol usingSymbol = new OCAliasUsingSymbol(this.project, this.myVirtualFile, nameOffset, name != null ? name : "", context.getParentSymbol(), templateParameters, scope);
            result = usingSymbol;
            for (T params : context.getTemplateParameters()) {
                this.processTemplateParameterList(params, templateParameters, new BuilderDriverBase.DeclarationContext(null, null, usingSymbol, null, null));
                templateParameters.trimToSize();
            }
            BuilderDriverBase.DeclarationContext context1 = new BuilderDriverBase.DeclarationContext(null, null, (OCSymbolWithQualifiedName)result, null, null);
            OCTypeBuilder innerBuilder = new OCTypeBuilder(this.myLanguageKind, this.project, context1);
            type = this.processTypeElement(child, innerBuilder, builder, context1);
            ((OCAliasUsingSymbol)result).setType(type);
        }
        if (qualifiedName != null && qualifiedName.getName() != null) {
            OCSymbolReference.SymbolFilter filter = OCSymbolReference.SymbolFilter.NONE;
            if (kind == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                filter = OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE;
            }
            OCSymbolReference reference = context.getLocalContext() != null ? OCSymbolReference.getLocalReference(qualifiedName, context.getLocalContext(), filter) : OCSymbolReference.getGlobalReference(qualifiedName, context.getParentSymbol(), filter);
            context.addSymbolReference(reference);
            result = new OCUsingSymbol(this.project, this.myVirtualFile, nameOffset, context.getParentSymbol(), reference, kind, context.getVisibility(), Collections.emptyList(), scope);
        } else if (name == null || type != null) {
            // empty if block
        }
        if (result != null) {
            builder.process(result);
        }
    }

    public void processNamespace(@NotNull T namespace, @NotNull Processor<OCSymbol> builder, @NotNull BuilderDriverBase.DeclarationContext<T> context, @Nullable String name, @Nullable Processor<OCSymbol> namespaceBuilder, @Nullable OCSymbolWithQualifiedName symbol) {
        boolean inline = false;
        boolean declareSymbol = symbol == null;
        for (T child : this.getChildren(namespace)) {
            IElementType tt = this.type(child);
            if (tt != OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
                if (tt == OCTokenTypes.INLINE_KEYWORD) {
                    inline = true;
                } else if (tt == OCTokenTypes.IDENTIFIER) {
                    name = this.nodeText(child);
                    if (this.myCompilerKind != OCCompilerKind.CLANG && name.equals("__1") && context.getParentSymbol() != null && "std".equals(context.getParentSymbol().getNameWithParent())) {
                        inline = true;
                    }
                } else if (tt == OCElementTypes.DECLARATION || tt == OCElementTypes.FUNCTION_DECLARATION || tt == OCElementTypes.FUNCTION_DEFINITION || tt == OCElementTypes.CPP_NAMESPACE || tt == OCElementTypes.CPP_NAMESPACE_ALIAS || tt == OCElementTypes.CPP_USING_STATEMENT || tt == OCTokenTypes.LBRACE || tt == OCElementTypes.CPP_EXTERN_BLOCK) {
                    if (namespaceBuilder == null) {
                        if (name != null) {
                            long startOffset = this.getComplexOffsetFromNode(namespace);
                            symbol = new OCNamespaceSymbol(this.project, this.myVirtualFile, startOffset, context.getParentSymbol(), OCQualifiedName.interned(name), Collections.emptyList(), null, null, null, inline);
                            namespaceBuilder = ((OCNamespaceSymbol)symbol).getBuilder();
                        } else {
                            symbol = context.getParentSymbol();
                            namespaceBuilder = builder;
                        }
                    }
                    if (tt == OCElementTypes.DECLARATION || tt == OCElementTypes.FUNCTION_DECLARATION || tt == OCElementTypes.FUNCTION_DEFINITION) {
                        this.processDeclaration(child, namespaceBuilder, new BuilderDriverBase.DeclarationContext(tt == OCElementTypes.FUNCTION_DEFINITION ? OCSymbolKind.FUNCTION_DECLARATION : null, null, symbol, null, null));
                    } else if (tt == OCElementTypes.CPP_NAMESPACE) {
                        this.processNamespace(child, namespaceBuilder, new BuilderDriverBase.DeclarationContext(null, null, symbol, null, null), null, null, null);
                    } else if (tt == OCElementTypes.CPP_NAMESPACE_ALIAS) {
                        this.processNamespaceAlias(child, namespaceBuilder, new BuilderDriverBase.DeclarationContext(null, null, symbol, null, null));
                    } else if (tt == OCElementTypes.CPP_USING_STATEMENT) {
                        this.processUsingStatement(child, namespaceBuilder, new BuilderDriverBase.DeclarationContext(null, null, symbol, null, null));
                    } else if (tt == OCElementTypes.CPP_EXTERN_BLOCK) {
                        this.processNamespace(child, builder, context, name, namespaceBuilder, symbol);
                    }
                }
            }
            this.processDefines(child);
        }
        if (declareSymbol && name != null && symbol != null) {
            builder.process((Object)symbol);
            if (inline) {
                OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(OCQualifiedName.with(name), context.getParentSymbol());
                context.addSymbolReference(reference);
                builder.process((Object)new OCUsingSymbol(this.project, null, 0L, context.getParentSymbol(), reference, OCSymbolKind.NAMESPACE_USING_SYMBOL, null, Collections.emptyList(), null));
            }
        }
    }

    public void processDeclaration(@NotNull T declaration, @NotNull Processor<OCSymbol> builder, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        Object child;
        int i;
        List children2 = ContainerUtil.collect(this.getChildren(declaration).iterator());
        boolean wasType = false;
        OCTypeBuilder typeBuilder = new OCTypeBuilder(this.myLanguageKind, this.project, context);
        context.pushDeclaration();
        if (this.type(declaration) == OCElementTypes.FUNCTION_KR_DEFINITION) {
            for (i = children2.size() - 1; i >= 0; --i) {
                child = children2.get(i);
                if (this.type(child) != OCElementTypes.PARAMETER_LIST) continue;
                context.myKRParamterList = child;
            }
        }
        for (i = 0; i < children2.size(); ++i) {
            child = children2.get(i);
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.ATTRIBUTES) {
                context.addAttributes(this.processAttributeList(child));
                continue;
            }
            if (tt == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                context.setTemplateSymbol(true);
                continue;
            }
            if (tt == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
                context.getTemplateParameters().add(child);
                continue;
            }
            if (tt == OCTokenTypes.EXTERN_KEYWORD) {
                context.setDeclaratorType(OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION);
                context.addModifier(OCSymbolAttribute.EXTERN);
                continue;
            }
            if (tt == OCTokenTypes.INLINE_KEYWORD) {
                context.addModifier(OCSymbolAttribute.INLINE);
                continue;
            }
            if (tt == OCTokenTypes.EXPLICIT_CPP_KEYWORD) {
                context.addModifier(OCSymbolAttribute.EXPLICIT);
                continue;
            }
            if (tt == OCTokenTypes.STATIC_KEYWORD) {
                context.addModifier(OCSymbolAttribute.STATIC);
                continue;
            }
            if (tt == OCTokenTypes.REGISTER_KEYWORD) {
                context.addModifier(OCSymbolAttribute.REGISTER);
                continue;
            }
            if (tt == OCTokenTypes.THREAD_LOCAL_KEYWORD) {
                context.addModifier(OCSymbolAttribute.THREAD_LOCAL);
                continue;
            }
            if (tt == OCTokenTypes.MUTABLE_CPP_KEYWORD) {
                context.addModifier(OCSymbolAttribute.MUTABLE);
                continue;
            }
            if (tt == OCTokenTypes.VIRTUAL_CPP_KEYWORD) {
                context.addModifier(OCSymbolAttribute.VIRTUAL);
                continue;
            }
            if (tt == OCTokenTypes.CONSTEXPR_CPP_KEYWORD) {
                context.addModifier(OCSymbolAttribute.CONSTEEXPR);
                continue;
            }
            if (tt == OCTokenTypes.FRIEND_CPP_KEYWORD) {
                context.addModifier(OCSymbolAttribute.FRIEND);
                continue;
            }
            if (tt == OCElementTypes.DECLARATOR) {
                if (!wasType) {
                    context.setDeclarationWithoutType(true);
                }
                this.processDeclarator(child, typeBuilder, builder, context);
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                wasType = true;
                boolean hasDeclarator = false;
                for (int j = i + 1; j < children2.size(); ++j) {
                    if (this.type(children2.get(j)) != OCElementTypes.DECLARATOR) continue;
                    hasDeclarator = true;
                    break;
                }
                context.setDeclarationWithoutDeclarators(!hasDeclarator);
                this.processTypeElement(child, typeBuilder, builder, context);
                continue;
            }
            if (tt != OCTokenTypes.AUTO_KEYWORD) continue;
            typeBuilder.learn(tt);
        }
        OCType type = typeBuilder.getResult();
        if (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM) {
            for (OCDeclaratorSymbol symbol : ((OCStructType)type).getFields()) {
                symbol.setType(type);
                symbol.addAttributes(((OCStructType)type).getSymbol().getAttributes());
            }
        }
        context.popDeclaration();
    }

    public long getComplexOffsetFromNode(@NotNull T node) {
        List children2 = ContainerUtil.collect(this.getChildren(node).iterator());
        long offset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, node);
        if (children2.isEmpty()) {
            return offset;
        }
        return OCSymbolOffsetUtil.adjust(offset, this.getComplexOffsetFromNode(children2.get(0)));
    }

    public OCType processTypeElement(@NotNull T typeElement, @NotNull OCTypeBuilder typeBuilder, @Nullable Processor<OCSymbol> builder, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        ArrayList<OCType> parameterTypes = null;
        ArrayList<String> parameterNames = null;
        boolean wasTypeOf = false;
        boolean first = true;
        boolean wasParamaters = false;
        boolean isConstFun = false;
        boolean isVolatileFun = false;
        for (T child : this.getChildren(typeElement)) {
            IElementType tt = this.type(child);
            if (first && tt == OCTokenTypes.LPAR) {
                first = false;
                continue;
            }
            if (tt == OCElementTypes.STRUCT || tt == OCElementTypes.ENUM || tt == OCElementTypes.UNION) {
                this.processStruct(child, typeBuilder, builder, context);
            } else if (tt == OCElementTypes.REFERENCE_ELEMENT) {
                this.processReference(child, typeBuilder, context);
            } else if (tt == OCElementTypes.PARAMETER_LIST) {
                wasParamaters = true;
                parameterTypes = new ArrayList<OCType>();
                parameterNames = new ArrayList<String>();
                this.processParameterList(child, null, parameterTypes, context, parameterNames);
            } else if (tt == OCTokenTypes.BLOCK_KEYWORD) {
                context.addModifier(OCSymbolAttribute.BLOCK_MODIFIABLE);
            } else if (tt == OCElementTypes.ATTRIBUTES) {
                context.addAttributes(this.processAttributeList(child));
            } else if (tt == OCTokenTypes.STATIC_KEYWORD) {
                context.addModifier(OCSymbolAttribute.STATIC);
            } else if (tt == OCTokenTypes.MUTABLE_CPP_KEYWORD) {
                context.addModifier(OCSymbolAttribute.MUTABLE);
            } else if (tt == OCTokenTypes.CONSTEXPR_CPP_KEYWORD) {
                context.addModifier(OCSymbolAttribute.CONSTEEXPR);
            } else if (tt == OCTokenTypes.CONST_KEYWORD) {
                if (wasParamaters) {
                    isConstFun = true;
                } else {
                    typeBuilder.learn(tt);
                }
            } else if (tt == OCTokenTypes.VOLATILE_KEYWORD) {
                if (wasParamaters) {
                    isVolatileFun = true;
                } else {
                    typeBuilder.learn(tt);
                }
            } else if (tt == OCTokenTypes.TYPEOF_KEYWORD || tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
                wasTypeOf = true;
            } else if (tt == OCTokenTypes.IDENTIFIER) {
                typeBuilder.learn(tt, this.nodeText(child));
            } else if (OCElementTypes.EXPRESSIONS.contains(tt) && wasTypeOf) {
                typeBuilder.learnBaseType(this.createAutoType(child, null, context));
            } else if (tt == OCElementTypes.LITERAL_EXPRESSION) {
                Object value = this.getIntegerConstValue(child);
                if (value instanceof Number) {
                    typeBuilder.learn(((Number)value).intValue());
                } else {
                    typeBuilder.learn(-1);
                }
            } else if (tt == OCElementTypes.CPP_QUALIFIED_POINTER) {
                for (T grChild : this.getChildren(child)) {
                    if (this.type(grChild) != OCElementTypes.CPP_NAMESPACE_QUALIFIER) continue;
                    typeBuilder.setPointerQualifier(this.processQualifiedName(grChild, null, context));
                }
                typeBuilder.learn(OCTokenTypes.MUL);
            } else if (!wasTypeOf || tt != OCTokenTypes.LPAR && tt != OCTokenTypes.RPAR) {
                typeBuilder.learn(tt);
            }
            first = false;
        }
        OCType returnType = typeBuilder.getResult(parameterTypes != null);
        return typeBuilder.createFunction(returnType, parameterTypes, parameterNames, true, isConstFun, isVolatileFun);
    }

    public void processStruct(@NotNull T structNode, @NotNull OCTypeBuilder typeBuilder, @Nullable Processor<OCSymbol> builder, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        T baseClause = null;
        T specialization = null;
        OCSymbolImpl structSymbol = null;
        String name = null;
        OCQualifiedName qualifier = null;
        OCQualifiedName nameWithArguments = null;
        OCSymbolKind kind = OCSymbolKind.STRUCT;
        OCSymbolKind contextType = OCSymbolKind.STRUCT_FIELD;
        List<String> attributeList = context.getAttributes();
        boolean isEnumClass = false;
        boolean isFinal = false;
        long startOffset = this.getComplexOffsetFromNode(structNode);
        Object parent = context.getParent();
        TextRange scope = parent instanceof OCElement ? ((OCElement)parent).getTextRange() : null;
        OCVisibility curVisibility = null;
        OCVisibility defaultVisibility = null;
        for (T child : this.getChildren(structNode)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.COLON2X && qualifier == null) {
                qualifier = OCQualifiedName.GLOBAL;
                continue;
            }
            if (tt == OCElementTypes.CPP_NAMESPACE_QUALIFIER) {
                qualifier = this.processQualifiedName(child, qualifier, context);
                continue;
            }
            if (tt == OCTokenTypes.FINAL_CPP_KEYWORD) {
                isFinal = true;
                continue;
            }
            if (tt == OCTokenTypes.LBRACE || tt == OCElementTypes.CPP_USING_STATEMENT || tt == OCElementTypes.DECLARATION || tt == OCElementTypes.FUNCTION_DECLARATION || tt == OCElementTypes.FUNCTION_DEFINITION) {
                boolean myAnonymous;
                boolean bl = myAnonymous = context.isDeclarationWithoutDeclarators && name == null && kind.isStructLike();
                if (structSymbol == null) {
                    ArrayList<Pair<OCType, OCVisibility>> bases = baseClause != null ? new ArrayList<Pair<OCType, OCVisibility>>() : Collections.emptyList();
                    OCQualifiedName ocQualifiedName = OCQualifiedName.interned(qualifier, name);
                    ArrayList<OCTypeParameterSymbol> templateParameters = context.getTemplateParameters().isEmpty() ? Collections.emptyList() : new ArrayList<OCTypeParameterSymbol>();
                    ArrayList<OCTypeArgument> templateSpecialization = specialization != null ? new ArrayList<OCTypeArgument>() : null;
                    int classProps = isEnumClass ? OCStructSymbol.Property.IS_ENUM_CLASS.getMask() : 0;
                    int classAttrs = isFinal ? OCSymbolAttribute.FINAL.getMask() : 0;
                    structSymbol = new OCStructSymbol(this.project, this.myVirtualFile, startOffset, context.getParentSymbol(), ocQualifiedName, Collections.emptyList(), kind, bases, templateParameters, templateSpecialization, new ArrayList<OCSymbol>(), (MostlySingularMultiMap<String, OCSymbol>)new MostlySingularMultiMap(), scope, context.getVisibility(), classProps, classAttrs);
                    this.prepareStruct((OCStructSymbol)structSymbol, templateParameters, templateSpecialization, context, specialization, baseClause, defaultVisibility, bases);
                    if (myAnonymous && ((OCSymbolWithQualifiedName)structSymbol).getParent() != null) {
                        builder.process((Object)new OCDeclaratorSymbol(this.project, this.myVirtualFile, structSymbol.getComplexOffset(), ((OCSymbolWithQualifiedName)structSymbol).getParent(), OCQualifiedName.interned(null), Collections.emptyList(), ((OCStructSymbol)structSymbol).getType(), OCSymbolKind.STRUCT_FIELD, ArrayUtil.EMPTY_INT_ARRAY, null, ((OCStructSymbol)structSymbol).getTemplateParameters(), 0, 0, ((OCStructSymbol)structSymbol).getScope(), null));
                    }
                }
                if (tt == OCTokenTypes.LBRACE) continue;
                if (tt == OCElementTypes.CPP_USING_STATEMENT) {
                    BuilderDriverBase.DeclarationContext innerContext = new BuilderDriverBase.DeclarationContext(null, null, (OCSymbolWithQualifiedName)structSymbol, curVisibility, null);
                    this.processUsingStatement(child, ((OCNamespaceSymbol)structSymbol).getBuilder(), innerContext);
                    continue;
                }
                OCSymbolImpl struct = structSymbol;
                final Processor<OCSymbol> structBuilder = ((OCNamespaceSymbol)structSymbol).getBuilder();
                final OCSymbolKind myKind = kind;
                final boolean myIsEnumClass = isEnumClass;
                OCSymbolKind memberKind = contextType;
                if (tt == OCElementTypes.FUNCTION_DEFINITION) {
                    memberKind = OCSymbolKind.FUNCTION_DECLARATION;
                }
                BuilderDriverBase.DeclarationContext declarationContext = new BuilderDriverBase.DeclarationContext(memberKind, context.getParent(), (OCSymbolWithQualifiedName)(myAnonymous || myKind == OCSymbolKind.ENUM && !myIsEnumClass ? ((OCSymbolWithQualifiedName)structSymbol).getParent() : structSymbol), curVisibility, context.getLocalContext());
                this.processDeclaration(child, new Processor<OCSymbol>((OCStructSymbol)struct, builder){
                    final /* synthetic */ OCStructSymbol val$struct;
                    final /* synthetic */ Processor val$builder;
                    {
                        this.val$struct = oCStructSymbol;
                        this.val$builder = processor3;
                    }

                    public boolean process(OCSymbol symbol) {
                        boolean addToParent = false;
                        if (symbol instanceof OCDeclaratorSymbol) {
                            OCDeclaratorSymbol dcl = (OCDeclaratorSymbol)symbol;
                            addToParent = !myIsEnumClass && myKind == OCSymbolKind.ENUM && dcl.getKind() == OCSymbolKind.ENUM_CONST;
                        } else if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isFriendFunction()) {
                            addToParent = true;
                        }
                        structBuilder.process((Object)symbol);
                        if (addToParent || myAnonymous && this.val$struct.getParent() instanceof OCStructSymbol && this.val$builder != null) {
                            this.val$builder.process((Object)symbol);
                        }
                        return true;
                    }
                }, declarationContext);
                continue;
            }
            if (tt == OCTokenTypes.STRUCT_KEYWORD || tt == OCTokenTypes.CLASS_KEYWORD) {
                if (kind != OCSymbolKind.ENUM) {
                    kind = OCSymbolKind.STRUCT;
                    if (curVisibility != null) continue;
                    defaultVisibility = tt == OCTokenTypes.STRUCT_KEYWORD ? OCVisibility.PUBLIC : OCVisibility.PRIVATE;
                    curVisibility = defaultVisibility;
                    continue;
                }
                isEnumClass = true;
                continue;
            }
            if (tt == OCTokenTypes.ENUM_KEYWORD) {
                kind = OCSymbolKind.ENUM;
                contextType = OCSymbolKind.ENUM_CONST;
                continue;
            }
            if (tt == OCTokenTypes.UNION_KEYWORD) {
                kind = OCSymbolKind.UNION;
                continue;
            }
            if (tt == OCTokenTypes.IDENTIFIER) {
                name = this.nodeText(child);
                startOffset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                continue;
            }
            if (OCTokenTypes.CPP_VISIBILITY_KEYWORDS.contains(tt)) {
                curVisibility = OCVisibility.getVisibilityFromElementType(tt);
                continue;
            }
            if (tt == OCElementTypes.REFERENCE_ELEMENT) {
                OCQualifiedName qualifiedName = this.processQualifiedName(child, null, context);
                name = qualifiedName.getName();
                startOffset = this.getComplexOffsetFromNode(child);
                qualifier = qualifiedName.getQualifier();
                if (!(qualifiedName instanceof OCQualifiedNameWithArguments)) continue;
                nameWithArguments = (OCQualifiedNameWithArguments)qualifiedName;
                continue;
            }
            if (tt == OCElementTypes.CPP_BASE_CLAUSE_LIST) {
                baseClause = child;
                continue;
            }
            if (tt == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                specialization = child;
                continue;
            }
            if (tt != OCElementTypes.ATTRIBUTES) continue;
            if (attributeList != null) {
                attributeList.addAll(this.processAttributeList(child));
                continue;
            }
            attributeList = this.processAttributeList(child);
        }
        if (attributeList == null) {
            attributeList = Collections.emptyList();
        }
        if (structSymbol == null) {
            OCQualifiedName qualifiedName = nameWithArguments != null ? nameWithArguments : OCQualifiedName.interned(qualifier, name);
            ArrayList<Pair<OCType, OCVisibility>> bases = baseClause != null ? new ArrayList<Pair<OCType, OCVisibility>>() : Collections.emptyList();
            ArrayList<OCTypeParameterSymbol> templateParameters = context.getTemplateParameters().isEmpty() ? Collections.emptyList() : new ArrayList<OCTypeParameterSymbol>();
            ArrayList<OCTypeArgument> templateSpecialization = specialization != null ? new ArrayList<OCTypeArgument>() : null;
            int classProps = isEnumClass ? OCStructSymbol.Property.IS_ENUM_CLASS.getMask() : 0;
            int classAttrs = context.getModifiers();
            structSymbol = new OCStructSymbol(this.project, this.myVirtualFile, startOffset, context.getParentSymbol(), qualifiedName, attributeList, kind, bases, templateParameters, templateSpecialization, null, null, scope, context.getVisibility(), classProps, classAttrs);
            this.prepareStruct((OCStructSymbol)structSymbol, templateParameters, templateSpecialization, context, specialization, baseClause, defaultVisibility, bases);
        } else {
            structSymbol.addAttributes(attributeList);
        }
        if (((OCNamespaceSymbol)structSymbol).getMembers() == null) {
            typeBuilder.setLocalContext(context);
            typeBuilder.learn(OCTokenTypes.IDENTIFIER, kind.getNameLowercase() + " " + name);
            typeBuilder.learnNamespaceQualifier(qualifier);
            if (nameWithArguments != null) {
                typeBuilder.learnTypeArguments(((OCQualifiedNameWithArguments)nameWithArguments).getArguments());
            }
        } else {
            boolean isConst = typeBuilder.eraseWasConst();
            OCStructType type = new OCStructType(Collections.singletonList(structSymbol), null, isConst, false);
            typeBuilder.learnBaseType(type);
        }
        if (name != null && structSymbol != null && builder != null) {
            builder.process((Object)structSymbol);
        }
    }

    private void prepareStruct(OCStructSymbol structSymbol, List<OCTypeParameterSymbol> templateParameters, List<OCTypeArgument> templateSpecialization, BuilderDriverBase.DeclarationContext<T> context, T specialization, T baseClause, OCVisibility defaultVisibility, List<Pair<OCType, OCVisibility>> bases) {
        if (specialization != null) {
            BuilderDriverBase.DeclarationContext declarationContext = new BuilderDriverBase.DeclarationContext(null, null, structSymbol, null, null);
            declarationContext.setInsideTemplateParams(true);
            this.processTemplateArgumentList(specialization, templateSpecialization, declarationContext);
        }
        this.processStructBaseClause(baseClause, structSymbol, defaultVisibility, bases, context);
        for (T params : context.getTemplateParameters()) {
            this.processTemplateParameterList(params, templateParameters, new BuilderDriverBase.DeclarationContext(null, null, structSymbol, null, null));
            ((ArrayList)templateParameters).trimToSize();
        }
    }

    private void processStructBaseClause(@Nullable T baseClause, @Nullable OCStructSymbol structSymbol, @Nullable OCVisibility defaultVisibility, @NotNull List<Pair<OCType, OCVisibility>> bases, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        if (baseClause != null) {
            OCVisibility inheritanceVisibility = defaultVisibility;
            for (T child : this.getChildren(baseClause)) {
                for (T grChild : this.getChildren(child)) {
                    IElementType childType = this.type(grChild);
                    if (childType == OCElementTypes.REFERENCE_ELEMENT || childType == OCElementTypes.TYPE_ELEMENT) {
                        BuilderDriverBase.DeclarationContext innerContext = new BuilderDriverBase.DeclarationContext(null, null, structSymbol, null, context.getLocalContext());
                        OCTypeBuilder innerBuilder = new OCTypeBuilder(this.myLanguageKind, this.project, innerContext);
                        innerContext.setBaseClause(true);
                        if (childType == OCElementTypes.TYPE_ELEMENT) {
                            this.processTypeElement(grChild, innerBuilder, (Processor<OCSymbol>)this.builder, innerContext);
                        } else {
                            this.processReference(grChild, innerBuilder, innerContext);
                        }
                        bases.add((Pair<OCType, OCVisibility>)Pair.create((Object)innerBuilder.getResult(), (Object)((Object)inheritanceVisibility)));
                        inheritanceVisibility = defaultVisibility;
                        continue;
                    }
                    if (!OCTokenTypes.CPP_VISIBILITY_KEYWORDS.contains(childType)) continue;
                    inheritanceVisibility = OCVisibility.getVisibilityFromElementType(childType);
                }
            }
            ((ArrayList)bases).trimToSize();
        }
    }

    private OCQualifiedName processQualifiedName(@NotNull T node, @Nullable OCQualifiedName base, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        OCQualifiedName result = base;
        String name = null;
        ArrayList<OCTypeArgument> arguments = null;
        boolean isCppOperator = false;
        for (T child : this.getChildren(node)) {
            IElementType tt = this.type(child);
            if (isCppOperator) {
                if (OCTokenTypes.OVERLOADED_CPP_OPERATORS.contains(tt)) {
                    name = name + this.nodeText(child);
                    continue;
                }
                if (tt != OCElementTypes.TYPE_ELEMENT) continue;
                OCTypeBuilder innerTypeBuilder = new OCTypeBuilder(OCLanguageKind.CPP, this.project, context);
                OCType typeElement = this.processTypeElement(child, innerTypeBuilder, (Processor<OCSymbol>)this.builder, context);
                name = name + " " + typeElement.getCanonicalName();
                continue;
            }
            if (tt == OCTokenTypes.COLON2X && result == null) {
                result = OCQualifiedName.GLOBAL;
                continue;
            }
            if (tt == OCElementTypes.CPP_NAMESPACE_QUALIFIER) {
                result = this.processQualifiedName(child, result, context);
                continue;
            }
            if (tt == OCElementTypes.REFERENCE_ELEMENT) {
                return this.processQualifiedName(child, result, context);
            }
            if (tt == OCTokenTypes.IDENTIFIER || tt == OCTokenTypes.THIS_CPP_KEYWORD) {
                name = this.nodeText(child);
                continue;
            }
            if (tt == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                arguments = new ArrayList<OCTypeArgument>();
                this.processTemplateArgumentList(child, arguments, context);
                continue;
            }
            if (tt != OCTokenTypes.OPERATOR_CPP_KEYWORD) continue;
            isCppOperator = true;
            name = this.nodeText(child);
        }
        result = arguments != null ? new OCQualifiedNameWithArguments(result, name, arguments) : OCQualifiedName.interned(result, name);
        return result;
    }

    private void processTemplateArgumentList(@NotNull T argumentListNode, @NotNull List<OCTypeArgument> arguments, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        for (T child : this.getChildren(argumentListNode)) {
            if (this.type(child) == OCElementTypes.GENERIC_ARGUMENT) {
                for (T argumentChild : this.getChildren(child)) {
                    OCTypeBuilder innerTypeBuilder;
                    OCType type;
                    if (this.type(argumentChild) != OCElementTypes.TYPE_ELEMENT || (type = this.processTypeElement(argumentChild, innerTypeBuilder = new OCTypeBuilder(OCLanguageKind.OBJ_C, this.project, context), (Processor<OCSymbol>)this.builder, context)) == null) continue;
                    arguments.add(type);
                }
            }
            if (this.type(child) == OCElementTypes.TYPE_ELEMENT) {
                OCTypeBuilder innerTypeBuilder = new OCTypeBuilder(OCLanguageKind.CPP, this.project, context);
                OCType type = this.processTypeElement(child, innerTypeBuilder, (Processor<OCSymbol>)this.builder, context);
                if (type == null) continue;
                arguments.add(type);
                continue;
            }
            if (!OCElementTypes.EXPRESSIONS.contains(this.type(child))) continue;
            arguments.add(new OCExpressionTypeArgument(this.getExpressionSymbol(child, context)));
        }
    }

    public OCTypeParameterTypeSymbol processTypeParameter(@NotNull T declarator, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        long offset = this.getComplexOffsetFromNode(declarator);
        List<String> attributes = Collections.emptyList();
        String name = null;
        OCType defaultValue = null;
        boolean variadic = false;
        for (T child : this.getChildren(declarator)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.IDENTIFIER) {
                name = this.nodeText(child);
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                OCTypeBuilder innerBuilder = new OCTypeBuilder(this.myLanguageKind, this.project, context);
                defaultValue = this.processTypeElement(child, innerBuilder, (Processor<OCSymbol>)this.builder, context);
                continue;
            }
            if (tt != OCTokenTypes.ELLIPSIS) continue;
            variadic = true;
        }
        Object parent = context.getParent();
        TextRange scope = parent instanceof OCElement ? ((OCElement)parent).getTextRange() : null;
        return new OCTypeParameterTypeSymbol(this.project, this.myVirtualFile, offset, name, defaultValue, attributes, scope, variadic);
    }

    private void processReference(@NotNull T refNode, @NotNull OCTypeBuilder typeBuilder, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        OCQualifiedName qualifier = null;
        for (T child : this.getChildren(refNode)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.COLON2X && qualifier == null) {
                qualifier = OCQualifiedName.GLOBAL;
                continue;
            }
            if (tt == OCElementTypes.CPP_NAMESPACE_QUALIFIER) {
                qualifier = this.processQualifiedName(child, qualifier, context);
                continue;
            }
            if (tt == OCTokenTypes.IDENTIFIER) {
                typeBuilder.learn(tt, this.nodeText(child));
                continue;
            }
            if (tt == OCElementTypes.TEMPLATE_ARGUMENT_LIST || tt == OCElementTypes.GENERIC_ARGUMENTS_LIST) {
                ArrayList<OCTypeArgument> arguments = new ArrayList<OCTypeArgument>();
                this.processTemplateArgumentList(child, arguments, context);
                typeBuilder.learnTypeArguments(arguments);
                continue;
            }
            if (tt == OCElementTypes.REFERENCE_ELEMENT) {
                this.processReference(child, typeBuilder, context);
                continue;
            }
            typeBuilder.learn(tt);
        }
        typeBuilder.learnNamespaceQualifier(qualifier);
    }

    private void processDeclarator(@NotNull T declaratorNode, @NotNull OCTypeBuilder typeBuilder, @NotNull Processor<OCSymbol> builder, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        OCSymbolImpl result;
        List<OCStructSymbol> structs;
        OCTypeBuilder originalTypeBuilder = typeBuilder;
        typeBuilder = typeBuilder.copy();
        long offset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, declaratorNode);
        String name = null;
        OCQualifiedName qualifier = null;
        ArrayList<T> parameterLists = new ArrayList<T>();
        List<String> attributeList = context.getAttributes();
        Boolean hasPointerLikeModifiers = null;
        boolean isDestructor = false;
        boolean isCppOperator = false;
        Boolean expectRParInOperator = null;
        boolean hasInitializer = false;
        boolean wasParameters = false;
        boolean wasDeref = false;
        boolean isConstFun = false;
        boolean isVolatileFun = false;
        boolean isFinal = false;
        boolean isOverride = false;
        OCType conversionOperatorType = null;
        Object initializer = context.getForCollection();
        T trailingReturnType = null;
        T specialization = null;
        for (T child : this.getChildren(declaratorNode)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.COLON2X && qualifier == null) {
                qualifier = OCQualifiedName.GLOBAL;
            }
            if (tt == OCElementTypes.CPP_NAMESPACE_QUALIFIER) {
                qualifier = this.processQualifiedName(child, qualifier, context);
                continue;
            }
            if (isCppOperator && !wasParameters && (tt == OCTokenTypes.IDENTIFIER || OCTokenTypes.OVERLOADED_CPP_OPERATORS.contains(tt))) {
                if (expectRParInOperator == null && tt == OCTokenTypes.LPAR) {
                    expectRParInOperator = Boolean.TRUE;
                }
                if (tt == OCTokenTypes.RPAR && !Boolean.TRUE.equals(expectRParInOperator)) continue;
                String sign = this.nodeText(child);
                name = OCElementUtil.getOperatorName(name, tt, sign);
                if (tt != OCTokenTypes.RPAR) continue;
                expectRParInOperator = Boolean.FALSE;
                continue;
            }
            if (isCppOperator && tt == OCElementTypes.TYPE_ELEMENT && !wasDeref) {
                OCTypeBuilder innerTypeBuilder = new OCTypeBuilder(OCLanguageKind.CPP, this.project, context);
                conversionOperatorType = this.processTypeElement(child, innerTypeBuilder, builder, context);
                name = name + " " + this.nodeText(child);
                continue;
            }
            if (!(tt != OCTokenTypes.IDENTIFIER && tt != OCTokenTypes.OPERATOR_CPP_KEYWORD || wasParameters)) {
                name = this.nodeText(child);
                offset = OCSymbolOffsetUtil.adjust(offset, OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child));
                boolean bl = isCppOperator = tt == OCTokenTypes.OPERATOR_CPP_KEYWORD;
                if (hasPointerLikeModifiers != null) continue;
                hasPointerLikeModifiers = Boolean.FALSE;
                continue;
            }
            if (tt == OCTokenTypes.TILDE && !wasParameters) {
                isDestructor = true;
                continue;
            }
            if (tt == OCTokenTypes.DEREF) {
                wasDeref = true;
                continue;
            }
            if (tt == OCElementTypes.PARAMETER_LIST) {
                wasParameters = true;
                if (context.myKRParamterList != null) {
                    parameterLists.add(context.myKRParamterList);
                    context.myKRParamterList = null;
                    continue;
                }
                parameterLists.add(child);
                continue;
            }
            if (tt == OCElementTypes.ATTRIBUTES) {
                if (attributeList != null) {
                    attributeList.addAll(this.processAttributeList(child));
                    continue;
                }
                attributeList = this.processAttributeList(child);
                continue;
            }
            if (tt == OCTokenTypes.BLOCK_KEYWORD) {
                context.addModifier(OCSymbolAttribute.BLOCK_MODIFIABLE);
                continue;
            }
            if (tt == OCTokenTypes.EQ) {
                hasInitializer = true;
                continue;
            }
            if (OCElementTypes.EXPRESSIONS.contains(tt) && (hasInitializer || tt == OCElementTypes.COMPOUND_INITIALIZER)) {
                hasInitializer = true;
                initializer = child;
                continue;
            }
            if (tt == OCElementTypes.ARGUMENT_LIST) {
                for (Object arg : this.getChildren(child)) {
                    IElementType type = this.type(arg);
                    if (!OCElementTypes.EXPRESSIONS.contains(type)) continue;
                    if (!hasInitializer) {
                        hasInitializer = true;
                        initializer = arg;
                        continue;
                    }
                    initializer = null;
                }
                continue;
            }
            if (tt == OCTokenTypes.CONST_KEYWORD) {
                if (wasParameters) {
                    isConstFun = true;
                    continue;
                }
                typeBuilder.learn(tt);
                continue;
            }
            if (tt == OCTokenTypes.VOLATILE_KEYWORD) {
                if (wasParameters) {
                    isVolatileFun = true;
                    continue;
                }
                typeBuilder.learn(tt);
                continue;
            }
            if (tt == OCElementTypes.LITERAL_EXPRESSION) {
                Iterator<T> value = this.getIntegerConstValue(child);
                if (value instanceof Number) {
                    typeBuilder.learn(((Number)((Object)value)).intValue());
                    continue;
                }
                typeBuilder.learn(-1);
                continue;
            }
            if (tt == OCElementTypes.CPP_QUALIFIED_POINTER) {
                for (T grChild : this.getChildren(child)) {
                    if (this.type(grChild) != OCElementTypes.CPP_NAMESPACE_QUALIFIER) continue;
                    typeBuilder.setPointerQualifier(this.processQualifiedName(grChild, null, context));
                }
                if (typeBuilder.isInsideParentheses() && hasPointerLikeModifiers == null) {
                    hasPointerLikeModifiers = Boolean.TRUE;
                }
                typeBuilder.learn(OCTokenTypes.MUL);
                continue;
            }
            if (tt == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                specialization = child;
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                trailingReturnType = child;
                continue;
            }
            if (tt == OCTokenTypes.DEFAULT_KEYWORD) {
                context.addModifier(OCSymbolAttribute.DEFAULT);
                continue;
            }
            if (tt == OCTokenTypes.DELETE_CPP_KEYWORD) {
                context.addModifier(OCSymbolAttribute.DELETE);
                continue;
            }
            if (tt == OCTokenTypes.FINAL_CPP_KEYWORD) {
                isFinal = true;
                continue;
            }
            if (tt == OCTokenTypes.OVERRIDE_CPP_KEYWORD) {
                isOverride = true;
                continue;
            }
            if (OCTokenTypes.FUNCTION_PTR_MODIFIERS.contains(tt) && typeBuilder.isInsideParentheses() && hasPointerLikeModifiers == null) {
                hasPointerLikeModifiers = Boolean.TRUE;
            }
            typeBuilder.learn(tt);
        }
        ArrayList parameterTypes = new ArrayList(parameterLists.size());
        ArrayList parameterSymbols = new ArrayList(parameterLists.size());
        ArrayList parameterNames = new ArrayList(parameterLists.size());
        OCType type = typeBuilder.getResult(!parameterLists.isEmpty());
        if (initializer != null && this.type(initializer) == OCElementTypes.COMPOUND_INITIALIZER) {
            typeBuilder.updateArrayLength(this.evaluateArrayLengths(initializer, type.isCString()));
            type = typeBuilder.getResult(!parameterLists.isEmpty());
        }
        for (int i = 0; i < parameterLists.size(); ++i) {
            parameterNames.add(new ArrayList());
            parameterTypes.add(new ArrayList());
            parameterSymbols.add(new ArrayList());
            type = typeBuilder.createFunction(type, (List)parameterTypes.get(i), (List)parameterNames.get(i), i == parameterLists.size() - 1, isConstFun, isVolatileFun);
        }
        hasInitializer |= typeBuilder.wasNonArrayExpression();
        if (initializer != null && typeBuilder.wasAuto()) {
            type = this.createAutoType(initializer, type, context);
        }
        if (context.getDeclaratorType() == OCSymbolKind.PARAMETER) {
            if (type instanceof OCReferenceType) {
                OCReferenceType referenceType = (OCReferenceType)type;
                referenceType.setFunctionParameterType(true);
            }
            type = OCFunctionType.convertArrayParameterType(type);
        }
        if (this.myImplicitBridgingOn) {
            if (attributeList == null) {
                attributeList = Collections.singletonList("ImplicitBridging");
            } else {
                attributeList.add("ImplicitBridging");
            }
        }
        if (attributeList == null) {
            attributeList = Collections.emptyList();
        }
        if (typeBuilder.isTypedef() && type instanceof OCStructType && (structs = ((OCStructType)type).getStructs()).size() == 1) {
            OCStructSymbol structSymbol = structs.get(0);
            if (structSymbol.isUnnamed()) {
                type = new OCStructType(structSymbol, name);
                originalTypeBuilder.learnBaseType(type);
            }
            structSymbol.addAttributes(attributeList);
        }
        if (isDestructor) {
            if (name == null) {
                isDestructor = false;
            } else {
                name = "~" + name;
            }
        }
        OCSymbolKind contextDeclType = context.getDeclaratorType();
        Object parent = context.getParent();
        OCVisibility visibility = context.getVisibility();
        OCSymbolWithQualifiedName container = context.getParentSymbol();
        if (type instanceof OCFunctionType && context.getDeclaratorType() == OCSymbolKind.PARAMETER) {
            type = OCPointerType.to(type);
        }
        if (context.isConstexpr()) {
            type = type.cloneWithConstModifier(this.project);
        }
        if (parent instanceof OCClassSymbol && visibility != null) {
            OCClassSymbol parentClass = (OCClassSymbol)parent;
            result = new OCInstanceVariableSymbolImpl(this.project, this.myVirtualFile, offset, name, attributeList, parentClass, type, visibility, null);
        } else {
            OCQualifiedName qualifiedName = OCQualifiedName.interned(qualifier, name);
            ArrayList<OCTypeArgument> templateSpecialization = null;
            List templateParameters = !context.getTemplateParameters().isEmpty() ? new ArrayList() : Collections.emptyList();
            if (!Boolean.TRUE.equals(hasPointerLikeModifiers) && !parameterLists.isEmpty() && !typeBuilder.isTypedef() && type instanceof OCFunctionType) {
                OCType returnType;
                boolean isDestructorOrConstructor;
                int funProps = 0;
                if (context.isVirtual() && hasInitializer) {
                    funProps |= OCFunctionSymbol.Property.IS_PURE_VIRTUAL.getMask();
                }
                if (context.isTemplateSymbol()) {
                    funProps |= OCFunctionSymbol.Property.IS_TEMPLATE.getMask();
                }
                if (conversionOperatorType != null) {
                    funProps |= OCFunctionSymbol.Property.IS_CONVERSION_OPERATOR.getMask();
                }
                if (isCppOperator) {
                    funProps |= OCFunctionSymbol.Property.IS_OPERATOR.getMask();
                }
                int funAttrs = context.getModifiers();
                if (isFinal) {
                    funAttrs |= OCSymbolAttribute.FINAL.getMask();
                }
                if (isOverride) {
                    funAttrs |= OCSymbolAttribute.OVERRIDE.getMask();
                }
                boolean bl = isDestructorOrConstructor = isDestructor || qualifier != null && name != null && name.equals(qualifier.getName()) || container instanceof OCStructSymbol && name != null && name.equals(container.getName()) || container instanceof OCStructSymbol && context.isDeclarationWithoutType && !isCppOperator && conversionOperatorType == null;
                OCSymbolKind kind = isDestructorOrConstructor ? (contextDeclType == OCSymbolKind.FUNCTION_DECLARATION ? OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION : OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION) : (contextDeclType == OCSymbolKind.FUNCTION_DECLARATION ? contextDeclType : OCSymbolKind.FUNCTION_PREDECLARATION);
                TextRange scope = parent instanceof OCElement ? ((OCElement)parent).getTextRange() : null;
                List firstParamSymbols = (List)parameterSymbols.get(0);
                List firstParamTypes = (List)parameterTypes.get(0);
                List firstParamNames = (List)parameterNames.get(0);
                if (specialization != null) {
                    templateSpecialization = new ArrayList<OCTypeArgument>();
                }
                if (parent instanceof OCElement && PsiTreeUtil.getContextOfType((PsiElement)((OCElement)parent), (Class[])new Class[]{OCCallable.class}) != null) {
                    result = new OCLocalFunctionSymbol(this.project, this.myVirtualFile, offset, container, qualifiedName, templateParameters, templateSpecialization, funProps, funAttrs, attributeList, (OCFunctionType)type, (List<OCDeclaratorSymbol>)firstParamSymbols, kind, scope);
                } else if (context.isTemplateValueParameter()) {
                    OCExpressionSymbol initializerSymbol = initializer != null ? this.processExpression(initializer, context) : null;
                    result = new OCTypeParameterValueSymbol(this.project, this.myVirtualFile, offset, container, qualifiedName, initializerSymbol, Collections.emptyList(), type, OCSymbolKind.TEMPLATE_VALUE_PARAMETER, typeBuilder.getArrayLengths(), templateParameters, 0, funAttrs, scope, visibility);
                } else {
                    result = new OCFunctionSymbol(this.project, this.myVirtualFile, offset, container, qualifiedName, templateParameters, templateSpecialization, funProps, funAttrs, attributeList, (OCFunctionType)type, firstParamSymbols, kind, visibility);
                }
                if (specialization != null) {
                    BuilderDriverBase.DeclarationContext declarationContext = new BuilderDriverBase.DeclarationContext(null, null, (OCSymbolWithQualifiedName)result, null, null);
                    declarationContext.setInsideTemplateParams(true);
                    this.processTemplateArgumentList(specialization, templateSpecialization, declarationContext);
                }
                BuilderDriverBase.DeclarationContext innerContext = new BuilderDriverBase.DeclarationContext(null, null, (OCSymbolWithQualifiedName)result, null, null);
                for (T params : context.getTemplateParameters()) {
                    this.processTemplateParameterList(params, templateParameters, innerContext);
                    ((ArrayList)templateParameters).trimToSize();
                }
                typeBuilder.setLocalContext(innerContext);
                for (OCSymbolReference reference : context.getReferencesInDeclaration()) {
                    if (!(reference instanceof OCSymbolReference.GlobalReference)) continue;
                    ((OCSymbolReference.GlobalReference)reference).setSymbolContext((OCSymbolWithQualifiedName)result);
                }
                if (trailingReturnType != null) {
                    this.processTypeElement(trailingReturnType, typeBuilder, builder, innerContext);
                }
                if (templateParameters.isEmpty()) {
                    returnType = typeBuilder.getResult();
                } else {
                    OCTypeParentSymbolSetter setter = new OCTypeParentSymbolSetter((OCSymbolWithQualifiedName)result);
                    returnType = typeBuilder.getResult().accept(setter);
                    if (conversionOperatorType != null) {
                        conversionOperatorType = conversionOperatorType.accept(setter);
                    }
                    ((OCSymbolWithQualifiedName)result).setQualifier(setter.replaceQualifiedName(qualifier));
                }
                OCFunctionType funType = (OCFunctionType)typeBuilder.createFunction(returnType, firstParamTypes, firstParamNames, false, isConstFun, isVolatileFun);
                if (isDestructorOrConstructor) {
                    if (isDestructor) {
                        funType = new OCFunctionType(OCVoidType.instance(), firstParamTypes, firstParamNames);
                    } else if (container instanceof OCStructSymbol && name != null && name.equals(container.getName())) {
                        funType = new OCFunctionType(new OCStructType((OCStructSymbol)container), firstParamTypes, firstParamNames);
                    } else {
                        OCReferenceType referenceType = new OCReferenceTypeBuilder(qualifier, container, false, false).build();
                        context.addSymbolReference(referenceType.getReference(this.file));
                        funType = new OCFunctionType(referenceType, firstParamTypes, firstParamNames);
                    }
                }
                if (conversionOperatorType != null) {
                    funType = new OCFunctionType(conversionOperatorType, firstParamTypes, firstParamNames, isConstFun, isVolatileFun);
                }
                if (result instanceof OCFunctionSymbol) {
                    ((OCFunctionSymbol)result).setType(funType);
                } else if (result instanceof OCDeclaratorSymbol) {
                    ((OCDeclaratorSymbol)result).setType(funType);
                }
            } else {
                OCSymbolKind declType = null;
                if (typeBuilder.isTypedef()) {
                    declType = OCSymbolKind.TYPEDEF;
                } else if (contextDeclType != null) {
                    switch (contextDeclType) {
                        case ENUM_CONST: 
                        case STRUCT_FIELD: 
                        case PARAMETER: 
                        case CATCH_EXCEPTION_VARIABLE: 
                        case GLOBAL_VARIABLE_PREDECLARATION: 
                        case TEMPLATE_VALUE_PARAMETER: {
                            declType = contextDeclType;
                            break;
                        }
                    }
                }
                if (declType == null) {
                    declType = parent != null ? OCSymbolKind.LOCAL_VARIABLE : (hasInitializer ? OCSymbolKind.GLOBAL_VARIABLE : OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION);
                }
                TextRange scope = parent instanceof OCElement ? ((OCElement)parent).getTextRange() : null;
                for (T params : context.getTemplateParameters()) {
                    this.processTemplateParameterList(params, templateParameters, context);
                    ((ArrayList)templateParameters).trimToSize();
                }
                int props = hasInitializer ? OCDeclaratorSymbol.Property.IS_HAS_INITIALIZER.getMask() : 0;
                int attrs = context.getModifiers();
                if (typeBuilder.isConst()) {
                    attrs |= OCSymbolAttribute.CONST.getMask();
                }
                OCExpressionSymbol initializerSymbol = initializer != null ? this.processExpression(initializer, context) : null;
                result = context.isTemplateValueParameter() ? new OCTypeParameterValueSymbol(this.project, this.myVirtualFile, offset, container, qualifiedName, initializerSymbol, Collections.emptyList(), type, OCSymbolKind.TEMPLATE_VALUE_PARAMETER, typeBuilder.getArrayLengths(), templateParameters, props, attrs, scope, visibility) : new OCDeclaratorSymbol(this.project, this.myVirtualFile, offset, container, qualifiedName, attributeList, type, declType, typeBuilder.getArrayLengths(), initializerSymbol, templateParameters, props, attrs, scope, visibility);
                if (!templateParameters.isEmpty()) {
                    OCTypeParentSymbolSetter setter = new OCTypeParentSymbolSetter((OCSymbolWithQualifiedName)result);
                    type = type.accept(setter);
                    ((OCDeclaratorSymbol)result).setType(type);
                }
            }
        }
        for (int i = 0; i < parameterLists.size(); ++i) {
            ArrayList symbols = (ArrayList)parameterSymbols.get(i);
            ArrayList types = (ArrayList)parameterTypes.get(i);
            List names = (List)parameterNames.get(i);
            BuilderDriverBase.DeclarationContext innerContext = new BuilderDriverBase.DeclarationContext();
            innerContext.myParentSymbol = result instanceof OCSymbolWithQualifiedName ? (OCSymbolWithQualifiedName)result : container;
            this.processParameterList(parameterLists.get(parameterLists.size() - i - 1), symbols, types, innerContext, names);
            symbols.trimToSize();
            types.trimToSize();
        }
        builder.process((Object)result);
    }

    @NotNull
    private OCAutoType createAutoType(@NotNull T initializer, @Nullable OCType type, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        PsiElement element;
        OCExpression expressionElement = null;
        if (initializer instanceof CompositeElement && (element = ((CompositeElement)initializer).getPsi()) instanceof OCExpression) {
            expressionElement = (OCExpression)element;
        }
        return new OCAutoType(this.getExpressionSymbol(initializer, context), expressionElement, type, false, false);
    }

    private int evaluateArrayLengths(@NotNull T initializer, boolean isCharArray) {
        int length = 0;
        for (T child : this.getChildren(initializer)) {
            T grChild;
            IElementType childType;
            Iterator<T> iterator;
            T subexpression;
            while (isCharArray && this.type(child) == OCElementTypes.PAREN_EXPRESSION && (subexpression = this.getParenSubexpression(child)) != null) {
                child = subexpression;
            }
            IElementType tt = this.type(child);
            if (isCharArray && tt == OCElementTypes.LITERAL_EXPRESSION && (iterator = this.getChildren(child).iterator()).hasNext() && OCTokenTypes.ALL_STRINGS.contains(childType = this.type(grChild = iterator.next()))) {
                OCStringLiteral literal = OCStringLiteralUtil.parseStringLiteral(this.nodeText(grChild));
                return literal.getContentLengthInCharacters();
            }
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            ++length;
        }
        return length;
    }

    @NotNull
    public List<String> processAttributeList(@NotNull T node) {
        ArrayList<String> answer = new ArrayList<String>();
        for (T child : this.getChildren(node)) {
            IElementType tt = this.type(child);
            if (tt != OCElementTypes.ATTRIBUTE) continue;
            String attributeName = "";
            for (T grChild : this.getChildren(child)) {
                if (this.type(grChild) == OCTokenTypes.IDENTIFIER) {
                    attributeName = this.nodeText(grChild);
                    answer.add(attributeName);
                }
                if (this.type(grChild) != OCElementTypes.ATTRIBUTE_PARAMETERS) continue;
                answer.add(attributeName + "#" + this.nodeText(grChild));
            }
        }
        return answer;
    }

    @Nullable
    private Object getIntegerConstValue(@NotNull T exprNode) {
        for (T child : this.getChildren(exprNode)) {
            IElementType tt = this.type(child);
            if (!OCTokenTypes.LITERALS.contains(tt) && !OCTokenTypes.CPP_LITERALS.contains(tt)) continue;
            return OCElementUtil.getConstValue(tt, this.nodeText(child), (PsiElement)this.file, this.context);
        }
        return null;
    }

    @Nullable
    private T getParenSubexpression(@NotNull T parenExpr) {
        if (this.type(parenExpr) == OCElementTypes.PAREN_EXPRESSION) {
            for (T child : this.getChildren(parenExpr)) {
                if (!OCElementTypes.EXPRESSIONS.contains(this.type(child))) continue;
                return child;
            }
        }
        return null;
    }

    @NotNull
    public OCExpressionSymbol getExpressionSymbol(@NotNull T child, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        OCExpressionSymbol symbol = this.processExpression(child, context);
        return symbol != null ? symbol : new OCUnknownExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(child), this.nodeText(child));
    }

    @Nullable
    private OCExpressionSymbol processExpression(@NotNull T expr, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        block53: {
            IElementType tt;
            block64: {
                block63: {
                    block62: {
                        block61: {
                            block60: {
                                block59: {
                                    block58: {
                                        block57: {
                                            T child;
                                            IElementType type;
                                            block56: {
                                                OCExpressionSymbol rightSymbol;
                                                block55: {
                                                    block54: {
                                                        OCExpressionSymbol operandSymbol;
                                                        block52: {
                                                            OCExpressionSymbol rightSymbol2;
                                                            tt = this.type(expr);
                                                            if (tt != OCElementTypes.BINARY_EXPRESSION) break block52;
                                                            T left = null;
                                                            T right = null;
                                                            OCElementType operator = null;
                                                            for (T child2 : this.getChildren(expr)) {
                                                                IElementType childType = this.type(child2);
                                                                if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                                                    if (left == null) {
                                                                        left = child2;
                                                                        continue;
                                                                    }
                                                                    right = child2;
                                                                    continue;
                                                                }
                                                                if (!OCTokenTypes.BINARY_OPERATIONS.contains(childType)) continue;
                                                                operator = (OCElementType)childType;
                                                            }
                                                            OCExpressionSymbol leftSymbol = left != null ? this.processExpression(left, context) : null;
                                                            OCExpressionSymbol oCExpressionSymbol = rightSymbol2 = right != null ? this.processExpression(right, context) : null;
                                                            if (operator != null && leftSymbol != null && rightSymbol2 != null) {
                                                                return new OCBinaryExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), operator, leftSymbol, rightSymbol2);
                                                            }
                                                            break block53;
                                                        }
                                                        if (tt != OCElementTypes.UNARY_EXPRESSION) break block54;
                                                        T operand = null;
                                                        OCElementType operator = null;
                                                        for (T child3 : this.getChildren(expr)) {
                                                            IElementType childType = this.type(child3);
                                                            if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                                                if (operand != null) continue;
                                                                operand = child3;
                                                                continue;
                                                            }
                                                            if (!OCTokenTypes.UNARY_OPERATIONS.contains(childType)) continue;
                                                            operator = (OCElementType)childType;
                                                        }
                                                        OCExpressionSymbol oCExpressionSymbol = operandSymbol = operand != null ? this.processExpression(operand, context) : null;
                                                        if (operator != null && operandSymbol != null) {
                                                            return new OCUnaryExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), operator, operandSymbol);
                                                        }
                                                        break block53;
                                                    }
                                                    if (tt != OCElementTypes.PREFIX_EXPRESSION && tt != OCElementTypes.POSTFIX_EXPRESSION) break block55;
                                                    T operand = null;
                                                    OCElementType operator = null;
                                                    Iterator<T> operandSymbol = this.getChildren(expr).iterator();
                                                    while (operandSymbol.hasNext()) {
                                                        T child4 = operandSymbol.next();
                                                        IElementType childType = this.type(child4);
                                                        if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                                            if (operand != null) continue;
                                                            operand = child4;
                                                            continue;
                                                        }
                                                        if (!OCTokenTypes.ARITHMETIC_OPERATIONS.contains(childType)) continue;
                                                        operator = (OCElementType)childType;
                                                    }
                                                    Iterator<T> iterator = operandSymbol = operand != null ? this.processExpression(operand, context) : null;
                                                    if (operator != null && operandSymbol != null) {
                                                        return tt == OCElementTypes.PREFIX_EXPRESSION ? new OCPrefixExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), operator, (OCExpressionSymbol)((Object)operandSymbol)) : new OCPostfixExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), operator, (OCExpressionSymbol)((Object)operandSymbol));
                                                    }
                                                    break block53;
                                                }
                                                if (tt != OCElementTypes.CONDITIONAL_EXPRESSION) break block56;
                                                T cond = null;
                                                T left = null;
                                                T right = null;
                                                for (T child5 : this.getChildren(expr)) {
                                                    IElementType childType = this.type(child5);
                                                    if (!OCElementTypes.EXPRESSIONS.contains(childType)) continue;
                                                    if (cond == null) {
                                                        cond = child5;
                                                        continue;
                                                    }
                                                    if (left == null) {
                                                        left = child5;
                                                        continue;
                                                    }
                                                    right = child5;
                                                }
                                                OCExpressionSymbol condSymbol = cond != null ? this.processExpression(cond, context) : null;
                                                OCExpressionSymbol leftSymbol = left != null ? this.processExpression(left, context) : null;
                                                OCExpressionSymbol oCExpressionSymbol = rightSymbol = right != null ? this.processExpression(right, context) : null;
                                                if (condSymbol != null && leftSymbol != null && rightSymbol != null) {
                                                    return new OCConditionalExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), condSymbol, leftSymbol, rightSymbol);
                                                }
                                                break block53;
                                            }
                                            if (tt != OCElementTypes.LITERAL_EXPRESSION) break block57;
                                            Object value = this.getIntegerConstValue(expr);
                                            if (value != null && (OCTokenTypes.LITERALS.contains(type = this.type(child = this.getChildren(expr).iterator().next())) || OCTokenTypes.CPP_LITERALS.contains(type))) {
                                                return new OCLiteralExpressionSymbol(this.nodeText(expr), value, type, this.nodeText(child));
                                            }
                                            break block53;
                                        }
                                        if (tt == OCElementTypes.REFERENCE_EXPRESSION) {
                                            OCQualifiedName name = this.processQualifiedName(expr, null, context);
                                            OCSymbolReference reference = context.getLocalContext() != null ? OCSymbolReference.getLocalReference(name, context.getLocalContext()) : OCSymbolReference.getGlobalReference(name, context.getParentSymbol());
                                            context.addSymbolReference(reference);
                                            return new OCReferenceExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), reference);
                                        }
                                        if (tt != OCElementTypes.QUALIFIED_EXPRESSION) break block58;
                                        OCExpressionSymbol qualifier = null;
                                        String name = null;
                                        List<OCTypeArgument> typeArguments = Collections.emptyList();
                                        boolean isDeref = false;
                                        for (T child : this.getChildren(expr)) {
                                            IElementType childType = this.type(child);
                                            if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                                qualifier = this.processExpression(child, context);
                                                continue;
                                            }
                                            if (childType == OCTokenTypes.IDENTIFIER) {
                                                name = this.nodeText(child);
                                                continue;
                                            }
                                            if (childType == OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR) {
                                                for (T grChild : this.getChildren(child)) {
                                                    if (this.type(grChild) != OCTokenTypes.DEREF) continue;
                                                    isDeref = true;
                                                }
                                                continue;
                                            }
                                            if (childType != OCElementTypes.TEMPLATE_ARGUMENT_LIST) continue;
                                            typeArguments = new ArrayList<OCTypeArgument>();
                                            this.processTemplateArgumentList(child, typeArguments, context);
                                        }
                                        if (qualifier != null && name != null) {
                                            return new OCQualifiedExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), qualifier, name, isDeref, typeArguments);
                                        }
                                        break block53;
                                    }
                                    if (tt != OCElementTypes.SIZEOF_EXPRESSION) break block59;
                                    boolean isVariadic = false;
                                    for (T child : this.getChildren(expr)) {
                                        IElementType childType = this.type(child);
                                        if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                            OCExpressionSymbol operand = this.processExpression(child, context);
                                            return operand != null ? new OCSizeofExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), operand, isVariadic) : null;
                                        }
                                        if (OCElementTypes.TYPE_ELEMENT == childType) {
                                            OCType type = this.processTypeElement(child, new OCTypeBuilder(this.myLanguageKind, this.project, context), null, context);
                                            return new OCSizeofExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), type, isVariadic);
                                        }
                                        if (childType != OCTokenTypes.ELLIPSIS) continue;
                                        isVariadic = true;
                                    }
                                    break block53;
                                }
                                if (tt != OCElementTypes.CALL_EXPRESSION) break block60;
                                OCExpressionSymbol callerSymbol = null;
                                ArrayList<OCExpressionSymbol> arguments = new ArrayList<OCExpressionSymbol>();
                                for (T child : this.getChildren(expr)) {
                                    IElementType childType = this.type(child);
                                    if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                        callerSymbol = this.processExpression(child, context);
                                        continue;
                                    }
                                    if (OCElementTypes.ARGUMENT_LIST != childType) continue;
                                    for (T grChild : this.getChildren(child)) {
                                        if (!OCElementTypes.EXPRESSIONS.contains(this.type(grChild))) continue;
                                        OCExpressionSymbol argumentSymbol = this.processExpression(grChild, context);
                                        if (argumentSymbol != null) {
                                            arguments.add(argumentSymbol);
                                            continue;
                                        }
                                        return null;
                                    }
                                }
                                if (callerSymbol != null) {
                                    OCCallExpressionSymbol callSymbol = new OCCallExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), callerSymbol, arguments);
                                    if (callerSymbol instanceof OCReferenceExpressionSymbol) {
                                        ((OCReferenceExpressionSymbol)callerSymbol).setParent(callSymbol);
                                    } else if (callerSymbol instanceof OCQualifiedExpressionSymbol) {
                                        ((OCQualifiedExpressionSymbol)callerSymbol).setParent(callSymbol);
                                    }
                                    return callSymbol;
                                }
                                break block53;
                            }
                            if (tt != OCElementTypes.PAREN_EXPRESSION) break block61;
                            T subexpression = this.getParenSubexpression(expr);
                            if (subexpression != null) {
                                return this.processExpression(subexpression, context);
                            }
                            break block53;
                        }
                        if (tt != OCElementTypes.CAST_EXPRESSION) break block62;
                        OCExpressionSymbol operandSymbol = null;
                        OCType type = null;
                        for (T child : this.getChildren(expr)) {
                            IElementType childType = this.type(child);
                            if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                operandSymbol = this.processExpression(child, context);
                                continue;
                            }
                            if (OCElementTypes.TYPE_ELEMENT == childType) {
                                type = this.processTypeElement(child, new OCTypeBuilder(this.myLanguageKind, this.project, context), null, context);
                                continue;
                            }
                            if (OCElementTypes.ARGUMENT_LIST != childType) continue;
                            for (T grChild : this.getChildren(child)) {
                                IElementType grChildType = this.type(grChild);
                                if (!OCElementTypes.EXPRESSIONS.contains(grChildType)) continue;
                                operandSymbol = this.processExpression(grChild, context);
                            }
                        }
                        if (type != null) {
                            return new OCCastExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), operandSymbol, type);
                        }
                        break block53;
                    }
                    if (tt == OCElementTypes.COMPOUND_INITIALIZER) {
                        ArrayList<OCExpressionSymbol> initializers = new ArrayList<OCExpressionSymbol>();
                        for (T child : this.getChildren(expr)) {
                            IElementType argType = this.type(child);
                            if (!OCElementTypes.EXPRESSIONS.contains(argType)) continue;
                            initializers.add(this.getExpressionSymbol(child, context));
                        }
                        return new OCInitializerListExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), (List<OCExpressionSymbol>)initializers);
                    }
                    if (tt != OCElementTypes.COMMA_EXPRESSION) break block63;
                    ArrayList<OCExpressionSymbol> expressions = new ArrayList<OCExpressionSymbol>();
                    for (T child : this.getChildren(expr)) {
                        IElementType argType = this.type(child);
                        if (!OCElementTypes.EXPRESSIONS.contains(argType)) continue;
                        expressions.add(this.getExpressionSymbol(child, context));
                    }
                    if (expressions.size() == 2) {
                        return new OCCommaExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), (OCExpressionSymbol)expressions.get(0), (OCExpressionSymbol)expressions.get(1));
                    }
                    break block53;
                }
                if (tt == OCElementTypes.CPP_LAMBDA_EXPRESSION) {
                    PsiElement psiElement;
                    OCLambdaExpression lambdaPsiElement = null;
                    OCPointerType lambdaType = null;
                    if (expr instanceof CompositeElement && (psiElement = ((CompositeElement)expr).getPsi()) instanceof OCLambdaExpression) {
                        lambdaPsiElement = (OCLambdaExpression)psiElement;
                    }
                    if (lambdaPsiElement == null) {
                        List<OCType> parameterTypes = Collections.emptyList();
                        OCType returnType = OCUnknownType.INSTANCE;
                        for (T child : this.getChildren(expr)) {
                            IElementType childType = this.type(child);
                            if (childType == OCElementTypes.PARAMETER_LIST) {
                                parameterTypes = new ArrayList<OCType>();
                                this.processParameterList(child, null, parameterTypes, context, null);
                                continue;
                            }
                            if (childType != OCElementTypes.TYPE_ELEMENT) continue;
                            returnType = this.processTypeElement(child, new OCTypeBuilder(this.myLanguageKind, this.project, context), null, context);
                        }
                        lambdaType = OCPointerType.to(new OCFunctionType(returnType, parameterTypes));
                    }
                    return new OCLambdaExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), lambdaPsiElement, lambdaType);
                }
                if (tt != OCElementTypes.CPP_NEW_EXPRESSION) break block64;
                OCType type = null;
                int arrayLengths = 0;
                for (T child : this.getChildren(expr)) {
                    IElementType childType = this.type(child);
                    if (OCElementTypes.TYPE_ELEMENT != childType) continue;
                    type = this.processTypeElement(child, new OCTypeBuilder(this.myLanguageKind, this.project, context), null, context);
                    for (T grChild : this.getChildren(child)) {
                        if (this.type(grChild) != OCTokenTypes.LBRACKET) continue;
                        ++arrayLengths;
                    }
                }
                if (type != null) {
                    return new OCNewExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), type, arrayLengths);
                }
                break block53;
            }
            if (tt != OCElementTypes.CPP_VARIADIC_PACK_EXPRESSION) break block53;
            for (T child : this.getChildren(expr)) {
                OCExpressionSymbol expression;
                if (!OCElementTypes.EXPRESSIONS.contains(this.type(child)) || (expression = this.processExpression(child, context)) == null) continue;
                return new OCVariadicPackExpressionSymbol(this.project, this.myVirtualFile, this.getComplexOffsetFromNode(expr), this.nodeText(expr), expression);
            }
        }
        return null;
    }

    private void processTemplateParameterList(@NotNull T parameterListNode, final @NotNull List<OCTypeParameterSymbol> collector, @NotNull BuilderDriverBase.DeclarationContext<T> context) {
        context = new BuilderDriverBase.DeclarationContext(null, null, context.getParentSymbol(), null, null);
        context.setTemplateValueParameter(true);
        for (T child : this.getChildren(parameterListNode)) {
            if (this.type(child) == OCElementTypes.CPP_TYPE_PARAMETER_DECLARATION) {
                collector.add(this.processTypeParameter(child, context));
                continue;
            }
            if (this.type(child) != OCElementTypes.PARAMETER_DECLARATION) continue;
            this.processDeclaration(child, new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCTypeParameterValueSymbol) {
                        collector.add((OCTypeParameterSymbol)((Object)symbol));
                    }
                    return true;
                }
            }, context);
        }
    }

    private void processParameterList(@NotNull T parameterListNode, final @Nullable List<OCDeclaratorSymbol> parameterSymbols, final @NotNull List<OCType> parameterTypes, @NotNull BuilderDriverBase.DeclarationContext<T> context, final @Nullable List<String> parameterNames) {
        for (T child : this.getChildren(parameterListNode)) {
            if (this.type(child) != OCElementTypes.PARAMETER_DECLARATION) continue;
            this.processParameterDeclaration(child, context, new Processor<OCDeclaratorSymbol>(){

                public boolean process(OCDeclaratorSymbol symbol) {
                    if (parameterSymbols != null) {
                        parameterSymbols.add(symbol);
                    }
                    if (parameterNames != null) {
                        parameterNames.add(symbol.getName());
                    }
                    parameterTypes.add(symbol.getType());
                    return true;
                }
            });
        }
    }

    private void processParameterDeclaration(@NotNull T declarationNode, @NotNull Processor<OCDeclaratorSymbol> processor2) {
        this.processParameterDeclaration(declarationNode, new BuilderDriverBase.DeclarationContext(), processor2);
    }

    private void processParameterDeclaration(@NotNull T declarationNode, @NotNull BuilderDriverBase.DeclarationContext<T> context, final @NotNull Processor<OCDeclaratorSymbol> processor2) {
        BuilderDriverBase.DeclarationContext innerContext = new BuilderDriverBase.DeclarationContext(OCSymbolKind.PARAMETER);
        innerContext.myParentSymbol = context.myParentSymbol;
        this.processDeclaration(declarationNode, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCDeclaratorSymbol) {
                    processor2.process((Object)((OCDeclaratorSymbol)symbol));
                }
                return true;
            }
        }, innerContext);
    }

    public void processImportModuleStatement(@NotNull T node) {
        String pathText;
        ArrayList moduleNameParts = ContainerUtil.newArrayList();
        for (T child : this.getChildren(node)) {
            if (this.type(child) != OCTokenTypes.IDENTIFIER) continue;
            moduleNameParts.add(this.nodeText(child));
        }
        int offset = this.nodeStructure.getStartOffset(node);
        final int offsetAfter = this.nodeStructure.getEndOffset(node);
        if (!OCModuleResolver.processModuleImports(this.context, moduleNameParts, new Processor<VirtualFile>(){

            public boolean process(VirtualFile header) {
                OCIncludeSymbol.IncludePath path = new OCIncludeSymbol.IncludePath(header.getPath(), true);
                OCBuilderDriver.this.builder.process((Object)new OCIncludeSymbol(OCBuilderDriver.this.project, OCBuilderDriver.this.myVirtualFile, offsetAfter, header, path, true, false, 0));
                return true;
            }
        }) && (pathText = OCModuleResolver.getGuessedPath(moduleNameParts)) != null) {
            OCIncludeSymbol.IncludePath path = new OCIncludeSymbol.IncludePath(pathText, true);
            VirtualFile header = this.context.resolvePath(path, this.file);
            this.builder.process((Object)new OCIncludeSymbol(this.project, this.myVirtualFile, offset, header, path, true, false, offsetAfter));
            if (header == null && LOG_UNRESOLVED_SYMBOLS) {
                System.out.println("Can't resolve: " + path.getPath());
            }
        }
    }

    public void processImportDirective(@NotNull T directiveNode) {
        boolean next = false;
        boolean importOnce = false;
        for (T child : this.getChildren(directiveNode)) {
            OCIncludeSymbol.IncludePath anchorPath;
            VirtualFile anchorFile;
            String path;
            if (this.type(child) == OCTokenTypes.IMPORT_DIRECTIVE) {
                importOnce = true;
                continue;
            }
            if (this.type(child) == OCTokenTypes.INCLUDE_NEXT_DIRECTIVE) {
                next = true;
                continue;
            }
            if (this.type(child) != OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT) continue;
            String content = this.nodeText(child);
            OCIncludeSymbol.IncludePath relativePath = OCInclusionContext.extractPath(content);
            IElementType type = this.nodeStructure.getTokenType(child);
            PsiFile anchor = type instanceof OCMacroForeignLeafType ? ((path = ((OCMacroForeignLeafType)type).getMacroName()) != null ? ((anchorFile = this.context.resolvePath(anchorPath = OCInclusionContext.extractPath(path), this.file)) != null && anchorFile.isValid() ? PsiManager.getInstance((Project)((OCFile)this.file).getProject()).findFile(anchorFile) : this.file) : this.file) : this.file;
            VirtualFile include = next ? this.context.resolveNextImportedFile(content, anchor) : this.context.resolveImportedFile(content, anchor);
            int offset = this.nodeStructure.getStartOffset(directiveNode);
            int offsetAfter = this.nodeStructure.getEndOffset(directiveNode);
            OCIncludeSymbol symbol = new OCIncludeSymbol(this.project, this.myVirtualFile, offset, include, relativePath, importOnce, next, offsetAfter);
            this.builder.process((Object)symbol);
            if (include != null || !LOG_UNRESOLVED_SYMBOLS) break;
            System.out.println("Can't resolve: " + content);
            break;
        }
    }

    public void processDefineDirective(@NotNull T directiveNode, boolean define) {
        List children2 = ContainerUtil.collect(this.getChildren(directiveNode).iterator());
        for (int i = 0; i < children2.size(); ++i) {
            OCSymbolImpl macro;
            String definition;
            Object child = children2.get(i);
            IElementType tt = this.type(child);
            if (tt != OCTokenTypes.IDENTIFIER && !OCTokenTypes.KEYWORDS.contains(tt) && tt != OCElementTypes.MACRO_REF) continue;
            int identOffset = this.nodeStructure.getStartOffset(child);
            IElementType type = this.nodeStructure.getTokenType(child);
            if (type instanceof OCMacroForeignLeafType) {
                StringBuilder definitionBuilder = new StringBuilder();
                for (int k = i; k < children2.size(); ++k) {
                    Object innerChild = children2.get(k);
                    if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.type(innerChild))) {
                        definitionBuilder.append(" ");
                        continue;
                    }
                    definitionBuilder.append(this.nodeTextNoIntern(innerChild, true));
                }
                definition = definitionBuilder.toString();
            } else {
                definition = this.text.substring(identOffset, this.nodeStructure.getEndOffset(directiveNode));
            }
            if (define) {
                macro = OCMacroSymbol.parseFromDirectiveContent(definition, (OCFile)this.file, identOffset);
                if (macro == null) break;
                this.context.define((OCMacroSymbol)macro);
                this.builder.process((Object)macro);
                break;
            }
            macro = OCUndefMacroSymbol.parseFromDirectiveContent(definition, (OCFile)this.file, this.nodeStructure.getStartOffset(child));
            if (macro == null) break;
            this.context.undef(macro.getName());
            this.builder.process((Object)macro);
            break;
        }
    }

    private void processPragma(@NotNull T root) {
        for (T child : this.getChildren(root)) {
            IElementType type = this.type(child);
            if (!(type instanceof OCPragmaOnceContentElementType)) continue;
            VirtualFile onceFile = ((OCPragmaOnceContentElementType)type).getFile();
            String pragmaOnceId = OCInclusionContextUtil.pragmaOnceId(onceFile);
            this.builder.process((Object)OCMacroSymbol.inclusionGuard(pragmaOnceId));
            break;
        }
    }
}

