/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.symbols.DeepEqualImpl;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeepEqual {
    private DeepEqual() {
    }

    public static boolean equalObjects(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        return DeepEqual.newResolver().equalObjects(o1, o2);
    }

    @NotNull
    public static Resolver newResolver() {
        return new DeepEqualImpl();
    }

    public static Resolver newResolver(final PairFunction<Object, Object, Void> preEqualCustom) {
        return new DeepEqualImpl(){

            @Override
            protected <T> boolean equalObjects(Equality<T> equality, T o1, T o2) {
                preEqualCustom.fun(o1, o2);
                return super.equalObjects(equality, o1, o2);
            }
        };
    }

    public static interface Equality<T> {
        public boolean deepEqualStep(@NotNull Comparator var1, @NotNull T var2, @NotNull T var3);
    }

    public static interface Resolver
    extends Comparator {
        public void clearCaches();

        public <T> void setEquality(@NotNull Class<T> var1, @Nullable Function<T, Equality<T>> var2);
    }

    public static interface Comparator {
        public <T> boolean equalObjects(@Nullable Equality<T> var1, @Nullable Equality<T> var2);

        public boolean equalIterable(@Nullable Iterable var1, @Nullable Iterable var2);

        public boolean equalMultiMaps(@Nullable MostlySingularMultiMap var1, @Nullable MostlySingularMultiMap var2);

        public boolean equalMaps(@Nullable Map var1, @Nullable Map var2);

        public boolean equalObjects(@Nullable Object var1, @Nullable Object var2);
    }
}

