/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.NodeStructure;
import com.intellij.lang.TokenWrapper;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuilderDriverBase<T, FILE extends PsiFile> {
    private static final String LOG_UNRESOLVED_SYMBOLS_PROPERTY = "appCode.LogUnresolvedSymbols";
    protected static final boolean LOG_UNRESOLVED_SYMBOLS = Comparing.equal((String)System.getProperty("appCode.LogUnresolvedSymbols"), (String)"true");
    public static NamedNodeStructure<ASTNode> AST_NAMED_NODE_STRUCTURE = new NamedNodeStructure<ASTNode>(){

        public int getStartOffset(ASTNode node) {
            if (node instanceof OCMacroForeignLeafElement) {
                return ((OCMacroForeignLeafElement)node).getRealStartOffset();
            }
            return node.getStartOffset();
        }

        public int getEndOffset(ASTNode node) {
            return node.getTextRange().getEndOffset();
        }

        public IElementType getTokenType(ASTNode node) {
            return node.getElementType();
        }

        @Override
        public String getNodeText(ASTNode node) {
            return node.getText();
        }
    };
    protected final FILE file;
    protected final OCInclusionContext context;
    protected final String text;
    protected final FlyweightCapableTreeStructure<T> structure;
    protected final NodeStructure<T> nodeStructure;
    protected final Processor<OCSymbol> builder;
    protected final Project project;
    protected final OCLanguageKind myLanguageKind;
    protected final VirtualFile myVirtualFile;

    protected int offset(@NotNull T nameElement) {
        return this.nodeStructure.getStartOffset(nameElement);
    }

    public BuilderDriverBase(@NotNull FILE file2, @NotNull OCInclusionContext context, @Nullable String text, @NotNull FlyweightCapableTreeStructure<T> structure, @NotNull NodeStructure<T> nodeStructure, @NotNull Processor<OCSymbol> builder, @Nullable VirtualFile virtualFile) {
        this.file = file2;
        this.context = context;
        this.text = text;
        this.structure = structure;
        this.nodeStructure = nodeStructure;
        this.builder = builder;
        this.project = file2.getProject();
        this.myLanguageKind = context.getLanguageKind();
        this.myVirtualFile = virtualFile;
    }

    @NotNull
    protected Iterable<T> getChildren(@NotNull T node) {
        final Ref childrenRef = Ref.create(null);
        final int count = this.structure.getChildren(this.structure.prepareForGetChildren(node), childrenRef);
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return !childrenRef.isNull() && this.idx < count;
                    }

                    @Override
                    public T next() {
                        ProgressManager.checkCanceled();
                        return ((Object[])childrenRef.get())[this.idx++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @NotNull
    protected IElementType type(@NotNull T child) {
        IElementType type = this.nodeStructure.getTokenType(child);
        if (type instanceof ForeignLeafType) {
            type = ((ForeignLeafType)type).getDelegate();
        }
        return type;
    }

    @NotNull
    protected String nodeText(@NotNull T node) {
        return OCNamesInternary.intern(this.nodeTextNoIntern(node, false));
    }

    @NotNull
    protected String nodeTextNoIntern(@NotNull T node, boolean withDirectives) {
        String text = this.nodeText(node, null, withDirectives);
        assert (text != null);
        return text;
    }

    @Nullable
    private String nodeText(@NotNull T node, @Nullable StringBuilder acc, boolean withDirectives) {
        IElementType unwrappedType = this.type(node);
        IElementType tt = this.nodeStructure.getTokenType(node);
        if (!withDirectives && (OCElementTypes.DIRECTIVES.contains(unwrappedType) || OCElementTypes.MACRO_CALL == unwrappedType)) {
            return "";
        }
        if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(unwrappedType)) {
            if (acc != null) {
                acc.append(" ");
            }
            return " ";
        }
        if (tt instanceof ForeignLeafType) {
            String value = ((ForeignLeafType)tt).getValue();
            if (acc != null) {
                acc.append(value);
            }
            return value;
        }
        if (node instanceof ForeignLeafPsiElement) {
            String value = ((ForeignLeafPsiElement)node).getText();
            if (acc != null) {
                acc.append(value);
            }
            return value;
        }
        if (tt instanceof TokenWrapper) {
            if (this.text != null) {
                return this.text.substring(this.nodeStructure.getStartOffset(node), this.nodeStructure.getEndOffset(node));
            }
            return ((NamedNodeStructure)this.nodeStructure).getNodeText(node);
        }
        List children2 = ContainerUtil.collect(this.getChildren(node).iterator());
        if (children2.size() == 1) {
            return this.nodeText(children2.get(0), acc, withDirectives);
        }
        if (children2.size() > 1) {
            boolean needReturnString = false;
            if (acc == null) {
                needReturnString = true;
                acc = new StringBuilder();
            }
            for (Object child : children2) {
                this.nodeText(child, acc, withDirectives);
            }
            return needReturnString ? acc.toString() : null;
        }
        String value = this.text != null ? this.text.substring(this.nodeStructure.getStartOffset(node), this.nodeStructure.getEndOffset(node)) : ((NamedNodeStructure)this.nodeStructure).getNodeText(node);
        if (acc != null) {
            acc.append(value);
        }
        return value;
    }

    public static class DeclarationContext<T> {
        private OCSymbolKind declaratorType;
        private Object parent;
        protected OCSymbolWithQualifiedName myParentSymbol;
        private OCVisibility visibility;
        protected boolean isDeclarationWithoutDeclarators;
        protected boolean isDeclarationWithoutType;
        private boolean isBaseClause;
        private boolean isTemplateValueParameter;
        private List<String> attributes;
        private PsiElement localContext;
        protected T myKRParamterList;
        private ASTNode forCollection;
        private Stack<List<OCSymbolReference>> referencesInDeclaration = new Stack();
        private List<T> myTemplateParameters = new ArrayList<T>();
        private boolean myIsTemplateSymbol;
        private boolean myInsideTemplateParams;
        private int myModifiers = 0;

        public DeclarationContext(OCSymbolKind declaratorType, Object parent, OCSymbolWithQualifiedName parentSymbol, OCVisibility visibility, PsiElement localContext) {
            this.declaratorType = declaratorType;
            this.parent = parent;
            this.myParentSymbol = parentSymbol;
            this.visibility = visibility;
            this.localContext = localContext;
        }

        public DeclarationContext(OCSymbolKind declaratorType) {
            this.declaratorType = declaratorType;
        }

        public DeclarationContext() {
        }

        public OCSymbolKind getDeclaratorType() {
            return this.declaratorType;
        }

        public void setDeclaratorType(OCSymbolKind declaratorType) {
            this.declaratorType = declaratorType;
        }

        public Object getParent() {
            return this.parent;
        }

        public OCSymbolWithQualifiedName getParentSymbol() {
            return this.myParentSymbol;
        }

        public OCVisibility getVisibility() {
            return this.isFriend() ? OCVisibility.NULL : this.visibility;
        }

        public boolean isFriend() {
            return this.hasModifier(OCSymbolAttribute.FRIEND);
        }

        public boolean isVirtual() {
            return this.hasModifier(OCSymbolAttribute.VIRTUAL);
        }

        public boolean isConstexpr() {
            return this.hasModifier(OCSymbolAttribute.CONSTEEXPR);
        }

        public boolean isBaseClause() {
            return this.isBaseClause;
        }

        public void setBaseClause(boolean isBaseClause) {
            this.isBaseClause = isBaseClause;
        }

        public boolean isTemplateValueParameter() {
            return this.isTemplateValueParameter;
        }

        public void setTemplateValueParameter(boolean isTemplateValueParameter) {
            this.isTemplateValueParameter = isTemplateValueParameter;
        }

        void addModifier(@NotNull OCSymbolAttribute modifier) {
            this.myModifiers |= modifier.getMask();
        }

        int getModifiers() {
            return this.myModifiers;
        }

        private boolean hasModifier(@NotNull OCSymbolAttribute modifier) {
            return (this.myModifiers & modifier.getMask()) != 0;
        }

        public List<String> getAttributes() {
            return this.attributes;
        }

        public void addAttributes(List<String> attributes) {
            if (this.attributes == null) {
                this.attributes = attributes;
            } else {
                this.attributes.addAll(attributes);
            }
        }

        public PsiElement getLocalContext() {
            return this.localContext;
        }

        public List<T> getTemplateParameters() {
            return this.myTemplateParameters;
        }

        public void setDeclarationWithoutDeclarators(boolean declarationWithoutDeclarators) {
            this.isDeclarationWithoutDeclarators = declarationWithoutDeclarators;
        }

        public void setDeclarationWithoutType(boolean declarationWithoutType) {
            this.isDeclarationWithoutType = declarationWithoutType;
        }

        public ASTNode getForCollection() {
            return this.forCollection;
        }

        public void setForCollection(ASTNode forCollection) {
            this.forCollection = forCollection;
        }

        @NotNull
        public List<OCSymbolReference> getReferencesInDeclaration() {
            return (List)this.referencesInDeclaration.peek();
        }

        public void addSymbolReference(@NotNull OCSymbolReference reference) {
            if (!this.referencesInDeclaration.isEmpty()) {
                ((List)this.referencesInDeclaration.peek()).add(reference);
            }
        }

        public void pushDeclaration() {
            this.referencesInDeclaration.push(new ArrayList());
        }

        public void popDeclaration() {
            this.referencesInDeclaration.pop();
        }

        public boolean isTemplateSymbol() {
            return this.myIsTemplateSymbol;
        }

        public void setTemplateSymbol(boolean templateSymbol) {
            this.myIsTemplateSymbol = templateSymbol;
        }

        public boolean isInsideTemplateParams() {
            return this.myInsideTemplateParams;
        }

        public void setInsideTemplateParams(boolean insideTemplateParams) {
            this.myInsideTemplateParams = insideTemplateParams;
        }
    }

    public static interface NamedNodeStructure<T>
    extends NodeStructure<T> {
        public String getNodeText(T var1);
    }
}

