/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettingsListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileExtensionsSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        return new MyMasterDetailsComponent(settings);
    }

    @Nullable
    public String getConfigurableDisplayName() {
        return OCBundle.message("fileExtensions.tabName", new Object[0]);
    }

    public boolean hasSettingsPage() {
        return false;
    }

    @Nullable
    public Language getLanguage() {
        return OCLanguage.getInstance();
    }

    private static class MyMasterDetailsComponent
    extends MasterDetailsComponent {
        private final OCCodeStyleSettings myOCSettings;

        public MyMasterDetailsComponent(CodeStyleSettings settings) {
            this.myOCSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
            this.initTree();
            this.myTree.getEmptyText().setText(OCBundle.message("fileExtensions.no.extensions", new Object[0]));
        }

        protected void reInitWholePanelIfNeeded() {
            boolean reinit = this.myToReInitWholePanel;
            super.reInitWholePanelIfNeeded();
            if (reinit) {
                this.getMaster().putClientProperty(UIUtil.KEEP_BORDER_SIDES, 6);
                this.myWholePanel.setBorder(null);
            }
        }

        @Nullable
        protected ArrayList<AnAction> createActions(boolean fromPopup) {
            ArrayList<AnAction> result = new ArrayList<AnAction>();
            result.add(new MyAddAction());
            result.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
            result.add(new MyMoveAction(ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0]), IconUtil.getMoveUpIcon(), -1));
            result.add(new MyMoveAction(ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0]), IconUtil.getMoveDownIcon(), 1));
            return result;
        }

        protected void processRemovedItems() {
        }

        protected boolean wasObjectStored(Object editableObject) {
            return false;
        }

        @Nls
        public String getDisplayName() {
            return OCBundle.message("fileExtensions.tabName", new Object[0]);
        }

        public void reset() {
            this.myRoot.removeAllChildren();
            for (OCCodeStyleSettings.FileExtensionPair pair : this.myOCSettings.FILE_EXTENSION_PAIRS_ORDERED) {
                this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new MyFileExtensionPairConfigurable(pair)));
            }
            super.reset();
        }

        public void apply() throws ConfigurationException {
            String title = OCBundle.message("fileExtensions.error", new Object[0]);
            if (this.myRoot.getChildCount() == 0) {
                throw new ConfigurationException(OCBundle.message("fileExtensions.noExtensionsError", new Object[0]), title);
            }
            this.checkForEmptyAndDuplicatedNames(OCBundle.message("fileExtensions.extensionPair", new Object[0]), title, MyFileExtensionPairConfigurable.class);
            super.apply();
            Enumeration children2 = this.myRoot.children();
            ArrayList list = ContainerUtil.newArrayList();
            while (children2.hasMoreElements()) {
                list.add((OCCodeStyleSettings.FileExtensionPair)((MasterDetailsComponent.MyNode)children2.nextElement()).getConfigurable().getEditableObject());
            }
            this.myOCSettings.FILE_EXTENSION_PAIRS_ORDERED = ContainerUtil.immutableList((List)list);
            ((OCFileExtensionsSettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(OCFileExtensionsSettingsListener.TOPIC)).settingsUpdated();
        }

        public boolean isModified() {
            ImmutableList<OCCodeStyleSettings.FileExtensionPair> pairs = this.myOCSettings.FILE_EXTENSION_PAIRS_ORDERED;
            if (this.myRoot.getChildCount() != pairs.size()) {
                return true;
            }
            for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                MasterDetailsComponent.MyNode node;
                MyFileExtensionPairConfigurable configurable;
                OCCodeStyleSettings.FileExtensionPair editablePair;
                OCCodeStyleSettings.FileExtensionPair originalPair = (OCCodeStyleSettings.FileExtensionPair)pairs.get(i);
                if (!originalPair.equals(editablePair = (configurable = (MyFileExtensionPairConfigurable)(node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getConfigurable()).getEditableObject())) {
                    return true;
                }
                if (!this.isInitialized(configurable) || !configurable.isModified()) continue;
                return true;
            }
            return false;
        }

        private class MyFileExtensionPairConfigurable
        extends NamedConfigurable {
            @NotNull
            private OCCodeStyleSettings.FileExtensionPair myFileExtensionPair;
            private ComboBox mySourceExtField;
            private ComboBox myHeaderExtField;

            public MyFileExtensionPairConfigurable() {
                this.myFileExtensionPair = new OCCodeStyleSettings.FileExtensionPair("cpp", "h");
            }

            public MyFileExtensionPairConfigurable(OCCodeStyleSettings.FileExtensionPair fileExtensionPair) {
                this.myFileExtensionPair = fileExtensionPair;
            }

            public void setDisplayName(String name) {
            }

            public OCCodeStyleSettings.FileExtensionPair getEditableObject() {
                return this.myFileExtensionPair;
            }

            public String getBannerSlogan() {
                return null;
            }

            public JComponent createOptionsPanel() {
                JPanel panel = new JPanel(new GridBagLayout());
                GridBag bag = new GridBag().setDefaultWeightX(1, 1.0).setDefaultAnchor(1, 23).setDefaultInsets(0, 0, 4, 10);
                Insets topInsets = new Insets(10, 0, 4, 10);
                panel.add((Component)new JBLabel(OCBundle.message("fileExtensions.sourceExtension", new Object[0])), bag.nextLine().next().insets(topInsets));
                List list = ContainerUtil.sorted(OCFileTypeHelpers.SOURCE_FILE_EXTENSIONS);
                if (!PlatformUtils.isAppCode()) {
                    list = ContainerUtil.filter((Collection)list, (Condition)new Condition<String>(){

                        public boolean value(String s) {
                            return !"m".equals(s) && !"mm".equals(s);
                        }
                    });
                }
                this.mySourceExtField = new ComboBox(list.toArray());
                panel.add((Component)this.mySourceExtField, bag.next().insets(topInsets));
                this.mySourceExtField.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        MyMasterDetailsComponent.this.TREE_UPDATER.run();
                    }
                });
                panel.add((Component)new JBLabel(OCBundle.message("fileExtensions.headerExtension", new Object[0])), bag.nextLine().next());
                list = ContainerUtil.filter(OCFileTypeHelpers.HEADER_FILE_EXTENSIONS, (Condition)new Condition<String>(){

                    public boolean value(String s) {
                        return !s.isEmpty() && !"pch".equals(s);
                    }
                });
                this.myHeaderExtField = new ComboBox(ContainerUtil.sorted((Collection)list).toArray());
                panel.add((Component)this.myHeaderExtField, bag.next());
                this.myHeaderExtField.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        MyMasterDetailsComponent.this.TREE_UPDATER.run();
                    }
                });
                JPanel wrapper = new JPanel(new BorderLayout());
                wrapper.add((Component)panel, "North");
                return wrapper;
            }

            public String getDisplayName() {
                String sourceExt = this.mySourceExtField == null ? this.myFileExtensionPair.mySourceExt : (String)this.mySourceExtField.getSelectedItem();
                String headerExt = this.myHeaderExtField == null ? this.myFileExtensionPair.myHeaderExt : (String)this.myHeaderExtField.getSelectedItem();
                return new OCCodeStyleSettings.FileExtensionPair(sourceExt, headerExt).toString();
            }

            @Nullable
            public String getHelpTopic() {
                return null;
            }

            public boolean isModified() {
                return !StringUtil.equals((CharSequence)((CharSequence)this.mySourceExtField.getSelectedItem()), (CharSequence)this.myFileExtensionPair.mySourceExt) || !StringUtil.equals((CharSequence)((CharSequence)this.myHeaderExtField.getSelectedItem()), (CharSequence)this.myFileExtensionPair.myHeaderExt);
            }

            public void apply() throws ConfigurationException {
                this.myFileExtensionPair = new OCCodeStyleSettings.FileExtensionPair((String)this.mySourceExtField.getSelectedItem(), (String)this.myHeaderExtField.getSelectedItem());
            }

            public void reset() {
                this.mySourceExtField.setSelectedItem((Object)this.myFileExtensionPair.mySourceExt);
                this.myHeaderExtField.setSelectedItem((Object)this.myFileExtensionPair.myHeaderExt);
            }

            public void disposeUIResources() {
            }
        }

        private class MyMoveAction
        extends AnAction {
            private final int myDirection;

            protected MyMoveAction(String text, Icon icon, int direction) {
                super(text, text, icon);
                this.myDirection = direction;
            }

            public void actionPerformed(AnActionEvent e) {
                TreeUtil.moveSelectedRow((JTree)MyMasterDetailsComponent.this.myTree, (int)this.myDirection);
            }

            public void update(AnActionEvent e) {
                boolean enabled = false;
                TreePath selectionPath = MyMasterDetailsComponent.this.myTree.getSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    enabled = (this.myDirection < 0 ? treeNode.getPreviousSibling() : treeNode.getNextSibling()) != null;
                }
                e.getPresentation().setEnabled(enabled);
            }
        }

        private class MyAddAction
        extends AnAction {
            public MyAddAction() {
                super(IdeBundle.message((String)"add.scope.popup.title", (Object[])new Object[0]), null, IconUtil.getAddIcon());
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)MyMasterDetailsComponent.this.myTree);
            }

            public void actionPerformed(AnActionEvent e) {
                MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new MyFileExtensionPairConfigurable());
                MyMasterDetailsComponent.this.myRoot.add((MutableTreeNode)node);
                ((DefaultTreeModel)MyMasterDetailsComponent.this.myTree.getModel()).reload((TreeNode)MyMasterDetailsComponent.this.myRoot);
                MyMasterDetailsComponent.this.selectNodeInTree((DefaultMutableTreeNode)node);
            }
        }
    }
}

