/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.settings.OCLanguageCodeStyleSettingsProvider;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCodeStyleSettings
extends CustomCodeStyleSettings {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.DefaultJDOMExternalizer");
    public static final int NEW_LINE_NEVER = 0;
    public static final int NEW_LINE_ALWAYS = 1;
    public static final int NEW_LINE_IF_LONG = 2;
    public static final String[] LEW_LINE_OPTIONS = new String[]{OCBundle.message("wrapping.new.line.never", new Object[0]), OCBundle.message("wrapping.new.line.always", new Object[0]), OCBundle.message("wrapping.new.line.if.long", new Object[0])};
    public static final int[] LEW_LINE_VALUES = new int[]{0, 1, 2};
    public boolean DO_NOT_ADD_BREAKS = false;
    public int INDENT_NAMESPACE_MEMBERS;
    public int INDENT_C_STRUCT_MEMBERS;
    public int INDENT_CLASS_MEMBERS;
    public int INDENT_INTERFACE_MEMBERS;
    public boolean INDENT_BLOCK_COMMENT;
    public boolean INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK;
    public int INDENT_IMPLEMENTATION_MEMBERS;
    public int INDENT_VISIBILITY_KEYWORDS;
    public int INDENT_INSIDE_CODE_BLOCK;
    public int INDENT_PREPROCESSOR_DIRECTIVE;
    public boolean INDENT_DIRECTIVE_AS_CODE;
    public boolean KEEP_STRUCTURES_IN_ONE_LINE;
    public boolean KEEP_CASE_EXPRESSIONS_IN_ONE_LINE;
    public boolean KEEP_NESTED_NAMESPACES_IN_ONE_LINE;
    public boolean KEEP_DIRECTIVE_AT_FIRST_COLUMN;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int NAMESPACE_BRACE_PLACEMENT;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int METHOD_BRACE_PLACEMENT;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int FUNCTION_BRACE_PLACEMENT;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int BLOCK_BRACE_PLACEMENT;
    public int METHOD_PARAMETERS_WRAP;
    public boolean METHOD_PARAMETERS_ALIGN_MULTILINE;
    public boolean METHOD_PARAMETERS_ALIGN_BY_COLONS;
    public int METHOD_CALL_ARGUMENTS_WRAP;
    public boolean METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE;
    public boolean METHOD_CALL_ARGUMENTS_ALIGN_BY_COLONS;
    public boolean METHOD_CALL_ARGUMENTS_SPECIAL_DICTIONARY_PAIRS_TREATMENT;
    public int FUNCTION_PARAMETERS_WRAP;
    public boolean FUNCTION_PARAMETERS_ALIGN_MULTILINE;
    public boolean FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR;
    public boolean FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR;
    public boolean FUNCTION_PARAMETERS_ALIGN_MULTILINE_PARS;
    public boolean FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE;
    public int FUNCTION_CALL_ARGUMENTS_WRAP;
    public boolean FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE;
    public boolean FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR;
    public boolean FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR;
    public boolean FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS;
    public boolean FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE;
    public int TEMPLATE_DECLARATION_STRUCT_WRAP;
    public boolean TEMPLATE_DECLARATION_STRUCT_BODY_INDENT;
    public int TEMPLATE_DECLARATION_FUNCTION_WRAP;
    public boolean TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT;
    public int TEMPLATE_PARAMETERS_WRAP;
    public boolean TEMPLATE_PARAMETERS_ALIGN_MULTILINE;
    public boolean TEMPLATE_PARAMETERS_NEW_LINE_AFTER_LT;
    public boolean TEMPLATE_PARAMETERS_NEW_LINE_BEFORE_GT;
    public boolean TEMPLATE_PARAMETERS_ALIGN_MULTILINE_PARS;
    public boolean TEMPLATE_PARAMETERS_COMMA_ON_NEXT_LINE;
    public int TEMPLATE_CALL_ARGUMENTS_WRAP;
    public boolean TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE;
    public boolean TEMPLATE_CALL_ARGUMENTS_NEW_LINE_AFTER_LT;
    public boolean TEMPLATE_CALL_ARGUMENTS_NEW_LINE_BEFORE_GT;
    public boolean TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS;
    public boolean TEMPLATE_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE;
    public int CLASS_CONSTRUCTOR_INIT_LIST_WRAP;
    public boolean CLASS_CONSTRUCTOR_INIT_LIST_ALIGN_MULTILINE;
    public boolean CLASS_CONSTRUCTOR_INIT_LIST_COMMA_ON_NEXT_LINE;
    @NewLineConstant
    public int CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_BEFORE_COLON;
    @NewLineConstant
    public int CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON;
    public int SUPERCLASS_LIST_WRAP;
    public boolean SUPERCLASS_LIST_ALIGN_MULTILINE;
    public boolean SUPERCLASS_LIST_COMMA_ON_NEXT_LINE;
    @NewLineConstant
    public int SUPERCLASS_LIST_BEFORE_COLON;
    @NewLineConstant
    public int SUPERCLASS_LIST_AFTER_COLON;
    public boolean SPACE_BEFORE_TEMPLATE_DECLARATION_LT;
    public boolean SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT;
    public boolean SPACE_WITHIN_EMPTY_TEMPLATE_DECLARATION_LTGT;
    public boolean SPACE_BEFORE_TEMPLATE_CALL_LT;
    public boolean SPACE_WITHIN_TEMPLATE_CALL_LTGT;
    public boolean SPACE_WITHIN_EMPTY_TEMPLATE_CALL_LTGT;
    public boolean SPACE_WITHIN_TEMPLATE_DOUBLE_GT;
    public int WRAP_PROPERTY_DECLARATION;
    public boolean ARRAY_INITIALIZER_COMMA_ON_NEXT_LINE;
    public boolean ALIGN_DICTIONARY_PAIR_VALUES;
    public boolean ALIGN_INIT_LIST_IN_COLUMNS;
    public boolean ENUM_CONSTANTS_COMMA_ON_NEXT_LINE;
    public boolean SPACE_BEFORE_NAMESPACE_LBRACE;
    public boolean SPACE_BEFORE_AUTORELEASE_POOL_LBRACE;
    public boolean SPACE_AFTER_STRUCTURES_RBRACE;
    public boolean SPACE_WITHIN_METHOD_RETURN_TYPE_PARENTHESES;
    public boolean SPACE_AFTER_METHOD_RETURN_TYPE_PARENTHESES;
    public boolean SPACE_WITHIN_METHOD_PARAMETER_TYPE_PARENTHESES;
    public boolean SPACE_AFTER_METHOD_PARAMETER_TYPE_PARENTHESES;
    public boolean SPACE_BEFORE_PROPERTY_ATTRIBUTES_PARENTHESES;
    public boolean SPACE_WITHIN_PROPERTY_ATTRIBUTES_PARENTHESES;
    public boolean SPACE_WITHIN_FUNCTION_DECLARATION_PARENTHESES;
    public boolean SPACE_WITHIN_EMPTY_FUNCTION_DECLARATION_PARENTHESES;
    public boolean SPACE_WITHIN_FUNCTION_CALL_PARENTHESES;
    public boolean SPACE_WITHIN_EMPTY_FUNCTION_CALL_PARENTHESES;
    public boolean SPACE_WITHIN_CATEGORY_PARENTHESES;
    public boolean SPACE_WITHIN_PROTOCOLS_BRACKETS;
    public boolean SPACE_WITHIN_SEND_MESSAGE_BRACKETS;
    public boolean SPACE_BEFORE_SUPERCLASS_COLON;
    public boolean SPACE_AFTER_SUPERCLASS_COLON;
    public boolean SPACE_BEFORE_INIT_LIST_COLON;
    public boolean SPACE_AFTER_INIT_LIST_COLON;
    public boolean SPACE_BEFORE_INIT_LIST;
    public boolean SPACE_BEFORE_CATEGORY_PARENTHESES;
    public boolean SPACE_BEFORE_PROTOCOLS_BRACKETS;
    public boolean SPACE_AFTER_VISIBILITY_SIGN_IN_METHOD_DECLARATION;
    public boolean SPACE_AFTER_COLON_IN_SELECTOR;
    public boolean SPACE_BEFORE_CHAINED_SEND_MESSAGE;
    public boolean SPACE_BEFORE_POINTER_IN_DECLARATION;
    public boolean SPACE_AFTER_POINTER_IN_DECLARATION;
    public boolean SPACE_BEFORE_REFERENCE_IN_DECLARATION;
    public boolean SPACE_AFTER_REFERENCE_IN_DECLARATION;
    public boolean SPACE_AFTER_REFERENCE_IN_RVALUE;
    public boolean SPACE_AFTER_CUP_IN_BLOCKS;
    public boolean SPACE_BETWEEN_ADJACENT_BRACKETS;
    public boolean SPACE_BETWEEN_OPERATOR_AND_PUNCTUATOR;
    public boolean SPACE_AROUND_DICTIONARY_LITERAL_COLON;
    public boolean SPACE_AROUND_PM_OPERATORS;
    public boolean DISCHARGED_SHORT_TERNARY_OPERATOR;
    public boolean IN_LINE_SHORT_TERNARY_OPERATOR;
    public int KEEP_BLANK_LINES_BEFORE_END;
    public int BLANK_LINES_AROUND_NAMESPACE;
    public int BLANK_LINES_AROUND_PROPERTIES_IN_INTERFACE;
    public int BLANK_LINES_AROUND_PROPERTIES_IN_DECLARATION;
    public boolean RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR;
    public RememberedOption GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES;
    public boolean REFACTOR_PROPERTIES_AND_IVARS;
    public boolean REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES;
    public boolean USE_SETTERS_IN_CONSTRUCTOR;
    public boolean GENERATE_CLASS_CONSTRUCTOR;
    public boolean CREATE_INTERFACE_FOR_CATEGORIES;
    public boolean PUT_IVARS_TO_IMPLEMENTATION;
    public boolean SEMICOLON_AFTER_METHOD_SIGNATURE;
    public ReleaseStyle RELEASE_STYLE;
    public boolean DECLARE_GENERATED_METHODS;
    public boolean DESCRIPTION_INCLUDE_MEMBER_NAMES;
    public boolean COPY_IS_DEEP;
    public boolean PROPERTY_NONATOMIC;
    public boolean INSERT_OVERRIDE;
    public String IVARS_PREFIX;
    public String IVARS_SUFFIX;
    public String FIELDS_PREFIX;
    public String FIELDS_SUFFIX;
    public String GETTERS_PREFIX;
    public String SETTERS_PREFIX;
    public List<OCDeclarationKind> FILE_DECLARATIONS_ORDER;
    public List<OCDeclarationKind> CLASS_DECLARATIONS_ORDER;
    public boolean INTRODUCE_CONST_VARS;
    public boolean INTRODUCE_CONST_PARAMS;
    public boolean INTRODUCE_AUTO_VARS;
    public boolean INTRODUCE_STATIC_CONSTS;
    public boolean INTRODUCE_GLOBALS_TO_HEADER;
    public boolean INTRODUCE_GENERATE_PROPERTY;
    public boolean INTRODUCE_GENERATE_SYNTHESIZE;
    public boolean INTRODUCE_PROP_TO_PRIVATE_CATEGORY;
    public boolean INTRODUCE_USE_NS_TYPES;
    public Placement TYPE_QUALIFIERS_PLACEMENT;
    public ImmutableList<FileExtensionPair> FILE_EXTENSION_PAIRS_ORDERED;

    protected OCCodeStyleSettings(CodeStyleSettings container) {
        super("Objective-C", container);
        this.INDENT_NAMESPACE_MEMBERS = this.getContainer().getIndentOptions((FileType)OCFileType.INSTANCE).INDENT_SIZE;
        this.INDENT_C_STRUCT_MEMBERS = this.getContainer().getIndentOptions((FileType)OCFileType.INSTANCE).INDENT_SIZE;
        this.INDENT_CLASS_MEMBERS = this.getContainer().getIndentOptions((FileType)OCFileType.INSTANCE).INDENT_SIZE;
        this.INDENT_INTERFACE_MEMBERS = 0;
        this.INDENT_BLOCK_COMMENT = true;
        this.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK = false;
        this.INDENT_IMPLEMENTATION_MEMBERS = 0;
        this.INDENT_VISIBILITY_KEYWORDS = 0;
        this.INDENT_INSIDE_CODE_BLOCK = this.getContainer().getIndentOptions((FileType)OCFileType.INSTANCE).INDENT_SIZE;
        this.INDENT_PREPROCESSOR_DIRECTIVE = 0;
        this.INDENT_DIRECTIVE_AS_CODE = false;
        this.KEEP_STRUCTURES_IN_ONE_LINE = false;
        this.KEEP_CASE_EXPRESSIONS_IN_ONE_LINE = false;
        this.KEEP_NESTED_NAMESPACES_IN_ONE_LINE = false;
        this.KEEP_DIRECTIVE_AT_FIRST_COLUMN = true;
        this.NAMESPACE_BRACE_PLACEMENT = 1;
        this.METHOD_BRACE_PLACEMENT = 1;
        this.BLOCK_BRACE_PLACEMENT = this.FUNCTION_BRACE_PLACEMENT = 1;
        this.METHOD_PARAMETERS_WRAP = 0;
        this.METHOD_PARAMETERS_ALIGN_MULTILINE = false;
        this.METHOD_PARAMETERS_ALIGN_BY_COLONS = true;
        this.METHOD_CALL_ARGUMENTS_WRAP = 0;
        this.METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE = false;
        this.METHOD_CALL_ARGUMENTS_ALIGN_BY_COLONS = true;
        this.METHOD_CALL_ARGUMENTS_SPECIAL_DICTIONARY_PAIRS_TREATMENT = true;
        this.FUNCTION_PARAMETERS_WRAP = 0;
        this.FUNCTION_PARAMETERS_ALIGN_MULTILINE = false;
        this.FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR = false;
        this.FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR = false;
        this.FUNCTION_PARAMETERS_ALIGN_MULTILINE_PARS = false;
        this.FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE = false;
        this.FUNCTION_CALL_ARGUMENTS_WRAP = 0;
        this.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE = false;
        this.FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR = false;
        this.FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR = false;
        this.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS = false;
        this.FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE = false;
        this.TEMPLATE_DECLARATION_STRUCT_WRAP = 2;
        this.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT = false;
        this.TEMPLATE_DECLARATION_FUNCTION_WRAP = 2;
        this.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT = false;
        this.TEMPLATE_PARAMETERS_WRAP = this.FUNCTION_PARAMETERS_WRAP;
        this.TEMPLATE_PARAMETERS_ALIGN_MULTILINE = this.FUNCTION_PARAMETERS_ALIGN_MULTILINE;
        this.TEMPLATE_PARAMETERS_NEW_LINE_AFTER_LT = this.FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR;
        this.TEMPLATE_PARAMETERS_NEW_LINE_BEFORE_GT = this.FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR;
        this.TEMPLATE_PARAMETERS_ALIGN_MULTILINE_PARS = this.FUNCTION_PARAMETERS_ALIGN_MULTILINE_PARS;
        this.TEMPLATE_PARAMETERS_COMMA_ON_NEXT_LINE = this.FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE;
        this.TEMPLATE_CALL_ARGUMENTS_WRAP = this.FUNCTION_CALL_ARGUMENTS_WRAP;
        this.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE = this.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE;
        this.TEMPLATE_CALL_ARGUMENTS_NEW_LINE_AFTER_LT = this.FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR;
        this.TEMPLATE_CALL_ARGUMENTS_NEW_LINE_BEFORE_GT = this.FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR;
        this.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS = this.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS;
        this.TEMPLATE_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE = this.FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE;
        this.CLASS_CONSTRUCTOR_INIT_LIST_WRAP = 5;
        this.CLASS_CONSTRUCTOR_INIT_LIST_ALIGN_MULTILINE = true;
        this.CLASS_CONSTRUCTOR_INIT_LIST_COMMA_ON_NEXT_LINE = false;
        this.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_BEFORE_COLON = 2;
        this.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON = 0;
        this.SUPERCLASS_LIST_WRAP = 5;
        this.SUPERCLASS_LIST_ALIGN_MULTILINE = true;
        this.SUPERCLASS_LIST_COMMA_ON_NEXT_LINE = false;
        this.SUPERCLASS_LIST_BEFORE_COLON = 2;
        this.SUPERCLASS_LIST_AFTER_COLON = 0;
        this.SPACE_BEFORE_TEMPLATE_DECLARATION_LT = false;
        this.SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT = false;
        this.SPACE_WITHIN_EMPTY_TEMPLATE_DECLARATION_LTGT = false;
        this.SPACE_BEFORE_TEMPLATE_CALL_LT = false;
        this.SPACE_WITHIN_TEMPLATE_CALL_LTGT = false;
        this.SPACE_WITHIN_EMPTY_TEMPLATE_CALL_LTGT = false;
        this.SPACE_WITHIN_TEMPLATE_DOUBLE_GT = true;
        this.WRAP_PROPERTY_DECLARATION = 0;
        this.ARRAY_INITIALIZER_COMMA_ON_NEXT_LINE = false;
        this.ALIGN_DICTIONARY_PAIR_VALUES = false;
        this.ALIGN_INIT_LIST_IN_COLUMNS = false;
        this.ENUM_CONSTANTS_COMMA_ON_NEXT_LINE = false;
        this.SPACE_BEFORE_NAMESPACE_LBRACE = true;
        this.SPACE_BEFORE_AUTORELEASE_POOL_LBRACE = true;
        this.SPACE_AFTER_STRUCTURES_RBRACE = true;
        this.SPACE_WITHIN_METHOD_RETURN_TYPE_PARENTHESES = false;
        this.SPACE_AFTER_METHOD_RETURN_TYPE_PARENTHESES = false;
        this.SPACE_WITHIN_METHOD_PARAMETER_TYPE_PARENTHESES = false;
        this.SPACE_AFTER_METHOD_PARAMETER_TYPE_PARENTHESES = false;
        this.SPACE_BEFORE_PROPERTY_ATTRIBUTES_PARENTHESES = false;
        this.SPACE_WITHIN_PROPERTY_ATTRIBUTES_PARENTHESES = false;
        this.SPACE_WITHIN_FUNCTION_DECLARATION_PARENTHESES = false;
        this.SPACE_WITHIN_EMPTY_FUNCTION_DECLARATION_PARENTHESES = false;
        this.SPACE_WITHIN_FUNCTION_CALL_PARENTHESES = false;
        this.SPACE_WITHIN_EMPTY_FUNCTION_CALL_PARENTHESES = false;
        this.SPACE_WITHIN_CATEGORY_PARENTHESES = false;
        this.SPACE_WITHIN_PROTOCOLS_BRACKETS = false;
        this.SPACE_WITHIN_SEND_MESSAGE_BRACKETS = false;
        this.SPACE_BEFORE_SUPERCLASS_COLON = true;
        this.SPACE_AFTER_SUPERCLASS_COLON = true;
        this.SPACE_BEFORE_INIT_LIST_COLON = true;
        this.SPACE_AFTER_INIT_LIST_COLON = true;
        this.SPACE_BEFORE_INIT_LIST = false;
        this.SPACE_BEFORE_CATEGORY_PARENTHESES = true;
        this.SPACE_BEFORE_PROTOCOLS_BRACKETS = true;
        this.SPACE_AFTER_VISIBILITY_SIGN_IN_METHOD_DECLARATION = true;
        this.SPACE_AFTER_COLON_IN_SELECTOR = false;
        this.SPACE_BEFORE_CHAINED_SEND_MESSAGE = true;
        this.SPACE_BEFORE_POINTER_IN_DECLARATION = true;
        this.SPACE_AFTER_POINTER_IN_DECLARATION = false;
        this.SPACE_BEFORE_REFERENCE_IN_DECLARATION = true;
        this.SPACE_AFTER_REFERENCE_IN_DECLARATION = false;
        this.SPACE_AFTER_REFERENCE_IN_RVALUE = false;
        this.SPACE_AFTER_CUP_IN_BLOCKS = false;
        this.SPACE_BETWEEN_ADJACENT_BRACKETS = true;
        this.SPACE_BETWEEN_OPERATOR_AND_PUNCTUATOR = false;
        this.SPACE_AROUND_DICTIONARY_LITERAL_COLON = true;
        this.SPACE_AROUND_PM_OPERATORS = false;
        this.DISCHARGED_SHORT_TERNARY_OPERATOR = false;
        this.IN_LINE_SHORT_TERNARY_OPERATOR = true;
        this.KEEP_BLANK_LINES_BEFORE_END = 2;
        this.BLANK_LINES_AROUND_NAMESPACE = 0;
        this.BLANK_LINES_AROUND_PROPERTIES_IN_INTERFACE = 0;
        this.BLANK_LINES_AROUND_PROPERTIES_IN_DECLARATION = 0;
        this.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR = true;
        this.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES = RememberedOption.ASK;
        this.REFACTOR_PROPERTIES_AND_IVARS = true;
        this.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES = true;
        this.USE_SETTERS_IN_CONSTRUCTOR = true;
        this.GENERATE_CLASS_CONSTRUCTOR = true;
        this.CREATE_INTERFACE_FOR_CATEGORIES = true;
        this.PUT_IVARS_TO_IMPLEMENTATION = true;
        this.SEMICOLON_AFTER_METHOD_SIGNATURE = false;
        this.RELEASE_STYLE = ReleaseStyle.IVAR;
        this.DECLARE_GENERATED_METHODS = true;
        this.DESCRIPTION_INCLUDE_MEMBER_NAMES = true;
        this.COPY_IS_DEEP = false;
        this.PROPERTY_NONATOMIC = true;
        this.INSERT_OVERRIDE = true;
        this.IVARS_PREFIX = "_";
        this.IVARS_SUFFIX = "";
        this.FIELDS_PREFIX = "";
        this.FIELDS_SUFFIX = "";
        this.GETTERS_PREFIX = "get";
        this.SETTERS_PREFIX = "set";
        this.FILE_DECLARATIONS_ORDER = new ArrayList<OCDeclarationKind>(OCDeclarationKind.ourFileDeclarationKinds);
        this.CLASS_DECLARATIONS_ORDER = new ArrayList<OCDeclarationKind>(OCDeclarationKind.ourClassDeclarationKinds);
        this.INTRODUCE_CONST_VARS = false;
        this.INTRODUCE_CONST_PARAMS = false;
        this.INTRODUCE_AUTO_VARS = false;
        this.INTRODUCE_STATIC_CONSTS = true;
        this.INTRODUCE_GLOBALS_TO_HEADER = true;
        this.INTRODUCE_GENERATE_PROPERTY = false;
        this.INTRODUCE_GENERATE_SYNTHESIZE = true;
        this.INTRODUCE_PROP_TO_PRIVATE_CATEGORY = false;
        this.INTRODUCE_USE_NS_TYPES = false;
        this.TYPE_QUALIFIERS_PLACEMENT = Placement.BEFORE;
        ArrayList<FileExtensionPair> list = new ArrayList<FileExtensionPair>(3);
        if (PlatformUtils.isAppCode()) {
            list.add(new FileExtensionPair("mm", "h"));
        }
        ContainerUtil.addAll(list, (Object[])new FileExtensionPair[]{new FileExtensionPair("cpp", "h"), new FileExtensionPair("c", "h")});
        this.FILE_EXTENSION_PAIRS_ORDERED = ContainerUtil.immutableList(list);
        OCLanguageCodeStyleSettingsProvider.CUSTOM_OPTION.configureCustomSettings(this);
    }

    public Object clone() {
        OCCodeStyleSettings clone = (OCCodeStyleSettings)((Object)super.clone());
        clone.FILE_DECLARATIONS_ORDER = new ArrayList<OCDeclarationKind>(this.FILE_DECLARATIONS_ORDER);
        clone.CLASS_DECLARATIONS_ORDER = new ArrayList<OCDeclarationKind>(this.CLASS_DECLARATIONS_ORDER);
        return clone;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        super.readExternal(parentElement);
        Element parentNode = parentElement.getChild(this.getTagName() + "-extensions");
        if (parentNode == null) {
            return;
        }
        for (Object o : parentNode.getChildren("option")) {
            Element e = (Element)o;
            String fieldName = e.getAttributeValue("name");
            String value = e.getAttributeValue("value");
            try {
                Field field = ((Object)((Object)this)).getClass().getField(fieldName);
                if (!field.getType().isEnum() || value == null) continue;
                field.set((Object)this, Enum.valueOf(field.getType(), value));
            }
            catch (IllegalAccessException ex) {
                throw new InvalidDataException((Throwable)ex);
            }
            catch (NoSuchFieldException ex) {
                LOG.debug((Throwable)ex);
            }
        }
        OCCodeStyleSettings.readDeclarationsOrder(parentNode, "file", this.FILE_DECLARATIONS_ORDER);
        OCCodeStyleSettings.readDeclarationsOrder(parentNode, "class", this.CLASS_DECLARATIONS_ORDER);
        this.readFileExtensions(parentNode);
    }

    private static void readDeclarationsOrder(Element parentNode, String orderName, List<OCDeclarationKind> order) {
        Element childElement = parentNode.getChild(orderName);
        if (childElement == null) {
            return;
        }
        order.clear();
        for (Object o : childElement.getChildren("option")) {
            Element e = (Element)o;
            OCDeclarationKind kind = Enum.valueOf(OCDeclarationKind.class, e.getAttributeValue("value"));
            if (!kind.isAvailable()) continue;
            order.add(kind);
        }
    }

    private void readFileExtensions(Element parentNode) {
        Element childElement = parentNode.getChild("extensions");
        if (childElement != null) {
            ArrayList list = ContainerUtil.newArrayList();
            for (Element e : childElement.getChildren("pair")) {
                String source = e.getAttributeValue("source");
                String header = e.getAttributeValue("header");
                if (source == null || header == null) continue;
                list.add(new FileExtensionPair(source, header));
            }
            if (!list.isEmpty()) {
                this.FILE_EXTENSION_PAIRS_ORDERED = ContainerUtil.immutableList((List)list);
            }
        }
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        super.writeExternal(parentElement, parentSettings);
        Element childElement = new Element(this.getTagName() + "-extensions");
        for (Field field : ((Object)((Object)this)).getClass().getFields()) {
            Element element;
            if (!field.getType().isEnum()) continue;
            try {
                element = OCCodeStyleSettings.writeEnumField(field.getName(), (Enum)field.get((Object)this));
            }
            catch (IllegalAccessException e) {
                continue;
            }
            childElement.addContent(element);
        }
        OCCodeStyleSettings.addDeclarationsOrder(childElement, "file", this.FILE_DECLARATIONS_ORDER);
        OCCodeStyleSettings.addDeclarationsOrder(childElement, "class", this.CLASS_DECLARATIONS_ORDER);
        OCCodeStyleSettings.addList(childElement, "extensions", this.FILE_EXTENSION_PAIRS_ORDERED);
        parentElement.addContent(childElement);
    }

    private static void addList(Element element, String name, List<? extends JDOMExternalizable> list) throws WriteExternalException {
        Element childElement = new Element(name);
        for (JDOMExternalizable jDOMExternalizable : list) {
            jDOMExternalizable.writeExternal(childElement);
        }
        if (!childElement.getContent().isEmpty()) {
            element.addContent(childElement);
        }
    }

    private static void addDeclarationsOrder(Element parentElement, String orderName, List<OCDeclarationKind> order) {
        Element childElement = new Element(orderName);
        for (OCDeclarationKind kind : order) {
            Element element = OCCodeStyleSettings.writeEnumField(OCDeclarationKind.class.getName(), kind);
            childElement.addContent(element);
        }
        parentElement.addContent(childElement);
    }

    private static Element writeEnumField(String name, Enum value) {
        Element element = new Element("option");
        element.setAttribute("name", name);
        element.setAttribute("value", value.name());
        return element;
    }

    @Nullable
    public static RememberedOption askAndSave(RememberedOption option, String message, String title, Ref<Boolean> result) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            result.set((Object)true);
            return option;
        }
        if (option == RememberedOption.ASK) {
            final Ref save = Ref.create((Object)Boolean.FALSE);
            int code = ((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).doNotAsk(new DialogWrapper.DoNotAskOption(){

                public boolean isToBeShown() {
                    return true;
                }

                public void setToBeShown(boolean value, int exitCode) {
                    save.set((Object)(!value ? 1 : 0));
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return true;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    return "Remember the choice";
                }
            })).show();
            if (code == 2) {
                return null;
            }
            boolean answer = code == 0;
            result.set((Object)answer);
            if (((Boolean)save.get()).booleanValue()) {
                return answer ? RememberedOption.YES : RememberedOption.NO;
            }
        } else {
            result.set((Object)(option == RememberedOption.YES ? 1 : 0));
        }
        return option;
    }

    public static class FileExtensionPair
    implements JDOMExternalizable {
        @NotNull
        public final String mySourceExt;
        @NotNull
        public final String myHeaderExt;

        public FileExtensionPair(@NotNull String sourceExt, @NotNull String headerExt) {
            this.mySourceExt = sourceExt;
            this.myHeaderExt = headerExt;
        }

        public String toString() {
            return "." + this.mySourceExt + " / " + "." + this.myHeaderExt;
        }

        public void readExternal(Element parentElement) throws InvalidDataException {
        }

        public void writeExternal(Element parentElement) throws WriteExternalException {
            Element element = new Element("pair");
            element.setAttribute("source", this.mySourceExt);
            element.setAttribute("header", this.myHeaderExt);
            parentElement.addContent(element);
        }
    }

    public static enum Placement {
        BEFORE,
        AFTER;

    }

    public static enum RememberedOption {
        YES,
        NO,
        ASK;

    }

    public static enum ReleaseStyle {
        IVAR,
        IVAR_2,
        PROPERTY;

    }

    public static enum HeaderImportStyle {
        PREDEFINE,
        IMPORT;

    }

    public static @interface NewLineConstant {
    }
}

