/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchScope {
    private static final Key<GlobalSearchScope> PROJECT_SOURCES_SCOPE = Key.create((String)"PROJECT_SOURCES_SCOPE");
    private static final Key<CachedValue<Collection<VirtualFile>>> EXPLICIT_PROJECT_SOURCE_FILES = Key.create((String)"EXPLICIT_PROJECT_SOURCE_FILES");

    @NotNull
    public static GlobalSearchScope getGotoSymbolScope(@NotNull Project project2, boolean includeNonProjectFiles) {
        return includeNonProjectFiles ? ProjectScope.getAllScope((Project)project2) : OCSearchScope.getProjectSourcesScope(project2);
    }

    @NotNull
    public static GlobalSearchScope getProjectSourcesScope(@NotNull Project project2) {
        GlobalSearchScope cached = (GlobalSearchScope)project2.getUserData(PROJECT_SOURCES_SCOPE);
        return cached != null ? cached : (GlobalSearchScope)((UserDataHolderEx)project2).putUserDataIfAbsent(PROJECT_SOURCES_SCOPE, (Object)OCSearchScope.createProjectSourcesScope(project2));
    }

    @NotNull
    private static DelegatingGlobalSearchScope createProjectSourcesScope(@NotNull Project project2) {
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        return new DelegatingGlobalSearchScope(ProjectScope.getContentScope((Project)project2)){

            public boolean contains(@NotNull VirtualFile file2) {
                return OCSearchScope.isSourceFile(index, file2);
            }
        };
    }

    private static boolean isSourceFile(ProjectFileIndex index, VirtualFile file2) {
        return index.isInSourceContent(file2) && !index.isInLibrarySource(file2) && !index.isInLibraryClasses(file2);
    }

    @NotNull
    public static Collection<VirtualFile> getExplicitlySpecifiedProjectSourceFiles(final @NotNull Project project2) {
        return (Collection)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, EXPLICIT_PROJECT_SOURCE_FILES, (CachedValueProvider)new CachedValueProvider<Collection<VirtualFile>>(){

            @Nullable
            public CachedValueProvider.Result<Collection<VirtualFile>> compute() {
                THashSet result = new THashSet();
                ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project2);
                final ProjectFileIndex index = rootManager.getFileIndex();
                final FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
                for (VirtualFile eachSourceRoot : rootManager.getContentSourceRoots()) {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)eachSourceRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (Set)result){
                        final /* synthetic */ Set val$result;
                        {
                            this.val$result = set;
                            super(arg0);
                        }

                        public boolean visitFile(@NotNull VirtualFile each) {
                            if (index.isExcluded(each) || typeRegistry.isFileIgnored(each)) {
                                return false;
                            }
                            if (!each.isDirectory() && OCSearchScope.isSourceFile(index, each)) {
                                this.val$result.add(each);
                            }
                            return true;
                        }
                    });
                }
                return CachedValueProvider.Result.create(Collections.unmodifiableCollection(result), OCSearchScope.getProjectSourcesCacheDependencies(project2));
            }
        }, false);
    }

    @NotNull
    public static Collection<?> getProjectSourcesCacheDependencies(@NotNull Project project2) {
        return Arrays.asList(VirtualFileManager.getInstance(), ProjectRootManager.getInstance((Project)project2));
    }

    @Contract(value="null->false")
    public static boolean isInProjectSources(@Nullable OCSymbol symbol) {
        return OCSearchScope.isInProjectSources((PsiElement)OCSearchScope.getContainingFile(symbol));
    }

    @Nullable
    private static PsiFile getContainingFile(@Nullable OCSymbol symbol) {
        if (symbol == null || symbol.getKind() == OCSymbolKind.BUILTIN_SYMBOL) {
            return null;
        }
        return symbol.getContainingPsiFile();
    }

    @Contract(value="null->false")
    public static boolean isInProjectSources(@Nullable PsiElement element) {
        VirtualFile file2 = OCSearchScope.getVirtualFile(element);
        return file2 != null && OCSearchScope.getProjectSourcesScope(element.getProject()).contains(file2);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSourcesOrLibraries(@Nullable OCSymbol symbol) {
        return OCSearchScope.isInProjectSourcesOrLibraries((PsiElement)OCSearchScope.getContainingFile(symbol));
    }

    @Contract(value="null->false")
    public static boolean isInProjectSourcesOrLibraries(@Nullable PsiElement element) {
        VirtualFile file2 = OCSearchScope.getVirtualFile(element);
        if (file2 == null) {
            return false;
        }
        return OCSearchScope.getProjectSourcesScope(element.getProject()).contains(file2) || ProjectScope.getLibrariesScope((Project)element.getProject()).contains(file2);
    }

    @Contract(value="null->false")
    public static boolean isInLibraries(@Nullable OCSymbol symbol) {
        return OCSearchScope.isInLibraries((PsiElement)OCSearchScope.getContainingFile(symbol));
    }

    @Contract(value="null->false")
    public static boolean isInLibraries(@Nullable PsiElement element) {
        VirtualFile file2 = OCSearchScope.getVirtualFile(element);
        if (file2 == null) {
            return false;
        }
        return OCSearchScope.isInLibraries(file2, element.getProject());
    }

    public static boolean isInLibraries(@NotNull VirtualFile file2, @NotNull Project project2) {
        return ProjectScope.getLibrariesScope((Project)project2).contains(file2);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof PsiCodeFragment) {
            PsiElement context = file2.getContext();
            file2 = context == null ? null : context.getContainingFile();
        }
        return file2 == null ? null : OCInclusionContextUtil.getVirtualFile(file2);
    }
}

