/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.search.OCDirectStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class OCStructInheritorsSearch
extends QueryFactory<OCStructSymbol, SearchParameters> {
    public static final OCStructInheritorsSearch INSTANCE = new OCStructInheritorsSearch();

    private OCStructInheritorsSearch() {
    }

    public static Query<OCStructSymbol> search(OCStruct struct) {
        Project project2 = struct.getProject();
        OCStructSymbol symbol = (OCStructSymbol)struct.getSymbol();
        OCQualifiedName structName = symbol != null ? symbol.getResolvedQualifiedName() : null;
        return OCStructInheritorsSearch.search(structName, GlobalSearchScope.allScope((Project)project2), struct.getContainingFile(), project2);
    }

    public static Query<OCStructSymbol> search(OCStructSymbol struct, @NotNull PsiElement context) {
        Project project2 = struct.getProject();
        OCQualifiedName structName = struct.getResolvedQualifiedName();
        return OCStructInheritorsSearch.search(structName, GlobalSearchScope.allScope((Project)project2), context.getContainingFile(), project2);
    }

    public static Query<OCStructSymbol> search(OCQualifiedName structName, GlobalSearchScope scope, PsiFile file2, Project project2) {
        return INSTANCE.createQuery(new SearchParameters(scope, structName, file2, project2));
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCStructSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, final @NotNull Processor<OCStructSymbol> consumer) {
            final GlobalSearchScope scope = p.getScope();
            Project project2 = p.getProject();
            final Stack names = new Stack();
            HashSet<OCQualifiedName> processed2 = new HashSet<OCQualifiedName>();
            final HashSet accepted = new HashSet();
            names.push((Object)p.getStructName());
            while (!names.isEmpty()) {
                ProgressManager.checkCanceled();
                OCQualifiedName name = (OCQualifiedName)names.pop();
                if (!processed2.add(name)) continue;
                Query<OCStructSymbol> search = OCDirectStructInheritorsSearch.search(name, GlobalSearchScope.allScope((Project)project2), p.getFile(), project2);
                search.forEach((Processor)new Processor<OCStructSymbol>(){

                    public boolean process(OCStructSymbol symbol) {
                        OCQualifiedName qualifiedName = symbol.getResolvedQualifiedName();
                        names.push((Object)qualifiedName);
                        return !scope.contains(symbol.getContainingFile()) || !accepted.add(qualifiedName) || consumer.process((Object)symbol);
                    }
                });
            }
        }
    }

    public static class SearchParameters {
        private GlobalSearchScope myScope;
        private OCQualifiedName myStructName;
        private PsiFile myFile;
        private Project myProject;

        public SearchParameters(GlobalSearchScope scope, OCQualifiedName structName, PsiFile file2, Project project2) {
            this.myScope = scope;
            this.myStructName = structName;
            this.myFile = file2;
            this.myProject = project2;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        public OCQualifiedName getStructName() {
            return this.myStructName;
        }

        public PsiFile getFile() {
            return this.myFile;
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

