/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCConstructorInEmptyInitializationUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCExternalReferenceUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDotCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCPropertyAttributeUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelectorExpressionUsage;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.constructors.OCBaseConstructorReference;
import com.jetbrains.cidr.lang.search.constructors.OCConstructorImplicitReferenceSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchUtil {
    @NotNull
    public static Collection<VirtualFile> getProjectVirtualFilesByName(@NotNull Project project2, @NotNull String name) {
        return FilenameIndex.getVirtualFilesByName(project2, name, SystemInfo.isFileSystemCaseSensitive, GlobalSearchScope.projectScope((Project)project2));
    }

    @NotNull
    public static List<OCFile> getProjectOCFilesByName(@NotNull Project project2, @NotNull String name) {
        return OCSearchUtil.getOCFilesByName(project2, name, GlobalSearchScope.projectScope((Project)project2));
    }

    @NotNull
    public static List<OCFile> getOCFilesByName(@NotNull Project project2, @NotNull String name, @NotNull GlobalSearchScope scope) {
        return ContainerUtil.filter((Object[])FilenameIndex.getFilesByName(project2, name, scope), (Condition)new FilteringIterator.InstanceOf(OCFile.class));
    }

    public static <T extends OCSymbolWithParent> boolean processMembersHierarchy(T member, Processor<? super T> processor2, boolean searchAncestors, boolean searchInheritors) {
        return OCSearchUtil.processMembersHierarchy(member, processor2, searchAncestors, searchInheritors, true);
    }

    public static <T extends OCSymbolWithParent> boolean processMembersHierarchy(T member, Processor<? super T> processor2, boolean searchAncestors, boolean searchInheritors, boolean includeSameSymbols) {
        Object parameters;
        if (member instanceof OCFunctionSymbol && searchInheritors) {
            parameters = OCFunctionInheritorsSearch.getParameters((OCFunctionSymbol)member, member.getContainingOCFile(), true);
            ((OCFunctionInheritorsSearch.SearchParameters)parameters).setIncludeSameSymbols(includeSameSymbols);
            if (!OCFunctionInheritorsSearch.search((OCFunctionInheritorsSearch.SearchParameters)parameters).forEach(processor2)) {
                return false;
            }
        }
        if (member instanceof OCFunctionSymbol && searchAncestors && !new OCFunctionAncestorsQuery((OCFunctionSymbol)member, true, includeSameSymbols).processResults(processor2)) {
            return false;
        }
        if (member instanceof OCMemberSymbol) {
            parameters = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)member);
            ((OCMemberInheritorsSearch.SearchParameters)parameters).setIncludeSelfImplementation(includeSameSymbols);
            ((OCMemberInheritorsSearch.SearchParameters)parameters).setInheritors(searchInheritors);
            ((OCMemberInheritorsSearch.SearchParameters)parameters).setAncestors(searchAncestors);
            if (!OCMemberInheritorsSearch.search(parameters).forEach(processor2)) {
                return false;
            }
        }
        return true;
    }

    public static boolean processMembersHierarchyPsi(OCSymbolWithParent member, final Processor<PsiElement> processor2, boolean searchAncestors, boolean searchInheritors) {
        return OCSearchUtil.processMembersHierarchy(member, new Processor<OCSymbolWithParent>(){

            public boolean process(OCSymbolWithParent symbol) {
                Object overridingMethod = symbol.locateDefinition();
                if (overridingMethod instanceof OCDeclarator) {
                    overridingMethod = overridingMethod.getParent();
                }
                if (overridingMethod != null) {
                    return processor2.process(overridingMethod);
                }
                return true;
            }
        }, searchAncestors, searchInheritors);
    }

    @Nullable
    public static Ancestor findSomeAncestor(OCSymbolWithParent member) {
        final Ancestor result = new Ancestor();
        OCSearchUtil.processMembersHierarchy(member, new Processor<OCSymbolWithParent>(){

            public boolean process(OCSymbolWithParent symbol) {
                result.symbol = symbol;
                if (!OCSearchScope.isInProjectSources(symbol)) {
                    result.isOutOfProject = true;
                    return false;
                }
                return true;
            }
        }, true, false, false);
        return result.getSymbol() != null ? result : null;
    }

    public static boolean processMemberAncestors(final OCSymbolWithParent member, final Processor<? super OCSymbolWithParent> processor2, final boolean onlyDeclarations) {
        return OCSearchUtil.processMembersHierarchy(member, new Processor<OCSymbolWithParent>(){

            public boolean process(OCSymbolWithParent ancestor) {
                if (onlyDeclarations && ancestor.isDefinition() && ancestor.getFirstPredeclaration() != null || ancestor.equals(member)) {
                    return true;
                }
                return processor2.process((Object)ancestor);
            }
        }, true, false, true);
    }

    public static boolean findAllMemberUsages(OCSymbolWithParent member, final Set<UsageInfo> result, boolean searchInheritors, boolean searchAncestors) {
        return OCSearchUtil.processMembersHierarchyPsi(member, new Processor<PsiElement>(){

            public boolean process(PsiElement element) {
                OCSearchUtil.findOneMethodUsages(element, result);
                return true;
            }
        }, searchAncestors, searchInheritors);
    }

    public static void findOneMethodUsages(PsiElement method, final Set<UsageInfo> result) {
        GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(method.getProject());
        if (method instanceof OCFunctionDeclaration) {
            OCDeclarator declarator = ((OCFunctionDeclaration)method).getDeclarator();
            if (declarator != null) {
                for (PsiReference ref : ReferencesSearch.search((PsiElement)declarator, (SearchScope)scope).findAll()) {
                    if (ref.getElement() == null || !((Object)((Object)OCLanguage.getInstance())).equals(ref.getElement().getLanguage())) continue;
                    result.add(new OCFunctionUsage(ref));
                }
                for (PsiReference ref : OCConstructorImplicitReferenceSearch.search(declarator, (SearchScope)scope)) {
                    result.add(new OCConstructorInEmptyInitializationUsage((OCBaseConstructorReference)ref));
                }
            }
        } else if (method instanceof OCMethod) {
            Processor<PsiReference> consumer = new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    if (psiReference instanceof OCExternalReference) {
                        result.add(new OCExternalReferenceUsage((OCExternalReference)psiReference));
                        return true;
                    }
                    PsiElement element = psiReference.getElement();
                    if (element instanceof OCSendMessageExpression) {
                        result.add(new OCMethodCallUsage(psiReference));
                    } else if (element instanceof OCSelectorExpression) {
                        result.add(new OCSelectorExpressionUsage(psiReference));
                    } else if (element instanceof OCPropertyAttribute) {
                        result.add(new OCPropertyAttributeUsage(psiReference));
                    } else if (element instanceof OCQualifiedExpression) {
                        result.add(new OCMethodDotCallUsage(psiReference));
                    }
                    return true;
                }
            };
            ReferencesSearch.search((PsiElement)method, (SearchScope)scope, (boolean)false).forEach((Processor)consumer);
        }
    }

    public static class Ancestor {
        OCSymbolWithParent symbol;
        boolean isOutOfProject;

        public OCSymbolWithParent getSymbol() {
            return this.symbol;
        }

        public boolean isOutOfProject() {
            return this.isOutOfProject;
        }
    }
}

