/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import org.jetbrains.annotations.NotNull;

public class OCPropertyReferencesSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer) {
        return (Boolean)new ReadAction<Boolean>(){

            protected void run(@NotNull Result<Boolean> result) {
                result.setResult((Object)OCPropertyReferencesSearch.doExecute(queryParameters, (Processor<PsiReference>)consumer));
            }
        }.execute().getResultObject();
    }

    private static Boolean doExecute(final ReferencesSearch.SearchParameters queryParameters, final Processor<PsiReference> consumer) {
        final PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof OCSymbolDeclarator)) {
            return true;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (!(symbol instanceof OCPropertySymbol)) {
            return true;
        }
        final OCPropertySymbol property = (OCPropertySymbol)symbol;
        return ((OCClassSymbol)property.getParent()).processMembers(OCMethodSymbol.class, new Processor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol method) {
                return method.getGeneratedFromProperty() != property || OCPropertyReferencesSearch.processMethod(queryParameters, method, element, (Processor<PsiReference>)consumer);
            }
        });
    }

    private static boolean processMethod(ReferencesSearch.SearchParameters queryParameters, OCMethodSymbol method, final PsiElement declarator, final Processor<PsiReference> consumer) {
        final String methodSelector = method.getName();
        TextOccurenceProcessor processor2 = new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                PsiReference ref;
                String selector = null;
                if (element instanceof OCSendMessageExpression) {
                    selector = ((OCSendMessageExpression)element).getMessageSelector();
                } else if (element instanceof OCSelectorExpression) {
                    selector = ((OCSelectorExpression)element).getSelector();
                } else if (element instanceof OCQualifiedExpression) {
                    selector = ((OCQualifiedExpression)element).getName();
                }
                if (methodSelector.equals(selector) && (ref = element.getReference()) != null && ref.isReferenceTo(declarator)) {
                    return consumer.process((Object)ref);
                }
                return true;
            }
        };
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)declarator.getProject());
        return helper.processElementsWithWord(processor2, queryParameters.getEffectiveSearchScope(), methodSelector, (short)1, true);
    }
}

