/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCMethodReferencesSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    private final boolean myFindAllPotentialCalls;

    public OCMethodReferencesSearch() {
        this(false);
    }

    public OCMethodReferencesSearch(boolean findPotentialAllPotentialCalls) {
        this.myFindAllPotentialCalls = findPotentialAllPotentialCalls;
    }

    public boolean execute(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer) {
        return (Boolean)new ReadAction<Boolean>(){

            protected void run(@NotNull Result<Boolean> result) {
                result.setResult((Object)OCMethodReferencesSearch.this.doExecute(queryParameters, (Processor<PsiReference>)consumer));
            }
        }.execute().getResultObject();
    }

    private Boolean doExecute(ReferencesSearch.SearchParameters queryParameters, Processor<PsiReference> consumer) {
        String searchWord;
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof OCMethod)) {
            return true;
        }
        OCMethod method = (OCMethod)element;
        List<OCMethodSelectorPart> parts = method.getParameters();
        String methodSelector = method.getSelector();
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject());
        if (parts.isEmpty()) {
            return true;
        }
        String firstSelector = parts.get(0).getSelectorPart();
        if (firstSelector == null) {
            return true;
        }
        String string = searchWord = firstSelector.endsWith(":") ? firstSelector.substring(0, firstSelector.length() - 1) : firstSelector;
        if (searchWord.isEmpty()) {
            return true;
        }
        if (!helper.processElementsWithWord((TextOccurenceProcessor)new MyOccurenceProcessor(method, methodSelector, consumer, false, this.myFindAllPotentialCalls), queryParameters.getEffectiveSearchScope(), searchWord, (short)1, true)) {
            return false;
        }
        String getterName = OCNameSuggester.getObjCGetterFromSetter(methodSelector);
        if (getterName != null && !getterName.isEmpty()) {
            return helper.processElementsWithWord((TextOccurenceProcessor)new MyOccurenceProcessor(method, getterName, consumer, true, this.myFindAllPotentialCalls), queryParameters.getEffectiveSearchScope(), getterName, (short)1, true);
        }
        return true;
    }

    private static class MyOccurenceProcessor
    implements TextOccurenceProcessor {
        private final OCMethod myMethod;
        private final OCMethodSymbol mySymbol;
        private final String myMethodSelector;
        private final OCObjectType myType;
        private final Processor<PsiReference> myConsumer;
        private final boolean myFindAllPotentialCalls;
        private final boolean mySetterMode;

        public MyOccurenceProcessor(OCMethod method, String methodSelector, Processor<PsiReference> consumer, boolean setterMode, boolean findAllPotentialCalls) {
            this.mySetterMode = setterMode;
            this.myMethodSelector = methodSelector;
            this.myMethod = method;
            this.mySymbol = (OCMethodSymbol)method.getSymbol();
            this.myConsumer = consumer;
            this.myFindAllPotentialCalls = findAllPotentialCalls;
            OCClassDeclaration containingClass = method.getContainingClass();
            this.myType = containingClass.getType();
        }

        public boolean execute(@NotNull PsiElement element, int offsetInElement) {
            String selector = null;
            if (element instanceof OCQualifiedExpression) {
                selector = ((OCQualifiedExpression)element).getName();
                OCExpression expression = OCParenthesesUtils.topmostParenthesized((OCExpression)element);
                if (expression.getParent() instanceof OCAssignmentExpression && ((OCAssignmentExpression)expression.getParent()).getReceiverExpression() == expression ? !this.mySetterMode : this.mySetterMode) {
                    return true;
                }
            } else if (this.mySetterMode) {
                return true;
            }
            if (element instanceof OCMessageArgument && offsetInElement == 0) {
                OCSendMessageExpression sendMessageExpression = (OCSendMessageExpression)element.getParent();
                if (sendMessageExpression.getArguments().get(0) == element) {
                    selector = sendMessageExpression.getMessageSelector();
                    element = sendMessageExpression;
                }
            } else if (element instanceof OCSelectorExpression) {
                selector = ((OCSelectorExpression)element).getSelector();
            } else if (element instanceof XmlTag) {
                selector = ((XmlTag)element).getValue().getText();
            } else if (element instanceof XmlAttributeValue) {
                selector = ((XmlAttributeValue)element).getValue();
            } else if (element.getParent() instanceof OCPropertyAttribute) {
                element = element.getParent();
                selector = ((OCPropertyAttribute)element).getValue();
            }
            if (this.myMethodSelector.equals(selector)) {
                for (PsiReference ref : element.getReferences()) {
                    if (ref.isReferenceTo((PsiElement)this.myMethod)) {
                        return this.myConsumer.process((Object)ref);
                    }
                    OCObjectTypeContext receiverContext = null;
                    boolean isVirtualCall = true;
                    if (ref.getElement() instanceof OCSendMessageExpression) {
                        OCExpression receiver = OCParenthesesUtils.diveIntoParentheses(((OCSendMessageExpression)ref.getElement()).getReceiverExpression());
                        if (receiver instanceof OCReferenceExpression) {
                            isVirtualCall = ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF;
                        }
                        receiverContext = ((OCSendMessageExpression)ref.getElement()).getReceiverContext();
                    } else if (ref.getElement() instanceof OCQualifiedExpression) {
                        receiverContext = ((OCQualifiedExpression)ref.getElement()).getQualifier().getTypeContext();
                    }
                    if (receiverContext == null || this.myType == null || !receiverContext.fitsStaticness(this.mySymbol)) continue;
                    OCObjectType receiverType = receiverContext.getType();
                    if (this.myFindAllPotentialCalls && !isVirtualCall) {
                        if (!receiverType.equalsAfterResolving(this.myType, (PsiElement)element.getContainingFile())) continue;
                        this.myConsumer.process((Object)ref);
                        continue;
                    }
                    if ((!this.myFindAllPotentialCalls || !receiverType.isCompatible(this.myType, element)) && (this.myFindAllPotentialCalls || !this.myType.isCompatible(receiverType, element))) continue;
                    return this.myConsumer.process((Object)ref);
                }
            }
            return true;
        }
    }
}

