/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.util.Condition;
import com.intellij.util.AbstractQuery;
import com.intellij.util.FilteredQuery;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionAncestorsQuery
extends AbstractQuery<OCFunctionSymbol> {
    private final OCFunctionSymbol myFunction;
    private final boolean myProcessSameSymbols;
    private boolean myGoTransitive = true;

    public OCFunctionAncestorsQuery(OCFunctionSymbol function, boolean goTransitive, boolean processSameSymbols) {
        this.myFunction = function;
        this.myGoTransitive = goTransitive;
        this.myProcessSameSymbols = processSameSymbols;
    }

    @Nullable
    public static OCFunctionSymbol findFirstVirtual(OCFunctionSymbol function, boolean processSameSymbols) {
        return (OCFunctionSymbol)new FilteredQuery((Query)new OCFunctionAncestorsQuery(function, false, processSameSymbols), (Condition)new Condition<OCFunctionSymbol>(){

            public boolean value(OCFunctionSymbol symbol) {
                return symbol.isVirtual();
            }
        }).findFirst();
    }

    @Nullable
    public static OCFunctionSymbol findFirstNonPure(OCFunctionSymbol function, boolean processSameSymbols) {
        return (OCFunctionSymbol)new FilteredQuery((Query)new OCFunctionAncestorsQuery(function, false, processSameSymbols), (Condition)new Condition<OCFunctionSymbol>(){

            public boolean value(OCFunctionSymbol symbol) {
                return !symbol.isPureVirtual();
            }
        }).findFirst();
    }

    protected boolean processResults(@NotNull Processor<OCFunctionSymbol> consumer) {
        OCSymbol associated;
        OCSymbolWithQualifiedName struct = this.myFunction.getResolvedOwner();
        if (!(struct instanceof OCStructSymbol)) {
            return true;
        }
        if (struct.isPredeclaration() && (associated = struct.getDefinitionSymbol()) instanceof OCSymbolWithQualifiedName) {
            struct = (OCSymbolWithQualifiedName)associated;
        }
        final HashMap map = new HashMap();
        final OCFile file2 = this.myFunction.getContainingOCFile();
        final OCType resolvedType = this.myFunction.getResolvedType();
        final boolean isDestructor = this.myFunction.isCppDestructor();
        final OCResolveContext context = new OCResolveContext(file2);
        Condition<OCSymbol> condition = new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                return symbol instanceof OCFunctionSymbol && !((OCFunctionSymbol)symbol).isStatic() && new OCTypeEqualityAfterResolvingVisitor(resolvedType, true, context).isFunctionSignatureEqual(symbol.getType().resolve(file2));
            }
        };
        final OCSymbolWithQualifiedName finalStruct = struct;
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
                OCQualifiedName name = functionSymbol.getResolvedQualifiedName();
                if (isDestructor && !functionSymbol.isCppDestructor() || !OCFunctionAncestorsQuery.this.myProcessSameSymbols && finalStruct.equals(functionSymbol.getParent())) {
                    return true;
                }
                OCFunctionSymbol old = (OCFunctionSymbol)map.get((Object)name);
                if (old == null || !old.isPredeclaration()) {
                    map.put((Object)name, (Object)functionSymbol);
                }
                return true;
            }
        };
        if (!this.myFunction.isStatic()) {
            OCStructType.processMembersInBaseTypes((OCStructSymbol)struct, isDestructor ? null : this.myFunction.getName(), false, this.myGoTransitive, condition, processor2, context);
        }
        if (this.myProcessSameSymbols) {
            this.myFunction.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor((Condition)condition, (Processor)processor2));
        }
        for (OCFunctionSymbol symbol : map.values()) {
            if (!(this.myProcessSameSymbols ? !symbol.processSameSymbols(new OCCommonProcessors.TypeFilteredProcessor(consumer, OCFunctionSymbol.class)) : !consumer.process((Object)symbol))) continue;
            return false;
        }
        return true;
    }
}

