/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.resolve.references.OCStatefulReference;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCOperatorReference
extends OCPolyVariantReferenceImpl<OCSymbol>
implements OCStatefulReference {
    private final OCElement myElement;
    private final String mySign;
    private final OperatorPlacement myPlacement;
    protected final List<? extends OCTypeOwner> myArguments;
    private final List<OCType> myParamTypes;
    private final PsiElement mySignElement;
    private static Key<MyResolver> RESOLVER_KEY = Key.create((String)"RESOLVER_KEY");

    public OCOperatorReference(@NotNull OCElement element, @NotNull String sign, @NotNull OperatorPlacement placement, @Nullable PsiElement signElement, OCExpression ... arguments) {
        this(element, sign, placement, signElement, Arrays.asList(arguments), null);
    }

    public OCOperatorReference(@NotNull OCElement element, @NotNull String sign, @NotNull OperatorPlacement placement, @Nullable PsiElement signElement, @Nullable List<? extends OCTypeOwner> arguments, @Nullable List<OCType> paramTypes) {
        this.myElement = element;
        this.mySign = sign;
        this.myPlacement = placement;
        this.myArguments = arguments;
        this.myParamTypes = paramTypes;
        this.mySignElement = signElement;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.mySignElement != null ? OCElementUtil.getRangeInParent(this.mySignElement) : TextRange.EMPTY_RANGE;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        return new Object[0];
    }

    @Override
    public boolean isValid() {
        return !(!this.myElement.isValid() || this.mySignElement != null && !this.mySignElement.isValid() || this.myArguments != null && !ContainerUtil.and(this.myArguments, (Condition)new Condition<OCTypeOwner>(){

            public boolean value(OCTypeOwner owner) {
                return !(owner instanceof OCExpression) || ((OCExpression)owner).isValid();
            }
        }));
    }

    public boolean isSoft() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCOperatorReference reference = (OCOperatorReference)o;
        if (this.myElement != null ? !this.myElement.equals(reference.myElement) : reference.myElement != null) {
            return false;
        }
        if (this.mySignElement != null ? !this.mySignElement.equals(reference.mySignElement) : reference.mySignElement != null) {
            return false;
        }
        return !(this.mySign != null ? !this.mySign.equals(reference.mySign) : reference.mySign != null);
    }

    public int hashCode() {
        int result = this.myElement != null ? this.myElement.hashCode() : 0;
        result = 31 * result + (this.mySign != null ? this.mySign.hashCode() : 0);
        result = 31 * result + (this.mySignElement != null ? this.mySignElement.hashCode() : 0);
        return result;
    }

    @Nullable
    public List<? extends OCTypeOwner> getArgumentExpressions() {
        return this.myArguments;
    }

    @NotNull
    public String getCanonicalText() {
        return this.mySign;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.getElement();
    }

    @Override
    public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
        return this.handleElementRename(symbol.getName());
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
    }

    @Nullable
    public static OCFunctionSymbol resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<OCType> types, @Nullable List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context) {
        OCOperatorReference reference = new OCOperatorReference((OCElement)context.getElement(), sign, placement, null, arguments, types);
        List symbols = (List)new MyResolver((boolean)true, (boolean)true, (OCResolveContext)context).resolve((OCOperatorReference)reference, (OCResolveContext)context).first;
        return (OCFunctionSymbol)ContainerUtil.getFirstItem((List)symbols);
    }

    @Nullable
    public static OCFunctionSymbol resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull OCElement element, @NotNull OCStructType struct) {
        OCResolveContext context = new OCResolveContext(element);
        return (OCFunctionSymbol)ContainerUtil.getFirstItem((List)new MyResolver(true, true, context).doResolveOperator(sign, placement, Collections.singletonList(struct), null, context, null));
    }

    @Nullable
    public static OCFunctionSymbol resolveDerefOperator(@NotNull OCElement element, @NotNull OCStructType struct) {
        return OCOperatorReference.resolveOperator("->", OperatorPlacement.INFIX, element, struct);
    }

    @NotNull
    private List<OCSymbol> resolveToSymbols(@NotNull MyResolver resolver) {
        Pair<List<OCSymbol>, Boolean> pair = ResolveCache.getInstance(this.myElement.getProject()).resolveWithCaching(this, resolver, false, false);
        return pair != null ? (List)pair.getFirst() : Collections.emptyList();
    }

    @NotNull
    public Collection<OCSymbol> resolveToSymbols(boolean resolveOverloads) {
        return this.resolveToSymbols(MyResolver.getInstance(resolveOverloads));
    }

    @NotNull
    public Collection<OCSymbol> resolveToSymbols(boolean resolveOverloads, boolean filterAmbigs) {
        Pair<List<OCSymbol>, Boolean> pair = new MyResolver(resolveOverloads, filterAmbigs).resolve(this, false);
        return pair != null ? (Collection)pair.getFirst() : Collections.emptyList();
    }

    public boolean hasMagicOperands() {
        Pair<List<OCSymbol>, Boolean> pair = ResolveCache.getInstance(this.myElement.getProject()).resolveWithCaching(this, MyResolver.getInstance(true), false, false);
        return pair != null ? (Boolean)pair.getSecond() : false;
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols() {
        return new ArrayList<OCSymbol>(this.resolveToSymbols(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
        MyResolver resolver;
        OCResolveContext oCResolveContext = context;
        synchronized (oCResolveContext) {
            resolver = (MyResolver)context.getUserData(RESOLVER_KEY);
            if (resolver == null) {
                resolver = new MyResolver(true, true, context);
                context.putUserData(RESOLVER_KEY, resolver);
            }
        }
        return this.resolveToSymbols(resolver);
    }

    private static class MyResolver
    implements ResolveCache.AbstractResolver<OCOperatorReference, Pair<List<OCSymbol>, Boolean>> {
        private boolean myResolveOverloads;
        private boolean myFilterAmbigs;
        private OCResolveContext myContext;
        private static final MyResolver[] INSTANCES = new MyResolver[]{new MyResolver(false, false), new MyResolver(true, false)};
        private static final Pair<List<OCSymbol>, Boolean> EMPTY = new Pair(Collections.emptyList(), (Object)false);
        private static final Pair<List<OCSymbol>, Boolean> EMPTY_MAGIC = new Pair(Collections.emptyList(), (Object)true);

        public static MyResolver getInstance(boolean resolveOverloads) {
            return resolveOverloads ? INSTANCES[1] : INSTANCES[0];
        }

        private MyResolver(boolean resolveOverloads, boolean filterAmbigs, @NotNull OCResolveContext context) {
            this.myResolveOverloads = resolveOverloads;
            this.myFilterAmbigs = filterAmbigs;
            this.myContext = context;
        }

        private MyResolver(boolean resolveOverloads, boolean filterAmbigs) {
            this.myResolveOverloads = resolveOverloads;
            this.myFilterAmbigs = filterAmbigs;
        }

        @Override
        public Pair<List<OCSymbol>, Boolean> resolve(@NotNull OCOperatorReference reference, boolean incompleteCode) {
            return this.resolve(reference, this.myContext != null ? this.myContext : new OCResolveContext(reference.getElement()));
        }

        public Pair<List<OCSymbol>, Boolean> resolve(@NotNull OCOperatorReference reference, @NotNull OCResolveContext context) {
            if (reference.myArguments != null) {
                return this.resolveOperator(reference.mySign, reference.myPlacement, reference.myParamTypes, reference.myArguments, context, reference.getElement());
            }
            return Pair.create(this.doResolveOperator(reference.mySign, reference.myPlacement, reference.myParamTypes, null, context, reference.getElement()), (Object)false);
        }

        @NotNull
        private Pair<List<OCSymbol>, Boolean> resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @Nullable List<OCType> paramTypes, @NotNull List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context, @Nullable PsiElement localContext) {
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCTypeOwner> args = new ArrayList<OCTypeOwner>();
            boolean hasCppStructType = false;
            boolean wasNonLiteral = false;
            boolean hasMagicParameter = false;
            for (OCTypeOwner oCTypeOwner : arguments) {
                if (oCTypeOwner instanceof OCLiteralExpression || oCTypeOwner instanceof OCLiteralExpressionSymbol) continue;
                wasNonLiteral = true;
            }
            if (!wasNonLiteral) {
                return EMPTY;
            }
            for (int i = 0; i < arguments.size(); ++i) {
                OCType derefType;
                OCTypeOwner oCTypeOwner = arguments.get(i);
                OCType type = paramTypes != null && i < paramTypes.size() ? paramTypes.get(i).resolve(context) : oCTypeOwner.getResolvedType(context);
                args.add(oCTypeOwner);
                OCType oCType = derefType = type instanceof OCCppReferenceType ? ((OCCppReferenceType)type).getRefType() : type;
                if (derefType instanceof OCMagicType) {
                    hasMagicParameter = true;
                }
                if (derefType instanceof OCStructType && ((OCStructType)derefType).getKind() == OCSymbolKind.STRUCT) {
                    hasCppStructType = true;
                } else if (i == 0 && sign.equals("()")) {
                    return hasMagicParameter ? EMPTY_MAGIC : EMPTY;
                }
                types.add(type);
            }
            if (hasCppStructType) {
                List<OCSymbol> symbols = this.doResolveOperator(sign, placement, types, args, context, localContext);
                return symbols != Collections.emptyList() ? new Pair(symbols, (Object)hasMagicParameter) : EMPTY;
            }
            return hasMagicParameter ? EMPTY_MAGIC : EMPTY;
        }

        @NotNull
        private List<OCSymbol> doResolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<OCType> types, @Nullable List<OCTypeOwner> args, @NotNull OCResolveContext context, @Nullable PsiElement localContext) {
            String name = "operator" + sign;
            OCType leftType = types.get(0);
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
            if (leftType instanceof OCCppReferenceType) {
                leftType = ((OCCppReferenceType)leftType).getRefType();
            }
            if (leftType instanceof OCStructType) {
                List<OCSymbol> members = OCQualifiedExpressionImpl.getResolvedMembers((OCStructType)leftType, name, null, context, true);
                ContainerUtil.process((List)members, (Processor)collector);
            }
            if (localContext != null) {
                OCSymbolReference.getLocalReference(name, localContext).processPossibleSymbols((Processor<OCSymbol>)collector, context);
            }
            for (OCType type : types) {
                OCType terminalType = type.getTerminalType();
                if (!(terminalType instanceof OCStructType)) continue;
                OCSymbolWithQualifiedName parent = ((OCStructType)terminalType).getSymbol().getParent();
                OCSymbolReference.getGlobalReference(name, parent).processPossibleSymbols((Processor<OCSymbol>)collector, context);
            }
            Collection<OCSymbol> symbols = collector.getResults();
            if (args != null && args.get(0) instanceof OCExpression) {
                symbols = OCArgumentDepLookupAccumulator.doArgDepLookup(collector.getResults(), types, args, OCQualifiedName.with(name), context);
            }
            if (this.myResolveOverloads) {
                OCArgumentsList<OCTypeOwner> arguments = new OCArgumentsList<OCTypeOwner>(types, args);
                OCSymbol result = OCResolveOverloadsUtil.resolveOverloads(symbols, arguments, leftType.getCVQualifiers(), context, placement, true, true, this.myFilterAmbigs);
                if (result != null) {
                    return Collections.singletonList(result);
                }
                return Collections.emptyList();
            }
            return (List)collector.getResults();
        }
    }

    public static enum OperatorPlacement {
        PREFIX,
        INFIX,
        POSTFIX;

    }
}

