/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSelectorAdHocResolver {
    private static final Map<String, SelectorMethod> ourSelectorMethodsMap = new HashMap<String, SelectorMethod>();
    private static final SelectorMethod[] ourSelectorMethods;

    public static boolean isPerformSelectorMethod(String methodName) {
        return ourSelectorMethodsMap.containsKey(methodName) && methodName.startsWith("performSelector");
    }

    @Nullable
    public static OCObjectTypeContext getActionTargetContext(OCExpression selectorExpr) {
        OCObjectTypeContext targetContext;
        OCSendMessageExpression sendMessageExpr;
        OCMethodSymbol responder;
        OCExpression expression = OCParenthesesUtils.topmostParenthesized(selectorExpr);
        OCExpression target = null;
        if (expression.getParent() instanceof OCMessageArgument && (responder = (sendMessageExpr = (OCSendMessageExpression)expression.getParent().getParent()).getProbableResponders().getKnownResponder()) != null) {
            List<OCExpression> argumentExpressions;
            int targetIndex = OCSelectorAdHocResolver.getTargetParameterIndex(responder, expression.getContainingFile());
            if (targetIndex == 0) {
                target = sendMessageExpr.getReceiverExpression();
            } else if (targetIndex != -1 && targetIndex - 1 < (argumentExpressions = sendMessageExpr.getArgumentExpressions()).size()) {
                target = argumentExpressions.get(targetIndex - 1);
            }
        }
        if (target != null && (targetContext = target.getTypeContext(true, false)) != null && !targetContext.getType().getName().equals("NSObject")) {
            return targetContext;
        }
        return null;
    }

    private static int getTargetParameterIndex(@NotNull OCMethodSymbol method, PsiFile context) {
        OCType type;
        SelectorMethod selectorMethod = ourSelectorMethodsMap.get(method.getName());
        if (selectorMethod != null && (method.getParent() instanceof OCProtocolSymbol && selectorMethod.mySearchInProtocol ? (type = OCReferenceType.resolvedFromText("id", selectorMethod.myClassName, context)).isPointerToObject() && ((OCObjectType)type.getTerminalType()).implementsProtocol((OCProtocolSymbol)method.getParent()) : (type = OCReferenceType.resolvedFromText(selectorMethod.myClassName, context)) instanceof OCObjectType && ((OCClassSymbol)method.getParent()).isSubclass(((OCObjectType)type).getClassSymbol()))) {
            return selectorMethod.myTargetIndex;
        }
        return -1;
    }

    static {
        for (SelectorMethod method : ourSelectorMethods = new SelectorMethod[]{new SelectorMethod("CADisplayLink", "displayLinkWithTarget:selector:", 1), new SelectorMethod("NSArray", "makeObjectsPerformSelector:", -1), new SelectorMethod("NSArray", "makeObjectsPerformSelector:withObject:", -1), new SelectorMethod("NSArray", "sortedArrayUsingSelector:", -1), new SelectorMethod("NSAssertionHandler", "handleFailureInMethod:object:file:lineNumber:description:", -1), new SelectorMethod("NSComparisonPredicate", "customSelector", -1), new SelectorMethod("NSComparisonPredicate", "initWithLeftExpression:rightExpression:customSelector:", 1), new SelectorMethod("NSComparisonPredicate", "predicateWithLeftExpression:rightExpression:customSelector:", 1), new SelectorMethod("NSDecimalNumberBehaviors", "exceptionDuringOperation:error:leftOperand:rightOperand:", -1), new SelectorMethod("NSDictionary", "keysSortedByValueUsingSelector:", -1), new SelectorMethod("NSInvocation", "selector", -1), new SelectorMethod("NSInvocation", "setSelector:", -1), new SelectorMethod("NSInvocationOperation", "initWithTarget:selector:object:", 1), new SelectorMethod("NSMutableArray", "sortUsingSelector:", -1), new SelectorMethod("NSNotificationCenter", "addObserver:selector:name:object:", 1), new SelectorMethod("NSObject", "attemptRecoveryFromError:optionIndex:delegate:didRecoverSelector:contextInfo:", -1), new SelectorMethod("NSObject", "cancelPreviousPerformRequestsWithTarget:selector:object:", 1), new SelectorMethod("NSObject", "doesNotRecognizeSelector:", -1), new SelectorMethod("NSObject", "forwardingTargetForSelector:", -1), new SelectorMethod("NSObject", "instanceMethodForSelector:", 0), new SelectorMethod("NSObject", "instanceMethodSignatureForSelector:", 0), new SelectorMethod("NSObject", "instancesRespondToSelector:", 0), new SelectorMethod("NSObject", "methodForSelector:", 0), new SelectorMethod("NSObject", "methodSignatureForSelector:", 0), new SelectorMethod("NSObject", "performSelector:", 0, true), new SelectorMethod("NSObject", "performSelector:onThread:withObject:waitUntilDone:", 0), new SelectorMethod("NSObject", "performSelector:onThread:withObject:waitUntilDone:modes:", 0), new SelectorMethod("NSObject", "performSelector:withObject:", 0, true), new SelectorMethod("NSObject", "performSelector:withObject:afterDelay:", 0), new SelectorMethod("NSObject", "performSelector:withObject:afterDelay:inModes:", 0), new SelectorMethod("NSObject", "performSelector:withObject:withObject:", 0, true), new SelectorMethod("NSObject", "performSelectorInBackground:withObject:", 0), new SelectorMethod("NSObject", "performSelectorOnMainThread:withObject:waitUntilDone:", 0), new SelectorMethod("NSObject", "performSelectorOnMainThread:withObject:waitUntilDone:modes:", 0), new SelectorMethod("NSObject", "resolveClassMethod:", 0), new SelectorMethod("NSObject", "resolveInstanceMethod:", 0), new SelectorMethod("NSObject", "respondsToSelector:", 0, true), new SelectorMethod("NSRunLoop", "cancelPerformSelector:target:argument:", 2), new SelectorMethod("NSRunLoop", "performSelector:target:argument:order:modes:", 2), new SelectorMethod("NSSet", "makeObjectsPerformSelector:", -1), new SelectorMethod("NSSet", "makeObjectsPerformSelector:withObject:", -1), new SelectorMethod("NSSortDescriptor", "initWithKey:ascending:selector:", -1), new SelectorMethod("NSSortDescriptor", "selector", -1), new SelectorMethod("NSSortDescriptor", "sortDescriptorWithKey:ascending:selector:", -1), new SelectorMethod("NSThread", "detachNewThreadSelector:toTarget:withObject:", 2), new SelectorMethod("NSThread", "initWithTarget:selector:object:", 1), new SelectorMethod("NSTimer", "initWithFireDate:interval:target:selector:userInfo:repeats:", 3), new SelectorMethod("NSTimer", "scheduledTimerWithTimeInterval:target:selector:userInfo:repeats:", 2), new SelectorMethod("NSTimer", "timerWithTimeInterval:target:selector:userInfo:repeats:", 2), new SelectorMethod("NSUndoManager", "registerUndoWithTarget:selector:object:", 1), new SelectorMethod("SenTestCase", "afterTestIteration:selector:", 0), new SelectorMethod("SenTestCase", "beforeTestIteration:selector:", 0), new SelectorMethod("SenTestCase", "failureAction", -1), new SelectorMethod("SenTestCase", "initWithSelector:", 0), new SelectorMethod("SenTestCase", "numberOfTestIterationsForTestWithSelector:", -1), new SelectorMethod("SenTestCase", "selector", -1), new SelectorMethod("SenTestCase", "setFailureAction:", 0), new SelectorMethod("SenTestCase", "setUpTestWithSelector:", 0), new SelectorMethod("SenTestCase", "tearDownTestWithSelector:", 0), new SelectorMethod("SenTestCase", "testCaseWithSelector:", 0), new SelectorMethod("UIApplication", "sendAction:to:from:forEvent:", 2), new SelectorMethod("UIBarButtonItem", "initWithBarButtonSystemItem:target:action:", 2), new SelectorMethod("UIBarButtonItem", "initWithImage:landscapeImagePhone:style:target:action:", 3), new SelectorMethod("UIBarButtonItem", "initWithImage:style:target:action:", 3), new SelectorMethod("UIBarButtonItem", "initWithTitle:style:target:action:", 3), new SelectorMethod("UIControl", "addTarget:action:forControlEvents:", 1), new SelectorMethod("UIControl", "removeTarget:action:forControlEvents:", 1), new SelectorMethod("UIControl", "sendAction:to:forEvent:", 2), new SelectorMethod("UIDocumentInteractionControllerDelegate", "documentInteractionController:canPerformAction:", -1), new SelectorMethod("UIDocumentInteractionControllerDelegate", "documentInteractionController:performAction:", -1), new SelectorMethod("UIGestureRecognizer", "addTarget:action:", 1), new SelectorMethod("UIGestureRecognizer", "initWithTarget:action:", 1), new SelectorMethod("UIGestureRecognizer", "removeTarget:action:", 1), new SelectorMethod("UILocalizedIndexedCollation", "sectionForObject:collationStringSelector:", 1), new SelectorMethod("UILocalizedIndexedCollation", "sortedArrayFromArray:collationStringSelector:", -1), new SelectorMethod("UIMenuItem", "initWithTitle:action:", -1), new SelectorMethod("UIResponder", "canPerformAction:withSender:", -1), new SelectorMethod("UIScreen", "displayLinkWithTarget:selector:", 1), new SelectorMethod("UITableViewDelegate", "tableView:canPerformAction:forRowAtIndexPath:withSender:", -1), new SelectorMethod("UITableViewDelegate", "tableView:performAction:forRowAtIndexPath:withSender:", -1), new SelectorMethod("UIView", "setAnimationDidStopSelector:", -1), new SelectorMethod("UIView", "setAnimationWillStartSelector:", -1)}) {
            ourSelectorMethodsMap.put(method.myMethodSelector, method);
        }
    }

    private static class SelectorMethod {
        String myClassName;
        String myMethodSelector;
        int myTargetIndex;
        boolean mySearchInProtocol;

        private SelectorMethod(String className, String methodSelector, int targetIndex, boolean searchInProtocol) {
            this.myClassName = className;
            this.myMethodSelector = methodSelector;
            this.myTargetIndex = targetIndex;
            this.mySearchInProtocol = searchInProtocol;
        }

        private SelectorMethod(String className, String methodSelector, int targetIndex) {
            this(className, methodSelector, targetIndex, false);
        }
    }
}

