/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCLocalSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCNoexceptSpecifierImpl;
import com.jetbrains.cidr.lang.resolve.OCLocalDeclarationsVisitor;
import com.jetbrains.cidr.lang.resolve.OCTypeParameterSymbolResolver;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveUtil {
    public static Key<Boolean> DISABLE_LOCAL_SYMBOL_TABLE = Key.create((String)"DISABLE_LOCAL_SYMBOL_TABLE");
    private static List<Class<? extends OCLocalScopeable>> stopSet = Arrays.asList(OCFunctionDefinition.class, OCMethod.class);

    private OCResolveUtil() {
    }

    public static boolean isEarlierInCode(OCSymbol symbol, VirtualFile usageFile, int usageOffset) {
        return symbol.getContainingFile() == null || !Comparing.equal((Object)symbol.getContainingFile(), (Object)usageFile) || symbol.getOffset() <= usageOffset;
    }

    public static boolean isEarlierInCodeWithComplexOffset(OCSymbol symbol, VirtualFile usageFile, long usageComplexOffset) {
        return symbol.getContainingFile() == null || !Comparing.equal((Object)symbol.getContainingFile(), (Object)usageFile) || OCSymbolOffsetUtil.compare(symbol.getComplexOffset(), usageComplexOffset) <= 0;
    }

    public static boolean isInSameStructInCode(OCSymbol symbol, int usageOffset) {
        if (!(symbol instanceof OCSymbolWithQualifiedName)) {
            return false;
        }
        OCSymbolWithQualifiedName parent = ((OCSymbolWithQualifiedName)symbol).getParent();
        return parent instanceof OCStructSymbol && parent.getOffset() < usageOffset;
    }

    public static boolean isInSameStructInCode(OCSymbol symbol, PsiElement usage) {
        PsiFile usageContainingFile = usage.getContainingFile();
        return symbol.getContainingFile() == null || usageContainingFile == null || OCResolveUtil.isInSameStructInCode(symbol, usage.getTextOffset());
    }

    private static boolean isInSameObjCClass(OCSymbol symbol, @NotNull PsiFile file2, VirtualFile usageFile, int offset) {
        if (symbol.isGlobal() && Comparing.equal((Object)symbol.getContainingFile(), (Object)usageFile)) {
            OCClassDeclaration class1 = (OCClassDeclaration)PsiTreeUtil.getParentOfType(symbol.locateDefinition(), OCClassDeclaration.class);
            OCClassDeclaration class2 = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), OCClassDeclaration.class);
            return class1 != null && class1 == class2;
        }
        return false;
    }

    public static boolean isEarlierInCode(OCSymbol symbol, @Nullable PsiElement usage) {
        if (usage == null) {
            return true;
        }
        PsiFile usageContainingFile = usage.getContainingFile();
        return symbol.getContainingFile() == null || usageContainingFile == null || OCResolveUtil.isEarlierInCode(symbol, usageContainingFile.getVirtualFile(), usage.getTextOffset());
    }

    public static boolean isEarlierInCode(OCSymbol symbol, OCSymbol usage) {
        VirtualFile usageContainingFile = usage.getContainingFile();
        return symbol.getContainingFile() == null || usageContainingFile == null || OCResolveUtil.isEarlierInCode(symbol, usageContainingFile, usage.getOffset());
    }

    public static boolean isDisabledSymbol(OCSymbol symbol, @NotNull PsiFile context) {
        return symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).isForbiddenClang4ImplicitIvar(context);
    }

    public static boolean isSymbolAvailable(@NotNull OCSymbol symbolToCheck, @Nullable PsiElement contextElement) {
        return OCResolveUtil.checkAvailability(symbolToCheck, contextElement) == null;
    }

    @Nullable
    public static String checkAvailability(@NotNull OCSymbol symbol, @Nullable PsiElement contextElement) {
        if (contextElement == null) {
            return null;
        }
        OCResolveConfiguration configuration = OCInclusionContextUtil.getActiveConfiguration(contextElement);
        if (configuration != null) {
            for (OCAnnotatorHelper each : OCAnnotator.getAnnotatorHelpers()) {
                String unavailableMessage = each.checkAvailability(symbol, configuration);
                if (unavailableMessage == null) continue;
                return unavailableMessage;
            }
        }
        return null;
    }

    public static boolean isDependentCode(@NotNull OCQualifiedName name, @NotNull OCResolveContext context) {
        OCQualifiedName qualifier;
        if (name instanceof OCQualifiedNameWithArguments) {
            for (OCTypeArgument argument : ((OCQualifiedNameWithArguments)name).getArguments()) {
                OCType type;
                if (!(argument instanceof OCType) || !((type = context.getSubstitution().substitute(((OCType)argument).transformType(new OCTypeResolveVisitor(context)), context)) instanceof OCMagicType)) continue;
                return true;
            }
        }
        return (qualifier = name.getQualifier()) != null && OCResolveUtil.isDependentCode(qualifier, context);
    }

    public static boolean isDependentCode(OCExpression expression, @NotNull OCResolveContext context) {
        if (expression instanceof OCReferenceExpression) {
            OCReferenceElement refElement = ((OCReferenceExpression)expression).getReferenceElement();
            return OCResolveUtil.isDependentCode(refElement, context);
        }
        if (expression instanceof OCCallExpression) {
            OCExpression funExpr = ((OCCallExpression)expression).getFunctionReferenceExpression();
            if (funExpr.getResolvedType() instanceof OCMagicType || OCResolveUtil.isDependentCode(funExpr, context)) {
                return true;
            }
            for (OCExpression argument : ((OCCallExpression)expression).getArguments()) {
                if (!(argument.getResolvedType() instanceof OCMagicType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDependentCode(@Nullable OCReferenceElement refElement, @NotNull OCResolveContext context) {
        OCTypeArgumentList templateArgList;
        OCCppNamespaceQualifier namespaceQualifier = refElement != null ? refElement.getNamespaceQualifier() : null;
        OCTypeArgumentList oCTypeArgumentList = templateArgList = namespaceQualifier != null ? namespaceQualifier.getTemplateArgumentList() : null;
        if (templateArgList != null) {
            for (OCElement argument : templateArgList.getArguments()) {
                OCType type;
                if (!(argument instanceof OCTypeElement) || !((type = context.getSubstitution().substitute(((OCTypeElement)argument).getType(), context).transformType(new OCTypeResolveVisitor(context))) instanceof OCMagicType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNonResolvedTemplateParameters(OCSymbolWithSubstitution symbol, @NotNull OCResolveContext context) {
        OCSymbol<Object> parent = (OCSymbol)((Object)symbol);
        while (parent instanceof OCSymbolWithParent) {
            if (parent instanceof OCTemplateSymbol) {
                for (OCTypeParameterSymbol param : ((OCTemplateSymbol)parent).getTemplateParameters()) {
                    OCTypeArgument argument = symbol.getSubstitution().getSubstitutionFor(param);
                    if (argument != null && (!(argument instanceof OCType) || !((OCType)argument).isMagicInside(context))) continue;
                    return true;
                }
            }
            parent = ((OCSymbolWithParent)parent).getParent();
        }
        return false;
    }

    public static boolean processSymbols(@Nullable String name, @NotNull PsiElement context, @NotNull Processor<OCSymbol> processor2) {
        OCSymbolReference.LocalReference reference = OCSymbolReference.getLocalReference(OCQualifiedName.with(name), context);
        return reference.processPossibleSymbols(processor2, context.getContainingFile());
    }

    public static boolean processLocalAndMemberSymbols(@Nullable String name, @NotNull PsiElement context, @NotNull Processor<OCSymbol> processor2) {
        if (!OCResolveUtil.processLocalSymbols(name, context, processor2)) {
            return true;
        }
        return !OCResolveUtil.processMemberSymbols(name, context, processor2);
    }

    public static boolean processLocalAndMemberSymbols(@Nullable String name, @NotNull PsiElement context, @NotNull Processor<OCSymbol> processor2, @NotNull OCResolveContext resolveContext) {
        if (!OCResolveUtil.processLocalSymbols(name, context, processor2, resolveContext)) {
            return true;
        }
        return !OCResolveUtil.processMemberSymbols(name, context, processor2);
    }

    public static boolean processGlobalSymbols(@Nullable String name, @NotNull PsiElement context, @NotNull Processor<OCSymbol> processor2) {
        OCFile file2 = (OCFile)context.getContainingFile();
        return OCResolveUtil.processGlobalSymbols(name, context, file2, context.getTextRange().getEndOffset(), processor2);
    }

    public static boolean processGlobalSymbols(@Nullable String name, @Nullable PsiElement context, OCFile file2, int textOffset, Processor<OCSymbol> processor2) {
        PsiElement context1;
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(new ResolveFilteringProcessor<OCSymbol>(processor2, file2, textOffset, false), new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                return !symbol.isPredeclaration();
            }
        }, Conditions.alwaysTrue());
        if (name != null) {
            OCSymbolKind kind;
            OCType builtInType;
            if (name.startsWith("__builtin")) {
                builtInType = OCUnknownType.INSTANCE;
                kind = OCSymbolKind.BUILTIN_SYMBOL;
            } else if (name.equals("_cmd") && PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCMethod.class}) != null) {
                builtInType = OCReferenceType.fromText("SEL");
                kind = OCSymbolKind.PARAMETER;
            } else {
                builtInType = null;
                kind = OCSymbolKind.BUILTIN_SYMBOL;
            }
            if (builtInType != null) {
                orderedProcessor.process(new OCDeclaratorSymbol(file2.getProject(), null, textOffset, null, name, Collections.emptyList(), builtInType, kind));
                return orderedProcessor.finish();
            }
        }
        if ((context1 = file2.getContext()) != null) {
            return OCResolveUtil.processSymbols(name, context1, processor2);
        }
        OCStructType.processMembersOfNamespace(file2.getMembersContainer(false), name, true, false, orderedProcessor, new OCResolveContext(file2));
        return orderedProcessor.finish();
    }

    public static boolean processMemberSymbols(@Nullable String name, final PsiElement element, Processor<? super OCMemberSymbol> processor2) {
        OCObjectType type = OCResolveUtil.getContainingObjectType(element);
        if (type == null) {
            return true;
        }
        OCCommonProcessors.OrderedProcessor<? super OCMemberSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCMemberSymbol>(new ResolveFilteringProcessor<OCMemberSymbol>(processor2, element), new Condition<OCMemberSymbol>(){

            public boolean value(OCMemberSymbol symbol) {
                return symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() == null || symbol instanceof OCPropertySymbol && ((OCClassSymbol)symbol.getParent()).getCategoryName() == null;
            }
        }, new Condition<OCMemberSymbol>(){

            public boolean value(OCMemberSymbol symbol) {
                return symbol instanceof OCInstanceVariableSymbol && !((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar(element.getContainingFile()) || symbol instanceof OCPropertySymbol && "".equals(((OCClassSymbol)symbol.getParent()).getCategoryName());
            }
        }, Conditions.alwaysTrue());
        type.processMembers(name, OCMemberSymbol.class, orderedProcessor);
        return orderedProcessor.finish();
    }

    public static boolean processLocalSymbols(String name, PsiElement element, Processor<OCSymbol> processor2) {
        if (element == null) {
            return true;
        }
        return OCResolveUtil.processLocalSymbols(name, element, processor2, new OCResolveContext((PsiElement)element.getContainingFile()));
    }

    public static boolean processLocalSymbols(final @Nullable String name, PsiElement element, final Processor<OCSymbol> processor2, final @NotNull OCResolveContext context) {
        boolean result;
        final ResolveFilteringProcessor<OCSymbol> resolveProcessor = new ResolveFilteringProcessor<OCSymbol>(processor2, element);
        OCElement rootElement = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCFunctionDeclaration.class, OCMethod.class, OCParameterList.class});
        if (rootElement == null) {
            rootElement = (OCElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, OCBlockExpression.class);
        }
        if (rootElement == null) {
            rootElement = (OCElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, OCLambdaExpression.class);
        }
        if (rootElement == null) {
            return OCResolveUtil.processGenericAndTemplateSymbols(name, element, processor2, context);
        }
        OCFile containingFile = rootElement.getContainingOCFile();
        if (element.getParent() instanceof OCConstructorFieldInitializer) {
            return true;
        }
        if (name != null && element.getProject().getUserData(DISABLE_LOCAL_SYMBOL_TABLE) != Boolean.TRUE) {
            PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCTypeElement.class, OCNoexceptSpecifierImpl.class});
            Iterable<OCSymbol> localSymbols = OCFileSymbols.getLocalSymbols(containingFile, name);
            if (localSymbols != null && (parent == null || !(parent.getParent() instanceof OCDeclarator) && !(parent.getParent() instanceof OCLambdaExpression))) {
                if (!OCResolveUtil.processLocalSymbolsInTable(localSymbols, name, element, rootElement.getNode().getStartOffset(), resolveProcessor, context)) {
                    return false;
                }
                return OCResolveUtil.processGenericAndTemplateSymbols(name, element, processor2, context);
            }
        }
        if (result = OCResolveUtil.treeWalkUp(element, new Processor<OCLocalSymbolDeclarator>(){

            public boolean process(OCLocalSymbolDeclarator element) {
                Object symbol = element.getLocalSymbol();
                if (symbol == null) {
                    return true;
                }
                String symbolName = symbol.getName();
                if (symbol.isUnnamed()) {
                    return true;
                }
                if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                    for (OCSymbol namespace : context.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference())) {
                        if (!(namespace instanceof OCNamespaceSymbol) || OCStructType.processMembersOfNamespace((OCNamespaceSymbol)namespace, name, true, false, (Processor<OCSymbol>)processor2, context)) continue;
                        return false;
                    }
                    return true;
                }
                if (name != null && !symbolName.equals(name)) {
                    return true;
                }
                if (symbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL) {
                    return ContainerUtil.process(context.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference()), (Processor)processor2);
                }
                return resolveProcessor.process(symbol);
            }
        }, element.getParent() instanceof OCGotoStatement)) {
            return OCResolveUtil.processGenericAndTemplateSymbols(name, element, processor2, context);
        }
        return false;
    }

    static boolean processGenericAndTemplateSymbols(@Nullable String name, PsiElement element, Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        return OCTypeParameterSymbolResolver.processGenericSymbols(name, element, processor2, context) && OCTypeParameterSymbolResolver.processTemplateSymbols(name, element, processor2, context);
    }

    private static int getElementOffset(PsiElement element) {
        if (element instanceof OCLocalSymbolDeclarator) {
            Object symbol = ((OCLocalSymbolDeclarator)element).getLocalSymbol();
            if (symbol != null && symbol.getKind() == OCSymbolKind.PARAMETER && symbol.getScope() != null) {
                return symbol.getScope().getStartOffset();
            }
        } else {
            OCParameterList parameterList = (OCParameterList)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCParameterList.class});
            if (parameterList != null) {
                PsiElement parent = parameterList.getParent().getParent();
                if (parent instanceof OCFunctionDefinition) {
                    OCBlockStatement body = ((OCFunctionDefinition)parent).getBody();
                    return body != null ? body.getTextOffset() : parent.getTextOffset();
                }
                return parameterList.getTextOffset();
            }
        }
        return element.getTextOffset();
    }

    private static boolean processLocalSymbolsInTable(Iterable<OCSymbol> symbols, String name, PsiElement element, int rootElementOffset, Processor<OCSymbol> processor2, OCResolveContext context) {
        int elementOffset = OCResolveUtil.getElementOffset(element);
        if (symbols instanceof Set) {
            assert (((Set)symbols).size() == 1);
            OCSymbol symbol = symbols.iterator().next();
            if (symbol.getScope().containsOffset(elementOffset)) {
                return processor2.process((Object)symbol);
            }
        } else if (symbols instanceof List) {
            OCSymbol symbol;
            List list = (List)symbols;
            int index = OCResolveUtil.findNearest(elementOffset, list);
            ListIterator itr = list.listIterator(-index - 1);
            while (itr.hasPrevious() && (symbol = (OCSymbol)itr.previous()).getScope().getEndOffset() >= rootElementOffset) {
                if (!symbol.getScope().containsOffset(elementOffset)) continue;
                if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                    for (OCSymbol namespace : context.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference())) {
                        if (!(namespace instanceof OCNamespaceSymbol) || OCStructType.processMembersOfNamespace((OCNamespaceSymbol)namespace, name, true, false, processor2, context)) continue;
                        return false;
                    }
                    continue;
                }
                if (symbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL) {
                    return ContainerUtil.process(context.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference()), processor2);
                }
                if (processor2.process((Object)symbol)) continue;
                return false;
            }
        } else assert (symbols == null);
        return true;
    }

    public static int findNearest(final int elementOffset, @NotNull List<? extends OCSymbol> list) {
        return Collections.binarySearch(list, null, new Comparator<OCSymbol>(){

            @Override
            public int compare(OCSymbol symbol1, OCSymbol symbol2) {
                int offset2;
                int offset1 = symbol1 != null ? symbol1.getScope().getStartOffset() : elementOffset;
                int n = offset2 = symbol2 != null ? symbol2.getScope().getStartOffset() : elementOffset;
                if (offset1 == offset2) {
                    if (symbol1 == null) {
                        ++offset1;
                    } else if (symbol2 == null) {
                        ++offset2;
                    }
                }
                return offset1 - offset2;
            }
        });
    }

    private static boolean treeWalkUp(PsiElement place, Processor<OCLocalSymbolDeclarator> processor2, boolean stepIntoBlocks) {
        PsiElement lastParent = null;
        for (PsiElement run = place; run != null; run = run.getContext()) {
            OCLocalDeclarationsVisitor visitor = new OCLocalDeclarationsVisitor(processor2, lastParent, stepIntoBlocks);
            run.accept((PsiElementVisitor)visitor);
            if (!visitor.getResult()) {
                return false;
            }
            Class<?> runClass = run.getClass();
            for (Class<? extends OCLocalScopeable> clazz : stopSet) {
                if (!clazz.isAssignableFrom(runClass)) continue;
                return true;
            }
            if ((runClass.equals(OCBlockExpression.class) || runClass.equals(OCLambdaExpression.class) || runClass.equals(OCFunctionDeclaration.class)) && PsiTreeUtil.getContextOfType((PsiElement)run.getContext(), (Class[])new Class[]{OCCallable.class}) == null) {
                return true;
            }
            lastParent = run;
        }
        return true;
    }

    @Nullable
    private static OCObjectType getContainingObjectType(PsiElement element) {
        OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{OCInterface.class, OCImplementation.class, OCProtocol.class});
        return clazz != null ? clazz.getType() : null;
    }

    public static boolean isDuplicate(OCSymbolKind kind1, OCSymbolKind kind2) {
        if (kind1 == OCSymbolKind.METHOD || kind2 == OCSymbolKind.METHOD || kind1 == OCSymbolKind.PROPERTY || kind2 == OCSymbolKind.PROPERTY || kind1 == OCSymbolKind.SYNTHESIZE || kind2 == OCSymbolKind.SYNTHESIZE) {
            return kind1 == kind2;
        }
        if (kind1.isClass() != kind2.isClass()) {
            return false;
        }
        if (kind1.isStructLike() != kind2.isStructLike()) {
            return false;
        }
        if (kind1 == OCSymbolKind.PROTOCOL != (kind2 == OCSymbolKind.PROTOCOL)) {
            return false;
        }
        if (kind1 == OCSymbolKind.PARAMETER && (kind2.isGlobalVariable() || kind2.isFunction())) {
            return false;
        }
        return kind2 != OCSymbolKind.PARAMETER || !kind1.isGlobalVariable() && !kind1.isFunction();
    }

    public static boolean isDuplicate(OCSymbol symbol, OCSymbol duplicate) {
        if (symbol.equals(duplicate)) {
            return false;
        }
        if (!OCResolveUtil.isEarlierInCodeWithComplexOffset(symbol, duplicate.getContainingFile(), duplicate.getComplexOffset())) {
            return false;
        }
        if ((!symbol.getClass().equals(duplicate.getClass()) || symbol.isPredeclaration() != duplicate.isPredeclaration()) && (!symbol.isGlobal() || !duplicate.isGlobal() || symbol instanceof OCClassSymbol && duplicate instanceof OCClassSymbol || symbol.getKind().isTemplateParameter() || duplicate.getKind().isTemplateParameter())) {
            return false;
        }
        if (symbol.getKind() == OCSymbolKind.PROTOCOL != (duplicate.getKind() == OCSymbolKind.PROTOCOL)) {
            return false;
        }
        if (symbol instanceof OCClassSymbol && duplicate instanceof OCClassSymbol && (!Comparing.equal((String)((OCClassSymbol)symbol).getCategoryName(), (String)((OCClassSymbol)duplicate).getCategoryName()) || "".equals(((OCClassSymbol)symbol).getCategoryName()))) {
            return false;
        }
        if (symbol instanceof OCMemberSymbol && duplicate instanceof OCMemberSymbol && !((OCClassSymbol)((OCMemberSymbol)symbol).getParent()).equals(((OCMemberSymbol)duplicate).getParent())) {
            return false;
        }
        if (symbol instanceof OCDeclaratorSymbol && duplicate instanceof OCDeclaratorSymbol && !Comparing.equal((Object)symbol.getScope(), (Object)duplicate.getScope())) {
            return false;
        }
        if (symbol instanceof OCMethodSymbol && duplicate instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).isStatic() != ((OCMethodSymbol)duplicate).isStatic()) {
            return false;
        }
        if (symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).getGeneratedFromProperty() != null || duplicate instanceof OCMethodSymbol && ((OCMethodSymbol)duplicate).getGeneratedFromProperty() != null) {
            return false;
        }
        if ((symbol instanceof OCMethodSymbol && duplicate instanceof OCPropertySymbol || symbol instanceof OCPropertySymbol && duplicate instanceof OCMethodSymbol) && symbol.getName().equals(duplicate.getName())) {
            return false;
        }
        if (symbol instanceof OCMacroSymbol != duplicate instanceof OCMacroSymbol) {
            return false;
        }
        if (duplicate instanceof OCMacroSymbol && !Comparing.equal((Object)symbol.getContainingFile(), (Object)duplicate.getContainingFile())) {
            return false;
        }
        if (symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar()) {
            return false;
        }
        if (duplicate instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)duplicate).isClang4ImplicitIvar()) {
            return false;
        }
        OCFile file2 = symbol.getContainingOCFile();
        if (symbol instanceof OCSymbolWithQualifiedName && duplicate instanceof OCSymbolWithQualifiedName) {
            OCSymbolWithQualifiedName duplicateParent;
            OCSymbolWithQualifiedName parent;
            if (file2 != null && file2.isCpp() || symbol.hasAttribute("overloadable") || duplicate.hasAttribute("overloadable")) {
                if (!Comparing.equal((Object)((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(), (Object)((OCSymbolWithQualifiedName)duplicate).getResolvedQualifiedName())) {
                    return false;
                }
                if (symbol instanceof OCFunctionSymbol && duplicate instanceof OCFunctionSymbol && !OCTypeUtils.areSignaturesEqual((OCFunctionSymbol)symbol, (OCFunctionSymbol)duplicate, new OCResolveContext(file2), ((OCFunctionSymbol)symbol).isTemplateSymbol() || ((OCFunctionSymbol)duplicate).isTemplateSymbol())) {
                    return false;
                }
            } else if (!Comparing.equal((Object)((OCSymbolWithQualifiedName)symbol).getParent(), (Object)((OCSymbolWithQualifiedName)duplicate).getParent())) {
                return false;
            }
            if ((parent = ((OCSymbolWithQualifiedName)symbol).getParent()) != (duplicateParent = ((OCSymbolWithQualifiedName)duplicate).getParent()) && parent != null && duplicateParent != null && !parent.isPredeclaration() && parent.getKind().isStructLike() && !duplicateParent.isPredeclaration() && duplicateParent.getKind().isStructLike()) {
                return false;
            }
        }
        return !(symbol instanceof OCTemplateSymbol) || !(duplicate instanceof OCTemplateSymbol) || !(symbol instanceof OCFunctionSymbol) || ((OCTemplateSymbol)symbol).getTemplateParameters().isEmpty() == ((OCTemplateSymbol)duplicate).getTemplateParameters().isEmpty();
    }

    private static int findSymbolInList(List<? extends OCSymbol> symbols, final int offset) {
        int index = Collections.binarySearch(symbols, null, new Comparator<OCSymbol>(){

            @Override
            public int compare(OCSymbol o1, OCSymbol o2) {
                int offset1 = o1 == null ? offset : o1.getOffset();
                int offset2 = o2 == null ? offset : o2.getOffset();
                return offset1 - offset2;
            }
        });
        return index >= 0 ? index : -index - 1;
    }

    public static boolean processSymbolsFromList(Processor<OCSymbol> processor2, List<? extends OCSymbol> symbols, int afterOffset, int beforeOffset) {
        int endIdx;
        int startIdx = afterOffset == -1 ? 0 : OCResolveUtil.findSymbolInList(symbols, afterOffset == 0 ? 0 : afterOffset + 1);
        int n = endIdx = beforeOffset == -1 ? symbols.size() : OCResolveUtil.findSymbolInList(symbols, beforeOffset + 1);
        if (startIdx > 0 && symbols.get(startIdx - 1) instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)symbols.get(startIdx - 1)).getLastElementOffset() >= afterOffset) {
            --startIdx;
        }
        for (int i = startIdx; i < endIdx; ++i) {
            if (processor2.process((Object)symbols.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends OCSymbol> boolean processMap(Processor<? super T> processor2, @Nullable String name, MostlySingularMultiMap<String, T> map) {
        if (name != null) {
            return map.processForKey((Object)name, processor2);
        }
        return map.processAllValues(processor2);
    }

    @NotNull
    public static Collection<OCSymbol> resolveTemplateDeclarations(@NotNull OCNamespaceQualifierOwner element) {
        return OCSymbolReference.getLocalReference(element, OCSymbolReference.SymbolFilter.NONE).resolveToSymbols(false, false, false, new OCResolveContext(element));
    }

    public static class ResolveFilteringProcessor<T extends OCSymbol>
    implements Processor<T> {
        private Processor<? super T> myProcessor;
        private PsiFile myFile;
        private int myTextOffset;
        private final VirtualFile myVirtualFile;
        private boolean myIgnoringImports;

        public ResolveFilteringProcessor(Processor<? super T> processor2, @Nullable PsiFile file2, int textOffset, boolean isIgnoringImports) {
            this.myProcessor = processor2;
            this.myFile = file2;
            if (file2 instanceof OCCodeFragment) {
                PsiElement context = file2.getContext();
                if (context != null) {
                    file2 = context.getContainingFile();
                    this.myTextOffset = context.getTextOffset();
                }
            } else {
                this.myTextOffset = textOffset;
            }
            this.myVirtualFile = OCInclusionContextUtil.getVirtualFile(file2);
            this.myIgnoringImports = isIgnoringImports;
        }

        public ResolveFilteringProcessor(Processor<? super T> processor2, PsiElement context) {
            this(processor2, context.getContainingFile(), context.getTextOffset(), false);
        }

        public boolean process(T symbol) {
            if (symbol.getKind() == OCSymbolKind.LABEL || symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind().isStructLike() || symbol.getKind() == OCSymbolKind.PARAMETER || symbol.getKind() == OCSymbolKind.STRUCT_FIELD || symbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL || symbol.getKind() == OCSymbolKind.TEMPLATE_TYPE_PARAMETER || symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() != null || this.myIgnoringImports || OCResolveUtil.isInSameStructInCode(symbol, this.myTextOffset) || OCResolveUtil.isEarlierInCode(symbol, this.myVirtualFile, this.myTextOffset) || this.myFile != null && OCResolveUtil.isInSameObjCClass(symbol, this.myFile, this.myVirtualFile, this.myTextOffset)) {
                return this.myFile != null && OCResolveUtil.isDisabledSymbol(symbol, this.myFile) || this.myProcessor.process(symbol);
            }
            return true;
        }
    }
}

