/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.daemon.OCArgumentsChecker;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveOverloadsUtil {
    public static OCSymbol resolveOverloads(@Nullable OCStructType type, Collection<OCSymbol> cases, @NotNull OCArgumentsList<?> arguments, @Nullable CVQualifiers cvQualifiers, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, boolean allowImplicitConversions, boolean filterByParameters, boolean filterByTemplates, boolean filterAmbigs, boolean acceptOnlyCompatible, @NotNull OCResolveContext context) {
        if (type == null) {
            return (OCSymbol)OCResolveOverloadsUtil.resolveOverloads(cases, arguments, (CVQualifiers)cvQualifiers, (OCResolveContext)context, (OCOperatorReference.OperatorPlacement)operatorPlacement, (boolean)filterByParameters, (boolean)filterByTemplates, (boolean)filterAmbigs, (boolean)allowImplicitConversions, (boolean)false).first;
        }
        OCSymbol<PsiElement> badResult = type.getSymbol();
        cases = new LinkedHashSet<OCSymbol>(cases);
        List<?> argExprs = arguments.getExprs();
        if (argExprs != null && argExprs.size() == 1 && argExprs.get(0) instanceof OCCompoundInitializer) {
            if (OCCodeInsightUtil.isInitializerListType(type, context.getFile())) {
                return type.getSymbol();
            }
            OCCompoundInitializer compInitializer = (OCCompoundInitializer)argExprs.get(0);
            arguments = OCArgumentsList.getArgumentList(compInitializer.getInitializerExpressions(), context);
            ArrayList<OCSymbol> ctorsWithInitList = new ArrayList<OCSymbol>();
            OCSymbol result = OCResolveOverloadsUtil.findCtorWithInitializerList(type, arguments, ctorsWithInitList, context.getFile(), allowImplicitConversions);
            cases.removeAll(ctorsWithInitList);
            if (result != null) {
                return result;
            }
            if (ctorsWithInitList.size() == 1) {
                badResult = (OCSymbol)ctorsWithInitList.get(0);
            }
            if (!allowImplicitConversions) {
                return badResult;
            }
        }
        if (badResult instanceof OCFunctionSymbol || arguments.getCount() == 1 && type.checkCompatible(arguments.getTypes().get(0), null, context.getElement(), allowImplicitConversions, true, context).getState() == OCType.TypeCheckState.OK) {
            filterAmbigs = true;
            filterByTemplates = true;
            filterByParameters = true;
        }
        if (type.isMagicInside(context)) {
            filterAmbigs = false;
        }
        Pair<OCSymbol, ParamFitness> pair = OCResolveOverloadsUtil.resolveOverloads(cases, arguments, cvQualifiers, context, operatorPlacement, filterByParameters, filterByTemplates, filterAmbigs, allowImplicitConversions, type.isMagicInside(context));
        return pair.first != null && ((ParamFitness)((Object)pair.second)).ordinal() <= ParamFitness.okWithConversion.ordinal() || acceptOnlyCompatible ? (OCSymbol)pair.first : badResult;
    }

    @Nullable
    public static OCSymbol resolveOverloads(@NotNull Collection<OCSymbol> cases, @NotNull OCArgumentsList<?> arguments, @Nullable CVQualifiers cvQualifiers, @NotNull OCResolveContext context, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, boolean filterByParameters, boolean filterByTemplates, boolean filterAmbigs) {
        return (OCSymbol)OCResolveOverloadsUtil.resolveOverloads(cases, arguments, (CVQualifiers)cvQualifiers, (OCResolveContext)context, (OCOperatorReference.OperatorPlacement)operatorPlacement, (boolean)filterByParameters, (boolean)filterByTemplates, (boolean)filterAmbigs, (boolean)true, (boolean)false).first;
    }

    @NotNull
    public static Pair<OCSymbol, ParamFitness> resolveOverloads(@NotNull Collection<OCSymbol> cases, @NotNull OCArgumentsList<?> arguments, @Nullable CVQualifiers cvQualifiers, @NotNull OCResolveContext context, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, boolean filterByParameters, boolean filterByTemplates, boolean filterAmbigs, boolean allowImplicitConversions, boolean hasMagic) {
        List<OCSymbol> filtered = OCResolveOverloadsUtil.resolveTemplateSpecializations(cases, arguments, cvQualifiers, operatorPlacement, filterByTemplates, allowImplicitConversions, context);
        if (!(filterByParameters |= context.isInSFINAE())) {
            if (filtered.size() == 1) {
                return Pair.create((Object)ContainerUtil.getFirstItem(filtered), (Object)((Object)ParamFitness.ok));
            }
            if (filtered.size() == 0) {
                return Pair.create((Object)(filterByTemplates ? null : OCResolveOverloadsUtil.filterPredeclarations(cases)), (Object)((Object)ParamFitness.ok));
            }
        }
        ArrayList<Overload> overloads = new ArrayList<Overload>(cases.size());
        PsiElement psiContext = context.getElement();
        for (OCSymbol symbol : filtered) {
            List<Object> paramTypes;
            boolean magic = false;
            ParamFitness fitness = ParamFitness.ok;
            int price = 0;
            if (symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol function = (OCFunctionSymbol)symbol;
                paramTypes = OCResolveOverloadsUtil.getParameterTypes((OCFunctionSymbol)function, (OCOperatorReference.OperatorPlacement)operatorPlacement, (OCResolveContext)context, (CVQualifiers)cvQualifiers).types;
                if (cvQualifiers != null && (cvQualifiers.isConst() || cvQualifiers.isVolatile()) && !function.isStatic() && function.getResolvedOwner(context, false) instanceof OCStructSymbol && !function.getKind().isConstructorOrDestructor()) {
                    if (cvQualifiers.isConst() && !function.isConst()) {
                        fitness = ParamFitness.error;
                    }
                    if (cvQualifiers.isVolatile() && !function.isVolatile()) {
                        fitness = ParamFitness.error;
                    }
                }
            } else {
                paramTypes = symbol instanceof OCStructSymbol ? Collections.singletonList(((OCStructSymbol)symbol).getType()) : Collections.emptyList();
            }
            for (int i = 0; i < Math.min(arguments.getCount(), paramTypes.size()); ++i) {
                OCTypeOwner argExpression;
                OCType declType = ((OCType)paramTypes.get(i)).resolve(context);
                OCType actualType = arguments.getTypes().get(i);
                OCTypeOwner oCTypeOwner = argExpression = arguments.getExprs() != null ? (OCTypeOwner)arguments.getExprs().get(i) : null;
                if (declType instanceof OCEllipsisType) {
                    fitness = ParamFitness.ellipsis;
                    price = -i;
                    break;
                }
                OCType.TypeCheckResult result = declType.checkCompatible(actualType, argExpression, psiContext, allowImplicitConversions, false, context);
                OCType.TypeCheckState state = result.getState();
                if (state.isError(context.getElement())) {
                    fitness = ParamFitness.error;
                } else if (fitness != ParamFitness.error && state != OCType.TypeCheckState.OK && result.getInspectionClass() != OCInspections.SignednessMismatch.class) {
                    fitness = ParamFitness.warning;
                } else if (fitness != ParamFitness.error && fitness != ParamFitness.warning && result.isWithConversion()) {
                    fitness = ParamFitness.okWithConversion;
                    if (!result.getTypeAfterConversion().isUnknown() && !result.getTypeAfterConversion().isMagicInside(context)) {
                        actualType = result.getTypeAfterConversion();
                    }
                }
                if ((declType.isUnknown() || declType.isMagicInside(context)) && declType.getGuessedUnmagicType().checkCompatible(actualType, null, psiContext, allowImplicitConversions, false, context).getState() != OCType.TypeCheckState.OK) {
                    ++price;
                }
                if (actualType.isUnknown() || actualType.isMagicInside(context)) {
                    magic = true;
                }
                if (actualType.getTerminalType() instanceof OCMagicType || declType.getTerminalType() instanceof OCMagicType) continue;
                if (declType instanceof OCCppReferenceType && ((OCCppReferenceType)declType).isRvalueRef()) {
                    --price;
                }
                actualType = actualType instanceof OCCppReferenceType && !(declType instanceof OCCppReferenceType) ? ((OCCppReferenceType)actualType).getRefType() : actualType;
                declType = declType instanceof OCCppReferenceType && !(actualType instanceof OCCppReferenceType) ? ((OCCppReferenceType)declType).getRefType() : declType;
                price += OCTypeCompatibilityVisitor.getTypesDifference(declType, actualType, context);
            }
            if (("operator++".equals(symbol.getName()) || "operator--".equals(symbol.getName())) && (operatorPlacement == OCOperatorReference.OperatorPlacement.POSTFIX && paramTypes.size() == arguments.getCount() || operatorPlacement == OCOperatorReference.OperatorPlacement.PREFIX && paramTypes.size() == arguments.getCount() + 1)) {
                fitness = ParamFitness.error;
            }
            if (fitness == ParamFitness.error) continue;
            overloads.add(new Overload(fitness, price, symbol));
            hasMagic |= magic;
        }
        Collections.sort(overloads);
        List<OCSymbol> result = new ArrayList<OCSymbol>();
        Overload prev = null;
        ParamFitness bestFitness = null;
        for (Overload overload : overloads) {
            if (prev != null && (!hasMagic && prev.compareTo(overload) != 0 || hasMagic && prev.myFitness.ordinal() <= ParamFitness.warning.ordinal() && overload.myFitness.ordinal() > ParamFitness.warning.ordinal())) break;
            result.add(overload.mySymbol);
            prev = overload;
            bestFitness = overload.myFitness;
        }
        if (result.size() == 1) {
            return Pair.create(result.get(0), bestFitness);
        }
        if (!hasMagic) {
            result = OCResolveOverloadsUtil.filterCVFunctions(result, context);
        }
        if (result.size() > 1) {
            result = OCResolveOverloadsUtil.filterSpecializations(result);
        }
        if (result.size() == 1) {
            return Pair.create((Object)result.get(0), (Object)((Object)bestFitness));
        }
        if (result.size() > 1) {
            return Pair.create((Object)OCResolveOverloadsUtil.filterPredeclarations(result, operatorPlacement, cvQualifiers, context, filterAmbigs && !hasMagic), (Object)((Object)bestFitness));
        }
        if (filterByParameters) {
            return Pair.create(null, (Object)((Object)ParamFitness.ok));
        }
        if (filtered.size() > 1) {
            return Pair.create((Object)OCResolveOverloadsUtil.filterPredeclarations(filtered, operatorPlacement, cvQualifiers, context, filterAmbigs && !hasMagic), (Object)((Object)ParamFitness.ok));
        }
        return Pair.create((Object)ContainerUtil.getFirstItem(filtered), (Object)((Object)ParamFitness.ok));
    }

    @NotNull
    private static TypesAndNames getParameterTypes(OCFunctionSymbol function, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @NotNull OCResolveContext context, @Nullable CVQualifiers cvQualifiers) {
        OCFunctionType functionType = function.getType();
        List<OCType> paramTypes = functionType.getParameterTypes();
        List<String> paramNames = functionType.getParameterNames();
        paramTypes = OCArgumentsList.expandVariadicTypes(paramTypes, context);
        if (paramNames != null && paramNames.size() != paramTypes.size()) {
            paramNames = null;
        }
        if (OCResolveOverloadsUtil.needsPseudoParamAdded(function, operatorPlacement, context)) {
            ArrayList<OCType> newParamTypes = new ArrayList<OCType>(paramTypes.size() + 1);
            OCStructType objectType = ((OCStructSymbol)function.getResolvedOwner(context, false)).getType();
            if (cvQualifiers != null) {
                objectType = (OCStructType)objectType.cloneWithAddedCVQualifiers(cvQualifiers, context.getProject());
            }
            newParamTypes.add(objectType);
            newParamTypes.addAll(paramTypes);
            paramTypes = newParamTypes;
            if (paramNames != null) {
                ArrayList<String> newParamNames = new ArrayList<String>(paramTypes.size() + 1);
                newParamNames.add("<unnamed>");
                newParamNames.addAll(paramNames);
                paramNames = newParamNames;
            }
        }
        return new TypesAndNames(paramTypes, paramNames);
    }

    private static boolean needsPseudoParamAdded(OCFunctionSymbol function, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @NotNull OCResolveContext context) {
        return operatorPlacement != null && function.isCppMemberOperator(context);
    }

    private static int getNonInitializedParametersCount(OCFunctionSymbol function, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @NotNull OCResolveContext context) {
        int parametersCount = function.getNonInitializedParametersCount(context);
        if (OCResolveOverloadsUtil.needsPseudoParamAdded(function, operatorPlacement, context)) {
            ++parametersCount;
        }
        return parametersCount;
    }

    private static List<OCSymbol> filterCVFunctions(@NotNull List<OCSymbol> cases, @NotNull OCResolveContext context) {
        ArrayList<OCSymbol> result = new ArrayList<OCSymbol>(cases.size());
        int bestCVCount = -1;
        for (OCSymbol symbol : cases) {
            if (!(symbol instanceof OCFunctionSymbol)) continue;
            OCType symbolType = symbol.getType();
            int CVQualifiersCnt = (symbolType.isConst() ? 1 : 0) + (symbolType.isVolatile() ? 1 : 0);
            for (OCDeclaratorSymbol paramSymbol : ((OCFunctionSymbol)symbol).getParameterSymbols(context)) {
                OCType type = paramSymbol.getType();
                if (type instanceof OCCppReferenceType) {
                    type = ((OCCppReferenceType)type).getRefType();
                }
                if (type.isConst()) {
                    ++CVQualifiersCnt;
                }
                if (!type.isVolatile()) continue;
                ++CVQualifiersCnt;
            }
            if (bestCVCount == -1) {
                bestCVCount = CVQualifiersCnt;
            }
            if (CVQualifiersCnt < bestCVCount) {
                bestCVCount = CVQualifiersCnt;
                result.clear();
            }
            if (CVQualifiersCnt != bestCVCount) continue;
            result.add(symbol);
        }
        if (result.isEmpty()) {
            return cases;
        }
        return result;
    }

    private static List<OCSymbol> filterSpecializations(List<OCSymbol> cases) {
        ArrayList<OCSymbol> specializations = new ArrayList<OCSymbol>();
        for (OCSymbol symbol : cases) {
            if (!(symbol instanceof OCTemplateSymbol) || ((OCTemplateSymbol)symbol).getTemplateSpecialization() == null) continue;
            specializations.add(symbol);
        }
        return specializations.isEmpty() ? cases : specializations;
    }

    private static OCSymbol filterPredeclarations(Collection<OCSymbol> cases) {
        for (OCSymbol symbol : cases) {
            if (!(symbol instanceof OCFunctionSymbol) || symbol.isPredeclaration()) continue;
            return symbol;
        }
        for (OCSymbol symbol : cases) {
            if (symbol.isPredeclaration()) continue;
            return symbol;
        }
        Iterator<OCSymbol> iterator = cases.iterator();
        if (iterator.hasNext()) {
            OCSymbol symbol;
            symbol = iterator.next();
            return symbol;
        }
        return null;
    }

    private static OCSymbol filterPredeclarations(List<OCSymbol> symbols, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @Nullable CVQualifiers cvQualifiers, @NotNull OCResolveContext context, boolean filterAmbigs) {
        ArrayList<OCFunctionSymbol> filtered = new ArrayList<OCFunctionSymbol>(symbols.size());
        boolean differentPredeclaredTypes = false;
        boolean differentPredeclaredReturnTypes = false;
        boolean differentDeclaredTypes = false;
        boolean differentDeclaredReturnTypes = false;
        OCFunctionType firstPredeclaredType = null;
        OCType firstPredeclaredReturnType = null;
        OCFunctionType firstDeclaredType = null;
        OCType firstDeclaredReturnType = null;
        OCSymbol implicitConstructorDef = null;
        OCSymbol implicitConstructorPredef = null;
        Collections.sort(symbols, new Comparator<OCSymbol>(){

            @Override
            public int compare(OCSymbol f1, OCSymbol f2) {
                return OCSymbolOffsetUtil.compare(f1.getComplexOffset(), f2.getComplexOffset());
            }
        });
        Collections.sort(symbols, new Comparator<OCSymbol>(){

            private int rank(OCSymbol symbol) {
                return symbol.isPredeclaration() ? 1 : 0;
            }

            @Override
            public int compare(OCSymbol f1, OCSymbol f2) {
                return this.rank(f1) - this.rank(f2);
            }
        });
        for (OCSymbol symbol : symbols) {
            if (!(symbol instanceof OCFunctionSymbol)) {
                if (symbol.isPredeclaration()) {
                    implicitConstructorPredef = symbol;
                    continue;
                }
                implicitConstructorDef = symbol;
                continue;
            }
            OCFunctionSymbol function = (OCFunctionSymbol)symbol;
            OCFunctionType functionType = function.getType();
            TypesAndNames typesAndNames = OCResolveOverloadsUtil.getParameterTypes(function, operatorPlacement, context, cvQualifiers);
            functionType = new OCFunctionType(functionType.getReturnType(), typesAndNames.types, typesAndNames.names, functionType.isConst(), functionType.isVolatile());
            OCType returnType = functionType.getReturnType().resolve(context);
            if (!function.isPredeclaration()) {
                filtered.add(function);
                if (firstDeclaredType == null) {
                    firstDeclaredType = functionType;
                    firstDeclaredReturnType = returnType;
                    continue;
                }
                differentDeclaredTypes |= !functionType.equalsAfterResolving(firstDeclaredType, (PsiElement)context.getFile());
                differentDeclaredReturnTypes |= !returnType.equalsAfterResolving(firstDeclaredReturnType, (PsiElement)context.getFile());
                continue;
            }
            if (firstDeclaredType == null) {
                if (firstPredeclaredType == null) {
                    firstPredeclaredType = functionType;
                    firstPredeclaredReturnType = returnType;
                    continue;
                }
                differentPredeclaredTypes |= !functionType.equalsAfterResolving(firstPredeclaredType, (PsiElement)context.getFile());
                differentPredeclaredReturnTypes |= !returnType.equalsAfterResolving(firstPredeclaredReturnType, (PsiElement)context.getFile());
                continue;
            }
            if (differentDeclaredTypes) continue;
            differentDeclaredTypes = !functionType.equalsAfterResolving(firstDeclaredType, (PsiElement)context.getFile());
            differentDeclaredReturnTypes = !returnType.equalsAfterResolving(firstDeclaredReturnType, (PsiElement)context.getFile());
        }
        if (filtered.size() == 1 && !differentDeclaredTypes) {
            return (OCSymbol)filtered.get(0);
        }
        if (filtered.size() >= 1) {
            if (differentDeclaredTypes) {
                return filterAmbigs ? null : new OCFunctionGroupSymbol(filtered, differentDeclaredReturnTypes ? null : firstDeclaredReturnType);
            }
            return (OCSymbol)ContainerUtil.getFirstItem(filtered);
        }
        if (implicitConstructorDef != null) {
            return implicitConstructorDef;
        }
        if (implicitConstructorPredef != null) {
            return implicitConstructorPredef;
        }
        if (differentPredeclaredTypes) {
            return filterAmbigs ? null : new OCFunctionGroupSymbol(ContainerUtil.map(symbols, (Function)new Function<OCSymbol, OCFunctionSymbol>(){

                public OCFunctionSymbol fun(OCSymbol symbol) {
                    return (OCFunctionSymbol)symbol;
                }
            }), differentPredeclaredReturnTypes ? null : firstPredeclaredReturnType);
        }
        return (OCSymbol)ContainerUtil.getFirstItem(symbols);
    }

    private static OCSymbol findCtorWithInitializerList(OCStructType clazz, final @NotNull OCArgumentsList<?> arguments, final Collection<OCSymbol> allCandidates, final @Nullable PsiFile file2, final boolean implicitCtors) {
        final Ref result = new Ref();
        final OCResolveContext context = new OCResolveContext((PsiElement)file2);
        clazz.processMembers(clazz.getSymbol().getName(), new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                OCFunctionSymbol function;
                if (symbol instanceof OCFunctionSymbol && (function = (OCFunctionSymbol)symbol).isCppConstructor() && function.getNonInitializedParametersCount(context) == 1) {
                    OCType paramType = function.getParameterSymbols().get(0).getType().resolve(file2);
                    if (paramType instanceof OCCppReferenceType) {
                        paramType = ((OCCppReferenceType)paramType).getRefType();
                    }
                    if (paramType instanceof OCStructType) {
                        OCStructSymbol paramTypeSymbol = ((OCStructType)paramType).getSymbol();
                        List<OCTypeParameterSymbol> parameters = paramTypeSymbol.getTemplateParameters();
                        if (OCCodeInsightUtil.isInitializerListType(paramType, file2) && parameters.size() == 1) {
                            allCandidates.add(function);
                            OCTypeArgument paramSubstitution = paramTypeSymbol.getSubstitution().getSubstitutionFor(parameters.get(0));
                            if (paramSubstitution instanceof OCType) {
                                boolean isCompatible = true;
                                for (int i = 0; i < arguments.getExprs().size(); ++i) {
                                    OCTypeOwner expr = (OCTypeOwner)arguments.getExprs().get(i);
                                    OCType type = arguments.getTypes().get(i);
                                    isCompatible &= ((OCType)paramSubstitution).isCompatible(type, expr, (PsiElement)file2);
                                }
                                if (isCompatible) {
                                    result.set((Object)function);
                                    return false;
                                }
                            }
                        }
                        if (implicitCtors && OCResolveOverloadsUtil.findCtorWithInitializerList((OCStructType)paramType, arguments, new ArrayList(), file2, false) != null) {
                            result.set((Object)function);
                            return false;
                        }
                    }
                }
                return true;
            }
        }, context);
        return (OCSymbol)result.get();
    }

    private static <E extends OCTypeOwner> List<OCSymbol> resolveTemplateSpecializations(@NotNull Collection<OCSymbol> symbols, @NotNull OCArgumentsList<E> arguments, @Nullable CVQualifiers cvQualifiers, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, boolean acceptOnlyCompatible, boolean allowImplicitConversions, final @NotNull OCResolveContext context) {
        ArrayList<OCSymbol> unified = new ArrayList<OCSymbol>();
        ArrayList<OCSymbol> allSymbols = new ArrayList<OCSymbol>();
        int argumentsCount = arguments.getCount();
        for (OCSymbol symbol : symbols) {
            HashMap substitutionMap = new HashMap();
            HashSet dependentTypes = new HashSet();
            if (symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol function = (OCFunctionSymbol)symbol;
                List<OCType> parameterTypes = OCResolveOverloadsUtil.getParameterTypes((OCFunctionSymbol)function, (OCOperatorReference.OperatorPlacement)operatorPlacement, (OCResolveContext)context, (CVQualifiers)cvQualifiers).types;
                int paramsCount = OCArgumentsChecker.getNonVariadicParametersCount(parameterTypes);
                if (OCResolveOverloadsUtil.getNonInitializedParametersCount(function, operatorPlacement, context) > argumentsCount && !arguments.hasNonExpandedVariadics() || argumentsCount > paramsCount && !function.isVararg()) continue;
                boolean isUnified = OCArgumentsChecker.processArguments(parameterTypes, null, arguments, context, new OCArgumentsChecker.ArgumentsProcessor<E>((Map)substitutionMap, (Set)dependentTypes, allowImplicitConversions){
                    final /* synthetic */ Map val$substitutionMap;
                    final /* synthetic */ Set val$dependentTypes;
                    final /* synthetic */ boolean val$allowImplicitConversions;
                    {
                        this.val$substitutionMap = map;
                        this.val$dependentTypes = set;
                        this.val$allowImplicitConversions = bl;
                    }

                    @Override
                    public boolean process(@NotNull OCType paramType, @Nullable OCDeclaratorSymbol parameterSymbol, @NotNull OCType argumentType, @Nullable E argument, boolean isVariadic) {
                        if (paramType instanceof OCPointerType && argumentType instanceof OCIntType && OCExpressionEvaluator.isNullCompatible(OCExpressionEvaluator.evaluate(argument, context))) {
                            return true;
                        }
                        if (paramType instanceof OCTypeParameterType) {
                            argumentType = argumentType.transformType(OCArrayToPointerChanger.INSTANCE);
                        }
                        return paramType instanceof OCEllipsisType || OCSimpleTypeSubstitution.unify(paramType, argumentType, argument, this.val$substitutionMap, this.val$dependentTypes, true, isVariadic, context) != OCTypeUnificationVisitor.NOT_UNIFIED || !(paramType instanceof OCTypeParameterType) && paramType.checkCompatible(argumentType, (OCTypeOwner)argument, context.getElement(), this.val$allowImplicitConversions, true, context).getState() == OCType.TypeCheckState.OK;
                    }
                });
                OCResolveOverloadsUtil.addDefaultSubstitutions(function, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap);
                OCSimpleTypeSubstitution substitution = OCSimpleTypeSubstitution.create((Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap);
                if (isUnified && OCResolveOverloadsUtil.isPrunedBySFINAE(function, substitution, (Set<OCTypeParameterSymbol>)dependentTypes, context)) {
                    isUnified = false;
                }
                OCSymbol substitutedFunction = substitution.substitute(symbol, context);
                allSymbols.add(substitutedFunction);
                if (!isUnified) continue;
                unified.add(substitutedFunction);
                continue;
            }
            if (symbol instanceof OCStructSymbol && argumentsCount == 1 && !((OCStructSymbol)symbol).hasDeclaredConstructor()) {
                OCType argumentType = arguments.getTypes().get(0);
                OCTypeOwner argumentExpr = arguments.getExprs() != null ? (OCTypeOwner)arguments.getExprs().get(0) : null;
                OCTypeUnificationVisitor.UnificationResult unifyResult = OCSimpleTypeSubstitution.unify(symbol.getType(), argumentType, argumentExpr, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, (Set<OCTypeParameterSymbol>)dependentTypes, true, false, context);
                OCSymbol substitutedFunction = OCSimpleTypeSubstitution.create((Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap).substitute(symbol, context);
                allSymbols.add(substitutedFunction);
                if (unifyResult == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                unified.add(substitutedFunction);
                continue;
            }
            if (symbol instanceof OCStructSymbol && argumentsCount == 0 && !((OCStructSymbol)symbol).hasDeclaredConstructor()) {
                unified.add(symbol);
                continue;
            }
            if (symbol instanceof OCStructSymbol) continue;
            unified.add(symbol);
        }
        return unified.isEmpty() && !acceptOnlyCompatible ? allSymbols : unified;
    }

    private static void addDefaultSubstitutions(OCFunctionSymbol function, Map<OCTypeParameterSymbol, OCTypeArgument> map) {
        for (OCTypeParameterSymbol parameter : function.getTemplateParameters()) {
            if (parameter.getDefaultValue() == null || map.containsKey(parameter)) continue;
            map.put(parameter, (OCTypeArgument)parameter.getDefaultValue());
        }
    }

    private static <T> boolean containsAny(Set<T> set, Collection<T> collection) {
        for (T element : collection) {
            if (!set.contains(element)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPrunedBySFINAE(OCFunctionSymbol function, OCSimpleTypeSubstitution substitution, Set<OCTypeParameterSymbol> dependentTypes, @NotNull OCResolveContext context) {
        context = context.substituteFirst(substitution);
        context = context.useFor(function);
        boolean oldSfinaeFlag = OCResolveContext.setInSFINAEFlag(context, true);
        try {
            for (OCDeclaratorSymbol parameter : function.getParameterSymbols(context)) {
                OCType paramType = parameter.getType().resolve(context);
                if (!paramType.isUnresolved(context)) continue;
                boolean bl = true;
                return bl;
            }
            OCType returnType = function.getEffectiveType().resolve(context);
            if ((returnType.isUnresolved(context) || returnType.isUnknown()) && !OCResolveOverloadsUtil.containsAny(dependentTypes, context.getTypeDependencies(returnType))) {
                boolean bl = true;
                return bl;
            }
            for (OCTypeParameterSymbol parameter : function.getTemplateParameters()) {
                OCType type;
                Object defaultValue = parameter.getDefaultValue();
                if (defaultValue == null && !dependentTypes.contains(parameter) && !parameter.isVariadic() && function.getSubstitution().getSubstitutionFor(parameter) == null && substitution.getSubstitutionFor(parameter) == null) {
                    boolean bl = true;
                    return bl;
                }
                if (!(defaultValue instanceof OCType) || !(type = ((OCType)defaultValue).resolve(context)).isUnresolved(context) || OCResolveOverloadsUtil.containsAny(dependentTypes, context.getTypeDependencies(type))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            OCResolveContext.setInSFINAEFlag(context, oldSfinaeFlag);
        }
    }

    private static class TypesAndNames {
        @NotNull
        public final List<OCType> types;
        @Nullable
        public final List<String> names;

        private TypesAndNames(@NotNull List<OCType> types, @Nullable List<String> names) {
            this.types = types;
            this.names = names;
        }
    }

    private static class Overload
    implements Comparable<Overload> {
        ParamFitness myFitness;
        int price;
        OCSymbol mySymbol;

        public Overload(ParamFitness fitness, int price, OCSymbol symbol) {
            this.myFitness = fitness;
            this.price = price;
            this.mySymbol = symbol;
        }

        @Override
        public int compareTo(Overload o) {
            if (this.myFitness.ordinal() < o.myFitness.ordinal()) {
                return -1;
            }
            if (this.myFitness == o.myFitness) {
                return this.price - o.price;
            }
            return 1;
        }
    }

    private static enum ParamFitness {
        ok,
        okWithConversion,
        warning,
        ellipsis,
        error;

    }

    public static class OCFunctionGroupSymbol
    extends OCFunctionSymbol {
        private List<OCFunctionSymbol> myOverloads;

        public OCFunctionGroupSymbol(@NotNull List<OCFunctionSymbol> overloads, @Nullable OCType returnType) {
            super(overloads.get(0).getProject(), overloads.get(0).getContainingFile(), 0L, overloads.get(0).getParent(), overloads.get(0).getQualifiedName(), Collections.emptyList(), Collections.emptyList(), 0, OCSymbolAttribute.STATIC.getMask(), Collections.emptyList(), OCFunctionGroupSymbol.getFunctionType(overloads, returnType), OCFunctionGroupSymbol.getParameters(overloads), OCFunctionGroupSymbol.getSymbolKind(overloads, OCSymbolKind.FUNCTION_PREDECLARATION), null);
            this.myOverloads = overloads;
        }

        private static List<OCDeclaratorSymbol> getParameters(List<OCFunctionSymbol> overloads) {
            return overloads.get(0).getParameterSymbols();
        }

        private static OCFunctionType getFunctionType(List<OCFunctionSymbol> overloads, @Nullable OCType returnType) {
            if (returnType == null) {
                returnType = new OCMagicType(overloads.get(0).getType().getReturnType());
            }
            return new OCFunctionType(returnType, overloads.get(0).getType().getParameterTypes());
        }

        private static OCSymbolKind getSymbolKind(List<OCFunctionSymbol> overloads, OCSymbolKind defaultKind) {
            OCSymbolKind kind = null;
            for (OCFunctionSymbol symbol : overloads) {
                if (kind == null) {
                    kind = symbol.getKind();
                    continue;
                }
                if (kind == symbol.getKind()) continue;
                return defaultKind;
            }
            return kind != null ? kind : defaultKind;
        }

        public List<OCFunctionSymbol> getOverloads() {
            return this.myOverloads;
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
            throw new UnsupportedOperationException("this symbol is synthetic and should not be interned");
        }
    }
}

