/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.impl.OCImportModuleStatementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCIncludeDirectiveImpl;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCImportManipulator
extends AbstractElementManipulator<OCIncludeDirectiveImpl> {
    public OCIncludeDirectiveImpl handleContentChange(@NotNull OCIncludeDirectiveImpl element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element instanceof OCImportModuleStatementImpl) {
            PsiElement newElement = OCElementFactory.topLevelDeclarationFromText("@import " + newContent + ";", element);
            return (OCIncludeDirectiveImpl)OCChangeUtil.replaceHandlingMacros(element, newElement);
        }
        ASTNode oldContentNode = element.getNode().findChildByType((IElementType)OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT);
        PsiElement newDirective = OCElementFactory.topLevelDeclarationFromText("#import " + newContent, element);
        ASTNode newContentNode = newDirective.getNode().findChildByType((IElementType)OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT);
        CodeEditUtil.replaceChild(element.getNode(), oldContentNode, newContentNode);
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull OCIncludeDirectiveImpl element) {
        IElementType tt;
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return TextRange.EMPTY_RANGE;
        }
        ASTNode node = element.getNode();
        if (element instanceof OCImportModuleStatementImpl) {
            int start;
            ASTNode child = node.findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
            if (child == null) {
                return TextRange.EMPTY_RANGE.shiftRight(node.getTextLength());
            }
            int end = start = OCSymbolOffsetUtil.getTextOffsetInTopMacroSubstitution(child.getPsi()) - node.getStartOffset();
            while (child != null) {
                if (child.getElementType() == OCTokenTypes.IDENTIFIER) {
                    end = OCSymbolOffsetUtil.getTextOffsetInTopMacroSubstitution(child.getPsi()) + child.getTextLength() - node.getStartOffset();
                }
                child = child.getTreeNext();
            }
            return new TextRange(start, end);
        }
        ASTNode content = node.findChildByType((IElementType)OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT);
        if (content == null || content.getStartOffset() == 0) {
            return new TextRange(node.getTextLength(), node.getTextLength());
        }
        int off = content.getStartOffset() - node.getStartOffset();
        String txt = content.getText();
        OCLexer lexer = new OCLexer();
        lexer.start(txt);
        int ltstart = -1;
        while ((tt = lexer.getTokenType()) != null && !OCTokenTypes.COMMENTS.contains(tt)) {
            if (tt == OCTokenTypes.STRING_LITERAL) {
                int start = lexer.getTokenStart();
                int end = lexer.getTokenEnd();
                if (txt.charAt(start) == '\"') {
                    ++start;
                }
                if (end <= txt.length() && txt.charAt(end - 1) == '\"') {
                    --end;
                }
                if (end >= start) {
                    return new TextRange(start, end).shiftRight(off);
                }
                return new TextRange(start, start).shiftRight(off);
            }
            if (tt == OCTokenTypes.LT) {
                ltstart = lexer.getTokenEnd();
            } else if (tt == OCTokenTypes.GT) {
                int gtstart = lexer.getTokenStart();
                if (ltstart >= 0 && gtstart - ltstart > 1) {
                    return new TextRange(ltstart, gtstart).shiftRight(off);
                }
                return TextRange.EMPTY_RANGE.shiftRight(off);
            }
            lexer.advance();
        }
        if (ltstart >= 0) {
            int end = lexer.getTokenStart();
            if (end - ltstart <= 1) {
                end = ltstart;
            }
            return new TextRange(ltstart, end).shiftRight(off);
        }
        return TextRange.EMPTY_RANGE.shiftRight(off);
    }
}

