/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCVariadicPackExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArgumentsList<E extends OCTypeOwner> {
    @NotNull
    private List<OCType> types;
    @Nullable
    private List<E> exprs;
    private boolean nonExpandedVariadics;

    public OCArgumentsList(@NotNull List<OCType> types, @Nullable List<E> exprs, boolean nonExpandedVariadics) {
        this.types = Collections.unmodifiableList(types);
        this.exprs = exprs != null ? Collections.unmodifiableList(exprs) : null;
        this.nonExpandedVariadics = nonExpandedVariadics;
    }

    public OCArgumentsList(@NotNull List<OCType> types, @Nullable List<E> exprs) {
        this(types, exprs, false);
    }

    @NotNull
    public static OCArgumentsList<OCExpression> getArgumentList(@NotNull List<OCExpression> expressionsList) {
        return OCArgumentsList.getArgumentList(expressionsList, null);
    }

    @NotNull
    public static OCArgumentsList<OCExpression> getArgumentList(@NotNull List<OCExpression> expressionsList, @Nullable OCResolveContext context) {
        ArrayList<OCType> types = new ArrayList<OCType>();
        boolean nonExpandedVariadics = false;
        ArrayList<OCExpression> expressions = new ArrayList<OCExpression>();
        for (OCExpression expression : expressionsList) {
            if (expression instanceof OCVariadicPackExpression) {
                nonExpandedVariadics = true;
                continue;
            }
            expressions.add(expression);
            types.add(expression.getResolvedType(context != null ? context : new OCResolveContext(expression)));
        }
        return new OCArgumentsList<OCExpression>(types, expressions, nonExpandedVariadics);
    }

    @NotNull
    public static OCArgumentsList<OCExpressionSymbol> expandVariadicExpressions(@NotNull List<OCExpressionSymbol> expressionsList, @NotNull OCResolveContext context) {
        ArrayList<OCType> expandedTypes = new ArrayList<OCType>();
        ArrayList<OCExpressionSymbol> expandedExprs = new ArrayList<OCExpressionSymbol>();
        boolean nonExpandedVariadics = false;
        for (OCExpressionSymbol expression : expressionsList) {
            if (expression instanceof OCVariadicPackExpressionSymbol) {
                List<OCType> expansions = ((OCVariadicPackExpressionSymbol)expression).getExpandedResolvedTypes(context);
                if (expansions != null) {
                    for (OCType type : expansions) {
                        expandedExprs.add(null);
                        expandedTypes.add(type);
                    }
                    continue;
                }
                nonExpandedVariadics = true;
                continue;
            }
            expandedExprs.add(expression);
            expandedTypes.add(expression.getResolvedType(context));
        }
        return new OCArgumentsList<OCExpressionSymbol>(expandedTypes, expandedExprs, nonExpandedVariadics);
    }

    @NotNull
    public static <T extends OCTypeArgument> List<T> expandVariadicTypes(@NotNull List<T> types, @NotNull OCResolveContext context) {
        ArrayList<OCTypeArgument> result = new ArrayList<OCTypeArgument>();
        if (context.isDontExpandVariadics()) {
            return types;
        }
        for (OCTypeArgument type : types) {
            List<OCTypeArgument> expandedTypes = null;
            if (type instanceof OCVariadicType) {
                OCType underlyingType = ((OCVariadicType)type).getUnderlyingType();
                expandedTypes = OCArgumentsList.expandExpansionPacks(underlyingType, context);
                if (expandedTypes == null) {
                    expandedTypes = OCArgumentsList.expandVariadicType(underlyingType, context);
                }
            } else if (type.isVariadic()) {
                expandedTypes = OCArgumentsList.expandVariadicPackExpression((OCVariadicPackExpressionSymbol)((OCExpressionTypeArgument)type).getSymbol(), context);
            }
            if (expandedTypes != null) {
                result.addAll(expandedTypes);
                continue;
            }
            result.add(type);
        }
        return result;
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandExpansionPacks(@NotNull OCType type, final @NotNull OCResolveContext context) {
        final Ref expansionsCnt = new Ref();
        OCType resolvedType = type.resolve(context);
        resolvedType.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitExpansionPackType(OCExpansionPackType type) {
                OCLog.LOG.assertTrue(expansionsCnt.isNull() || ((Integer)expansionsCnt.get()).intValue() == type.getExpansionsCnt(), (Object)context.getFile());
                expansionsCnt.set((Object)type.getExpansionsCnt());
                return true;
            }
        });
        if (!expansionsCnt.isNull()) {
            ArrayList<OCType> expandedTypes = new ArrayList<OCType>();
            int i = 0;
            while (i < (Integer)expansionsCnt.get()) {
                final int expansionIndex = i++;
                expandedTypes.add(resolvedType.accept(new OCNonPrimitiveTypeCloneVisitor(){

                    @Override
                    public OCType visitExpansionPackType(OCExpansionPackType type) {
                        OCTypeArgument argument;
                        if (expansionIndex < type.getExpansionsCnt() && (argument = type.getExpansions().get(expansionIndex)) instanceof OCType) {
                            return (OCType)argument;
                        }
                        return OCUnknownType.INSTANCE;
                    }
                }));
            }
            return expandedTypes;
        }
        return null;
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandVariadicPackExpression(@NotNull OCVariadicPackExpressionSymbol expressionSymbol, @NotNull OCResolveContext context) {
        final OCExpressionSymbol symbol = expressionSymbol.getExpression();
        return OCArgumentsList.getExpandedResolvedTypes(new Function<OCResolveContext, OCTypeArgument>(){

            public OCTypeArgument fun(OCResolveContext context) {
                return symbol.evaluateToTypeArgument(context);
            }
        }, new OCTypeOwner(){

            @Override
            @Nullable
            public OCType getResolvedType(@NotNull OCResolveContext context) {
                return symbol.getResolvedType(context);
            }
        }, context);
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandVariadicType(final @NotNull OCType underlyingType, @NotNull OCResolveContext context) {
        return OCArgumentsList.getExpandedResolvedTypes(new Function<OCResolveContext, OCType>(){

            @Nullable
            public OCType fun(@NotNull OCResolveContext context2) {
                return context2.getSubstitution().substitute(underlyingType, context2);
            }
        }, new OCTypeOwner(){

            @Override
            @Nullable
            public OCType getResolvedType(@NotNull OCResolveContext context2) {
                return underlyingType.resolve(context2);
            }
        }, context);
    }

    @Nullable
    public static List<OCType> getExpandedResolvedTypes(final @NotNull OCTypeOwner operand, @NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        return OCArgumentsList.getExpandedResolvedTypes(new Function<OCResolveContext, OCType>(){

            public OCType fun(OCResolveContext context) {
                return operand.getResolvedType(context);
            }
        }, dependency, context);
    }

    @Nullable
    public static <T extends OCTypeArgument> List<T> getExpandedResolvedTypes(@NotNull Function<OCResolveContext, T> operand, @NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        while (context.isVariadicExpansionMode()) {
            context = context.getOriginalContext();
        }
        Set<OCTypeParameterSymbol> dependencies = OCArgumentsList.getTypeParameterDependencies(dependency, context);
        List<Pair<OCTypeParameterSymbol, OCExpansionPackType>> expansions = OCArgumentsList.getExpansions(dependencies, context);
        if (expansions == null || expansions.isEmpty()) {
            return null;
        }
        ArrayList<OCTypeArgument> result = new ArrayList<OCTypeArgument>();
        for (int i = 0; i < ((OCExpansionPackType)expansions.get((int)0).second).getExpansionsCnt(); ++i) {
            HashMap<OCTypeParameterSymbol, OCTypeArgument> map = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
            for (Pair<OCTypeParameterSymbol, OCExpansionPackType> expansion : expansions) {
                map.put((OCTypeParameterSymbol)expansion.first, ((OCExpansionPackType)expansion.second).getExpansions().get(i));
            }
            OCResolveContext resolveContext = context.substitute(OCSimpleTypeSubstitution.create(map), true);
            resolveContext.setVariadicExpansionMode(true);
            OCTypeArgument argument = (OCTypeArgument)operand.fun((Object)resolveContext);
            if (argument == null) {
                return null;
            }
            result.add(argument);
        }
        return result;
    }

    @Nullable
    private static List<Pair<OCTypeParameterSymbol, OCExpansionPackType>> getExpansions(final @NotNull Set<OCTypeParameterSymbol> dependencies, @NotNull OCResolveContext context) {
        HashSet processed2 = new HashSet();
        ArrayList<Pair<OCTypeParameterSymbol, OCExpansionPackType>> pairs = new ArrayList<Pair<OCTypeParameterSymbol, OCExpansionPackType>>();
        if (!context.getSubstitution().processSubstitutions(new Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>((Set)processed2, pairs){
            final /* synthetic */ Set val$processed;
            final /* synthetic */ List val$pairs;
            {
                this.val$processed = set2;
                this.val$pairs = list;
            }

            public boolean process(Map.Entry<OCTypeParameterSymbol, OCTypeArgument> entry) {
                OCTypeParameterSymbol parameter = entry.getKey();
                OCTypeArgument argument = entry.getValue();
                if (dependencies.contains(parameter) && !this.val$processed.contains(parameter) && argument instanceof OCExpansionPackType) {
                    this.val$processed.add(parameter);
                    if (!this.val$pairs.isEmpty() && ((OCExpansionPackType)((Pair)this.val$pairs.get((int)0)).second).getExpansionsCnt() != ((OCExpansionPackType)argument).getExpansionsCnt()) {
                        return false;
                    }
                    this.val$pairs.add(Pair.create((Object)parameter, (Object)((OCExpansionPackType)argument)));
                }
                return true;
            }
        })) {
            return null;
        }
        return pairs;
    }

    @NotNull
    private static Set<OCTypeParameterSymbol> getTypeParameterDependencies(@NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        OCResolveContext contextWithoutSubstitutions = context.clearSubstitution();
        contextWithoutSubstitutions.setDontExpandVariadics(true);
        OCType resolvedDependency = dependency.getResolvedType(contextWithoutSubstitutions);
        return contextWithoutSubstitutions.getTypeDependencies(resolvedDependency);
    }

    @NotNull
    public List<OCType> getTypes() {
        return this.types;
    }

    @Nullable
    public List<E> getExprs() {
        return this.exprs;
    }

    public int getCount() {
        return this.types.size();
    }

    public boolean hasNonExpandedVariadics() {
        return this.nonExpandedVariadics;
    }
}

