/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OCNormalizeUtil {
    private OCNormalizeUtil() {
    }

    @Nullable
    public static OCDeclaration normalizeDeclarator(final OCDeclarator declarator) throws IncorrectOperationException {
        final Ref result = Ref.create(null);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                OCDeclaration declaration = (OCDeclaration)declarator.getParent();
                ASTNode declarationOrPropertyNode = declaration.getNode();
                int declarationIndex = declaration.getDeclarators().indexOf(declarator);
                if (declarationOrPropertyNode == null || declaration.getDeclarators().size() <= 1) {
                    result.set((Object)declaration);
                    return;
                }
                ASTNode parent = declarationOrPropertyNode.getTreeParent();
                if (parent.getElementType() == OCElementTypes.DECLARATION_STATEMENT || parent.getElementType() == OCElementTypes.PROPERTY) {
                    declarationOrPropertyNode = parent;
                    parent = declarationOrPropertyNode.getTreeParent();
                }
                ASTNode newDeclarationOrPropertyNode = declarationOrPropertyNode.copyElement();
                CodeEditUtil.addChild(parent, newDeclarationOrPropertyNode, declarationOrPropertyNode.getTreeNext());
                ASTNode newDeclarationNode = newDeclarationOrPropertyNode;
                if (newDeclarationNode.getElementType() != OCElementTypes.DECLARATION) {
                    for (ASTNode child : newDeclarationNode.getChildren(null)) {
                        if (child.getElementType() != OCElementTypes.DECLARATION) continue;
                        newDeclarationNode = child;
                        break;
                    }
                }
                if (newDeclarationNode.getElementType() != OCElementTypes.DECLARATION) {
                    return;
                }
                OCDeclaration newDeclaration = (OCDeclaration)newDeclarationNode.getPsi(OCDeclaration.class);
                if (newDeclaration == null) {
                    return;
                }
                OCDeclarator newDeclarator = newDeclaration.getDeclarators().get(declarationIndex);
                OCChangeUtil.delete(declarator);
                for (OCDeclarator curDeclarator : newDeclaration.getDeclarators()) {
                    if (curDeclarator == newDeclarator) continue;
                    OCChangeUtil.delete(curDeclarator);
                }
                CodeStyleManager.getInstance((Project)newDeclaration.getProject()).reformat((PsiElement)newDeclaration);
                result.set((Object)newDeclaration);
            }
        });
        return (OCDeclaration)result.get();
    }

    public static List<OCDeclaration> normalizeDeclaration(OCDeclaration declaration) {
        ArrayList<OCDeclaration> newDeclarations = new ArrayList<OCDeclaration>();
        int declaratorsCnt = declaration.getDeclarators().size();
        for (int i = 0; i < declaratorsCnt; ++i) {
            List<OCDeclarator> declarators = declaration.getDeclarators();
            newDeclarations.add(OCNormalizeUtil.normalizeDeclarator(declarators.get(declarators.size() - 1)));
        }
        return newDeclarations;
    }

    public static OCSynthesizePropertiesList normalizeSynthesizeStatement(final OCSynthesizeProperty property) {
        final Ref result = Ref.create(null);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                OCSynthesizePropertiesList list = (OCSynthesizePropertiesList)property.getParent();
                ASTNode listNode = list.getNode();
                int propertyIndex = list.getProperties().indexOf(property);
                if (listNode == null || list.getProperties().size() <= 1) {
                    result.set((Object)list);
                    return;
                }
                ASTNode parent = listNode.getTreeParent();
                ASTNode newListNode = listNode.copyElement();
                CodeEditUtil.addChild(parent, newListNode, listNode.getTreeNext());
                OCSynthesizePropertiesList newList = (OCSynthesizePropertiesList)newListNode.getPsi();
                if (newList == null) {
                    return;
                }
                OCSynthesizeProperty newProperty = newList.getProperties().get(propertyIndex);
                OCChangeUtil.delete(property);
                for (OCSynthesizeProperty curProperty : newList.getProperties()) {
                    if (curProperty == newProperty) continue;
                    OCChangeUtil.delete(curProperty);
                }
                CodeStyleManager.getInstance((Project)newList.getProject()).reformat((PsiElement)newList);
                result.set((Object)newList);
            }
        });
        return (OCSynthesizePropertiesList)result.get();
    }
}

