/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveModifyableVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeVisibilityIntentionAction;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCEscalateVisibilityDialog;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBindUtil {
    private static final Key<OCSymbolWithParent> REF_TO_SYMBOL = Key.create((String)"REF_TO_SYMBOL_KEY");
    private static final Key<PsiElement> REF_TO_DEFINITION = Key.create((String)"REF_TO_DEFINITION_KEY");
    private static final Key<Object> KEY_ENCODED = Key.create((String)"KEY_ENCODED");
    private static final Key<Boolean> KEY_IS_REF_TO_PARENT = Key.create((String)"KEY_IS_REF_TO_PARENT");
    private static final Key<Boolean> KEY_BIND_QUALIFIER = Key.create((String)"KEY_BIND_QUALIFIER");

    private OCBindUtil() {
    }

    public static void encodeContextInfo(PsiElement element, boolean encodeLocals) {
        OCBindUtil.encodeContextInfo(Collections.singletonList(element), null, encodeLocals);
    }

    public static void encodeContextInfo(Collection<PsiElement> elements, @Nullable OCSymbol parentSymbol, boolean encodeLocals) {
        for (PsiElement element : elements) {
            OCBindUtil.encodeContextInfo(element, elements, parentSymbol, encodeLocals);
        }
    }

    private static void encodeContextInfo(PsiElement element, final Collection<PsiElement> scope, final @Nullable OCSymbol parentSymbol, final boolean encodeLocals) {
        element.accept((PsiElementVisitor)new OCRecursiveModifyableVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (OCElementUtil.isPartOfMacroSubstitution(element)) {
                    return;
                }
                super.visitElement(element);
                OCSymbol refSymbol = null;
                if (element instanceof OCReferenceElement) {
                    refSymbol = ((OCReferenceElement)element).resolveToSymbol();
                } else {
                    PsiReference ref = element.getReference();
                    if (ref instanceof OCReference) {
                        refSymbol = ((OCReference)ref).resolveToSymbol();
                    } else if (ref instanceof OCPolyVariantReference) {
                        List symbols = ((OCPolyVariantReference)ref).resolveToSymbols();
                        OCSymbol oCSymbol = refSymbol = symbols.isEmpty() ? null : (OCSymbol)symbols.iterator().next();
                    }
                }
                if (refSymbol != null) {
                    Object definition = refSymbol.locateDefinition();
                    if (refSymbol instanceof OCSymbolWithParent) {
                        boolean isInScope = false;
                        if (definition != null) {
                            for (PsiElement scopePart : scope) {
                                if (!PsiTreeUtil.isContextAncestor((PsiElement)scopePart, definition, (boolean)false)) continue;
                                isInScope = true;
                                break;
                            }
                        }
                        if (isInScope) {
                            if (parentSymbol != null) {
                                PsiReference qualifierRef = OCBindUtil.getQualifierReference(element);
                                if (qualifierRef instanceof OCReference && parentSymbol.isSameSymbol(((OCReference)qualifierRef).resolveToSymbol())) {
                                    OCBindUtil.encodeAsRefToParent(element);
                                } else if (qualifierRef instanceof OCPolyVariantReference) {
                                    for (OCSymbol symbol : ((OCPolyVariantReference)qualifierRef).resolveToSymbols()) {
                                        if (!parentSymbol.isSameSymbol(symbol)) continue;
                                        OCBindUtil.encodeAsRefToParent(element);
                                        break;
                                    }
                                }
                            }
                        } else if (encodeLocals || !refSymbol.getKind().isLocal()) {
                            element.putCopyableUserData(KEY_ENCODED, (Object)KEY_ENCODED);
                            element.putCopyableUserData(REF_TO_SYMBOL, (Object)((OCSymbolWithParent)refSymbol));
                            element.putCopyableUserData(REF_TO_DEFINITION, definition);
                            element.putCopyableUserData(KEY_IS_REF_TO_PARENT, (Object)false);
                            element.putCopyableUserData(KEY_BIND_QUALIFIER, (Object)(((OCSymbolWithParent)refSymbol).getParent() == parentSymbol ? 1 : 0));
                        }
                    }
                }
            }
        });
    }

    public static void encodeAsRefToParent(PsiElement element) {
        element.putCopyableUserData(KEY_ENCODED, KEY_ENCODED);
        element.putCopyableUserData(KEY_IS_REF_TO_PARENT, (Object)true);
        element.putCopyableUserData(KEY_BIND_QUALIFIER, (Object)false);
    }

    public static void decodeContextInfo(Collection<PsiElement> elements) {
        for (PsiElement element : elements) {
            OCBindUtil.decodeContextInfo(element, null, null);
        }
    }

    public static void decodeContextInfo(PsiElement element) {
        OCBindUtil.decodeContextInfo(element, null, null);
    }

    public static void decodeContextInfo(PsiElement element, final @Nullable OCSymbol newParentSymbol, final @Nullable Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        element.accept((PsiElementVisitor)new OCRecursiveModifyableVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (OCElementUtil.isPartOfMacroSubstitution(element)) {
                    return;
                }
                super.visitElement(element);
                if (element.getCopyableUserData(KEY_ENCODED) != null) {
                    OCSymbolWithParent symbol = (OCSymbolWithParent)element.getCopyableUserData(REF_TO_SYMBOL);
                    PsiElement definition = (PsiElement)element.getCopyableUserData(REF_TO_DEFINITION);
                    Boolean isRefToParent = (Boolean)element.getCopyableUserData(KEY_IS_REF_TO_PARENT);
                    Boolean bindQualifier = (Boolean)element.getCopyableUserData(KEY_BIND_QUALIFIER);
                    element.putCopyableUserData(KEY_ENCODED, null);
                    element.putCopyableUserData(KEY_IS_REF_TO_PARENT, null);
                    element.putCopyableUserData(KEY_BIND_QUALIFIER, null);
                    element.putCopyableUserData(REF_TO_SYMBOL, null);
                    element.putCopyableUserData(REF_TO_DEFINITION, null);
                    assert (bindQualifier != null);
                    if (isRefToParent == Boolean.TRUE) {
                        PsiReference reference = element instanceof OCDeclarator ? ((OCDeclarator)element).getNamespaceQualifier().getReference() : OCBindUtil.getQualifierReference(element);
                        OCBindUtil.bindReferenceAndMakeVisible(reference, newParentSymbol, newParentSymbol.locateDefinition(), elemsToEscalateVisibility, bindQualifier);
                    } else if (symbol != null) {
                        OCBindUtil.bindReferenceAndMakeVisible(element.getReference(), symbol, definition, elemsToEscalateVisibility, bindQualifier);
                    }
                }
            }
        });
    }

    public static PsiElement insertRedundantQualifiers(final PsiElement rootElement, final boolean isDotCall) {
        final Ref result = Ref.create((Object)rootElement);
        rootElement.accept((PsiElementVisitor)new OCRecursiveModifyableVisitor(){

            @Override
            public void visitReferenceExpression(OCReferenceExpression expression) {
                if (OCElementUtil.isPartOfMacroSubstitution(expression)) {
                    return;
                }
                super.visitReferenceExpression(expression);
                OCSymbol symbol = expression.resolveToSymbol();
                OCExpression newElement = null;
                if (symbol instanceof OCInstanceVariableSymbol) {
                    newElement = OCElementFactory.expressionFromText("self->" + symbol.getName(), expression);
                } else if (symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).getParent() instanceof OCStructSymbol && !((OCSymbolWithQualifiedName)symbol).isStatic() && symbol.getKind() != OCSymbolKind.ENUM_CONST) {
                    newElement = OCElementFactory.expressionFromText((isDotCall ? "this." : "this->") + symbol.getName(), expression);
                }
                if (newElement != null) {
                    if (expression == rootElement) {
                        result.set((Object)newElement);
                    } else {
                        OCChangeUtil.replaceHandlingMacros(expression, newElement);
                    }
                }
            }
        });
        return (PsiElement)result.get();
    }

    public static List<PsiElement> insertRedundantQualifiers(Collection<PsiElement> elements, boolean isDotCall) {
        ArrayList<PsiElement> newElements = new ArrayList<PsiElement>();
        for (PsiElement element : elements) {
            if (element.isPhysical()) {
                newElements.add(OCBindUtil.insertRedundantQualifiers(element, isDotCall));
                continue;
            }
            newElements.add(element);
        }
        return newElements;
    }

    public static void removeRedundantQualifiers(PsiElement expression) {
        expression.accept((PsiElementVisitor)new OCRecursiveModifyableVisitor(){

            @Override
            public void visitQualifiedExpression(OCQualifiedExpression expression) {
                if (OCElementUtil.isPartOfMacroSubstitution(expression)) {
                    return;
                }
                super.visitQualifiedExpression(expression);
                OCExpression qualifier = expression.getQualifier();
                OCSymbol symbol = expression.resolveToSymbol();
                PsiElement copy = expression.copy();
                if (symbol instanceof OCSymbolWithParent && qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).isSelfSuperOrThis()) {
                    OCReferenceExpression refExpr = (OCReferenceExpression)OCElementFactory.expressionFromText(symbol.getName(), expression);
                    if (!OCBindUtil.bindReferenceToSymbol((refExpr = (OCReferenceExpression)OCChangeUtil.replaceHandlingMacros(expression, refExpr)).getReferenceElement().getReference(), symbol, false)) {
                        OCChangeUtil.replaceHandlingMacros(refExpr, copy);
                    }
                }
            }
        });
    }

    public static boolean setShortestPossibleName(OCReferenceElement element) {
        OCSymbol symbol = element.resolveToSymbol();
        if (symbol instanceof OCSymbolWithQualifiedName) {
            OCQualifiedName parent;
            OCQualifiedName qualifiedName = OCSymbolReferenceResolver.getQualifiedName(element);
            for (parent = qualifiedName.getQualifier(); parent != null && parent != OCQualifiedName.GLOBAL; parent = parent.getQualifier()) {
            }
            if (parent == OCQualifiedName.GLOBAL) {
                qualifiedName = qualifiedName.dropSuperQualifier();
            }
            return OCBindUtil.setShortestPossibleName(qualifiedName, element, (OCSymbolWithQualifiedName)symbol);
        }
        return false;
    }

    public static boolean setShortestPossibleName(OCQualifiedName shortName, OCNamespaceQualifierOwner element, OCSymbolWithQualifiedName symbol) {
        OCQualifiedName oldName = OCSymbolReferenceResolver.getQualifiedName(element);
        if (OCBindUtil.doSetShortestPossibleName(shortName, element, symbol)) {
            return true;
        }
        OCElementUtil.changeQualifiedName(element, oldName);
        return false;
    }

    private static boolean doSetShortestPossibleName(OCQualifiedName shortName, OCNamespaceQualifierOwner element, OCSymbolWithQualifiedName symbol) {
        if (shortName.getQualifier() != null && OCBindUtil.doSetShortestPossibleName(shortName.dropSuperQualifier(), element, symbol)) {
            return true;
        }
        OCElementUtil.changeQualifiedName(element, shortName);
        if (shortName == OCQualifiedName.GLOBAL) {
            return true;
        }
        if (element instanceof OCReferenceElement) {
            return symbol.isSameSymbol(((OCReferenceElement)element).resolveToSymbol());
        }
        if (element instanceof OCCppNamespaceQualifier) {
            return ((OCCppNamespaceQualifier)element).resolveToSymbols().contains(symbol);
        }
        return false;
    }

    @Nullable
    public static OCQualifiedName getShortestPossibleName(OCQualifiedName shortName, OCReferenceElement element, OCSymbol symbol) {
        OCQualifiedName name;
        if (shortName.getQualifier() != null && (name = OCBindUtil.getShortestPossibleName(shortName.dropSuperQualifier(), element, symbol)) != null) {
            return name;
        }
        element = OCElementFactory.referenceElementFromText(shortName.getCanonicalName(true), element, true);
        OCLog.LOG.assertTrue(element != null);
        OCElementUtil.changeQualifiedName(element, shortName);
        OCSymbol resolvedElement = element.resolveToSymbol();
        if (Comparing.equal((Object)resolvedElement, (Object)symbol)) {
            return shortName;
        }
        return null;
    }

    @Nullable
    public static PsiReference getQualifierReference(PsiElement element) {
        OCElement qualifier = null;
        if (element instanceof OCReferenceElement) {
            qualifier = ((OCReferenceElement)element).getNamespaceQualifier();
        } else if (element instanceof OCQualifiedExpression) {
            qualifier = ((OCQualifiedExpression)element).getQualifier();
        } else if (element instanceof OCSendMessageExpression) {
            qualifier = ((OCSendMessageExpression)element).getReceiverExpression();
        } else if (element instanceof OCCppNamespaceQualifier) {
            qualifier = ((OCCppNamespaceQualifier)element).getNamespaceQualifier();
        }
        if (qualifier instanceof OCExpression) {
            qualifier = OCParenthesesUtils.diveIntoParentheses((OCExpression)qualifier);
        }
        if (qualifier instanceof OCReferenceExpression) {
            OCReferenceElement referenceElement = ((OCReferenceExpression)qualifier).getReferenceElement();
            if (referenceElement != null && ((OCReferenceExpression)qualifier).isSelfSuperOrThis()) {
                return referenceElement.getReference();
            }
            OCSymbol symbol = referenceElement != null ? referenceElement.resolveToSymbol() : null;
            return symbol != null && symbol.getKind().isClass() ? referenceElement.getReference() : null;
        }
        if (qualifier instanceof OCCppNamespaceQualifier) {
            return qualifier.getReference();
        }
        return null;
    }

    private static boolean bindReferenceToSymbol(@Nullable PsiReference reference, @Nullable OCSymbol symbol, boolean bindQualifier) {
        if (symbol != null) {
            PsiReference qualifierReference;
            List<Object> resolvedSymbols;
            PsiElement newElement;
            if (reference instanceof OCReference) {
                newElement = ((OCReference)reference).bindToSymbol(symbol);
            } else if (reference instanceof OCPolyVariantReference) {
                newElement = ((OCPolyVariantReference)reference).bindToSymbol(symbol);
            } else {
                return false;
            }
            PsiReference newReference = newElement.getReference();
            if (newReference instanceof OCReference) {
                OCSymbol resolvedSymbol = ((OCReference)newReference).resolveToSymbol();
                resolvedSymbols = resolvedSymbol != null ? Collections.singletonList(resolvedSymbol) : Collections.emptyList();
            } else if (newElement instanceof OCSendMessageExpression) {
                OCMethodSymbol responder = ((OCSendMessageExpression)newElement).getProbableResponders().getKnownResponder();
                resolvedSymbols = responder != null ? Collections.singletonList(responder) : Collections.emptyList();
            } else if (newReference instanceof OCPolyVariantReference) {
                resolvedSymbols = ((OCPolyVariantReference)newReference).resolveToSymbols();
            } else {
                return false;
            }
            boolean resolves = resolvedSymbols.contains(symbol);
            if ((bindQualifier || !resolves) && (symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).isStatic() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isStatic() || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isStatic() || symbol instanceof OCNamespaceSymbol) && (qualifierReference = OCBindUtil.getQualifierReference(newElement)) != null) {
                return OCBindUtil.bindReferenceToSymbol(qualifierReference, ((OCSymbolWithParent)symbol).getParent(), false);
            }
            return resolves;
        }
        return false;
    }

    public static void bindReferenceAndMakeVisible(@Nullable PsiReference reference, @Nullable OCSymbol symbol, @Nullable PsiElement definition, @Nullable Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility, boolean bindQualifier) {
        OCSymbol newSymbol;
        if (reference == null) {
            return;
        }
        OCSymbol oCSymbol = newSymbol = definition instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)definition).getSymbol() : null;
        if (elemsToEscalateVisibility != null && newSymbol instanceof OCSymbolWithParent) {
            OCType qualifierType = reference.getElement() instanceof OCQualifiedExpression ? ((OCQualifiedExpression)reference.getElement()).getQualifier().getResolvedType().getTerminalType() : null;
            OCVisibility visibility = OCVisibility.getVisibility(newSymbol, reference.getElement(), qualifierType);
            if (visibility != OCVisibility.NULL && !OCVisibility.isVisible(newSymbol, visibility)) {
                Pair<OCSymbol, OCVisibility> oldPair = elemsToEscalateVisibility.get(definition);
                OCVisibility newVisibility = oldPair != null ? OCVisibility.min((OCVisibility)((Object)oldPair.getSecond()), visibility) : visibility;
                SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)definition.getProject()).createSmartPsiElementPointer(definition);
                elemsToEscalateVisibility.put(pointer, (Pair<OCSymbol, OCVisibility>)Pair.create(newSymbol, (Object)((Object)newVisibility)));
            }
        }
        OCBindUtil.bindReferenceToSymbol(reference, symbol, bindQualifier);
    }

    public static boolean escalateVisibilities(final Project project2, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility, final VirtualFile ... affectedFiles) {
        if (elemsToEscalateVisibility != null && !elemsToEscalateVisibility.isEmpty()) {
            final OCEscalateVisibilityDialog dialog = new OCEscalateVisibilityDialog(project2, elemsToEscalateVisibility);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                if (!dialog.showAndGet()) {
                    return false;
                }
            } else {
                Disposer.dispose((Disposable)dialog.getDisposable());
            }
            new WriteCommandAction(project2, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                    CommandProcessor.getInstance().setCurrentCommandName("Escalate visibility");
                    CommandProcessor.getInstance().addAffectedFiles(project2, affectedFiles);
                    for (Pair<SmartPsiElementPointer, OCVisibility> pair : dialog.getCheckedMembers()) {
                        PsiElement element = ((SmartPsiElementPointer)pair.getFirst()).getElement();
                        Object symbol = element instanceof OCSymbolDeclarator ? ((OCSymbolDeclarator)element).getSymbol() : null;
                        if (!(symbol instanceof OCSymbolWithParent)) continue;
                        new OCChangeVisibilityIntentionAction(symbol, (OCVisibility)((Object)pair.getSecond())).invoke();
                    }
                }
            }.execute();
        }
        return true;
    }
}

