/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewSourceFileAction;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveTopLevelProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCTopLevelModel;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.ui.OCFileReferenceEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMoveTopLevelDialog
extends OCAbstractMoveDialog {
    private OCFileReferenceEditor myTargetFileField;

    public OCMoveTopLevelDialog(@NotNull OCFile file2, Condition<PsiElement> selectedCondition, String targetFileName) {
        super(null, null, selectedCondition, file2.getProject());
        this.mySourceFile = file2;
        this.myMemberInfos = this.myStorage.getClassMemberInfos(file2);
        this.myMemberInfoModel = this.createModel();
        this.setMembersChecked();
        this.setTitle("Move Declarations");
        this.init();
        if (targetFileName != null) {
            this.myTargetFileField.setText(targetFileName);
        }
    }

    public OCMoveTopLevelDialog(@NotNull OCCppNamespace namespace, OCNamespaceSymbol symbol, Condition<PsiElement> selectedCondition, String targetFileName) {
        super(namespace, symbol, selectedCondition, namespace.getProject());
        this.myMemberInfos = this.myStorage.getClassMemberInfos(namespace);
        this.myMemberInfoModel = this.createModel();
        this.setMembersChecked();
        this.setTitle("Move Declarations");
        this.init();
        if (targetFileName != null) {
            this.myTargetFileField.setText(targetFileName);
        }
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.moveMembers";
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel("Move declarations to file (existing or new):"), "North");
        this.myTargetFileField = OCFileReferenceEditor.create(this.myProject);
        _panel.add((Component)((Object)this.myTargetFileField), "Center");
        this.myTargetFileField.addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                OCMoveTopLevelDialog.this.validateButtons();
            }
        });
        Box box = Box.createVerticalBox();
        box.add(_panel);
        box.add(Box.createVerticalStrut(7));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetFileField;
    }

    @Override
    public boolean allowsEmptySelection() {
        return false;
    }

    @Override
    protected void checkCanRun() throws ConfigurationException {
        super.checkCanRun();
        String targetName = this.getTargetName();
        OCFile file2 = this.getTargetFile();
        if (targetName.isEmpty()) {
            throw new ConfigurationException("No target file is selected");
        }
        if (!PathUtil.isValidFileName((String)targetName)) {
            throw new ConfigurationException("Name of the file is invalid");
        }
        if (file2 != null && !file2.isInProjectSources()) {
            throw new ConfigurationException("File \"" + file2.getName() + "\" is not located inside the project");
        }
        if (file2 != null && file2.equals(this.mySourceFile)) {
            throw new ConfigurationException("Source and target files should be different");
        }
    }

    @Override
    public boolean checkConflicts() {
        String message = "Target file \"" + this.getTargetName() + "\" doesn't yet exist.";
        return this.getTargetFile() != null || OCNewFileActionBase.isNewFileActionSupported() && Messages.showYesNoDialog((Project)this.getProject(), (String)message, (String)this.getTitle(), (String)"Create New File", (String)"Cancel", (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    public String getTargetName() {
        return this.myTargetFileField.getText().trim();
    }

    @Nullable
    private OCFile getTargetFile() {
        return this.myTargetFileField != null ? this.myTargetFileField.getFile(this.myProject) : null;
    }

    @Override
    protected String getOKButtonText() {
        return "&Move";
    }

    private PsiElement getSource() {
        return this.mySourceClass != null ? this.mySourceClass : this.mySourceFile;
    }

    @Override
    @Nullable
    protected OCMoveProcessor createProcessor() {
        return new OCMoveTopLevelProcessor(this.getSource(), this.getTargetName(), this.getTargetFile(), this.getSelectedMemberInfos()){

            @Override
            protected String getCommandName() {
                return OCMoveTopLevelDialog.this.getTitle();
            }

            @Override
            @Nullable
            protected OCNewFileActionBase getNewClassAction() {
                return new OCNewSourceFileAction();
            }

            @Override
            protected boolean importTargetFromSource() {
                return ((OCTopLevelModel)OCMoveTopLevelDialog.this.myMemberInfoModel).importTargetFromSource();
            }

            @Override
            protected boolean importSourceFromTarget() {
                return ((OCTopLevelModel)OCMoveTopLevelDialog.this.myMemberInfoModel).importSourceFromTarget();
            }
        };
    }

    @Override
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel() {
        return new OCTopLevelModel(this.getSource());
    }

    @Override
    protected String getConflictMessage(OCMemberInfo info, OCSymbol symbol) {
        return null;
    }
}

