/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCMoveRefactoringHandler;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCExtractSuperClassDialog;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCPullUpDialog;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;

public class OCPullUpRefactoringHandler
extends OCMoveRefactoringHandler {
    private String myTargetClassName;
    private boolean myRemoveConflictingMembers;
    private boolean mySelectAllMembers;

    public OCPullUpRefactoringHandler(String targetClassName, boolean selectAllMembers, boolean removeConflictingMembers) {
        this.mySelectAllMembers = selectAllMembers;
        this.myTargetClassName = targetClassName;
        this.myRemoveConflictingMembers = removeConflictingMembers;
    }

    public OCPullUpRefactoringHandler() {
    }

    @Override
    protected String getTitle() {
        return RefactoringBundle.message((String)"pull.members.up.title");
    }

    @Override
    protected void showDialog(OCSymbolDeclarator clazz, Condition<PsiElement> selectedCond, Editor editor) {
        OCInterfaceSymbol mainInterface;
        Project project2 = clazz.getProject();
        Object symbol = clazz.getSymbol();
        if (symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null && (mainInterface = ((OCClassSymbol)symbol).getMainInterface()) != null && !OCSearchScope.isInProjectSources(mainInterface)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)OCBundle.message("refactoring.categoryElement.not.in.project", new Object[0]), (String)this.getTitle(), null);
            return;
        }
        super.showDialog(clazz, selectedCond, editor);
    }

    @Override
    protected OCAbstractMoveDialog createDialog(OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition, Editor editor) {
        OCPullUpDialog dialog = new OCPullUpDialog(clazz, classSymbol, selectedCondition, this.myTargetClassName, this.myRemoveConflictingMembers){

            @Override
            protected boolean selectAllMembers() {
                return OCPullUpRefactoringHandler.this.mySelectAllMembers;
            }
        };
        if (dialog.getSuperClasses().isEmpty()) {
            return OCNewFileActionBase.isNewFileActionSupported() ? new OCExtractSuperClassDialog(clazz, classSymbol, selectedCondition) : null;
        }
        return dialog;
    }
}

