/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCCopyMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameProcessor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class OCCopyFilesHandlerDelegate<M, R, G extends R, P>
extends CopyFilesOrDirectoriesHandler {
    protected abstract void addTargets(Set<String> var1, R var2);

    protected abstract void addFiles(PsiDirectory var1, G var2, List<VirtualFile> var3, Set<String> var4);

    protected abstract boolean skipElement(PsiElement var1);

    protected abstract OCCopyMoveProcessor.Helper<M, R, G, P> getHelper();

    @Override
    public void doCopy(PsiElement[] elements, PsiDirectory targetDirectory) {
        PsiDirectory defaultDirectory;
        if (elements.length == 0) {
            return;
        }
        String newName = null;
        PsiDirectory psiDirectory = defaultDirectory = elements[0] instanceof PsiDirectory ? ((PsiDirectory)elements[0]).getParentDirectory() : elements[0].getContainingFile().getContainingDirectory();
        if (targetDirectory == null || targetDirectory.equals(defaultDirectory)) {
            CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(elements, defaultDirectory, elements[0].getProject(), false);
            if (dialog.showAndGet()) {
                targetDirectory = dialog.getTargetDirectory();
                newName = dialog.getNewName();
            } else {
                return;
            }
        }
        new MyProcessor(elements, newName).process(elements[0].getProject(), (PsiElement)targetDirectory);
    }

    public void doCloneForTest(PsiElement element) {
        PsiDirectory targetDirectory = element instanceof PsiDirectory ? ((PsiDirectory)element).getParentDirectory() : ((PsiFile)element).getContainingDirectory();
        PsiElement[] elements = new PsiElement[]{element};
        HashMap filesMap = new HashMap();
        new MyProcessor(elements, "CloneTest", (Map)filesMap){
            final /* synthetic */ Map val$filesMap;
            {
                this.val$filesMap = map;
                super(elements, newName);
            }

            @Override
            protected void cloneClass(OCFile oldFile, OCFile newFile) {
                super.cloneClass(oldFile, newFile);
                this.val$filesMap.put(oldFile, newFile);
            }
        }.process(element.getProject(), (PsiElement)targetDirectory);
        ApplicationManager.getApplication().runWriteAction(new Runnable((Map)filesMap, element){
            final /* synthetic */ Map val$filesMap;
            final /* synthetic */ PsiElement val$element;
            {
                this.val$filesMap = map;
                this.val$element = psiElement;
            }

            @Override
            public void run() {
                for (OCFile oldFile : this.val$filesMap.keySet()) {
                    OCFile newFile = (OCFile)this.val$filesMap.get(oldFile);
                    OCChangeUtil.changeText(this.val$element.getProject(), oldFile, 0, oldFile.getTextLength(), newFile.getText(), true);
                }
            }
        });
    }

    @Override
    public void doClone(PsiElement element) {
        PsiDirectory targetDirectory = element instanceof PsiDirectory ? ((PsiDirectory)element).getParentDirectory() : ((PsiFile)element).getContainingDirectory();
        PsiElement[] elements = new PsiElement[]{element};
        CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(elements, null, element.getProject(), true);
        if (dialog.showAndGet()) {
            new MyProcessor(elements, dialog.getNewName()).process(element.getProject(), (PsiElement)targetDirectory);
        }
    }

    private class MyProcessor
    extends OCCopyMoveProcessor<M, R, G, P> {
        private String myNewName;

        private MyProcessor(PsiElement[] elements, String newName) {
            super(elements);
            this.myNewName = newName;
        }

        @Override
        protected void doActionForExternalFiles(final Project project2, @NotNull P projectFile, final @NotNull List<VirtualFile> notInProjectFiles, G targetGroup, final @NotNull PsiDirectory targetDirectory) {
            new WriteCommandAction(project2, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    try {
                        for (VirtualFile file2 : notInProjectFiles) {
                            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
                            if (psiFile == null) continue;
                            MyProcessor.this.doCopy(targetDirectory, (PsiFileSystemItem)psiFile);
                        }
                    }
                    catch (IOException e) {
                        Messages.showErrorDialog((String)("Failed to copy files to \"" + targetDirectory.getName() + "\""), (String)"Error");
                    }
                }
            }.execute();
        }

        @Override
        protected void doAction(@NotNull OCCopyMoveProcessor.Helper<M, R, G, P> helper, @NotNull P projectFile, @NotNull PsiDirectory targetDir, @NotNull G targetRef, @NotNull List<R> sourceRefs) {
            ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
            ArrayList<PsiFile> filesToReveal = new ArrayList<PsiFile>();
            try {
                for (PsiElement element : this.myElements) {
                    if (OCCopyFilesHandlerDelegate.this.skipElement(element) || !(element instanceof PsiFile) && !(element instanceof PsiDirectory)) continue;
                    PsiFile newFile = this.doCopy(targetDir, (PsiFileSystemItem)element);
                    if (element instanceof OCFile && this.myNewName != null && !this.myNewName.equals(((PsiFileSystemItem)element).getName()) && StringUtil.isJavaIdentifier((String)FileUtil.getNameWithoutExtension((String)this.myNewName))) {
                        this.cloneClass((OCFile)element, (OCFile)newFile);
                    }
                    if (newFile == null) continue;
                    filesToReveal.add(newFile);
                    VirtualFile newVirtualFile = element instanceof PsiFile ? newFile.getVirtualFile() : newFile.getContainingDirectory().getVirtualFile();
                    if (newVirtualFile == null) continue;
                    newFiles.add(newVirtualFile);
                }
                HashSet<String> targets = new HashSet<String>();
                for (Object ref : sourceRefs) {
                    OCCopyFilesHandlerDelegate.this.addTargets(targets, ref);
                }
                if (!newFiles.isEmpty()) {
                    OCCopyFilesHandlerDelegate.this.addFiles(targetDir, targetRef, newFiles, targets);
                }
                for (PsiFile file2 : filesToReveal) {
                    EditorHelper.openInEditor((PsiElement)file2);
                }
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)("Failed to copy files to \"" + targetDir.getName() + "\""), (String)"Error");
            }
        }

        protected void cloneClass(OCFile oldFile, OCFile newFile) {
            OCSymbolDeclarator oldClazz = oldFile.findClass(oldFile.getMainClassName());
            Project project2 = oldFile.getProject();
            if (oldClazz == null) {
                OCFile associatedFile = oldFile.getAssociatedFile();
                OCSymbolDeclarator oCSymbolDeclarator = oldClazz = associatedFile != null ? associatedFile.findClass(oldFile.getMainClassName()) : null;
            }
            if (oldClazz == null) {
                return;
            }
            OCRenameProcessor processor2 = new OCRenameProcessor();
            LocalSearchScope scope = new LocalSearchScope((PsiElement)oldFile);
            final ArrayList<Integer> offsets = new ArrayList<Integer>();
            final VirtualFile virtualFile = oldFile.getVirtualFile();
            Object symbol = oldClazz.getSymbol();
            for (PsiReference reference : processor2.findReferences((PsiElement)oldClazz, (SearchScope)scope)) {
                offsets.add(reference.getElement().getTextOffset() + reference.getRangeInElement().getStartOffset());
            }
            for (PsiReference reference : processor2.findReferences((PsiElement)oldFile.getAssociatedFile(), (SearchScope)scope)) {
                offsets.add(reference.getElement().getTextOffset() + reference.getRangeInElement().getStartOffset());
            }
            if (symbol instanceof OCStructSymbol && virtualFile != null) {
                ((OCStructSymbol)symbol).processConstructors((Processor<? super OCFunctionSymbol>)new Processor<OCFunctionSymbol>(){

                    public boolean process(OCFunctionSymbol symbol) {
                        if (virtualFile.equals(symbol.getContainingFile())) {
                            offsets.add(symbol.getOffset());
                        }
                        return true;
                    }
                });
            }
            if (symbol != null && virtualFile != null) {
                symbol.processSameSymbols(new Processor<OCSymbol>(){

                    public boolean process(OCSymbol symbol) {
                        if (virtualFile.equals(symbol.getContainingFile())) {
                            offsets.add(symbol.getOffset());
                        }
                        return true;
                    }
                });
            }
            Collections.sort(offsets, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o2 - o1;
                }
            });
            String oldName = ((PsiNamedElement)oldClazz).getName();
            String newName = FileUtil.getNameWithoutExtension((String)this.myNewName);
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)newFile);
            if (document != null) {
                PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
                for (Integer offset : offsets) {
                    document.replaceString(offset.intValue(), offset + oldName.length(), (CharSequence)newName);
                }
                PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            }
        }

        private PsiFile doCopy(PsiDirectory targetDir, PsiFileSystemItem fileSystemItem) throws IOException {
            String newName = this.myNewName == null ? fileSystemItem.getName() : (fileSystemItem instanceof OCFile && this.myElements.contains(((OCFile)fileSystemItem).getAssociatedFile()) ? FileUtil.getNameWithoutExtension((String)this.myNewName) + "." + FileUtilRt.getExtension((String)fileSystemItem.getName()) : this.myNewName);
            String newUniqueName = newName;
            final String errorMessage = OCCopyMoveProcessor.checkOperationIsValid(fileSystemItem, targetDir, newUniqueName, true, false);
            if (errorMessage != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)errorMessage, (String)"Error");
                    }
                });
                return null;
            }
            int i = 1;
            while (OCCopyMoveProcessor.checkOperationIsValid(fileSystemItem, targetDir, newUniqueName, false, false) != null) {
                newUniqueName = FileUtil.getNameWithoutExtension((String)newName) + " copy";
                if (i > 1) {
                    newUniqueName = newUniqueName + " " + i;
                }
                newUniqueName = newUniqueName + "." + FileUtilRt.getExtension((String)newName);
                ++i;
            }
            return CopyFilesOrDirectoriesHandler.copyToDirectory(fileSystemItem, newUniqueName, targetDir);
        }

        @Override
        protected OCCopyMoveProcessor.Helper<M, R, G, P> getHelper() {
            return OCCopyFilesHandlerDelegate.this.getHelper();
        }
    }
}

