/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import org.jetbrains.annotations.NotNull;

public class OCMemberInfo
extends MemberInfoBase<OCSymbolHolderVirtualPsiElement> {
    private OCVisibility myVisibility;
    private OCSymbol mySymbol;
    private boolean isAbstract;

    public OCMemberInfo(OCSymbol symbol, OCMembersContainer parent) {
        this(symbol, symbol, false, parent);
    }

    public OCMemberInfo(final OCSymbol intfSymbol, OCSymbol implSymbol, boolean nameWithParent, OCMembersContainer parent) {
        super((PsiElement)new OCSymbolHolderVirtualPsiElement(implSymbol));
        this.mySymbol = implSymbol;
        this.displayName = intfSymbol.getPresentableName();
        this.myVisibility = OCVisibility.getDeclaredVisibility(this.mySymbol);
        if (nameWithParent && intfSymbol instanceof OCSymbolWithParent) {
            this.displayName = ((OCSymbolWithParent)intfSymbol).getNameWithParent();
        }
        if (intfSymbol instanceof OCMemberSymbol) {
            this.isAbstract = ((OCMemberSymbol)this.mySymbol).getParent() instanceof OCProtocolSymbol;
        }
        if (this.myVisibility == null || intfSymbol.getKind() == OCSymbolKind.PROPERTY) {
            this.myVisibility = OCVisibility.PUBLIC;
        }
        if (intfSymbol instanceof OCDeclaratorSymbol) {
            this.isStatic = ((OCDeclaratorSymbol)intfSymbol).isStatic();
        } else if (intfSymbol instanceof OCFunctionSymbol) {
            this.isStatic = ((OCFunctionSymbol)intfSymbol).isStatic();
            this.isAbstract = ((OCFunctionSymbol)intfSymbol).isPureVirtual();
            this.displayName = ((OCFunctionSymbol)intfSymbol).getSignatureWithoutParamNames(nameWithParent, true);
        } else if (intfSymbol instanceof OCMethodSymbol) {
            this.isStatic = ((OCMethodSymbol)intfSymbol).isStatic();
            if (!nameWithParent) {
                this.displayName = intfSymbol.getSignature();
            }
        } else if (parent instanceof OCClassSymbol && intfSymbol instanceof OCProtocolSymbol) {
            this.displayName = "conforms to " + intfSymbol.getNameWithKindLowercase();
            this.isAbstract = true;
        } else if (parent instanceof OCStructSymbol && intfSymbol instanceof OCStructSymbol && ((OCStructSymbol)intfSymbol).getParent() != parent) {
            this.displayName = "super " + intfSymbol.getNameWithKindLowercase();
            this.isAbstract = true;
        }
        if ((parent instanceof OCClassSymbol || parent instanceof OCStructSymbol) && intfSymbol instanceof OCSymbolWithParent) {
            OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)intfSymbol, new Processor<OCSymbolWithParent>(){

                public boolean process(OCSymbolWithParent symbol) {
                    if (symbol.getParent() instanceof OCClassSymbol && symbol.getParent().getName().equals(((OCSymbolWithParent)intfSymbol).getParent().getName())) {
                        return true;
                    }
                    if (symbol.getParent() instanceof OCProtocolSymbol || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isVirtual()) {
                        OCMemberInfo.this.overrides = Boolean.FALSE;
                        return true;
                    }
                    OCMemberInfo.this.overrides = Boolean.TRUE;
                    return false;
                }
            }, true, false);
        }
    }

    public OCMemberInfo(OCStructSymbol member, OCVisibility visibility, OCMembersContainer parent) {
        this(member, parent);
        this.myVisibility = visibility;
    }

    public OCSymbol getSymbol() {
        return this.mySymbol;
    }

    @NotNull
    public OCVisibility getVisibility() {
        return this.myVisibility;
    }

    public String getDisplayNameWithKind() {
        return this.mySymbol.getKindUppercase() + " '" + this.getDisplayName() + "'";
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }
}

