/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseIntroduceHandler;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class OCBaseLocalConvertibleHandler
extends OCBaseIntroduceHandler<PsiElement> {
    protected OCBaseLocalConvertibleHandler(String refactoringName) {
        super("an expression or a local declarator", refactoringName, OCExpression.class, OCDeclarator.class);
    }

    @Override
    protected PsiElement substituteElement(PsiElement element) {
        if (element instanceof OCReferenceExpression) {
            OCSymbol symbol = ((OCReferenceExpression)element).resolveToSymbol();
            if (symbol != null && symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE) {
                Object definition = symbol.locateDefinition();
                return definition instanceof OCDeclarator ? ((OCDeclarator)definition).getNameIdentifier() : null;
            }
            return super.substituteElement(element);
        }
        if (element instanceof OCDeclarator) {
            OCSymbol symbol = ((OCDeclarator)element).getSymbol();
            if (symbol != null && symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE) {
                return ((OCDeclarator)element).getNameIdentifier();
            }
        } else {
            return super.substituteElement(element);
        }
        return null;
    }

    @Override
    protected List<PsiElement> findElementOccurrences(PsiElement expression) {
        if (OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(expression)) {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            result.add(((OCDeclarator)expression.getParent()).getNameIdentifier());
            for (PsiReference reference : ReferencesSearch.search((PsiElement)expression.getParent(), (SearchScope)expression.getUseScope()).findAll()) {
                PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), OCExpression.class, (boolean)false);
                if (element == null) continue;
                result.add(element);
            }
            return result;
        }
        return super.findElementOccurrences(expression);
    }

    @Override
    protected boolean filterUsages(PsiElement expression) {
        return super.filterUsages(expression) && !OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(expression);
    }

    static boolean isDeclaratorIdentifier(PsiElement expression) {
        return OCElementUtil.getElementType(expression) == OCTokenTypes.IDENTIFIER && expression.getParent() instanceof OCDeclarator;
    }
}

