/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import java.util.Map;

public class OCInlineTypedefHandler
extends OCInlineActionHandlerBase<OCDeclarator> {
    @Override
    protected String getElementKind(OCDeclarator element) {
        return "typedef";
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof OCDeclarator && ((OCDeclaration)element.getParent()).isTypedef();
    }

    @Override
    protected String checkUsageValid(PsiElement usage, OCDeclarator element) {
        OCType elementType = element.getType();
        OCTypeElement typeElement = (OCTypeElement)PsiTreeUtil.getParentOfType((PsiElement)usage, OCTypeElement.class);
        if (typeElement != null && typeElement.getParent() instanceof OCFunctionDeclaration && elementType.getTerminalType() instanceof OCFunctionType) {
            return "Can't inline the function type in the return type of another function";
        }
        return null;
    }

    @Override
    protected void inlineUsage(PsiElement usage, OCDeclarator element, PsiElement elementData, Project project2, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        if (usage instanceof OCCppNamespaceQualifier) {
            OCCppNamespaceQualifier qualifier = OCElementFactory.declarationFromText("int " + element.getType().getCanonicalName(usage) + "::x;", usage).getDeclarators().get(0).getNamespaceQualifier();
            OCChangeUtil.replaceHandlingMacros(usage, qualifier);
            return;
        }
        if (!(usage instanceof OCReferenceElement)) {
            return;
        }
        OCTypeElement typeElement = (OCTypeElement)PsiTreeUtil.getParentOfType((PsiElement)usage, OCTypeElement.class);
        OCSymbol symbol = element.getSymbol();
        OCType elementType = element.getType();
        if (typeElement == null || symbol == null) {
            return;
        }
        if (typeElement.getParent() instanceof OCDeclaration) {
            for (OCDeclaration declaration : OCNormalizeUtil.normalizeDeclaration((OCDeclaration)typeElement.getParent())) {
                OCDeclarator declarator = declaration.getDeclarators().get(0);
                OCType newType = OCInlineTypedefHandler.transformType(symbol, elementType, declarator.getType(), element.getContainingFile());
                OCDeclaration newDeclaration = OCElementFactory.declarationStatement(declarator.getName(), newType, declarator.getInitializer(), declarator).getDeclaration();
                OCElementUtil.replaceDeclarationQualifiers(newDeclaration, declaration);
                OCElementUtil.replaceDeclarationQualifiers(newDeclaration.getTypeElement(), declaration.getTypeElement());
                OCChangeUtil.replaceHandlingMacros(declaration, newDeclaration);
            }
        } else {
            OCType newType = OCInlineTypedefHandler.transformType(symbol, elementType, typeElement.getType(), typeElement.getContainingFile());
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(newType.getBestNameInContext(usage), usage);
            OCChangeUtil.replaceHandlingMacros(typeElement, newTypeElement);
        }
    }

    private static OCType transformType(final OCSymbol symbol, final OCType elementType, OCType usageType, final PsiFile containingFile) {
        return usageType.transformType(new OCTypeCloneVisitor(false){

            @Override
            public OCType visitReferenceType(OCReferenceType type) {
                List<OCSymbol> symbols = type.getReference(containingFile).resolveToSymbols(containingFile);
                if (symbols.contains(symbol)) {
                    return type.isConst() ? elementType.cloneWithConstModifier(symbol.getProject()) : elementType;
                }
                return super.visitReferenceType(type);
            }
        });
    }
}

