/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDotCallUsage;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineMethodHandler;
import com.jetbrains.cidr.lang.refactoring.move.OCCodeMoveValidator;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OCInlineParameterHandler
extends OCInlineActionHandlerBase<PsiNamedElement> {
    @Override
    protected String getElementKind(PsiNamedElement element) {
        return "parameter";
    }

    public boolean canInlineElement(PsiElement element) {
        if (!(element instanceof OCDeclarator) && !(element instanceof OCMethodSelectorPart)) {
            return false;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        return symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.PARAMETER;
    }

    private static int getParamIndex(PsiNamedElement element, OCCallable callable) {
        if (callable instanceof OCMethod) {
            return ((OCMethod)callable).getParameters().indexOf((OCMethodSelectorPart)element);
        }
        if (callable instanceof OCFunctionDeclaration) {
            return ((OCFunctionDeclaration)callable).getParameterList().getParameterDeclarations().indexOf(element.getParent());
        }
        if (callable instanceof OCBlockExpression) {
            return ((OCBlockExpression)callable).getParameterList().getParameterDeclarations().indexOf(element.getParent());
        }
        if (callable instanceof OCLambdaExpression) {
            return ((OCLambdaExpression)callable).getParameterList().getParameterDeclarations().indexOf(element.getParent());
        }
        return -1;
    }

    @Override
    protected boolean allowInlineSingleUsage() {
        return false;
    }

    @Override
    protected String checkValidness(final PsiNamedElement element, List<PsiElement> usages, PsiElement selectedUsage, String elementNameWithKind, Editor editor, final Ref<PsiElement> elementData, List<String> warnings, boolean silentMode) {
        String superMessage = super.checkValidness(element, usages, selectedUsage, elementNameWithKind, editor, elementData, warnings, silentMode);
        if (superMessage != null) {
            return superMessage;
        }
        for (PsiElement usage : usages) {
            if (new OCReadWriteAccessDetector().getExpressionAccess(usage) == ReadWriteAccessDetector.Access.Read) continue;
            OCInlineParameterHandler.highlightUsages(element.getProject(), editor, Collections.singletonList(usage), EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
            OCInlineParameterHandler.showHighlightRemovalStatus(element.getProject());
            return StringUtil.capitalize((String)elementNameWithKind) + " is accessed for writing";
        }
        OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
        if (callable == null) {
            return "Cannot find the method/function";
        }
        if (callable instanceof OCBlockExpression) {
            return "Cannot inline the parameters of blocks";
        }
        if (callable instanceof OCLambdaExpression) {
            return "Cannot inline the parameters of lambdas";
        }
        OCSymbol callableSymbol = callable.getSymbol();
        if (callableSymbol == null) {
            return "SILENT_EXIT";
        }
        OCInlineMethodHandler.checkMethodsHierarchy(callable, callableSymbol.getNameWithKindLowercase(), warnings);
        String callableName = callableSymbol.getNameWithKindLowercase();
        int paramIndex = OCInlineParameterHandler.getParamIndex(element, callable);
        assert (paramIndex >= 0);
        if (!OCInlineParameterHandler.processCalls(callableSymbol, paramIndex, new Processor<OCExpression>(){

            public boolean process(OCExpression expression) {
                OCReferenceElement refElement;
                OCReferenceElement oCReferenceElement = refElement = expression instanceof OCReferenceExpression ? ((OCReferenceExpression)expression).getReferenceElement() : null;
                if (refElement != null && element.equals(refElement.resolve())) {
                    return true;
                }
                if (elementData.isNull()) {
                    elementData.set((Object)expression);
                } else if (!OCElementUtil.areElementsEquivalent((PsiElement)elementData.get(), expression, true)) {
                    return false;
                }
                return true;
            }
        })) {
            return "There are several call sites with different parameter initializers";
        }
        if (elementData.isNull()) {
            return "There are no usages of " + callableName;
        }
        OCCodeMoveValidator validator = new OCCodeMoveValidator(callable.getBody());
        ((PsiElement)elementData.get()).accept((PsiElementVisitor)validator);
        if (validator.isOutOfScope()) {
            warnings.add("Parameter initializer is not available in " + callableName + ": " + validator.getOutOfScopeMessage() + ".");
        }
        return null;
    }

    private static boolean processCalls(OCSymbol callable, int paramIndex, Processor<OCExpression> processor2) {
        HashSet methodUsages = new HashSet();
        OCSearchUtil.findAllMemberUsages((OCSymbolWithParent)callable, (Set<UsageInfo>)methodUsages, true, true);
        for (UsageInfo usage : methodUsages) {
            OCExpression kid;
            PsiElement parent;
            List<OCElement> arguments;
            PsiElement usageElement = usage.getElement();
            if (!(usage instanceof OCMethodCallUsage && usageElement instanceof OCSendMessageExpression ? (arguments = ((OCSendMessageExpression)usageElement).getArguments()).size() > paramIndex && !processor2.process((Object)arguments.get(paramIndex).getArgumentExpression()) : (usage instanceof OCMethodDotCallUsage && usageElement instanceof OCQualifiedExpression && paramIndex == 0 ? (parent = (kid = OCParenthesesUtils.topmostParenthesized((OCExpression)usageElement)).getParent()) instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getReceiverExpression() == kid && !processor2.process((Object)((OCAssignmentExpression)parent).getSourceExpression()) : usage instanceof OCFunctionUsage && usageElement instanceof OCReferenceElement && usageElement.getParent().getParent() instanceof OCCallExpression && (arguments = ((OCCallExpression)usageElement.getParent().getParent()).getArguments()).size() > paramIndex && !processor2.process((Object)arguments.get(paramIndex))))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void inlineUsage(PsiElement usage, PsiNamedElement element, PsiElement elementData, Project project2, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        if (!(usage instanceof OCReferenceElement) || !(usage.getParent() instanceof OCReferenceExpression)) {
            return;
        }
        usage = OCParenthesesUtils.replaceExpressionAndAppendParentheses((OCExpression)usage.getParent(), (OCExpression)elementData);
        OCImportSymbolFix.fixAllSymbolsRecursively(usage);
    }

    @Override
    protected void deleteElement(PsiNamedElement element, PsiElement elementData) {
        OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
        OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler(callable, true);
        handler2.setChangeAncestors(true);
        handler2.removeParameter(OCInlineParameterHandler.getParamIndex(element, callable));
        handler2.invokeSynchronously();
    }
}

