/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCCallableDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCBlockDefinitionUsage
extends OCCallableDefinitionUsage<OCBlockExpression> {
    public OCBlockDefinitionUsage(@NotNull OCBlockExpression element) {
        super(element, false);
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull OCBlockExpression block, @NotNull Project project2) {
        if (changeInfo.isParameterSetOrOrderChanged()) {
            return super.processUsage(changeInfo, block, project2);
        }
        if (changeInfo.isNameChanged() || changeInfo.isParameterTypesChanged()) {
            OCChangeSignatureUsageProcessor.processParameters(changeInfo, block, block.getParameterList(), project2, false);
        }
        if (changeInfo.isReturnTypeChanged()) {
            OCTypeElement typeElement = block.getReturnTypeElement();
            if (typeElement != null) {
                OCChangeUtil.replaceHandlingMacros(typeElement, OCElementFactory.typeElementFromText(changeInfo.getNewReturnType(), block));
            } else {
                PsiElement newMethod = OCChangeUtil.replaceHandlingMacros(block, OCChangeSignatureUsageProcessor.generateMethodDefinition(changeInfo, block, true, true, false));
                changeInfo.setNewMethod((OCCallable)newMethod);
                changeInfo.addNewMethod((OCCallable)newMethod);
            }
        }
        return true;
    }
}

