/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.ui.ListCellRendererWrapper;
import com.jetbrains.cidr.lang.actions.newFile.OCNewCategoryAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCGeneratedInfo;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class OCTargetSymbolPanel
extends ComboBoxVisibilityPanel<Object> {
    public static final Key<TargetSymbolsMode> VISIBILITY_KEY = Key.create((String)"VISIBILITY_KEY");
    private static final String SEPARATOR = "separator";

    public OCTargetSymbolPanel() {
        super("Targets:", new Object[0]);
    }

    @Override
    protected ListCellRendererWrapper getRenderer() {
        return new ListCellRendererWrapper<Object>(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof OCSymbol) {
                    this.setText(((OCSymbol)value).getPresentableName());
                    this.setIcon(((OCSymbol)value).getIcon());
                } else if (value instanceof Trinity) {
                    Trinity tuple = (Trinity)value;
                    this.setText(((OCClassSymbol)tuple.getFirst()).getPresentableName() + (String)tuple.getThird());
                    this.setIcon(((OCClassSymbol)tuple.getFirst()).getIcon());
                } else if (OCTargetSymbolPanel.SEPARATOR.equals(value)) {
                    this.setSeparator();
                } else if (value != null) {
                    this.setText(value.toString());
                }
            }
        };
    }

    public void fillData(final OCGeneratedInfo info) {
        final OCClassSymbol parent = (OCClassSymbol)info.getMethodParent();
        OCInterfaceSymbol interfaceSymbol = parent.getInterface();
        if (OCSearchScope.isInProjectSources(interfaceSymbol)) {
            String extensions = "  [" + OCTargetSymbolPanel.getExtension(interfaceSymbol, "h") + ", " + OCTargetSymbolPanel.getExtension(parent.getImplementation(), "m") + "]";
            this.addOption(new Trinity((Object)parent, (Object)TargetSymbolsMode.INTERFACE, (Object)extensions));
        }
        if (parent instanceof OCImplementationSymbol && OCSearchScope.isInProjectSources(parent)) {
            String extension = OCTargetSymbolPanel.getExtension(parent, "m");
            this.addOption(new Trinity((Object)parent, (Object)TargetSymbolsMode.IMPLEMENTATION, (Object)("  [" + (String)extension + "]")));
            this.addOption(new Trinity((Object)parent, (Object)TargetSymbolsMode.PRIVATE_CATEGORY, (Object)(" + ()  [" + (String)extension + "]")));
        }
        if (this.myComboBox.getItemCount() > 0 && (info.getAuxParents().size() > 0 || info.isAllowChangeCategories())) {
            this.addOption(SEPARATOR);
        }
        for (OCSymbol oCSymbol : info.getAuxParents()) {
            if (!OCSearchScope.isInProjectSources(oCSymbol)) continue;
            this.addOption(oCSymbol);
        }
        if (info.isAllowChangeCategories()) {
            OCType type = parent.getType().resolve(parent.getContainingOCFile(), true);
            if (type instanceof OCObjectType) {
                for (OCInterfaceSymbol category : ((OCObjectType)type).getCategoryInterfaces()) {
                    if (!OCSearchScope.isInProjectSources(category) || "".equals(category.getCategoryName())) continue;
                    this.addOption(category);
                }
            }
            if (this.myComboBox.getItemCount() > 0 && !SEPARATOR.equals(this.myComboBox.getItemAt(this.myComboBox.getItemCount() - 1))) {
                this.addOption(SEPARATOR);
            }
            this.addOption("New category of " + parent.getName() + "...");
        }
        this.myComboBox.setSelectedIndex(this.getFirstSelectionIndex(parent));
        this.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object item = OCTargetSymbolPanel.this.myComboBox.getSelectedItem();
                if (item instanceof Trinity) {
                    TargetSymbolsMode mode = (TargetSymbolsMode)((Object)((Trinity)item).getSecond());
                    parent.getProject().putUserData(VISIBILITY_KEY, (Object)mode);
                    info.setTargetSymbolsMode(mode);
                } else if (item.toString().startsWith("New category")) {
                    OCTargetSymbolPanel.this.createNewCategory(info);
                } else if (item instanceof OCClassSymbol) {
                    info.setMethodParent((OCSymbol)item);
                    info.setTargetSymbolsMode(TargetSymbolsMode.INTERFACE);
                }
            }
        });
        Object item = this.myComboBox.getSelectedItem();
        if (item instanceof Trinity) {
            info.setTargetSymbolsMode((TargetSymbolsMode)((Object)((Trinity)item).getSecond()));
        } else if (item instanceof OCClassSymbol) {
            info.setMethodParent((OCSymbol)item);
            info.setTargetSymbolsMode(TargetSymbolsMode.INTERFACE);
        }
    }

    private int getFirstSelectionIndex(OCClassSymbol parent) {
        int selectionIndex = 0;
        for (int i = 0; i < this.myComboBox.getItemCount(); ++i) {
            Object item = this.myComboBox.getItemAt(i);
            if (!(item instanceof Trinity) || ((Trinity)item).getSecond() != TargetSymbolsMode.IMPLEMENTATION) continue;
            selectionIndex = i;
            break;
        }
        return selectionIndex;
    }

    public boolean isOnlyNewCategoryAllowed() {
        return this.myComboBox.getItemCount() == 1 && this.myComboBox.getItemAt(0).toString().startsWith("New category");
    }

    public boolean createNewCategory(OCGeneratedInfo info) {
        OCClassSymbol category;
        PsiFile[] elements;
        final OCClassSymbol parent = (OCClassSymbol)info.getMethodParent();
        OCFile file2 = OCSearchScope.isInProjectSources(parent) ? parent.getContainingOCFile() : (OCFile)info.getMethodReference().getContainingFile();
        if (file2 == null) {
            return false;
        }
        OCNewCategoryAction action = new OCNewCategoryAction(){

            @Override
            protected OCClassSymbol getBaseClass() {
                return parent;
            }
        };
        action.performAction(parent.getProject(), file2.getParent(), file2, null);
        if (!this.isOnlyNewCategoryAllowed()) {
            this.myComboBox.setSelectedIndex(this.getFirstSelectionIndex(parent));
        }
        if ((elements = action.getCreatedElements()) != null && elements.length > 0 && elements[0] instanceof OCFile && (category = OCCodeInsightUtil.getClassInFile((OCFile)elements[0])) != null) {
            this.addOption(this.myComboBox.getItemCount() == 1 ? 0 : this.myComboBox.getItemCount() - 2, category, category.getPresentableName(), true);
            info.setMethodParent(category);
            info.setTargetSymbolsMode(TargetSymbolsMode.INTERFACE);
            return true;
        }
        return false;
    }

    private static String getExtension(@Nullable OCClassSymbol symbol, String defaultExtension) {
        VirtualFile file2;
        VirtualFile virtualFile = file2 = symbol != null ? symbol.getContainingFile() : null;
        if (file2 == null || defaultExtension.equals("h") && !OCFileImpl.isHeaderFile(file2.getName()) || defaultExtension.equals("m") && !OCFileImpl.isSourceCodeFile(file2.getName())) {
            return "." + defaultExtension;
        }
        return "." + FileUtilRt.getExtension((String)file2.getName());
    }

    public static enum TargetSymbolsMode {
        INTERFACE,
        PRIVATE_CATEGORY,
        IMPLEMENTATION;

    }
}

