/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCTargetSymbolPanel;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OCGeneratedInfo {
    private PsiElement myMethodReference;
    private OCSymbol myMethodParent;
    private OCTargetSymbolPanel.TargetSymbolsMode myTargetSymbolsMode;
    private boolean myAllowChangeCategories;
    private List<? extends OCClassSymbol> myAuxParents;
    private List<PsiElement> myMethodStatements;
    private String myCallString;
    private List<PsiElement> myBeforeCallStatements;
    private List<PsiElement> myAfterCallStatements;
    private List<Pair<Integer, Runnable>> myCallbacks = new ArrayList<Pair<Integer, Runnable>>();
    private boolean myStatic;
    private boolean mySelectMethod;

    public OCGeneratedInfo(@Nullable Project project2) {
        if (project2 != null) {
            this.myTargetSymbolsMode = (OCTargetSymbolPanel.TargetSymbolsMode)((Object)project2.getUserData(OCTargetSymbolPanel.VISIBILITY_KEY));
        }
        if (this.myTargetSymbolsMode == null) {
            this.myTargetSymbolsMode = OCTargetSymbolPanel.TargetSymbolsMode.INTERFACE;
        }
    }

    public List<PsiElement> getBeforeCallStatements() {
        return this.myBeforeCallStatements;
    }

    public void setBeforeCallStatements(List<PsiElement> beforeCallStatements) {
        this.myBeforeCallStatements = beforeCallStatements;
    }

    public List<PsiElement> getAfterCallStatements() {
        return this.myAfterCallStatements;
    }

    public void setAfterCallStatements(List<PsiElement> afterCallStatements) {
        this.myAfterCallStatements = afterCallStatements;
    }

    public String getCallString() {
        return this.myCallString;
    }

    public void setCallString(String callString) {
        this.myCallString = callString;
    }

    public OCSymbol getMethodParent() {
        return this.myMethodParent;
    }

    public boolean isAllowChangeCategories() {
        return this.myAllowChangeCategories;
    }

    public List<? extends OCClassSymbol> getAuxParents() {
        return this.myAuxParents;
    }

    public void setMethodParent(OCSymbol methodParent) {
        this.setMethodParent(methodParent, false, Collections.emptyList());
    }

    public void setMethodParent(OCSymbol methodParent, boolean allowChangeCategories, List<? extends OCClassSymbol> auxParents) {
        this.myMethodParent = methodParent;
        this.myAllowChangeCategories = allowChangeCategories;
        this.myAuxParents = auxParents;
    }

    public OCTargetSymbolPanel.TargetSymbolsMode getTargetSymbolsMode() {
        return this.myTargetSymbolsMode;
    }

    public void setTargetSymbolsMode(OCTargetSymbolPanel.TargetSymbolsMode targetSymbolsMode) {
        this.myTargetSymbolsMode = targetSymbolsMode;
    }

    public PsiElement getMethodReference() {
        return this.myMethodReference;
    }

    public void setMethodReference(PsiElement methodReference) {
        this.myMethodReference = methodReference;
    }

    public List<PsiElement> getMethodStatements() {
        return this.myMethodStatements;
    }

    public void setMethodStatements(List<PsiElement> methodStatements) {
        this.myMethodStatements = methodStatements;
    }

    public void runOnSuccess(Runnable callback, int rank) {
        this.myCallbacks.add((Pair<Integer, Runnable>)new Pair((Object)rank, (Object)callback));
    }

    public List<Pair<Integer, Runnable>> getCallbacks() {
        return this.myCallbacks;
    }

    public void runOnSuccess(Runnable callback) {
        this.runOnSuccess(callback, -1000);
    }

    public boolean isStatic() {
        return this.myStatic;
    }

    public void setStatic(boolean aStatic) {
        this.myStatic = aStatic;
    }

    public boolean isSelectMethod() {
        return this.mySelectMethod;
    }

    public void setSelectMethod(boolean selectMethod) {
        this.mySelectMethod = selectMethod;
    }

    public List<PsiFile> getFilesToWrite() {
        ArrayList<PsiFile> files = new ArrayList<PsiFile>();
        if (this.myMethodParent == null) {
            return files;
        }
        if (this.myMethodParent instanceof OCClassSymbol) {
            OCClassSymbol anInterface;
            OCImplementationSymbol implementation = ((OCClassSymbol)this.myMethodParent).getImplementation();
            if (implementation != null) {
                files.add(implementation.getContainingOCFile());
            }
            if (this.myTargetSymbolsMode == OCTargetSymbolPanel.TargetSymbolsMode.INTERFACE && (anInterface = ((OCClassSymbol)this.myMethodParent).getInterfaceOrProtocol()) != null) {
                ContainerUtil.addIfNotNull(files, (Object)anInterface.getContainingOCFile());
            }
        } else {
            files.add(this.myMethodParent.getContainingOCFile());
        }
        return files;
    }
}

