/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCBlockDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCGeneratedCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCGeneratedMethodUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCParameterUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelectorExpressionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelfSuperUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    protected static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.refactoring.changeSignature.ChangeSignatureUsageProcessor");
    private static final String BLOCK_CONFLICT = OCBundle.message("changeSignature.usages.cantConvertToBlock", new Object[0]);

    public UsageInfo[] findUsages(ChangeInfo info) {
        if (!(info instanceof OCChangeInfo)) {
            return UsageInfo.EMPTY_ARRAY;
        }
        return OCChangeSignatureUsageProcessor.findUsages((OCChangeInfo)info, false);
    }

    private static UsageInfo[] findUsages(@NotNull OCChangeInfo info, boolean onlyCalls) {
        OCCallable method = info.getMethod();
        if (!method.isValid()) {
            return UsageInfo.EMPTY_ARRAY;
        }
        HashSet result = new HashSet();
        if (info.getGenerated().getMethodReference() != null) {
            result.add(new OCGeneratedMethodUsage(info.getGenerated().getMethodReference()));
            if (info.getGenerated().getCallString() != null) {
                result.add(new OCGeneratedCallUsage(info.getGenerated().getMethodReference()));
            }
        }
        OCChangeSignatureUsageProcessor.findAllMethodUsages(info, method, onlyCalls, (Set<UsageInfo>)result);
        for (final Pair<Integer, Runnable> pair : info.getGenerated().getCallbacks()) {
            result.add(new OCUsageInfo<PsiElement>(info.getContext()){

                @Override
                public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull PsiElement element, @NotNull Project project2) {
                    ((Runnable)pair.getSecond()).run();
                    return true;
                }

                @Override
                public int getUsageRank() {
                    return (Integer)pair.getFirst();
                }

                public int hashCode() {
                    return 0;
                }

                public boolean equals(Object o) {
                    return this == o;
                }
            });
        }
        return result.toArray(new UsageInfo[result.size()]);
    }

    private static void findAllMethodUsages(final @NotNull OCChangeInfo info, final OCCallable method, final boolean onlyCalls, final Set<UsageInfo> result) {
        OCChangeSignatureUsageProcessor.findOneMethodUsages(method, info, result, onlyCalls, false);
        if (method instanceof OCBlockExpression || !info.isChangeUsages()) {
            return;
        }
        OCSearchUtil.processMembersHierarchyPsi((OCSymbolWithParent)method.getSymbol(), new Processor<PsiElement>(){

            public boolean process(PsiElement element) {
                if (element instanceof OCCallable && !Comparing.equal((Object)element, (Object)method)) {
                    OCChangeSignatureUsageProcessor.findOneMethodUsages((OCCallable)element, info, result, onlyCalls, true);
                }
                return true;
            }
        }, info.isChangeAncestors(), true);
    }

    private static void findOneMethodUsages(OCCallable method, OCChangeInfo info, Set<UsageInfo> result, boolean onlyCalls, boolean isInherited) {
        List<PsiNamedElement> parameters;
        if (info.isChangeUsages()) {
            OCSearchUtil.findOneMethodUsages(method, result);
            String oldName = info.getMethod().getName();
            if (oldName != null && !oldName.isEmpty()) {
                TextOccurrencesUtil.findNonCodeUsages(method, oldName, true, true, info.getNewName(), result);
            }
        }
        if (onlyCalls) {
            return;
        }
        if (info.getGenerated().getMethodReference() == null) {
            if (method instanceof OCFunctionDeclaration) {
                result.add(new OCFunctionDefinitionUsage((OCFunctionDeclaration)method, isInherited));
            } else if (method instanceof OCBlockExpression) {
                result.add(new OCBlockDefinitionUsage((OCBlockExpression)method));
            } else if (method instanceof OCMethod) {
                result.add(new OCMethodDefinitionUsage((OCMethod)method, isInherited));
            }
        }
        if ((parameters = method.getParameters()) == null) {
            return;
        }
        for (OCParameterInfo newParam : info.getNewParameters()) {
            PsiNamedElement oldParam;
            if (newParam.getUsages() != null) {
                for (PsiReference usage : newParam.getUsages()) {
                    result.add(new OCParameterUsage(usage, newParam, method, isInherited));
                }
            }
            if (newParam.getOldIndex() < 0 || newParam.getOldIndex() >= parameters.size() || Comparing.equal((String)(oldParam = parameters.get(newParam.getOldIndex())).getName(), (String)newParam.getName())) continue;
            for (PsiReference ref : ReferencesSearch.search((PsiElement)oldParam, (SearchScope)oldParam.getUseScope())) {
                if (newParam.getName().isEmpty()) {
                    result.add((UsageInfo)new UnresolvableCollisionUsageInfo(ref.getElement(), (PsiElement)oldParam){

                        @Override
                        public String getDescription() {
                            return OCBundle.message("changeSignature.usages.cantBeUnnamed", oldParam.getName());
                        }
                    });
                    continue;
                }
                result.add(new OCParameterUsage(ref, newParam, method, isInherited));
            }
        }
        Set newIndices = ContainerUtil.map2Set((Object[])info.getNewParameters(), (Function)new Function<OCParameterInfo, Integer>(){

            public Integer fun(OCParameterInfo info) {
                return info.getOldIndex();
            }
        });
        for (int i = 0; i < parameters.size(); ++i) {
            if (newIndices.contains(i)) continue;
            final PsiNamedElement oldParam = parameters.get(i);
            for (PsiReference ref : ReferencesSearch.search((PsiElement)oldParam, (SearchScope)oldParam.getUseScope())) {
                result.add((UsageInfo)new UnresolvableCollisionUsageInfo(ref.getElement(), (PsiElement)oldParam){

                    @Override
                    public String getDescription() {
                        return OCBundle.message("changeSignature.usages.cantBeRemoved", oldParam.getName());
                    }
                });
            }
        }
        for (OCReferenceExpression expr : info.getOldMethodDescriptor().getSelfReferences()) {
            if (!expr.isValid()) continue;
            result.add(new OCSelfSuperUsage(expr));
        }
    }

    public static boolean canProceedWithConflict(String conflict) {
        return !conflict.startsWith(BLOCK_CONFLICT);
    }

    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages;
        if (!(info instanceof OCChangeInfo)) {
            return MultiMap.empty();
        }
        final MultiMap result = new MultiMap();
        final PsiElement method = info.getMethod();
        final OCChangeInfo changeInfo = (OCChangeInfo)info;
        final String fullNewName = (Object)((Object)changeInfo.getNewCallableKind()) + " '" + changeInfo.getNewName() + "'";
        if (!changeInfo.willBeMethod()) {
            for (UsageInfo usage : (UsageInfo[])refUsages.get()) {
                PsiElement element = usage.getElement();
                if (!(element instanceof OCSelectorExpression)) continue;
                result.putValue((Object)usage.getElement(), (Object)OCBundle.message("changeSignature.usages.cantConvertSelectorToFuncBlock", new Object[0]));
            }
            usages = OCChangeSignatureUsageProcessor.findUsages((OCChangeInfo)info, true);
            if (changeInfo.willBeBlock() && !(changeInfo.getMethod() instanceof OCBlockExpression) && changeInfo.getGenerated().getMethodReference() == null) {
                for (UsageInfo usage : (UsageInfo[])refUsages.get()) {
                    PsiElement psiElement = usage.getElement();
                    if (psiElement == null || ((Object)((Object)OCLanguage.getInstance())).equals(psiElement.getLanguage())) continue;
                    result.putValue((Object)usage.getElement(), (Object)OCBundle.message("changeSignature.usages.cantConvertLanguage", psiElement.getLanguage().getDisplayName()));
                }
                if (usages.length == 0) {
                    result.putValue((Object)method, (Object)(BLOCK_CONFLICT + " " + OCBundle.message("changeSignature.usages.noUsagesFound", new Object[0])));
                } else if (usages.length > 1) {
                    result.putValue((Object)method, (Object)(BLOCK_CONFLICT + " " + OCBundle.message("changeSignature.usages.moreThan1Found", new Object[0])));
                } else if (PsiTreeUtil.isAncestor((PsiElement)changeInfo.getMethod(), (PsiElement)usages[0].getElement(), (boolean)true)) {
                    result.putValue((Object)method, (Object)(BLOCK_CONFLICT + " " + OCBundle.message("changeSignature.usages.usageInsideFunction", new Object[0])));
                }
            }
        }
        if (changeInfo.willBeFunction()) {
            OCQualifiedName name;
            OCSymbolWithQualifiedName originalSymbol;
            OCSymbolWithQualifiedName oCSymbolWithQualifiedName = originalSymbol = method instanceof OCFunctionDeclaration ? (OCSymbolWithQualifiedName)((OCFunctionDeclaration)method).getSymbol() : null;
            final OCQualifiedName parentName = originalSymbol != null ? ((name = originalSymbol.getResolvedQualifiedName()) != null ? name.getQualifier() : OCQualifiedName.GLOBAL) : OCQualifiedName.GLOBAL;
            List parameterTypes = ContainerUtil.map((Object[])changeInfo.getNewParameters(), (Function)new Function<OCParameterInfo, OCType>(){

                public OCType fun(OCParameterInfo info) {
                    OCType result = info.getType();
                    return result != null ? result.resolve(changeInfo.getContext().getContainingFile()) : OCUnknownType.INSTANCE;
                }
            });
            final OCFunctionType functionType = new OCFunctionType(OCVoidType.instance(), parameterTypes);
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(method.getProject(), new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    boolean conflict = false;
                    if (symbol instanceof OCSymbolWithQualifiedName && (!symbol.isSameSymbol(originalSymbol) || !method.isPhysical()) && OCResolveUtil.isDuplicate(OCSymbolKind.FUNCTION_DECLARATION, symbol.getKind())) {
                        OCQualifiedName name = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName();
                        if (name != null && Comparing.equal((Object)parentName, (Object)name.getQualifier())) {
                            if (symbol instanceof OCFunctionSymbol && (((OCFile)method.getContainingFile()).isCpp() || symbol.getAttributes().contains("overloadable"))) {
                                OCType type = symbol.getResolvedType();
                                OCTypeEqualityVisitor visitor = new OCTypeEqualityVisitor(type, false, new OCResolveContext(method));
                                if (type instanceof OCFunctionType && visitor.isFunctionSignatureEqual(functionType)) {
                                    conflict = true;
                                }
                            } else {
                                conflict = true;
                            }
                        }
                        if (conflict) {
                            String kind = symbol.getKindLowercase();
                            OCQualifiedName symbolName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName();
                            if (symbolName != null) {
                                String conflictWith = kind + " " + symbolName.dropSuperQualifier().toString() + (symbol instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol).getParamsSignatureWithoutNames() : "");
                                result.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.willConflictWith", fullNewName, conflictWith));
                            }
                        }
                    }
                    return true;
                }
            }, info.getNewName());
        } else if (changeInfo.willBeMethod()) {
            OCClassSymbol generatedParent;
            OCClassDeclaration parentClass;
            usages = (UsageInfo[])refUsages.get();
            int numOfFunctions = 0;
            for (UsageInfo usageInfo : usages) {
                if (!(usageInfo.getElement() instanceof OCFunctionDefinition)) continue;
                ++numOfFunctions;
            }
            if (numOfFunctions > 1) {
                for (UsageInfo usageInfo : usages) {
                    if (!(usageInfo.getElement() instanceof OCFunctionDefinition)) continue;
                    result.putValue((Object)usageInfo.getElement(), (Object)OCBundle.message("changeSignature.usages.functionHasSeveralDefinitions", changeInfo.getNewName()));
                }
            }
            if ((parentClass = OCElementUtil.resolveClassDeclaration(generatedParent = (OCClassSymbol)changeInfo.getGenerated().getMethodParent())) == null) {
                parentClass = changeInfo.getNewContainerClass();
            }
            if (parentClass != null && (changeInfo.isNameChanged() || generatedParent != null)) {
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(changeInfo.getNewName(), parentClass.getSymbol(), method.getProject(), OCMethodSymbol.class, changeInfo.getMethod() instanceof OCMethod && ((OCMethod)changeInfo.getMethod()).isInstanceMethod() ? OCObjectTypeContext.StaticMode.INSTANCE : OCObjectTypeContext.StaticMode.STATIC);
                parameters.setIncludeSelfImplementation(true);
                parameters.setAncestors(true);
                OCMemberInheritorsSearch.search(parameters).forEach((Processor)new Processor<OCMethodSymbol>(){

                    public boolean process(OCMethodSymbol methodSymbol) {
                        result.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.willConflictWithMethod", fullNewName, ((OCClassSymbol)methodSymbol.getParent()).getNameWithKindLowercase()));
                        return true;
                    }
                });
            }
        }
        OCBlockStatement body = ((OCCallable)info.getMethod()).getBody();
        HashSet set = new HashSet();
        for (ParameterInfo parameterInfo : info.getNewParameters()) {
            if (parameterInfo.getName().isEmpty() || set.add(parameterInfo.getName())) continue;
            result.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.atLeasTwoParams", parameterInfo.getName()));
        }
        if (body != null) {
            for (ParameterInfo parameterInfo : info.getNewParameters()) {
                OCResolveUtil.processLocalSymbols(parameterInfo.getName(), body.getClosingBrace(), new Processor<OCSymbol>(){

                    public boolean process(OCSymbol symbol) {
                        if (symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE) {
                            result.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.conflictsWithNewParameter", symbol.getNameWithKindUppercase()));
                        }
                        return true;
                    }
                });
            }
        }
        for (ParameterInfo parameterInfo : (UsageInfo[])refUsages.get()) {
            PsiElement element;
            if (parameterInfo instanceof OCSelectorExpressionUsage) {
                element = parameterInfo.getElement();
                if (!(element instanceof OCSelectorExpression) || OCSelectorAdHocResolver.getActionTargetContext((OCExpression)element) != null) continue;
                result.putValue((Object)element, (Object)OCBundle.message("changeSignature.usages.unrelatedSelector", new Object[0]));
                continue;
            }
            if (!(parameterInfo instanceof OCMethodCallUsage) || !((element = parameterInfo.getElement()) instanceof OCSendMessageExpression) || ((OCSendMessageExpression)element).getProbableResponders().getKnownResponder() != null) continue;
            result.putValue((Object)element, (Object)OCBundle.message("changeSignature.usages.unrelatedSelector", new Object[0]));
        }
        return result;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages) {
        if (!(usageInfo instanceof OCUsageInfo)) {
            return false;
        }
        if (beforeMethodChange) {
            return true;
        }
        Project project2 = changeInfo.getMethod().getProject();
        PsiElement element = usageInfo.getElement();
        return ((OCUsageInfo)usageInfo).processUsage((OCChangeInfo)changeInfo, element, project2);
    }

    public static void processParameters(OCChangeInfo changeInfo, OCCallable function, OCParameterList parameters, Project project2, boolean isInherited) {
        int paramIndex = 0;
        if (parameters != null) {
            OCParameterInfo[] newParameters = changeInfo.getNewParameters();
            for (OCParameterDeclaration parameter : parameters.getParameterDeclarations()) {
                OCTypeElement typeElement = parameter.getTypeElement();
                if (paramIndex >= newParameters.length) {
                    if (paramIndex == 0 && newParameters.length == 0 && typeElement != null && typeElement.getType().isVoid()) break;
                    LOG.error("Invalid parameter is involved into rename procedure!");
                    break;
                }
                OCDeclarator declarator = parameter.getDeclarator();
                if (declarator != null) {
                    OCParameterDeclaration parameterDeclaration;
                    OCSymbol symbol;
                    String oldTypeText;
                    PsiElement identifier = declarator.getNameIdentifier();
                    OCParameterInfo parameterInfo = newParameters[paramIndex];
                    if (typeElement != null && parameterInfo.isTypeChanged(oldTypeText = declarator.getType().getBestNameInContext(declarator, OCElementUtil.getTypeTextWithModifiers(parameter))) && (symbol = declarator.getSymbol()) != null) {
                        new OCChangeTypeIntentionAction(symbol, parameterInfo.getType()).invoke(project2, null, declarator.getContainingFile());
                    }
                    String newName = changeInfo.getNewParameterName(isInherited, function, parameterInfo);
                    boolean newNameEmpty = OCCallableUtil.isParameterNameEmpty(newName);
                    if (identifier != null) {
                        if (newNameEmpty) {
                            OCChangeUtil.delete(identifier);
                        } else {
                            OCElementUtil.replaceWithIdentifier(identifier, newName, identifier);
                        }
                    } else if (!newNameEmpty && (parameterDeclaration = OCElementFactory.paramDeclarationByNameAndType(newName, parameterInfo.getType(), function)).getDeclarator() != null) {
                        OCChangeUtil.replaceHandlingMacros(declarator, parameterDeclaration.getDeclarator());
                    }
                }
                ++paramIndex;
            }
        }
    }

    public static void changeConstructorOrMethodCall(@Nullable OCElement callExpression, OCChangeInfo changeInfo) {
        int paramIndex = 0;
        PsiElement name = null;
        OCArgumentList oldArguments = null;
        if (callExpression instanceof OCCppNewExpression) {
            oldArguments = ((OCCppNewExpression)callExpression).getArgumentList();
        } else if (callExpression instanceof OCDeclarator) {
            oldArguments = (OCArgumentList)PsiTreeUtil.getChildOfType((PsiElement)callExpression, OCArgumentList.class);
            if (oldArguments == null) {
                OCCallExpression emptyCall = OCElementFactory.callExpression(changeInfo.getNewName(), Collections.emptyList(), changeInfo.getContext());
                oldArguments = (OCArgumentList)callExpression.add(emptyCall.getArgumentList());
            }
        } else if (callExpression instanceof OCConstructorFieldInitializer) {
            oldArguments = ((OCConstructorFieldInitializer)callExpression).getArgumentList();
        } else if (callExpression instanceof OCCallExpression) {
            oldArguments = ((OCCallExpression)callExpression).getArgumentList();
            OCExpression function = ((OCCallExpression)callExpression).getFunctionReferenceExpression();
            if (function instanceof OCReferenceExpression) {
                OCReferenceElement referenceElement = ((OCReferenceExpression)function).getReferenceElement();
                name = referenceElement != null ? referenceElement.getNameIdentifier() : null;
            } else if (function instanceof OCQualifiedExpression) {
                name = ((OCQualifiedExpression)function).getSelectorElement();
            }
        }
        ArrayList<String> paramStubs = new ArrayList<String>();
        for (OCParameterInfo param : changeInfo.getNewParameters()) {
            paramStubs.add(param.getParameterStubText(false, false));
        }
        OCCallExpression stubCall = OCElementFactory.callExpression(changeInfo.getNewName(), paramStubs, changeInfo.getContext());
        if (oldArguments != null) {
            for (OCExpression argument : stubCall.getArguments()) {
                OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
                if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= oldArguments.getArguments().size()) continue;
                OCChangeUtil.replaceHandlingMacros(argument, oldArguments.getArguments().get(parameterInfo.getOldIndex()));
            }
            oldArguments = (OCArgumentList)OCChangeUtil.replaceHandlingMacros(oldArguments, stubCall.getArgumentList());
            OCImportSymbolFix.fixAllSymbolsRecursively(oldArguments);
        } else if (callExpression instanceof OCCppNewExpression) {
            oldArguments = OCChangeUtil.add(callExpression, stubCall.getArgumentList());
            OCImportSymbolFix.fixAllSymbolsRecursively(oldArguments);
        }
        if (name != null && changeInfo.isNameChanged()) {
            OCElementUtil.replaceWithIdentifier(name, changeInfo.getNewName(), stubCall);
        }
    }

    public static PsiElement generateCall(@Nullable OCExpression receiver, List<OCExpression> arguments, OCChangeInfo changeInfo) {
        OCCallable block;
        int paramIndex;
        ArrayList<String> paramStubs = new ArrayList<String>();
        OCCallable parentCallable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)receiver, OCCallable.class);
        boolean isSelfSuperCall = changeInfo.getMethod().equals(parentCallable) || receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() != null && parentCallable instanceof OCMethod && Comparing.equal((String)changeInfo.getMethod().getName(), (String)parentCallable.getName());
        for (OCParameterInfo param : changeInfo.getNewParameters()) {
            paramStubs.add(param.getParameterStubText(changeInfo.willBeMethod(), isSelfSuperCall));
        }
        if (changeInfo.willBeMethod()) {
            OCSendMessageExpression sendMessageExpression = OCElementFactory.sendMessageExpression(paramStubs, changeInfo.getContext());
            paramIndex = 0;
            for (OCExpression stubArgument : sendMessageExpression.getArgumentExpressions()) {
                OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
                if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= arguments.size()) continue;
                OCExpression newArgument = arguments.get(parameterInfo.getOldIndex());
                OCChangeUtil.replaceHandlingMacros(stubArgument, newArgument);
            }
            if (changeInfo.getOldMethodDescriptor().getCallableKind() != OCCallableKind.METHOD) {
                receiver = OCElementFactory.expressionFromText(changeInfo.getNewContainerClass().getName(), changeInfo.getContext());
            }
            OCChangeUtil.replaceHandlingMacros(sendMessageExpression.getReceiverExpression(), receiver);
            return sendMessageExpression;
        }
        OCCallExpression callExpression = OCElementFactory.callExpression(changeInfo.willBeBlock() ? "block" : changeInfo.getNewName(), paramStubs, changeInfo.getContext());
        paramIndex = 0;
        for (OCExpression argument : callExpression.getArguments()) {
            OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
            if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= arguments.size()) continue;
            OCExpression oldArgument = arguments.get(parameterInfo.getOldIndex());
            OCChangeUtil.replaceHandlingMacros(argument, oldArgument);
        }
        if (changeInfo.willBeBlock() && (block = OCChangeSignatureUsageProcessor.generateMethodDefinition(changeInfo, changeInfo.getMethod(), true, true, false)) != null) {
            OCChangeUtil.replaceHandlingMacros(callExpression.getFunctionReferenceExpression(), block);
            changeInfo.setNewMethod(block);
        }
        return callExpression;
    }

    @Nullable
    public static OCCallable generateMethodDefinition(OCChangeInfo changeInfo, OCCallable oldMethod, boolean needBody, boolean needComments, boolean isInherited) {
        String newSignature;
        OCCallable<OCMethodSymbol> result = null;
        OCBlockStatement body = oldMethod.getBody();
        PsiFile context = oldMethod.getContainingFile();
        String string = newSignature = isInherited ? changeInfo.getNewInheritedSignature(oldMethod) : changeInfo.getNewSignature();
        if (changeInfo.willBeMethod()) {
            result = OCElementFactory.methodFromSignature(newSignature, (PsiElement)context, needBody && (body != null || oldMethod instanceof OCFunctionDeclaration), false);
        } else if (changeInfo.willBeFunction()) {
            OCMethodDescriptor methodDescriptor = changeInfo.getOldMethodDescriptor();
            OCDeclaration declaration = methodDescriptor.isConstructor() ? OCElementFactory.constructorFromText(newSignature + (needBody && body != null ? "{\n}" : ""), (PsiElement)context) : OCElementFactory.declarationFromText(newSignature + (needBody && body != null ? "{\n}" : ""), (PsiElement)context);
            OCLog.LOG.assertTrue(declaration instanceof OCCallable, (Object)declaration.getTextWithMacros());
            result = (OCCallable)((Object)declaration);
        } else if (changeInfo.willBeBlock()) {
            result = body != null ? (OCBlockExpression)OCElementFactory.expressionFromText(newSignature + "{\n}", (PsiElement)context) : null;
        } else assert (false);
        if (needBody && body != null && result != null && body.isValid()) {
            OCChangeUtil.replaceHandlingMacros(result.getBody(), body);
        }
        OCElementUtil.replaceDeclarationQualifiers(result, oldMethod);
        if (needComments) {
            OCElementUtil.replaceComments(result, oldMethod);
        }
        if (result != null && changeInfo.getContext() != null) {
            OCElementFactory.initIndentFromContext(changeInfo.getContext(), result);
        }
        return result;
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        return changeInfo instanceof OCChangeInfo;
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project2) {
        return true;
    }

    public void registerConflictResolvers(List<ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
    }
}

