/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandlerImpl;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterTableModel;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCTargetSymbolPanel;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.ui.OCTypeReferenceEditor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureDialog
extends ChangeSignatureDialogBase<OCParameterInfo, OCCallable, Object, OCMethodDescriptor, ParameterTableModelItemBase<OCParameterInfo>, OCParameterTableModel> {
    private DialogChangeSignatureHandlerImpl myHandler;
    private OCTypeReferenceEditor myContainerClassField;
    private JPanel myContainerPanel;
    private boolean myChangeParentClassPossible;
    private String myHelpId;
    private static final Key<Integer> DECLARATION_PLACE_KEY = Key.create((String)"DECLARATION_PLACE_KEY");

    public OCChangeSignatureDialog(Project project2, OCMethodDescriptor method, PsiElement context) {
        super(project2, method, false, context);
        this.initHandler();
        this.myNameField.setText(method.getName());
    }

    protected void initHandler() {
        if (this.myHandler == null) {
            this.myHandler = new DialogChangeSignatureHandlerImpl();
        }
    }

    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    @Override
    protected String getHelpId() {
        return this.myHelpId == null ? "procedures.refactoring.changeMethodSignature" : this.myHelpId;
    }

    @Override
    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        OCClassDeclaration containerClass = ((OCMethodDescriptor)this.myMethod).getContainerClass();
        this.myContainerClassField = OCTypeReferenceEditor.create(containerClass != null ? containerClass.getSymbol() : null, new Condition<OCSymbol>(){

            public boolean value(OCSymbol declaration) {
                return declaration instanceof OCImplementationSymbol;
            }
        }, ((OCMethodDescriptor)this.myMethod).getMethod(), true, this.myProject);
        this.myContainerClassField.addDocumentListener(this.mySignatureUpdater);
        this.myContainerClassField.getEditorTextField().setPreferredWidth(200);
        this.myContainerPanel = new JPanel(new BorderLayout(0, 2));
        JLabel containerPrompt = new JLabel();
        containerPrompt.setText("Containing Class:");
        containerPrompt.setLabelFor((Component)((Object)this.myContainerClassField));
        panel.add((Component)super.createNorthPanel(), gbc);
        this.myContainerPanel.add((Component)containerPrompt, "North");
        this.myContainerPanel.add((Component)((Object)this.myContainerClassField), "South");
        OCSymbol symbol = this.myHandler.getMethodDescriptor().getMethodSymbol();
        if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppOperator()) {
            this.myNameField.setEnabled(false);
        }
        gbc.insets.left = 8;
        ++gbc.gridx;
        panel.add((Component)this.myContainerPanel, gbc);
        this.getRefactorAction().setEnabled(false);
        this.validateButtons();
        return panel;
    }

    @Override
    protected JPanel createParametersPanel(boolean hasTabsInDialog) {
        JPanel panel = super.createParametersPanel(hasTabsInDialog);
        this.myPropagateParamChangesButton.setVisible(false);
        return panel;
    }

    @Override
    protected LanguageFileType getFileType() {
        return OCFileType.INSTANCE;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        if (this.getMethodName().isEmpty() && !this.myHandler.isMethod()) {
            return this.myNameField;
        }
        return super.getPreferredFocusedComponent();
    }

    @Override
    protected OCParameterTableModel createParametersInfoModel(OCMethodDescriptor method) {
        return new OCParameterTableModel(this.myDefaultValueContext, ((OCMethodDescriptor)this.myMethod).getMethod() instanceof OCMethod);
    }

    @Override
    protected BaseRefactoringProcessor createRefactoringProcessor() {
        return this.myHandler.createRefactoringProcessor();
    }

    @Override
    protected PsiCodeFragment createReturnTypeCodeFragment() {
        return OCElementFactory.getTypeCodeFragmentInWriteAction(((OCMethodDescriptor)this.myMethod).getReturnTypeText(this.myDefaultValueContext), this.myProject, this.myDefaultValueContext);
    }

    @Override
    protected CallerChooserBase<OCCallable> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<OCCallable>> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void updateSignatureAlarmFired() {
        super.updateSignatureAlarmFired();
        this.validateButtons();
    }

    @Override
    protected String getMethodName() {
        return this.myHandler.isMethod() ? this.myHandler.calculateMethodName() : super.getMethodName();
    }

    @Override
    protected void canRun() throws ConfigurationException {
        OCTargetSymbolPanel panel;
        if (this.myNameField == null) {
            return;
        }
        if (this.myVisibilityPanel instanceof OCTargetSymbolPanel && this.myVisibilityPanel.isVisible() && (panel = (OCTargetSymbolPanel)this.myVisibilityPanel).isOnlyNewCategoryAllowed() && !panel.createNewCategory(this.myHandler.getGeneratedInfo())) {
            this.doCancelAction();
        }
        this.initHandler();
        String callableKind = StringUtil.decapitalize((String)this.myHandler.getCallableKind().toString());
        if (this.myNamePanel.isVisible() && this.myNameField.isEnabled() && !StringUtil.isJavaIdentifier((String)this.myNameField.getText().trim())) {
            throw new ConfigurationException("Name of " + callableKind + " is invalid");
        }
        if ((this.myHandler.isFunction() || this.myHandler.isMethod()) && ((OCMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite && OCElementUtil.getType((PsiElement)this.myReturnTypeCodeFragment) == null) {
            throw new ConfigurationException("Return type of " + callableKind + " is invalid");
        }
        if (this.myHandler.isMethod() && ((OCParameterTableModel)this.myParametersTableModel).getRowCount() == 0) {
            throw new ConfigurationException("No selector parts for " + callableKind);
        }
        if (this.myContainerPanel.isVisible()) {
            OCSymbol classSymbol = this.myContainerClassField.getClassDeclaration(this.myProject);
            if (classSymbol == null) {
                throw new ConfigurationException("Containing class \"" + this.myContainerClassField.getText() + "\" is invalid");
            }
            VirtualFile containingFile = classSymbol.getContainingFile();
            if (containingFile != null && !OCSearchScope.isInProjectSources(classSymbol)) {
                throw new ConfigurationException("Containing class \"" + this.myContainerClassField.getText() + "\" is outside of the project");
            }
        }
        List items = ((OCParameterTableModel)this.myParametersTableModel).getItems();
        boolean isSingleSelector = false;
        if (items.size() == 1 && this.myHandler.isMethod()) {
            ParameterTableModelItemBase item = (ParameterTableModelItemBase)items.get(0);
            isSingleSelector = item.typeCodeFragment.getText().isEmpty() && ((OCParameterInfo)item.parameter).getName().isEmpty();
        }
        boolean isFirst = true;
        for (ParameterTableModelItemBase item : items) {
            boolean isEllipsis = item.typeCodeFragment.getText().equals("...");
            String selectorName = ((OCParameterInfo)item.parameter).getSelector().trim();
            String parameterName = ((OCParameterInfo)item.parameter).getName().trim();
            if (this.myHandler.isMethod() && !StringUtil.isJavaIdentifier((String)selectorName) && (isFirst || !selectorName.isEmpty())) {
                throw new ConfigurationException("Selector part '" + StringUtil.escapeXml((String)selectorName) + "' is invalid");
            }
            if (!isSingleSelector && OCElementUtil.getType((PsiElement)item.typeCodeFragment) == null && !isEllipsis) {
                throw new ConfigurationException("Parameter type '" + StringUtil.escapeXml((String)item.typeCodeFragment.getText().trim()) + "' is invalid");
            }
            if (!(isSingleSelector || StringUtil.isJavaIdentifier((String)parameterName) || parameterName.isEmpty())) {
                throw new ConfigurationException("Parameter name '" + StringUtil.escapeXml((String)parameterName) + "' is invalid");
            }
            isFirst = false;
        }
    }

    @Override
    protected void doAction() {
        if (!this.isPreviewUsages() || ((OCMethodDescriptor)this.myMethod).getMethod().isPhysical()) {
            super.doAction();
        }
    }

    @Override
    @Nullable
    protected String validateAndCommitData() {
        OCSymbol containerClass;
        if (this.myContainerPanel.isVisible() && (containerClass = this.myContainerClassField.getClassDeclaration(this.myProject)) != null) {
            this.myHandler.getGeneratedInfo().setMethodParent(containerClass);
        }
        return null;
    }

    private static String convertName(String oldName) {
        return oldName.indexOf(58) == -1 ? oldName : oldName.substring(0, oldName.indexOf(58));
    }

    @Override
    protected VisibilityPanelBase<Object> createVisibilityControl() {
        this.initHandler();
        if (((OCMethodDescriptor)this.myMethod).isChangeCallableKindPossible()) {
            OCCallableKind[] visibility = new OCCallableKind[]{OCCallableKind.METHOD, OCCallableKind.FUNCTION, OCCallableKind.BLOCK};
            ComboBoxVisibilityPanel<OCCallableKind> panel = new ComboBoxVisibilityPanel<OCCallableKind>("Callable Type:", visibility);
            panel.addListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    OCChangeSignatureDialog.this.updateCallableKind((OCCallableKind)((Object)OCChangeSignatureDialog.this.getVisibility()));
                }
            });
            panel.setEnabled(((OCMethodDescriptor)this.myMethod).getMethod().getBody() != null);
            return panel;
        }
        this.updateCallableKind((OCCallableKind)((Object)((OCMethodDescriptor)this.myMethod).getVisibility()));
        if (((OCMethodDescriptor)this.myMethod).getMethod() instanceof OCFunctionDefinition && ((OCFunctionDefinition)((OCMethodDescriptor)this.myMethod).getMethod()).getNamespaceQualifier() == null) {
            final Object[] places = new Object[]{"above", "below"};
            final ComboBoxVisibilityPanel<Object> panel = new ComboBoxVisibilityPanel<Object>("Declaration place:", places);
            panel.addListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Object selectedItem = panel.getVisibility();
                    OCChangeSignatureDialog.this.myHandler.getGeneratedInfo().setTargetSymbolsMode("below".equals(selectedItem) ? OCTargetSymbolPanel.TargetSymbolsMode.INTERFACE : OCTargetSymbolPanel.TargetSymbolsMode.IMPLEMENTATION);
                    OCChangeSignatureDialog.this.myProject.putUserData(DECLARATION_PLACE_KEY, (Object)ArrayUtil.find((Object[])places, panel.getVisibility()));
                }
            });
            panel.setVisible(false);
            Integer choice = (Integer)this.myProject.getUserData(DECLARATION_PLACE_KEY);
            if (choice == null || choice == -1) {
                choice = 1;
            }
            panel.setVisibility(places[choice]);
            return panel;
        }
        OCTargetSymbolPanel panel = new OCTargetSymbolPanel();
        panel.setVisible(false);
        return panel;
    }

    private void updateCallableKind(OCCallableKind callableKind) {
        List<OCParameterInfo> parameters;
        String name = OCChangeSignatureDialog.convertName(this.myNameField.getText());
        if (this.myHandler.getCallableKind() == OCCallableKind.METHOD && !(parameters = this.myHandler.getParameters()).isEmpty()) {
            name = OCChangeSignatureDialog.convertName(parameters.get(0).getSelector());
        }
        this.myHandler.setCallableKindToModel(callableKind);
        boolean parentClassVisible = this.myChangeParentClassPossible || this.myHandler.isMethod() && this.myHandler.getOriginalCallableKind() != OCCallableKind.METHOD;
        this.myContainerPanel.setVisible(parentClassVisible);
        this.myHandler.setNameVisible(this.myHandler.isFunction());
        this.myNameField.setText(name);
        ((OCParameterTableModel)this.myParametersTableModel).updateColumns(this.myProject, this.myHandler.isMethod());
        if (this.getTableComponent() != null) {
            this.getTableComponent().repaint();
        }
    }

    public OCChangeSignatureHandlerImpl getHandler() {
        this.initHandler();
        return this.myHandler;
    }

    @Override
    protected boolean hasPreviewButton() {
        return !this.myHandler.isMethodGenerated();
    }

    @Override
    protected String calculateSignature() {
        this.initHandler();
        final String signature = this.myHandler.calculateSignature(null, true);
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        boolean methodAlignMultiline = false;
        boolean methodAlignCol = false;
        boolean functionAlign = false;
        if (settings != null) {
            methodAlignMultiline = settings.METHOD_PARAMETERS_ALIGN_MULTILINE;
            methodAlignCol = settings.METHOD_PARAMETERS_ALIGN_BY_COLONS;
            functionAlign = settings.FUNCTION_PARAMETERS_ALIGN_MULTILINE;
            settings.METHOD_PARAMETERS_ALIGN_MULTILINE = true;
            settings.METHOD_PARAMETERS_ALIGN_BY_COLONS = true;
            settings.FUNCTION_PARAMETERS_ALIGN_MULTILINE = true;
        }
        String formattedSignature = (String)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<String>(){

            public String compute() {
                switch (OCChangeSignatureDialog.this.myHandler.getCallableKind()) {
                    case METHOD: {
                        String text = OCElementFactory.methodFromSignature(signature, ((OCMethodDescriptor)OCChangeSignatureDialog.this.myMethod).getMethod(), false, true).getText();
                        return text.substring(0, text.length() - 1);
                    }
                    case FUNCTION: {
                        if (((OCMethodDescriptor)OCChangeSignatureDialog.this.myMethod).isConstructor()) {
                            return OCElementFactory.constructorFromText(signature, ((OCMethodDescriptor)OCChangeSignatureDialog.this.myMethod).getMethod(), true).getText();
                        }
                        return OCElementFactory.topLevelDeclarationFromText(signature, ((OCMethodDescriptor)OCChangeSignatureDialog.this.myMethod).getMethod(), true).getText();
                    }
                }
                return OCElementFactory.expressionFromText(signature, ((OCMethodDescriptor)OCChangeSignatureDialog.this.myMethod).getMethod(), true).getText();
            }
        });
        if (settings != null) {
            settings.METHOD_PARAMETERS_ALIGN_MULTILINE = methodAlignMultiline;
            settings.METHOD_PARAMETERS_ALIGN_BY_COLONS = methodAlignCol;
            settings.FUNCTION_PARAMETERS_ALIGN_MULTILINE = functionAlign;
        }
        return formattedSignature;
    }

    @Override
    protected boolean isListTableViewSupported() {
        return true;
    }

    private int getTypesMaxLength() {
        int len = 0;
        for (ParameterTableModelItemBase item : ((OCParameterTableModel)this.myParametersTableModel).getItems()) {
            String text = item.typeCodeFragment == null ? null : item.typeCodeFragment.getText();
            len = Math.max(len, text == null ? 0 : text.length());
        }
        return len;
    }

    private int getTypesColumnWidth() {
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        font = new Font(font.getFontName(), font.getStyle(), 12);
        return (this.getTypesMaxLength() + 1) * Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("W");
    }

    private int getSelectorsMaxLength() {
        int len = 0;
        for (ParameterTableModelItemBase item : ((OCParameterTableModel)this.myParametersTableModel).getItems()) {
            String text = ((OCParameterInfo)item.parameter).getSelector();
            len = Math.max(len, text == null ? 0 : text.length());
        }
        return len;
    }

    protected static SimpleTextAttributes getSelectorTextAttributes(EditorColorsScheme scheme) {
        return SimpleTextAttributes.fromTextAttributes((TextAttributes)scheme.getAttributes(OCHighlightingKeys.MESSAGE_ARGUMENT));
    }

    protected static SimpleTextAttributes getTypeTextAttributes(EditorColorsScheme scheme) {
        return SimpleTextAttributes.fromTextAttributes((TextAttributes)scheme.getAttributes(OCHighlightingKeys.CLASS_REFERENCE));
    }

    @Override
    protected JComponent getRowPresentation(ParameterTableModelItemBase<OCParameterInfo> item, boolean selected, boolean focused) {
        Color selBg = UIUtil.getTableSelectionBackground();
        Color selFg = UIUtil.getTableSelectionForeground();
        SimpleTextAttributes ATTR = selected && focused ? new SimpleTextAttributes(selBg, selFg, null, 0) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        SimpleColoredComponent text = new SimpleColoredComponent();
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Font font = globalScheme.getFont(EditorFontType.PLAIN);
        font = new Font(font.getFontName(), font.getStyle(), 12);
        text.setFont(font);
        String typeText = item.typeCodeFragment.getText();
        String selector = ((OCParameterInfo)item.parameter).getSelector();
        String name = ((OCParameterInfo)item.parameter).getName();
        if (this.myHandler.isMethod() && !StringUtil.isEmpty((String)selector)) {
            text.append(selector, selected ? ATTR : OCChangeSignatureDialog.getSelectorTextAttributes(globalScheme));
            if (!StringUtil.isEmpty((String)name)) {
                text.append(":", ATTR);
            }
            text.append(StringUtil.repeatSymbol((char)' ', (int)(this.getSelectorsMaxLength() - selector.length())), ATTR);
        }
        if (this.myHandler.isMethod() && !StringUtil.isEmpty((String)typeText)) {
            text.append("(", ATTR);
        }
        text.append(typeText, selected && focused ? ATTR : OCChangeSignatureDialog.getTypeTextAttributes(globalScheme));
        if (this.myHandler.isMethod() && !StringUtil.isEmpty((String)typeText)) {
            text.append(")", ATTR);
        }
        text.append(StringUtil.repeatSymbol((char)' ', (int)(this.getTypesMaxLength() - typeText.length() + 1)), ATTR);
        text.append(name, ATTR);
        text.setBackground(selected && focused ? selBg : UIUtil.getTableBackground());
        return text;
    }

    @Override
    protected JBTableRowEditor getTableEditor(final JTable t, final ParameterTableModelItemBase<OCParameterInfo> item) {
        return new JBTableRowEditor(){
            private List<EditorTextField> myEditors = new ArrayList<EditorTextField>();

            @Override
            public void prepareEditor(JTable table, int row) {
                this.setLayout(new BorderLayout());
                String[] anchors = new String[]{"West", "Center", "East"};
                int column = 0;
                for (ColumnInfo columnInfo : ((OCParameterTableModel)OCChangeSignatureDialog.this.myParametersTableModel).getColumnInfos()) {
                    EditorTextField editor;
                    JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                    if (OCParameterTableModel.isTypeColumn(columnInfo)) {
                        Document document = PsiDocumentManager.getInstance((Project)OCChangeSignatureDialog.this.getProject()).getDocument((PsiFile)item.typeCodeFragment);
                        editor = new EditorTextField(document, OCChangeSignatureDialog.this.getProject(), (FileType)OCChangeSignatureDialog.this.getFileType());
                    } else {
                        editor = new EditorTextField((String)columnInfo.valueOf((Object)item), OCChangeSignatureDialog.this.getProject(), (FileType)OCChangeSignatureDialog.this.getFileType());
                    }
                    final int columnFinal = column;
                    editor.addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void documentChanged(DocumentEvent e) {
                            this.fireDocumentChanged(e, columnFinal);
                        }
                    });
                    JBLabel label = new JBLabel(columnInfo.getName(), UIUtil.ComponentStyle.SMALL);
                    panel.add((Component)label);
                    panel.add((Component)((Object)editor));
                    IJSwingUtilities.adjustComponentsOnMac((JLabel)label, (JComponent)((Object)editor));
                    editor.setPreferredWidth(t.getWidth() / ((OCParameterTableModel)OCChangeSignatureDialog.this.myParametersTableModel).getColumnCount());
                    this.add((Component)panel, anchors[column]);
                    this.myEditors.add(editor);
                    ++column;
                }
            }

            @Override
            public JBTableRow getValue() {
                return new JBTableRow(){

                    @Override
                    public Object getValueAt(int column) {
                        if (OCParameterTableModel.isTypeColumn(((OCParameterTableModel)OCChangeSignatureDialog.this.myParametersTableModel).getColumnInfos()[column])) {
                            return item.typeCodeFragment;
                        }
                        return ((EditorTextField)myEditors.get(column)).getText();
                    }
                };
            }

            private int getEditorIndex(int x) {
                Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
                font = new Font(font.getFontName(), font.getStyle(), 12);
                int selectorsWidth = (OCChangeSignatureDialog.this.getSelectorsMaxLength() + 1) * Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("W");
                int typesWidth = (OCChangeSignatureDialog.this.getTypesMaxLength() + 1) * Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("W") + selectorsWidth;
                if (OCChangeSignatureDialog.this.myHandler.isMethod()) {
                    return x <= selectorsWidth ? 0 : (x <= typesWidth ? 1 : 2);
                }
                return x <= typesWidth ? 0 : 1;
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                MouseEvent me = this.getMouseEvent();
                if (me == null) {
                    return this.myEditors.get(0).getFocusTarget();
                }
                return this.myEditors.get(this.getEditorIndex((int)me.getPoint().getX())).getFocusTarget();
            }

            @Override
            public JComponent[] getFocusableComponents() {
                JComponent[] focusable = new JComponent[this.myEditors.size()];
                for (int i = 0; i < this.myEditors.size(); ++i) {
                    focusable[i] = this.myEditors.get(i).getFocusTarget();
                }
                return focusable;
            }
        };
    }

    private class DialogChangeSignatureHandlerImpl
    extends OCChangeSignatureHandlerImpl {
        public DialogChangeSignatureHandlerImpl() {
            super((OCParameterTableModel)OCChangeSignatureDialog.this.myParametersTableModel, (OCMethodDescriptor)OCChangeSignatureDialog.this.myMethod, OCChangeSignatureDialog.this.myDefaultValueContext);
        }

        @Override
        public void setTitle(String title) {
            super.setTitle(title);
            OCChangeSignatureDialog.this.setTitle(title);
        }

        @Override
        public void setHelpId(String helpId) {
            super.setHelpId(helpId);
            OCChangeSignatureDialog.this.setHelpId(helpId);
        }

        public void setCallableKindToModel(OCCallableKind callableKind) {
            super.setCallableKind(callableKind);
        }

        @Override
        public void setCallableKind(OCCallableKind callableKind) {
            super.setCallableKind(callableKind);
            OCChangeSignatureDialog.this.myVisibilityPanel.setVisibility(callableKind);
        }

        @Override
        public void setChangeParentClassPossible(boolean possible) {
            OCChangeSignatureDialog.this.myChangeParentClassPossible = possible;
            OCChangeSignatureDialog.this.myContainerPanel.setVisible(possible);
        }

        @Override
        public void setNameVisible(boolean visible) {
            OCChangeSignatureDialog.this.myNamePanel.setVisible(visible);
        }

        @Override
        public void setName(String name) {
            super.setName(name);
            OCChangeSignatureDialog.this.myNameField.setText(OCChangeSignatureDialog.this.myHandler.isMethod() ? this.calculateMethodName() : name);
            OCChangeSignatureDialog.this.updateSignatureAlarmFired();
        }

        @Override
        public void setReturnType(OCType returnType) {
            super.setReturnType(returnType);
            if (OCChangeSignatureDialog.this.myReturnTypeField != null) {
                OCChangeSignatureDialog.this.myReturnTypeField.setText(this.myReturnTypeText);
            }
        }

        @Override
        public void setParentClass(OCSymbol parent, boolean allowChangeCategories, List<? extends OCClassSymbol> auxParents) {
            super.setParentClass(parent, allowChangeCategories, auxParents);
            OCChangeSignatureDialog.this.myContainerClassField.setText(parent != null ? parent.getName() : "");
        }

        @Override
        OCType getReturnType() {
            OCType type = OCElementUtil.getType((PsiElement)OCChangeSignatureDialog.this.myReturnTypeCodeFragment);
            return type != null ? type : this.myReturnType;
        }

        @Override
        String getReturnTypeText() {
            return OCChangeSignatureDialog.this.myReturnTypeCodeFragment != null ? OCChangeSignatureDialog.this.myReturnTypeCodeFragment.getText().trim() : "";
        }

        @Override
        String getMethodName() {
            return OCChangeSignatureDialog.this.getMethodName();
        }

        @Override
        @Nullable
        OCClassDeclaration getContainerClass() {
            if (this.myCallableKind == OCCallableKind.METHOD) {
                OCClassSymbol symbol = (OCClassSymbol)OCChangeSignatureDialog.this.myContainerClassField.getClassDeclaration(OCChangeSignatureDialog.this.myProject);
                return OCElementUtil.resolveClassDeclaration(symbol);
            }
            return null;
        }

        @Override
        public void setRefactorButtonText(String text) {
            OCChangeSignatureDialog.this.getRefactorAction().putValue("Name", text);
        }

        @Override
        public void invoke() {
            List items = this.myParametersTableModel.getItems();
            if (OCChangeSignatureDialog.this.myHandler.getGeneratedInfo().getMethodParent() instanceof OCClassSymbol) {
                OCChangeSignatureDialog.this.myVisibilityPanel.setVisible(!OCChangeSignatureDialog.this.myChangeParentClassPossible);
                ((OCTargetSymbolPanel)OCChangeSignatureDialog.this.myVisibilityPanel).fillData(OCChangeSignatureDialog.this.myHandler.getGeneratedInfo());
                OCChangeSignatureDialog.this.myContainerClassField.setText(OCChangeSignatureDialog.this.myHandler.getGeneratedInfo().getMethodParent().getName());
            } else if (this.myMethod.getMethod() instanceof OCFunctionDefinition && ((OCFunctionDefinition)this.myMethod.getMethod()).getNamespaceQualifier() == null && this.myGeneratedInfo.getMethodReference() != null) {
                OCChangeSignatureDialog.this.myVisibilityPanel.setVisible(true);
            }
            if (this.myMethod.isConstructor()) {
                if (OCChangeSignatureDialog.this.myReturnTypeField != null) {
                    OCChangeSignatureDialog.this.myReturnTypeField.setEnabled(false);
                }
                OCChangeSignatureDialog.this.myNameField.setEnabled(false);
                OCChangeSignatureDialog.this.myVisibilityPanel.setVisible(false);
            }
            if (OCChangeSignatureDialog.this.myHandler.isMethod() && !items.isEmpty()) {
                Container parent;
                JBTable table = OCChangeSignatureDialog.this.getTableComponent();
                if (items.size() > 0 && ((OCParameterInfo)((ParameterTableModelItemBase)items.get((int)0)).parameter).getSelector().isEmpty()) {
                    Runnable editAlarm = new Runnable((JTable)table){
                        final /* synthetic */ JTable val$table;
                        {
                            this.val$table = jTable;
                        }

                        @Override
                        public void run() {
                            new Alarm(Alarm.ThreadToUse.SWING_THREAD).addRequest(new Runnable(){

                                @Override
                                public void run() {
                                    val$table.editCellAt(0, 0);
                                }
                            }, 300);
                        }
                    };
                    SwingUtilities.invokeLater(editAlarm);
                }
                if ((parent = table.getParent()) == null) {
                    table.repaint();
                } else {
                    parent.repaint();
                }
            }
            OCChangeSignatureDialog.this.show();
        }
    }
}

