/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.OCErrorAnnotator;
import com.jetbrains.cidr.lang.daemon.OCResolveAnnotator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCImportsOptimizer
implements ImportOptimizer {
    public boolean supports(PsiFile file2) {
        return file2 instanceof OCFile;
    }

    @NotNull
    public Runnable processFile(final PsiFile file2) {
        if (!(file2 instanceof OCFile) || ((OCFile)file2).isHeader()) {
            return EmptyRunnable.INSTANCE;
        }
        List<OCIncludeDirective> imports = OCImportsOptimizer.getUnusedImports((OCFile)file2);
        final OCRemoveElementsIntentionAction action = new OCRemoveElementsIntentionAction(imports, "", "");
        return new Runnable(){

            @Override
            public void run() {
                action.invoke(file2.getProject(), null, file2);
            }
        };
    }

    public static List<OCIncludeDirective> getUnusedImports(OCFile file2) {
        return OCImportsOptimizer.runAnnotatorAndGetImports(file2, Collections.singletonList(file2), false, true);
    }

    public static List<OCIncludeDirective> getUnusedImports(OCFile file2, Collection<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return OCImportsOptimizer.runAnnotatorAndGetImports(file2, elements, false, false);
    }

    public static List<OCIncludeDirective> getUsedImports(OCFile file2, Collection<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return OCImportsOptimizer.runAnnotatorAndGetImports(file2, elements, true, false);
    }

    private static List<OCIncludeDirective> runAnnotatorAndGetImports(OCFile file2, Collection<? extends PsiElement> elements, boolean used, boolean requiredAsUsed) {
        final OCResolveAnnotator resolveAnnotator = new OCResolveAnnotator();
        final OCErrorAnnotator errorAnnotator = new OCErrorAnnotator();
        final AnnotationSession session = new AnnotationSession((PsiFile)file2);
        file2.pushAnnotationSession(session);
        for (PsiElement psiElement : elements) {
            if (psiElement instanceof OCSymbolHolderVirtualPsiElement) {
                OCFileSymbols.markImportNeeded(file2, ((OCSymbolHolderVirtualPsiElement)psiElement).getSymbol());
                continue;
            }
            assert (psiElement.getContainingFile() == file2);
            psiElement.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    resolveAnnotator.annotate(element, null, session);
                    errorAnnotator.annotate(element, null, session);
                }
            });
        }
        List<OCIncludeDirective> result = OCImportsOptimizer.doGetImports(file2, used, requiredAsUsed);
        file2.popAnnotationSession();
        return result;
    }

    public static List<OCIncludeDirective> doGetImports(OCFile file2, boolean used, boolean requiredAsUsed) {
        ArrayList<OCIncludeDirective> result = new ArrayList<OCIncludeDirective>();
        HashSet<VirtualFile> usedFiles = new HashSet<VirtualFile>();
        for (OCIncludeDirective directive : file2.findIncludeDirectives()) {
            if (!OCCodeInsightUtil.isValid(directive) || !directive.isTopLevel() || !directive.getContainingFile().equals(file2)) continue;
            PsiFile importedFile = directive.getIncludedFile();
            VirtualFile filePath = OCElementUtil.getFilePath(importedFile);
            if (!(importedFile instanceof OCFile) || filePath == null) continue;
            if ((OCFileSymbols.isImportUsed(file2, filePath) || requiredAsUsed && OCFileSymbols.isImportRequired(file2, filePath)) && !usedFiles.contains(filePath)) {
                usedFiles.add(filePath);
                if (!used) continue;
                result.add(directive);
                continue;
            }
            if (used) continue;
            result.add(directive);
        }
        return result;
    }
}

