/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolQuickFix<T extends OCSymbol>
extends OCQuickFix {
    protected T mySymbol;

    protected OCSymbolQuickFix(@Nullable T symbol) {
        this.mySymbol = symbol;
    }

    protected abstract boolean isAvailable(T var1);

    protected abstract String getTextInternal(T var1);

    protected abstract void invoke(T var1);

    @Override
    protected boolean isAvailable() {
        return this.isAvailable(this.mySymbol);
    }

    @Override
    protected String getTextInternal() {
        return this.getTextInternal(this.mySymbol);
    }

    public void invoke() {
        OCFile containingFile = this.mySymbol.getContainingOCFile();
        if (containingFile != null && FileModificationService.getInstance().prepareFileForWrite((PsiFile)containingFile)) {
            PsiDocumentManager.getInstance((Project)containingFile.getProject()).commitAllDocuments();
            this.invoke(this.mySymbol);
        }
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.invoke();
    }
}

