/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSetSuperclassIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private OCSymbol mySuperClass;
    private OCVisibility myVisibility;

    public OCSetSuperclassIntentionAction(OCSymbol classSymbol, OCSymbol superClass, @Nullable OCVisibility visibility) {
        super(classSymbol);
        this.mySuperClass = superClass;
        this.myVisibility = visibility;
    }

    @Override
    protected String getTextInternal(OCSymbol symbol) {
        String superTypeName;
        if (symbol instanceof OCInterfaceSymbol && !(superTypeName = ((OCInterfaceSymbol)symbol).getSuperClassName()).isEmpty() && this.mySuperClass != null) {
            return "Change superclass of " + symbol.getNameWithKindLowercase() + " from '" + superTypeName + "' to '" + this.mySuperClass.getPresentableName() + "'";
        }
        assert (this.mySuperClass != null);
        return "Set '" + this.mySuperClass.getPresentableName() + "' as a " + (this.myVisibility != null ? this.myVisibility.toString() + " " : "") + "superclass of " + symbol.getNameWithKindLowercase();
    }

    @NotNull
    public String getFamilyName() {
        return "Change superclass";
    }

    @Override
    protected boolean isAvailable(OCSymbol symbol) {
        return !(!OCSearchScope.isInProjectSources(symbol) || symbol.isPredeclaration() || !(symbol instanceof OCInterfaceSymbol) && !(symbol instanceof OCStructSymbol) || !(this.mySuperClass instanceof OCInterfaceSymbol) && !(this.mySuperClass instanceof OCStructSymbol));
    }

    @Override
    protected void invoke(OCSymbol symbol) {
        OCSymbolDeclarator declaration = (OCSymbolDeclarator)symbol.locateDefinition();
        if (this.mySuperClass instanceof OCInterfaceSymbol) {
            if (declaration != null) {
                new OCElementsMover().setSuperClass((OCClassDeclaration)declaration, this.mySuperClass.getName());
            }
        } else {
            new OCElementsMover().removeBaseClass((OCStruct)declaration, (OCStructSymbol)this.mySuperClass, false);
            new OCElementsMover().addBaseClass((OCStruct)declaration, (OCStructSymbol)this.mySuperClass, this.myVisibility, false);
        }
    }
}

