/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveDeclarationIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    protected OCSymbol mySymbol;
    private String myText;
    private String myFamilyName;

    public OCRemoveDeclarationIntentionAction(String whatToRemove, OCSymbol symbol) {
        super(null);
        this.mySymbol = symbol;
        this.myText = "Remove " + whatToRemove + " of " + this.mySymbol.getNameWithKindLowercase();
        this.myFamilyName = "Remove " + whatToRemove;
    }

    public OCRemoveDeclarationIntentionAction(String whatToRemove, @Nullable PsiElement element) {
        super(element);
        this.myText = "Remove " + whatToRemove;
        this.myFamilyName = "Remove " + whatToRemove;
    }

    public OCRemoveDeclarationIntentionAction(OCSymbol symbol) {
        super(null);
        this.mySymbol = symbol;
        this.myText = "Remove declaration of " + this.mySymbol.getNameWithKindLowercase();
        this.myFamilyName = "Remove declaration";
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Override
    protected boolean isAvailable() {
        if (this.mySymbol != null) {
            Object declarator = this.mySymbol.locateDefinition();
            return OCSearchScope.isInProjectSources(this.mySymbol) && declarator != null && OCCodeInsightUtil.isValid(declarator) && !(declarator.getParent().getParent() instanceof OCForeachStatement);
        }
        PsiElement element = this.myElementPtr.getElement();
        return element != null && OCCodeInsightUtil.isValid(element) && element.getContext() instanceof OCStatement;
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        Object element;
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        if (this.mySymbol != null) {
            element = this.mySymbol.locateDefinition();
        } else {
            PsiElement el = this.myElementPtr.getElement();
            Object object = element = el != null ? el.getContext() : null;
        }
        if (element == null || !FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        if (element instanceof OCLabeledStatement) {
            OCStatement statement2 = ((OCLabeledStatement)element).getStatement();
            if (statement2 != null) {
                element.replace((PsiElement)statement2);
            } else {
                OCChangeUtil.delete(element);
            }
        } else if (this.mySymbol != null && this.mySymbol.getKind() == OCSymbolKind.PARAMETER) {
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType(element, OCCallable.class);
            if (callable == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable((PsiElement)element){
                final /* synthetic */ PsiElement val$element;
                {
                    this.val$element = psiElement;
                }

                @Override
                public void run() {
                    OCRemoveDeclarationIntentionAction.deleteUsages(this.val$element);
                }
            });
            OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler(callable, callable, true);
            handler2.removeParameter(this.mySymbol.getName(), true);
            handler2.invoke();
        } else {
            OCRemoveDeclarationIntentionAction.deleteUsages(element);
            OCChangeUtil.delete(element);
        }
    }

    protected static void deleteUsages(PsiElement element) {
        Collection usages = ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope()).findAll();
        for (PsiReference reference : usages) {
            OCChangeUtil.safeDeleteReference(reference.getElement());
        }
    }

    @Override
    public boolean startInWriteAction() {
        return this.mySymbol == null || this.mySymbol.getKind() != OCSymbolKind.PARAMETER;
    }
}

