/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveDeclarationButInitializerIntentionAction
extends OCRemoveDeclarationIntentionAction
implements HighPriorityAction {
    public OCRemoveDeclarationButInitializerIntentionAction(OCSymbol symbol) {
        super(symbol);
    }

    public OCRemoveDeclarationButInitializerIntentionAction(String whatToRemove, OCSymbol symbol) {
        super(whatToRemove, symbol);
    }

    public OCRemoveDeclarationButInitializerIntentionAction(String whatToRemove, @Nullable PsiElement element) {
        super(whatToRemove, element);
    }

    @Override
    @NotNull
    public String getText() {
        return super.getText() + " and leave initializer";
    }

    @Override
    public boolean isAvailable() {
        OCExpression initializer;
        if (!super.isAvailable()) {
            return false;
        }
        if (this.mySymbol != null) {
            if (this.mySymbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
                return false;
            }
            Object declarator = this.mySymbol.locateDefinition();
            if (!(declarator instanceof OCDeclarator) || declarator.getParent().getParent() instanceof OCForeachStatement) {
                return false;
            }
            initializer = ((OCDeclarator)declarator).getInitializer();
        } else {
            PsiElement element = this.myElementPtr.getElement();
            if (element instanceof OCAssignmentExpression) {
                initializer = ((OCAssignmentExpression)element).getSourceExpression();
            } else {
                return false;
            }
        }
        return initializer != null && OCCodeInsightUtil.hasSideEffects(initializer);
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        Object element;
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        Object object = element = this.mySymbol != null ? this.mySymbol.locateDefinition() : this.myElementPtr.getElement();
        if (element == null || !FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        OCExpression initializer = element instanceof OCDeclarator ? ((OCDeclarator)element).getInitializer() : ((OCAssignmentExpression)element).getSourceExpression();
        OCStatement declStatement = (OCStatement)PsiTreeUtil.getContextOfType(element, OCStatement.class, (boolean)false);
        OCExpressionStatement initializerStatement = (OCExpressionStatement)OCElementFactory.statementFromText("1", element);
        OCChangeUtil.replaceHandlingMacros(initializerStatement.getExpression(), initializer);
        if (declStatement == null) {
            OCChangeUtil.delete(element);
            return;
        }
        OCRemoveDeclarationButInitializerIntentionAction.deleteUsages(element);
        if (!(declStatement instanceof OCDeclarationStatement) || ((OCDeclarationStatement)declStatement).getDeclaration().getDeclarators().size() == 1) {
            OCChangeUtil.replaceHandlingMacros(declStatement, initializerStatement);
        } else {
            declStatement.getParent().addAfter((PsiElement)initializerStatement, (PsiElement)declStatement);
            OCChangeUtil.delete(element instanceof OCDeclarator ? element : declStatement);
        }
    }
}

