/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReleaseVariablesIntentionAction
extends OCPsiElementQuickFix {
    private OCSymbolKind mySymbolKind;
    private List<? extends OCSymbol> mySymbols;
    private List<String> myIvarNames;
    private TextRange myLocalScope;
    private SmartPsiElementPointer<PsiElement> myElement;

    private OCReleaseVariablesIntentionAction(OCSymbol symbol) {
        super(symbol != null ? (Object)symbol.locateDefinition() : null);
    }

    public OCReleaseVariablesIntentionAction(List<? extends OCSymbol> symbols) {
        this(symbols.get(0) instanceof OCMemberSymbol ? ((OCClassSymbol)((OCMemberSymbol)symbols.get(0)).getParent()).getImplementation() : symbols.get(0));
        this.mySymbolKind = symbols.get(0).getKind();
        this.mySymbols = symbols;
        this.myLocalScope = symbols.get(0).getScope();
    }

    public OCReleaseVariablesIntentionAction(OCSymbolKind symbolKind, OCClassSymbol classParent, List<OCPropertySymbol> properties, List<String> ivarNames) {
        this(classParent.getImplementation());
        this.mySymbolKind = symbolKind;
        this.mySymbols = properties;
        this.myIvarNames = ivarNames;
    }

    public OCReleaseVariablesIntentionAction(OCSymbol symbol, PsiElement element) {
        this(Collections.singletonList(symbol));
        this.myElement = OCElementUtil.createPsiElementPointer(element);
    }

    @Override
    protected String getTextInternal() {
        StringBuilder text = new StringBuilder("Release ");
        if (this.mySymbols.size() == 1) {
            text.append("'").append(this.mySymbols.get(0).getName()).append("'");
        } else {
            text.append("symbols");
        }
        if (this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            text.append(" in 'dealloc'");
        }
        return text.toString();
    }

    @NotNull
    public String getFamilyName() {
        return "Release variables";
    }

    @Override
    protected boolean isAvailable() {
        return this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE || this.myLocalScope != null;
    }

    protected void invoke(PsiFile file2, @NotNull PsiElement parent) {
        StringBuilder releaseText = new StringBuilder();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)file2.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        OCCodeStyleSettings.ReleaseStyle releaseStyle = settings != null ? settings.RELEASE_STYLE : OCCodeStyleSettings.ReleaseStyle.IVAR;
        block5: for (int i = 0; i < this.mySymbols.size(); ++i) {
            OCCodeStyleSettings.ReleaseStyle curReleaseStyle;
            OCSymbol symbol = this.mySymbols.get(i);
            if (releaseText.length() > 0) {
                releaseText.append(";\n");
            }
            String symbolName = symbol.getName();
            OCPropertySymbol property = null;
            if (symbol instanceof OCPropertySymbol) {
                property = (OCPropertySymbol)symbol;
                symbolName = this.myIvarNames.get(i);
            } else if (symbol instanceof OCInstanceVariableSymbol) {
                property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty();
            }
            if (property != null && property.isReadonly()) {
                property = property.getAssociatedPropertyInPrivateCategory();
            }
            if ((curReleaseStyle = releaseStyle) == OCCodeStyleSettings.ReleaseStyle.PROPERTY && (property == null || !property.isRetained() || property.isReadonly())) {
                curReleaseStyle = OCCodeStyleSettings.ReleaseStyle.IVAR;
            }
            switch (curReleaseStyle) {
                case IVAR: {
                    releaseText.append("[").append(symbolName).append(" release]");
                    continue block5;
                }
                case IVAR_2: {
                    releaseText.append("[").append(symbolName).append(" release], ").append(symbolName).append(" = nil");
                    continue block5;
                }
                case PROPERTY: {
                    releaseText.append("self.").append(property.getName()).append(" = nil");
                }
            }
        }
        if (this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            String insertText;
            int offset;
            if (!(parent instanceof OCClassDeclaration)) {
                return;
            }
            PsiElement anchor = this.getDeallocAnchor((OCClassDeclaration)parent);
            if (anchor != null) {
                offset = anchor.getTextOffset();
                insertText = releaseText + ";\n";
                file2 = anchor.getContainingFile();
            } else {
                offset = OCDeclarationKind.DeallocMethod.getChildrenEndOffset(parent);
                insertText = "-(void) dealloc { " + releaseText + "; [super dealloc]; }";
                file2 = parent.getContainingFile();
            }
            if (offset >= 0) {
                OCChangeUtil.changeText(file2.getProject(), file2, offset, 0, insertText, false);
            }
        } else if (this.myElement != null) {
            PsiElement element = file2.findElementAt(this.myLocalScope.getStartOffset());
            if (element == null || !(element.getParent() instanceof OCBlockStatement)) {
                return;
            }
            OCStatement newStatement = OCElementFactory.statementFromText(releaseText + ";", element);
            OCBlockStatement block = (OCBlockStatement)element.getParent();
            List<OCStatement> statements = block.getStatements();
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)block, OCCallable.class);
            if (statements != null && callable != null) {
                OCStatement lastStatement;
                OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(callable, null);
                analyzer.buildControlFlowGraph();
                MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = analyzer.getGraph().getInstructions(this.mySymbols.get(0));
                if (instructions != null) {
                    Collection kills = instructions.get((Object)OCInstruction.InstructionKind.KILL);
                    for (OCStatement statement2 : statements) {
                        TextRange range = statement2.getTextRange();
                        if (OCElementUtil.getPsiElementByPointer(this.myElement) == null || range.getStartOffset() <= OCElementUtil.getPsiElementByPointer(this.myElement).getTextRange().getStartOffset()) continue;
                        for (OCInstruction kill : kills) {
                            if (!range.contains(kill.getLValue().getTextRange())) continue;
                            block.addBefore(newStatement, statement2);
                            return;
                        }
                    }
                }
                if ((lastStatement = statements.get(statements.size() - 1)) instanceof OCReturnStatement || lastStatement instanceof OCContinueStatement || lastStatement instanceof OCBreakStatement) {
                    OCChangeUtil.addBefore(block, newStatement, lastStatement);
                } else {
                    OCChangeUtil.add(block, newStatement);
                }
            } else {
                OCChangeUtil.add(block, newStatement);
            }
        }
    }

    @Nullable
    private PsiElement getDeallocAnchor(OCClassDeclaration<OCClassSymbol> classDeclaration) {
        for (OCMethod method : classDeclaration.getMethods()) {
            OCBlockStatement body = method.getBody();
            if (!method.getSelector().equals("dealloc") || body == null) continue;
            int statementsCnt = body.getStatements().size();
            PsiElement element = statementsCnt > 0 ? OCNotReleasedIvarInspection.getCallToSuper(body.getStatements().get(statementsCnt - 1)) : null;
            return element != null ? element : body.getClosingBrace();
        }
        return null;
    }
}

