/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.jetbrains.cidr.lang.psi.OCAutoReleasePoolStatement;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCMigrateToARCIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    public OCMigrateToARCIntentionAction(OCSendMessageExpression expr) {
        super(expr);
    }

    public OCMigrateToARCIntentionAction(OCReferenceElement referenceElement) {
        super(referenceElement);
    }

    public OCMigrateToARCIntentionAction(OCFile file2) {
        super(file2);
    }

    @NotNull
    public String getFamilyName() {
        return "Migrate to ARC";
    }

    @Override
    protected String getTextInternal() {
        PsiElement element = this.myElementPtr.getElement();
        if (element instanceof OCFile) {
            return "Migrate '" + ((OCFile)element).getName() + "' to ARC";
        }
        return "Migrate statement to ARC";
    }

    @Override
    public boolean isAvailable(@NotNull PsiElement element) {
        return OCCompilerHelper.isArcEnabled(element.getContainingFile());
    }

    @Override
    public void invoke(PsiFile file2, @NotNull PsiElement element) throws IncorrectOperationException {
        OCDeclarationStatement statement2;
        final ArrayList<OCSendMessageExpression> exprs = new ArrayList<OCSendMessageExpression>();
        final ArrayList<OCDeclarationStatement> poolDeclarations = new ArrayList<OCDeclarationStatement>();
        ArrayList<List<PsiElement>> poolStatements = new ArrayList<List<PsiElement>>();
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        if (element instanceof OCFile) {
            element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitSendMessageExpression(OCSendMessageExpression expr) {
                    super.visitSendMessageExpression(expr);
                    exprs.add(expr);
                }

                @Override
                public void visitDeclarationStatement(OCDeclarationStatement stmt) {
                    super.visitDeclarationStatement(stmt);
                    if (stmt.getDeclaration().getType().getSimpleName(stmt).equals("NSAutoreleasePool")) {
                        poolDeclarations.add(stmt);
                    }
                }
            });
        } else if (element instanceof OCSendMessageExpression) {
            exprs.add((OCSendMessageExpression)element);
        } else if (element instanceof OCReferenceElement && (statement2 = (OCDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarationStatement.class)) != null && statement2.getDeclaration().getType().getSimpleName(element).equals("NSAutoreleasePool")) {
            poolDeclarations.add(statement2);
        }
        OCMigrateToARCIntentionAction.collectPoolStatements(poolDeclarations, poolStatements);
        OCMigrateToARCIntentionAction.handleMethods(exprs);
        OCMigrateToARCIntentionAction.handleAutoreleasePools(poolStatements);
    }

    private static void handleAutoreleasePools(List<List<PsiElement>> poolStatements) {
        for (List<PsiElement> statements : poolStatements) {
            PsiElement firstStatement = statements.get(0);
            OCAutoReleasePoolStatement pool = (OCAutoReleasePoolStatement)OCElementFactory.statementFromText("@autoreleasepool{}", firstStatement);
            for (PsiElement statement2 : statements) {
                if (!statement2.isValid() || statement2 == firstStatement) continue;
                OCChangeUtil.add(pool.getBody(), statement2);
            }
            for (PsiElement statement2 : statements) {
                if (!statement2.isValid() || statement2 == firstStatement) continue;
                OCChangeUtil.delete(statement2);
            }
            OCChangeUtil.replaceHandlingMacros(firstStatement, pool);
        }
    }

    private static void collectPoolStatements(List<OCDeclarationStatement> poolDeclarations, List<List<PsiElement>> poolStatements) {
        block0: for (OCDeclarationStatement declaration : poolDeclarations) {
            PsiElement next;
            if (!declaration.isValid()) continue;
            HashSet vars = new HashSet();
            for (OCDeclarator declarator : declaration.getDeclaration().getDeclarators()) {
                vars.add(declarator.getName());
            }
            PsiElement lastUsage = null;
            for (next = declaration.getNextSibling(); next != null; next = next.getNextSibling()) {
                if (!OCMigrateToARCIntentionAction.isPoolUsage((Set<String>)vars, next)) continue;
                lastUsage = next;
            }
            if (lastUsage == null) continue;
            OCDeclarationStatement statement2 = declaration;
            ArrayList<OCDeclarationStatement> curPoolStatements = new ArrayList<OCDeclarationStatement>();
            poolStatements.add(curPoolStatements);
            while (statement2 != null) {
                next = statement2.getNextSibling();
                if (OCMigrateToARCIntentionAction.isPoolUsage((Set<String>)vars, statement2)) {
                    OCChangeUtil.delete(statement2);
                } else {
                    curPoolStatements.add(statement2);
                }
                if (statement2 == lastUsage) continue block0;
                statement2 = next;
            }
        }
    }

    private static boolean isPoolUsage(Set<String> vars, PsiElement next) {
        OCExpression receiver;
        OCExpression expression;
        return next instanceof OCExpressionStatement && (expression = ((OCExpressionStatement)next).getExpression()) instanceof OCSendMessageExpression && (receiver = ((OCSendMessageExpression)expression).getReceiverExpression()) instanceof OCReferenceExpression && vars.contains(receiver.getText());
    }

    private static void handleMethods(List<OCSendMessageExpression> exprs) {
        ArrayList<OCMethod> deallocMethods = new ArrayList<OCMethod>();
        for (OCSendMessageExpression expr : exprs) {
            OCExpression receiver;
            List<OCMethodSymbol> responders;
            if (!expr.isValid() || (responders = expr.getProbableResponders().getAllResponders()).isEmpty()) continue;
            OCMethodSymbol method = responders.get(0);
            if ("dealloc".equals(method.getName())) {
                OCMethod parentMethod = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, OCMethod.class);
                if (parentMethod != null && parentMethod.getSelector().equals("dealloc")) {
                    deallocMethods.add(parentMethod);
                }
            } else if (!method.isForbiddenByARC(expr)) continue;
            if ((receiver = expr.getReceiverExpression()) == null) continue;
            if (receiver instanceof OCReferenceExpression && expr.getParent() instanceof OCExpressionStatement) {
                OCChangeUtil.delete(expr.getParent());
                continue;
            }
            OCChangeUtil.replaceHandlingMacros(expr, receiver);
        }
        for (OCMethod deallocMethod : deallocMethods) {
            OCBlockStatement body = deallocMethod.getBody();
            if (body == null || !body.getStatements().isEmpty()) continue;
            OCChangeUtil.delete(deallocMethod);
        }
    }
}

