/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplateExpression;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInsertCastIntentionAction
extends OCPsiElementQuickFix<OCExpression> {
    private OCType myType;
    private boolean myInsertBridgeCast;

    public OCInsertCastIntentionAction(OCExpression expression, OCType type, boolean insertBridgeCast) {
        super(expression);
        if (type instanceof OCPointerType && type.isPointerToObject() && ((OCPointerType)type).getARCAttribute() != null) {
            type = OCPointerType.to(((OCPointerType)type).getRefType());
        }
        this.myType = type;
        this.myInsertBridgeCast = insertBridgeCast;
    }

    public OCInsertCastIntentionAction(OCExpression expression, OCType type) {
        this(expression, type, false);
    }

    @Override
    protected String getTextInternal() {
        return "Cast expression to '" + this.myType.getName(this.myElementPtr.getElement()) + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Cast expression";
    }

    @Override
    protected boolean isAvailable(@NotNull OCExpression expression) {
        return this.myType != null;
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        int index;
        OCExpression operand;
        OCCastExpression castExpr;
        String typeElementText;
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCExpression expression = (OCExpression)this.myElementPtr.getElement();
        String string = typeElementText = this.myInsertBridgeCast ? "(__bridge int)" : "(int)";
        if (expression == null) {
            return;
        }
        if (expression instanceof OCBinaryExpression || expression instanceof OCConditionalExpression) {
            castExpr = (OCCastExpression)OCElementFactory.expressionFromText(typeElementText + "(1)", expression);
            operand = ((OCParenthesizedExpression)castExpr.getOperand()).getOperand();
        } else {
            castExpr = (OCCastExpression)OCElementFactory.expressionFromText(typeElementText + "1", expression);
            operand = castExpr.getOperand();
        }
        castExpr.getTypeElement().replace(OCElementFactory.typeElementFromText(this.myType.getName(expression), (PsiElement)file2));
        PsiElement parent = expression.getParent();
        PsiElement[] children2 = parent.getChildren();
        for (index = 0; index < children2.length && children2[index] != expression; ++index) {
        }
        OCChangeUtil.replaceHandlingMacros(operand, parent.copy().getChildren()[index]);
        castExpr = (OCCastExpression)OCChangeUtil.replaceHandlingMacros(expression, castExpr);
        if (this.myInsertBridgeCast && !ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)expression.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            PsiElement element = castExpr.getNode().getChildren(OCTokenTypes.BRIDGE_CAST_KEYWORDS)[0].getPsi();
            TemplateBuilderImpl builder = new TemplateBuilderImpl(element);
            Object[] types = OCTokenTypes.BRIDGE_CAST_KEYWORDS.getTypes();
            builder.replaceElement(element, (Expression)new OCTemplateExpression("__bridge", (String[])ContainerUtil.map((Object[])types, (Function)new Function<IElementType, String>(){

                public String fun(IElementType type) {
                    return ((OCElementType)type).getName();
                }
            }, (Object[])new String[0])));
            builder.run();
        }
    }
}

