/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCImplementOCMethodsHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImplementPropertyAccessorsQuickFix
extends OCImplementOCMethodsHandler
implements IntentionAction {
    private OCPropertySymbol myProperty;

    public OCImplementPropertyAccessorsQuickFix(OCPropertySymbol property) {
        this.myProperty = property;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Implement accessor methods for " + this.myProperty.getNameWithKindLowercase();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return OCSearchScope.isInProjectSources(this.myProperty);
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        return (OCClassSymbol)this.myProperty.getParent();
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCOverrideImplementActionContext context) {
        ArrayList<Pair<OCOption, Object>> result = new ArrayList<Pair<OCOption, Object>>();
        result.add(new Pair((Object)SHOW_OPTIONAL, (Object)false));
        result.add(new Pair((Object)SHOW_SYNTHESIZED_ACCESSORS, (Object)true));
        return result;
    }

    @Override
    @NotNull
    protected Collection<OCMethodSymbol> getSelectedCandidates(@NotNull OCOverrideImplementActionContext context, Editor editor, @NotNull PsiFile file2, @NotNull List<OCMethodSymbol> candidates) {
        CommonProcessors.CollectProcessor<OCMethodSymbol> collector = new CommonProcessors.CollectProcessor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol method) {
                if (method.getGeneratedFromProperty() == OCImplementPropertyAccessorsQuickFix.this.myProperty) {
                    return super.process((Object)method);
                }
                return true;
            }
        };
        ((OCClassSymbol)this.myProperty.getParent()).processMembers(OCMethodSymbol.class, collector);
        return collector.getResults();
    }
}

