/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCImplementOCMethodsHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class OCImplementMethodIntentionAction
extends OCImplementOCMethodsHandler
implements IntentionAction {
    private OCMethodSymbol myMethod;

    public OCImplementMethodIntentionAction(OCMethodSymbol method) {
        this.myMethod = method;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        if (this.myMethod == null) {
            return "Invalid";
        }
        return "Implement " + this.myMethod.getNameWithKindLowercase();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return OCSearchScope.isInProjectSources(this.myMethod);
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMethodSymbol> candidates) {
        return false;
    }

    @Override
    protected boolean selectAllCandidates() {
        return false;
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        return (OCClassSymbol)this.myMethod.getParent();
    }

    @Override
    @NotNull
    protected OCOverrideImplementActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        return new OCOverrideImplementActionContext(parent, parent.getResolvedType(true), element){

            @Override
            @NotNull
            public Collection<OCMethodSymbol> getMemberCandidates() {
                return Collections.singletonList(OCImplementMethodIntentionAction.this.myMethod);
            }
        };
    }
}

