/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import icons.CidrLangIcons;
import org.jetbrains.annotations.NotNull;

public class OCCreateInterfaceIntentionAction
extends OCNewFileActionBase
implements IntentionAction {
    private OCImplementationSymbol myImplementation;
    private PsiElement myImplNameIdentifier;

    public OCCreateInterfaceIntentionAction(OCImplementationSymbol anImplementation, PsiElement implNameIdentifier) {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.interface.title", new Object[0]), OCBundle.message("create.interface.description", new Object[0]), CidrLangIcons.CodeAssistantClass);
        this.myImplementation = anImplementation;
        this.myImplNameIdentifier = implNameIdentifier;
    }

    @NotNull
    public String getText() {
        if (this.myImplementation == null) {
            return "Invalid";
        }
        return "Create interface for " + this.myImplementation.getNameWithKindLowercase();
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    protected String getDefaultName() {
        return "Interface";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return super.isAvailable() && OCSearchScope.isInProjectSources(this.myImplementation);
    }

    public void invoke(final @NotNull Project project2, Editor editor, final PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        this.addAuxAction(new Runnable(){

            @Override
            public void run() {
                OCInterfaceSymbol interfaceSymbol = OCCreateInterfaceIntentionAction.this.myImplementation.getInterface(true, OCCreateInterfaceIntentionAction.this.myImplementation.getCategoryName());
                new OCImportSymbolFix(OCCreateInterfaceIntentionAction.this.myImplNameIdentifier, interfaceSymbol).fixFirstItem(project2, file2);
                OCImportSymbolFix.fixAllSymbolsRecursively(OCCreateInterfaceIntentionAction.this.myImplNameIdentifier);
            }
        });
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.performAction(project2, file2.getParent(), file2, this.myImplementation.getName());
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected String getFileTemplate(String fileName) {
        return "Objective-C Header File.h";
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(null, selectedName + ".h");
    }

    protected CreateInterfaceDialog createDialog(String defaultName) {
        return new CreateInterfaceDialog(defaultName);
    }

    protected class CreateInterfaceDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        public CreateInterfaceDialog(String defaultName) {
            super(OCCreateInterfaceIntentionAction.this.getText(), defaultName, null);
        }
    }
}

