/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCCreateDefinitionIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCCreateFunctionPredeclarationIntentionAction
extends OCCreateDefinitionIntentionAction {
    private OCFunctionSymbol myFunctionSymbol;

    public OCCreateFunctionPredeclarationIntentionAction(PsiElement usage, OCFunctionSymbol functionSymbol) {
        super(OCSymbolKind.FUNCTION_DECLARATION, usage, null);
        this.myFunctionSymbol = functionSymbol;
    }

    @Override
    protected OCDeclaration getDefinition(Project project2, Editor editor, PsiFile file2) {
        OCFunctionDeclaration function = this.myFunctionSymbol.locateFunctionDefinition();
        if (function == null) {
            return null;
        }
        String text = function.getText();
        int pos = text.indexOf(123);
        if (pos == -1) {
            return null;
        }
        return OCElementFactory.declarationFromText(text.substring(0, pos), (PsiElement)file2);
    }

    @NotNull
    public String getText() {
        return "Predeclare " + this.myFunctionSymbol.getNameWithKindLowercase();
    }
}

