/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangePropertyAttributeIntentionAction
extends OCPsiElementQuickFix<OCProperty> {
    private OCPropertySymbol myPropertySymbol;
    private OCPropertySymbol.PropertyAttribute myOldAttr;
    private OCPropertySymbol.PropertyAttribute myNewAttr;
    private String myNewValue;
    private String mySubject = "property";

    public OCChangePropertyAttributeIntentionAction(OCPropertySymbol propertySymbol, @Nullable OCPropertySymbol.PropertyAttribute oldAttr, @Nullable OCPropertySymbol.PropertyAttribute newAttr, @Nullable String newValue) {
        super(null);
        this.myPropertySymbol = propertySymbol;
        this.myOldAttr = oldAttr;
        this.myNewAttr = newAttr;
        this.myNewValue = newValue;
    }

    public OCChangePropertyAttributeIntentionAction(OCPropertySymbol propertySymbol, @Nullable OCPropertySymbol.PropertyAttribute oldAttr, @Nullable OCPropertySymbol.PropertyAttribute newAttr, @Nullable String newValue, String subject) {
        this(propertySymbol, oldAttr, newAttr, newValue);
        this.mySubject = subject;
    }

    public OCChangePropertyAttributeIntentionAction(OCProperty property, OCPropertySymbol.PropertyAttribute oldAttr, OCPropertySymbol.PropertyAttribute newAttr) {
        super(property);
        this.myOldAttr = oldAttr;
        this.myNewAttr = newAttr;
    }

    @Override
    protected String getTextInternal() {
        String prefix;
        String string = prefix = this.myPropertySymbol != null ? "' for " + this.myPropertySymbol.getNameWithKindLowercase() : "'";
        if (this.myOldAttr == null) {
            return "Enable attribute '" + this.myNewAttr.getTokenName() + prefix;
        }
        if (this.myNewAttr == null) {
            return "Disable attribute '" + this.myOldAttr.getTokenName() + prefix;
        }
        if (this.myNewValue != null) {
            return "Change value of attribute '" + this.myOldAttr.getTokenName() + "' to '" + this.myNewValue + "'";
        }
        return "Change " + this.mySubject + " attribute '" + this.myOldAttr.getTokenName() + "' to '" + this.myNewAttr.getTokenName() + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Change property attribute";
    }

    @Override
    protected boolean isAvailable() {
        OCProperty property;
        OCProperty oCProperty = property = this.myElementPtr != null ? (OCProperty)this.myElementPtr.getElement() : null;
        return (property != null ? OCSearchScope.isInProjectSources(property) : OCSearchScope.isInProjectSources(this.myPropertySymbol)) && (this.myOldAttr != this.myNewAttr || this.myNewValue != null);
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        OCProperty property;
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCProperty oCProperty = property = this.myElementPtr != null ? (OCProperty)this.myElementPtr.getElement() : null;
        if (property == null) {
            property = (OCProperty)PsiTreeUtil.getParentOfType(this.myPropertySymbol.locateDefinition(), OCProperty.class);
        }
        if (property == null || !FileModificationService.getInstance().prepareFileForWrite(property.getContainingFile())) {
            return;
        }
        OCPropertyAttributesList attrList = property.getPropertyAttributesList();
        OCPropertyAttributesList newAttrList = null;
        OCPropertyAttribute newAttribute = null;
        if (this.myNewAttr != null) {
            newAttrList = OCElementFactory.propertyAttributeList(this.myNewAttr, this.myNewValue, (PsiElement)file2);
            newAttribute = newAttrList.getAttributes().get(0);
        }
        if (attrList == null) {
            if (this.myNewAttr != null) {
                PsiElement prevSibling;
                OCDeclaration anchor = property.getDeclaration();
                PsiElement psiElement = prevSibling = anchor != null ? anchor.getPrevSibling() : null;
                if ("IBOutlet".equals(OCElementUtil.getTextWithMacros(prevSibling))) {
                    anchor = prevSibling;
                }
                property.addBefore(newAttrList, anchor);
            }
            return;
        }
        for (OCPropertyAttribute attribute : attrList.getAttributes()) {
            if (this.myOldAttr != null && Comparing.equal((String)attribute.getName(), (String)this.myOldAttr.getTokenName())) {
                if (newAttribute == null) {
                    OCChangeUtil.delete(attribute);
                } else if (this.myNewValue != null) {
                    attribute.setValue(this.myNewValue);
                } else {
                    attribute.replace(newAttribute);
                }
                return;
            }
            if (this.myNewAttr == null || !Comparing.equal((String)attribute.getName(), (String)this.myNewAttr.getTokenName())) continue;
            return;
        }
        if (newAttribute != null) {
            OCChangeUtil.add(attrList, newAttribute);
        }
    }
}

