/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCChangeMethodSignatureIntentionAction
extends OCSymbolQuickFix<OCMethodSymbol> {
    private List<OCType> myNewParamTypes;
    private List<String> myNewSelectors;
    private List<OCExpression> myNewExpressions;

    public OCChangeMethodSignatureIntentionAction(OCMethodSymbol methodSymbol, List<OCType> newParamTypes, List<String> newSelectors, List<OCExpression> newExpressions) {
        super(methodSymbol);
        this.myNewParamTypes = newParamTypes;
        this.myNewSelectors = newSelectors;
        this.myNewExpressions = newExpressions;
    }

    @Override
    protected boolean isAvailable(OCMethodSymbol symbol) {
        return OCSearchScope.isInProjectSources(symbol);
    }

    @Override
    protected String getTextInternal(OCMethodSymbol symbol) {
        return "Add parameters to " + symbol.getNameWithKindLowercase();
    }

    @NotNull
    public String getFamilyName() {
        return "Add parameters";
    }

    @Override
    protected void invoke(OCMethodSymbol symbol) {
        int i;
        Object method = symbol.locateDefinition();
        if (!(method instanceof OCMethod)) {
            return;
        }
        OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler((OCMethod)method, method, true);
        int oldSelectorsCnt = OCNameSuggester.isObjCGetter(symbol.getName()) ? 0 : symbol.getSelectors().size();
        HashSet prevParamNames = new HashSet();
        for (i = 0; i < oldSelectorsCnt; ++i) {
            OCDeclaratorSymbol parameter = symbol.getSelectors().get(i).getParameter();
            if (parameter == null) continue;
            prevParamNames.add(parameter.getName());
        }
        for (i = oldSelectorsCnt; i < this.myNewSelectors.size(); ++i) {
            String selector = this.myNewSelectors.get(i);
            OCExpression expression = this.myNewExpressions.get(i);
            String paramName = OCNameSuggester.suggestForParameter((Collection<String>)prevParamNames, i == 0, selector, this.myNewParamTypes.get(i), symbol, expression);
            prevParamNames.add(paramName);
            handler2.addParameter(selector, paramName, this.myNewParamTypes.get(i), -1, false);
        }
        handler2.invokeSynchronously();
    }
}

